# 5B-list_cues.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_cues
use strict;
use warnings;

use Test::More tests => 3;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @ari) = (qw/milk cow/);

my %dat_ref = (
    n_orths_milk => 5,
);

# Test list_associates:
$dat = scalar $usf->list_orthons($word1);
ok( is_equal($dat, $dat_ref{'n_orths_milk'}), "N orthons by list_orthons = $dat, should be $dat_ref{'n_orths_milk'}" );

# get the same via word_stat:
$dat = scalar $usf->word_stat($word1, 'ONC', {ref => 0, data => 0, cues_only => 0});
ok( is_equal($dat, $dat_ref{'n_orths_milk'}), "N orthons by word_stat = $dat, should be $dat_ref{'n_orths_milk'}" );

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
