# 5B-list_mediators.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_mediators
use strict;
use warnings;

use Test::More tests => 10;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @ari) = (qw/milk cow/);


my %dat_ref = (
    nmeds => 1,
    lastmed => 'DAIRY',
    depth6 => 2,
    depth5 => 1,
    depthmed12 => 2,
    depthmed11 => 1,
    depthval6s5 => .020,
);

# Test list_associates:
$aref = $usf->list_mediators($word1, $word2, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'nmeds'}), "N meds returned = $dat, should be $dat_ref{'nmeds'}" );

#- as open array:
@ari = $usf->list_mediators($word1, $word2, ref => 0); # data => 0
$dat = scalar(@ari);
ok( is_equal($dat, $dat_ref{'nmeds'}), "N meds returned = $dat, should be $dat_ref{'nmeds'}" );

#- check got right to the proper end of list:
ok(char_equal($ari[0], $dat_ref{'lastmed'}), "Last med returned = $ari[0], should be $dat_ref{'lastmed'}");

($word1, $word2) = (qw/love hate/); # have 3 mediators, LIKE, CARE, ADORE

#-controlling depth:
$aref = $usf->list_mediators($word1, $word2, depth => 6, ref => 1); # data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth6'}), "Seeking $dat_ref{'depth6'} med, got $dat" );
# - try to lose one mediator:
$aref = $usf->list_mediators($word1, $word2, depth => 5, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth5'}), "Seeking $dat_ref{'depth5'} med, got $dat" );
#- control mediator-to-associate depth:
$aref = $usf->list_mediators($word1, $word2, depth => 6, depth_med => 12, data => 0, ref => 1);
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depthmed12'}), "Seeking $dat_ref{'depthmed12'} med, got $dat" );
# - try to drop one:
$aref = $usf->list_mediators($word1, $word2, depth => 6, depth_med => 11, data => 0, ref => 1);
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depthmed11'}), "Seeking $dat_ref{'depthmed11'} med, got $dat" );

#- try to get data, not just word list:
$aref = $usf->list_mediators($word1, $word2, depth => 6, data => 1, ref => 1);
# -- expect only 2 lines - check the value of the 5th col in the 2nd line:
$dat = $aref->[1]->[5];
ok( is_equal($dat, $dat_ref{'depthval6s5'}), "Seeking $dat_ref{'depthval6s5'} meds, got $dat");
# - same but as a reference of hashed lines:
$aref = $usf->list_mediators($word1, $word2, depth => 6, data => 2, ref => 1);
$dat = $aref->[1]->{'FSG'};
ok( is_equal($dat, $dat_ref{'depthval6s5'}), "Seeking $dat_ref{'depthval6s5'} meds, got $dat");

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
