use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'Lingua::Norms::USF',
    AUTHOR              => q{Roderick Garton <rgarton@cpan.org>},
    VERSION_FROM        => 'lib/Lingua/Norms/USF.pm',
    ABSTRACT_FROM       => 'lib/Lingua/Norms/USF.pm',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
      ? ('LICENSE'=> 'perl')
      : ()),
    PL_FILES            => {},
    PREREQ_PM => {
		'Algorithm::Combinatorics' => 0,
		'File::RandomLine' => 0,
		'File::Slurp' => 0,
		'Lingua::EN::Syllable' => 0,
		'List::AllUtils' => 0,
		'Math::Random::Discrete' => 0,
		'Scalar::Util' => 0,
		'String::Similarity' => 1,
		'String::Util' => 0,
        'Test::More' => 0,
		'Text::CSV::Separator' => 0,
		'Text::LevenshteinXS' => 0,
		'Text::WagnerFischer' => 0,
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'Lingua-Norms-USF-0.01-*' },
);
