use 5.006;
use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Lingua::Norms::USF',
    license             => 'perl',
    dist_author         => q{Roderick Garton <rgarton@cpan.org>},
    dist_version_from   => 'lib/Lingua/Norms/USF.pm',
    build_requires => {
		'Algorithm::Combinatorics' => 0,
		'File::RandomLine' => 0,
		'File::Slurp' => 0,
		'Lingua::EN::Syllable' => 0,
		'List::AllUtils' => 0,
		'Math::Random::Discrete' => 0,
		'Scalar::Util' => 0,
		'String::Similarity' => 1,
		'String::Util' => 0,
        'Test::More' => 0,
		'Text::CSV::Separator' => 0,
		'Text::LevenshteinXS' => 0,
		'Text::WagnerFischer' => 0,
    },
    requires => {
        'perl' => 5.10.0,
    },
    add_to_cleanup      => [ 'Lingua-Norms-USF-0.01-*' ],
    create_makefile_pl => 'traditional',
);

$builder->create_build_script();
