package Forms::Sflang_dbc;

use strict;
use warnings;

use Wx::Perl::DbLinker::Wxform;

use Gtk2::Ex::DbLinker::DbcDataManager;
use Data::Dumper;
use Wx_dnav;

=for comment
The value comming from langid is used to display a combo and is also stored in a text field named langid1 in the xrc file.
The text field trigger a change event when records are navigate in the subform, but the combo does not.
The event is used to update the grid
=cut

use Wx qw[:everything];

sub new {
	 my $class = shift;
	 # , $href ) = @_;
         
	  my %arg = ref $_[0] eq "HASH" ? %{$_[0]} : ( @_ );
	 my $self;
	@$self{qw(dnav_top)} = delete @arg{qw(dnav)};
       	@$self{keys %arg} = values (%arg);
=for comment
	  {
   	xrcfolder => $$href{xrcfolder},
	schema => $$href{schema},
	dnav_top => $$href{dnav},
	panel_to => $$href{panel_to},
	countryid => $$href{countryid},
   };
=cut
    $self->{log} = Log::Log4perl->get_logger(__PACKAGE__);
$self->{log}->debug(" new form ");

	my $top_panel = $self->{dnav_top}->load_panel($self->{panel_to}, 'xrc/nav.xrc', 'm_dnav_panel');

 my $path = $self->{xrcfolder} .  "\\subform.xrc";
  $self->{dnav} = Wx_dnav->new({ismain=>0, frame=> $top_panel}); 


  $self->{dnav}->load_panel("m_panel_for_content", $path,  "m_panel1"); 
  $self->{dnav}->frame->SetBackgroundColour(wxLIGHT_GREY);

  $self->{dnav}->populate_widgets($top_panel, [qw(b_add b_apply)]);

 $self->{log}->debug("sform - populate_widgets 2d: " . join(" ", map {$_->GetName}  @{$self->{dnav}->{w2disable}}));		
 $self->{log}->debug("sform - populate_widgets: 2e: " . join(" ", map {$_->GetName}  @{$self->{dnav}->{w2enable}}));		

   
	my $rs = $self->{schema}->resultset('Speak')->search_rs({countryid => $self->{countryid}}, {columns => ['countryid', 'langid', {langid1 => 'langid'}]});
# (Dumper $rs->as_query);
#die $rs->count;

	my $dman = Gtk2::Ex::DbLinker::DbcDataManager->new(
			rs => $rs,
			);

		$self->{sform} = Wx::Perl::DbLinker::Wxform->new(
		data_manager => $dman,
		builder => $self->{dnav},
		datawidgets => [qw(countryid langid langid1)],
		rec_spinner => $self->{dnav}->get_object('RecordSpinner'),
	    	status_label=>  $self->{dnav}->get_object('lbl_RecordStatus'),
		rec_count_label => $self->{dnav}->get_object("lbl_RecordCount"),
		datawidgets_ro => [qw(langid1)],
		datawidgets_changed => {langid1=> sub{ on_langid1_changed(@_, $self) } },
		after_update => sub{ on_after_update($self, $self->{dnav}, $dman, "form"); },
			);

		my $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new(
				rs => $self->{schema}->resultset('Langue')->search_rs(undef, {order_by => 'langue' }),
				#{columns => ['langue', {langid2 => 'langid'}],
			);
		
		$self->{sform}->add_combo(
			data_manager => $combodata,
		    	id => 'langid',
			builder => $self->{dnav},
			);


		$self->{langid} = $self->{sform}->get_data_manager->get_field('langid1');
		my $list =  Gtk2::Ex::DbLinker::DbcDataManager->new(
				rs => $self->{schema}->resultset('Speak')->search_rs({langid => $self->{langid}, countryid => {'!=' => $self->{countryid} }}),
			);

		 $combodata = Gtk2::Ex::DbLinker::DbcDataManager->new(
				rs => $self->{schema}->resultset('Country')->search_rs(undef, { order_by => 'country'} ),
			);


		#set up the datasheet
		#$top_panel = $self->{dnav}->load_panel('m_panel_for_grid', 'xrc/nav.xrc', 'm_dnav_panel');
		$top_panel = $self->{dnav}->load_panel('m_panel_for_grid', 'xrc/nav.xrc', 'm_dnav_panel', wxCYAN);
		
		$self->{sf_list}->{dnav} = Wx_dnav->new({ismain=>0, frame => $top_panel});
		$self->{sf_list}->{dnav}->populate_widgets($top_panel, [qw(b_add b_apply)]);
		$self->{log}->debug("grid - populate_widgets: " . join(" ", map {$_->GetName}  @{$self->{sf_list}->{dnav}->{w2disable}}));


		#  renderer => "combo",	header_markup => "Country", data_manager=> $combodata, fieldnames => ["countryid", "country"],
		my $dsparam = {
			data_manager => $list,
			fields => [
				{name=>"countryid",
					renderer => "combo",	header_markup => "Country", data_manager=> $combodata, fieldnames => ["countryid", "country"],
					},	
				   {name=>"langid", renderer=>"hidden"},
				
		        	],
			after_update => => sub{ on_after_update($self, $self->{sf_list}->{dnav}, $list, "grid"); },
		
		};
		#my $grid = $self->{dnav}->load_grid({ top_panel=> $top_panel, dest_name=>"m_panel_for_content", datasheet_param =>$dsparam});
		$self->{grid} = $self->{dnav}->load_grid({bg=> wxCYAN, top_panel=> $top_panel, dest_name=>"m_panel_for_content", datasheet_param =>$dsparam});

	        $self->{sf_list}->{dnav}->set_form($self->{grid});
		$self->{sf_list}->{dnav}->connect_signal_for("b_add",\&on_add_lst_clicked, $self);
		$self->{grid}->update; 
		$self->{sform}->add_childform($self->{grid});

		 # on_countryid_changed($self, $self->{sform}->get_widget_value('countryid'));
		 # $sf_dnav->show_all_except([]);
		 
		$self->{dnav}->show_all_except([qw(langid1 countryid)]);
   		$self->{dnav}->connect_signal_for("b_add", \&on_add_clicked, $self );
   		$self->{dnav}->connect_signal_for("b_delete", \&on_delete_clicked, $self );
   		$self->{dnav}->connect_signal_for("b_apply", \&on_apply_clicked, $self );

		$self->{sform}->update;
		bless $self, $class;

}

sub on_countryid_changed {
	 my ($self,$value) = @_;
	if  (! defined $value || $value eq ""){
		$self->{langid} = undef;
		$self->{dnav}->widgets_set_sensitivity($self->{widgets}, 0);
		
	} else {
		return if ($value == $$self{countryid});
		$self->{log}->debug("countryid_changed countryid : $value");
		$self->{countryid}=$value;
		my $test = $self->{sform}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({ countryid => $value},  {columns => ['countryid', 'langid', {langid1 => 'langid'}]}) );
		$self->{log}->debug("query in subform returned : " . $test);
		$self->{sform}->update;
		$value = $self->{sform}->get_widget_value("langid");
		$self->{log}->debug("langid: " . (defined $value ? $value : " undef"));
		if ($value != $self->{langid}) {

			$self->{log}->debug("countryid_changed langid $value");
			$self->{grid}->get_data_manager->query(  $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} }) );
			$self->{grid}->update;
		}

	}
	


}

sub on_after_update {
	my ($self, $dnav, $dman, $where) = @_;
	#my $rc = $self->{sform}->get_data_manager->row_count;
	my $rc = $dman->row_count;
	$self->{log}->debug("on_after_update rc: " . $rc . " in " . $where);
	if ($rc == 0) {	
		$dnav->widgets_set_sensitivity(0);
	} else {
		$dnav->widgets_set_sensitivity(1);
	}

}

sub on_langid1_changed {
	my ($b, $e, $self) = @_;
	$self->{log}->debug("langid1_changed current values  countryid: " . ( defined $self->{countryid} ? $self->{countryid} : " undef" ) . " langid: " .  ( defined $self->{langid} ? $self->{langid} : " undef" ) );
	#print Dumper($b);
	my $value = $b->GetLineText(0);
	$value = (defined $value && $value eq "" ? undef : $value);
	if (defined $value && $value != $self->{langid} ) { #query and update are called only when langid changes
		$self->{log}->debug("langid : $value");
		$self->{langid} = $value;
		$self->{grid}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} })  );
		$self->{grid}->update;
	
	} elsif (! defined $value) {
		$self->{log}->debug("setting langid to undef");
		$self->{langid} = undef;
		$self->{grid}->get_data_manager->query( $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} })  );
		$self->{grid}->update;
	}
	
}

sub on_delete_clicked {
    my ($b, $self) =@_;
    $self->{sform}->delete;
}

sub on_add_clicked {
    my ($b, $self) = @_;
    #die Dumper ($self->{countryid});
    $self->{sform}->insert;
    $self->{sform}->set_widget_value("countryid",$self->{countryid});
    $self->{dnav}->get_object("langid")->Enable(1);
    
}


sub on_apply_clicked {
    my ($b, $self) = @_;
     my  $c = $self->{sform}->get_widget_value('countryid');
     return unless ($c ne "");
     my $value =  $self->{sform}->get_widget_value('langid');
    $self->{log}->debug("sform_apply country : " . $self->{countryid} . " langue : " .  $value );
    $self->{sform}->set_widget_value("langid1", $value);
    $self->{sform}->apply;
    $self->{sform}->update;
  	$self->{grid}->get_data_manager->query(  $self->{schema}->resultset('Speak')->search_rs({langid => $value, countryid => {'!=' => $self->{countryid}} }) );
	$self->{grid}->update;
}



sub on_add_lst_clicked {
	my ($b, $self) = @_;
	return unless defined $self->{langid};
	#ajoute une ligne vide qu'il faut completer avec le pays
	$self->{grid}->insert($self->{grid}->colnumber_from_name("langid") =>  $self->{langid});
	

}


1;
