BEGIN {
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by inc::My::MakeMaker v(dev).
use strict;
use warnings;

use 5.010;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Simplified alternative to Alien::FFI that uses system libffi",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Alt-Alien-FFI-System",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME" => "Alt::Alien::FFI::System",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "ExtUtils::CBuilder" => 0,
    "Test::More" => "0.94"
  },
  "VERSION" => "0.08",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "ExtUtils::CBuilder" => 0,
  "ExtUtils::MakeMaker" => 0,
  "Test::More" => "0.94"
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

do {

  # we do a compile/link test
  # but not a run test
  # that is reserved for for t/basic.t

  use lib 'lib';
  require ExtUtils::CBuilder;
  require Alien::FFI;

  my $b = ExtUtils::CBuilder->new;
  
  my $obj = eval {
    $b->compile(
      source               => "t/basic.c",
      extra_compiler_flags => Alien::FFI->cflags,
    );
  };
  
  if($@) {
    print STDERR "unable to compile with cflags=", Alien::FFI->cflags, "\n";
    exit;
  }

  my($exe, @rest) = eval {
    $b->link_executable(
      objects            => $obj,
      extra_linker_flags => Alien::FFI->libs,
    );
  };
  
  if($@) {
    print STDERR "unable to compile with libs=", Alien::FFI->libs, "\n";
    exit;
  }

  unlink $obj if $obj;
  unlink $exe if $exe;
  unlink $_ for @rest;

};


my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';
WriteMakefile(%WriteMakefileArgs);
