package Bencher::Scenario::IPCSystemOptions;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => "Measure the overhead of IPC::System::Options's system()".
        "over CORE::system()",
    modules => {
        'IPC::System::Options' => {version=>0.27},
    },
    default_precision => 0.001,
    participants => [
        {
            name => 'core-true',
            code => sub {
                system {"/bin/true"} "/bin/true";
            },
        },
        {
            name => 'iso-true',
            module => 'IPC::System::Options',
            code => sub {
                IPC::System::Options::system({shell=>0}, "/bin/true");
            },
        },
        {
            name => 'core-perl',
            code => sub {
                system {$^X} $^X, "-e1";
            },
        },
        {
            name => 'iso-perl',
            module => 'IPC::System::Options',
            code => sub {
                IPC::System::Options::system({shell=>0}, $^X, "-e1");
            },
        },
    ],
};

1;
# ABSTRACT: Measure the overhead of IPC::System::Options's system()over CORE::system()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::IPCSystemOptions - Measure the overhead of IPC::System::Options's system()over CORE::system()

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::IPCSystemOptions (from Perl distribution Bencher-Scenario-IPCSystemOptions), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m IPCSystemOptions

To run module startup overhead benchmark:

 % bencher --module-startup -m IPCSystemOptions

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<IPC::System::Options> 0.27

=head1 BENCHMARK PARTICIPANTS

=over

=item * core-true (perl_code)



=item * iso-true (perl_code)

L<IPC::System::Options>



=item * core-perl (perl_code)



=item * iso-perl (perl_code)

L<IPC::System::Options>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m IPCSystemOptions >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | iso-perl    |       395 |      2.53 |       1    | 2.5e-06 |     382 |
 | core-perl   |       401 |      2.49 |       1.01 | 2.5e-06 |     452 |
 | iso-true    |       588 |      1.7  |       1.49 | 1.6e-06 |     278 |
 | core-true   |       602 |      1.66 |       1.52 | 1.6e-06 |      87 |
 +-------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m IPCSystemOptions --module-startup >>):

 +----------------------+-----------+------------------------+------------+---------+---------+
 | participant          | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +----------------------+-----------+------------------------+------------+---------+---------+
 | IPC::System::Options |       6.6 |                    4.1 |       1    | 6.3e-06 |    1025 |
 | perl -e1 (baseline)  |       2.5 |                    0   |       2.64 | 2.5e-06 |     334 |
 +----------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Conclusion: Testing on my system (L<IPC::System::Options> 0.24, perl: 5.22.0,
CPU: Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores)) shows the overhead to be
~40μs (0.04ms) so for benchmarking commands that have overhead in the range of
10-100ms we normally don't need to worry about the overhead of
IPC::System::Option (0.04-0.4%) when we are using default precision (~1%).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-IPCSystemOptions>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-IPCSystemOptions>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-IPCSystemOptions>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
