# This -*- perl -*- script writes the Makefile for WWW::Search
# $Id: Makefile.PL,v 1.27 2002/07/18 21:46:10 mthurn Exp mthurn $

require 5.004;

@programs_to_install = qw( WebSearch AutoSearch );

# Allow us to suppress all program installation with the -n (library only)
# option.  This is for those that don't want to mess with the configuration
# section of this file.
use Getopt::Std;
my $opt_n;
unless (getopts("n")) { die "Usage: $0 [-n]\n"; }
@programs_to_install = () if $opt_n;

# Ok, now it is time to really generate the Makefile
use ExtUtils::MakeMaker;
# $ExtUtils::MakeMaker::Verbose = 99;

WriteMakefile(
              'NAME' => 'WWW::Search',
              'VERSION' => 2.37,

              ($] ge '5.005') ? (
                                 'AUTHOR' => 'Martin Thurn <mthurn@cpan.org>',
                                 'ABSTRACT' => 'Query web search engines and get URLs',
                                ) : (),
              'EXE_FILES' => [ @programs_to_install ],
              'PREREQ_PM' => {
                              'File::Find' => 0,
                              'File::Spec' => 0,
                              'Getopt::Long' => 2.24,  # for AutoSearch
                              'HTML::Parser' => 2.23,
                              'HTML::TreeBuilder' => 0,  # HTML-Tree-0.51 is good
                              'LWP::UserAgent' => 2.0,
                              'MIME::Lite' => 0,  # only needed for AutoSearch's --mail option
                              'Net::Domain' => 0,
                              'POSIX' => 0,  # for AutoSearch
                              'Test::Inline' => 0,
                              'Test::More' => 0,
                              'URI' => 0,
                              'URI::Escape' => 0,
                              'User' => 0,
                             },
              'clean' => { FILES => join(' ', @programs_to_install) },
             );

sub MY::preamble
  {
  # This does not work because MakeMaker apparently does not have a
  # preamble method.
  return '

AutoSearch :: FORCE
	/bin/rm -f AutoSearch

';
  } # MY::postamble


sub MY::postamble
  {
  return '
test_parsing: pure_all
	PERL_DL_NONLAZY=1 $(FULLPERL) -I$(INST_ARCHLIB) -I$(INST_LIB) -I$(PERL_ARCHLIB) -I$(PERL_LIB) t/test_parsing.pl $(TEST_ARGS)

tags:
	cat MANIFEST | etags -

';
  } # MY::postamble

# The following was added for Test::Inline handling.  Derived from
# `perldoc Test::Inline::Tutoral`.

  {
  package MY;

  sub top_targets
    {
    my $self = shift;
    # Use the default setting for (not) echoing commands during make:
    my $NOECHO = $self->{NOECHO};
    # And, ignore error signals.  This is necessary because pod2test
    # carps if the file contains no test code!
    $NOECHO .= '-';
    # Assume it's in the path:
    my $out = "POD2TEST_EXE = pod2test\n";
    $out .= $self->SUPER::top_targets(@_);
    $out .= "\n\ntestifypods : \n";
    $out .= "\t\$(FULLPERL) -MExtUtils::Command -e rm_f t/embedded-*.t\n";
    use Data::Dumper;
    # print STDERR " + self is ", Dumper($self);
    my %hsPOD;
    foreach my $pod (keys %{$self->{MAN1PODS}},
                     keys %{$self->{MAN3PODS}},
                     # Win32 has no MANPODS, so we add these:
                     keys %{$self->{PM}},
                    )
      {
      # print STDERR " +   will testifypod $pod\n";
      $hsPOD{$pod}++;
      } # foreach $pod
    foreach my $pod (keys %hsPOD)
      {
      # print STDERR " +   writing code to testifypod $pod\n";
      (my $test = $pod) =~ s/\.(pm|pod)$//;
      $test =~ s|/|-|g;
      $test =~ s/^lib\W//;
      $test =~ s/\W/-/;
      $test = "embedded-$test.t";
      my $sCode = "\$(POD2TEST_EXE) $pod t/$test";
      # print STDERR " +     code to testifypod $pod is $sCode\n";
      $out .= "\t$NOECHO $sCode\n";
      } # foreach
    return $out;
    } # MY::top_targets

  sub test
    {
    my $self = shift;
    my $out = $self->SUPER::test(@_);
    # Insert our target as a prerequisite for the main test goal:
    $out =~ s!^(test :: )(.*)!$1 pure_all testifypods $2!m;
    return $out;
    } # MY::test

  } # end of package MY block
