CREATE TABLE updates_pending(
    update_id INTEGER NOT NULL UNIQUE,
    terms VARCHAR NOT NULL,
    resolve INTEGER,
    FOREIGN KEY(update_id) REFERENCES updates(id) ON DELETE CASCADE
);

CREATE TRIGGER
    updates_pending_bi_1
BEFORE INSERT ON
    updates_pending
FOR EACH ROW
BEGIN
    SELECT debug(
        'TRIGGER updates_pending_bi_1',
        NEW.update_id,
        NEW.terms
    );
END;

CREATE TRIGGER
    updates_pending_bu_1
BEFORE UPDATE ON
    updates_pending
FOR EACH ROW WHEN
    NEW.resolve = 1
BEGIN

    SELECT debug(
        'TRIGGER updates_pending_bu_1',
        NEW.update_id,
        NEW.terms
    );

    UPDATE
        updates
    SET
        uuid = sha1_hex(NEW.terms)
    WHERE
        id = NEW.update_id
    ;

/*
    -- don't do this until development stops
    DELETE FROM
        updates_pending
    WHERE
        update_id = NEW.update_id
    ;
*/
    SELECT RAISE(IGNORE);
END;
