/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HTMLLauncher
implements HTMLResultsListener {
    private SeleniumServer server;
    private HTMLTestResults results;

    public HTMLLauncher(SeleniumServer server) {
        this.server = server;
    }

    public String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, int timeoutInSeconds, boolean multiWindow) throws IOException {
        outputFile.createNewFile();
        if (!outputFile.canWrite()) {
            throw new IOException("Can't write to outputFile: " + outputFile.getAbsolutePath());
        }
        long timeoutInMs = 1000L * (long)timeoutInSeconds;
        if (timeoutInMs < 0L) {
            System.err.println("Looks like the timeout overflowed, so resetting it to the maximum.");
            timeoutInMs = Long.MAX_VALUE;
        }
        this.server.handleHTMLRunnerResults(this);
        BrowserLauncherFactory blf = new BrowserLauncherFactory(this.server);
        String sessionId = Long.toString(System.currentTimeMillis() % 1000000L);
        BrowserLauncher launcher = blf.getBrowserLauncher(browser, sessionId, null);
        this.server.registerBrowserLauncher(sessionId, launcher);
        launcher.launchHTMLSuite(suiteURL, browserURL, multiWindow);
        long now = System.currentTimeMillis();
        long end = now + timeoutInMs;
        while (this.results == null && System.currentTimeMillis() < end) {
            AsyncExecute.sleepTight(500L);
        }
        launcher.close();
        if (this.results == null) {
            throw new SeleniumCommandTimedOutException();
        }
        if (outputFile != null) {
            FileWriter fw = new FileWriter(outputFile);
            this.results.write(fw);
            fw.close();
        }
        return this.results.getResult().toUpperCase();
    }

    public String runHTMLSuite(String browser, String browserURL, File suiteFile, File outputFile, int timeoutInSeconds, boolean multiWindow) throws IOException {
        if (!suiteFile.exists()) {
            throw new IOException("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
        }
        if (!suiteFile.canRead()) {
            throw new IOException("Can't read HTML Suite file: " + suiteFile.getAbsolutePath());
        }
        this.server.addNewStaticContent(suiteFile.getParentFile());
        String suiteURL = browserURL + "/selenium-server/tests/" + suiteFile.getName();
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow);
    }

    public void processResults(HTMLTestResults resultsParm) {
        this.results = resultsParm;
    }
}

