use Test::More;
use NetAddr::IP;

# $Id: v4-snew.t,v 1.3 2003/05/29 17:45:00 lem Exp $

my %w = ('broadcast'	=> [ '255.255.255.255', '255.255.255.255' ],
	 'default'	=> [ '0.0.0.0', '0.0.0.0' ],
	 'loopback'	=> [ '127.0.0.1', '255.0.0.0' ],
	 '10.'		=> [ '10.0.0.0', '255.0.0.0' ],
	 '10/8'		=> [ '10.0.0.0', '255.0.0.0' ],
	 '127/8'	=> [ '127.0.0.0', '255.0.0.0' ],
	 '11.11.'	=> [ '11.11.0.0', '255.255.0.0' ],
	 '12.12.12.'	=> [ '12.12.12.0', '255.255.255.0' ],
	 '13.13.13.13'	=> [ '13.13.13.13', '255.255.255.255' ],
	 '0-127'	=> [ '0.0.0.0', '128.0.0.0' ],
	 '128-255'	=> [ '128.0.0.0', '128.0.0.0' ],
	 '0-63'		=> [ '0.0.0.0', '192.0.0.0' ],
	 '128-191'	=> [ '128.0.0.0', '192.0.0.0' ],
	 '10.128.0-127'	=> [ '10.128.0.0', '255.255.128.0' ],
	 '10.10.10/24'	=> [ '10.10.10.0', '255.255.255.0' ],
	 '10.10/16'	=> [ '10.10.0.0', '255.255.0.0' ],
	 '10.10.10'	=> [ '10.10.0.10', '255.255.255.255' ],
	 );

plan tests => 2 * scalar keys %w;

for my $a (keys %w) {
    my $ip = new NetAddr::IP $a;
    is($ip->addr, $w{$a}->[0], "Matching ->addr()");
    is($ip->mask, $w{$a}->[1], "Matching ->mask()");
}
