package Image::PNG::Simple;

use 5.008007;
use strict;
use warnings;

our $VERSION = '0.05';

require XSLoader;
XSLoader::load('Image::PNG::Simple', $VERSION);

1;

=head1 NAME

Image::PNG::Simple - Convert bitmap file to png file without C library dependency.

=head1 CAUTION

This is beta release. API will be changed without warnings.

=head1 SYNOPSIS

  use Image::PNG::Simple;
  
  # Create Image::PNG::Simple object
  my $ips = Image::PNG::Simple->new;
  
  # Read bitmap file
  $ips->read_bmp_file('dog.bmp');
  
  # Write png file
  $ips->write_png_file('dog.png');

=head1 DESCRIPTION

Convert bitmap file to png file without C library dependency.

=head1 METHODS

=head2 new

  my $ips = Image::PNG::Simple->new;

Create new Image::PNG::Simple object.

=head2 read_bmp_file

  $ips->read_bmp_file('dog.bmp');

Read bitmap file.

=head2 write_bmp_file

  $ips->write_bmp_file('dog_copy.bmp');

Write bitmap file.

=head2 write_png_file

  $ips->write_png_file('dog.png');

Write png file.

=head1 INTERNAL

This module internally use libpng-1.6.17 and zlib-1.2.8.
So This module license follow Perl license, libpng license and zlib license.

=head1 SEE ALSO

L<Image::PNG>, L<Imager::File::PNG>, L<Image::PNG::Libpng>

=head1 AUTHOR

Yuki Kimoto E<lt>kimoto.yuki@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 by Yuki Kimoto

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl, libpng, and zlib itself, either Perl version 5.16.3 or,
at your option, any later version of Perl 5 you may have available.

=cut
