use Mojo::Base -strict;
use Test::More;
use Mojolicious::Lite;
use Mojolicious::Plugin::Riotjs;
use File::Temp 'tempdir';

plan skip_all => './node_modules does not exist' unless -d './node_modules';

my @original = grep {-d} split /:/, $ENV{NODE_PATH};
my $tempdir = tempdir;
my (@path, $expected);

app->home(Mojo::Home->new($tempdir));

@path = Mojolicious::Plugin::Riotjs->node_paths(app);
$expected = join ':', @original, Cwd::abs_path('node_modules');
is join(':', @path), $expected, $expected;

mkdir "$tempdir/node_modules";
@path = Mojolicious::Plugin::Riotjs->node_paths(app);
$expected = join ':', @original, Cwd::abs_path('node_modules'), "$tempdir/node_modules";
is join(':', @path), $expected, $expected;
rmdir "$tempdir/node_modules";
rmdir "$tempdir";

ok !-d $tempdir, 'tempdir was removed';

done_testing;
