package Locale::CLDR::Te;
# This file auto generated from Data\common\main\te.xml
#	on Mon 31 Mar  2:08:32 am GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use v5.18;
use mro 'c3';
use utf8;

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'అఫార్',
 				'ab' => 'అబ్ఖాజియన్',
 				'ace' => 'ఆఖినీస్',
 				'ach' => 'అకోలి',
 				'ada' => 'అడాంగ్మే',
 				'ady' => 'అడిగాబ్జే',
 				'ae' => 'అవేస్టాన్',
 				'af' => 'ఆఫ్రికాన్స్',
 				'afh' => 'అఫ్రిహిలి',
 				'ain' => 'ఐను',
 				'ak' => 'అకాన్',
 				'akk' => 'అక్కాడియాన్',
 				'ale' => 'అలియుట్',
 				'alt' => 'దక్షిణ ఆల్టై',
 				'am' => 'అమ్హారిక్',
 				'an' => 'అరగోనిస్',
 				'ang' => 'ప్రాచీన ఆగ్లం',
 				'anp' => 'ఆంగిక',
 				'ar' => 'అరబిక్',
 				'ar_001' => 'ఆధునిక ప్రామాణిక అరబిక్',
 				'arc' => 'అరామేక్',
 				'arn' => 'అరౌకేనియన్',
 				'arp' => 'అరాపాహో',
 				'arw' => 'అరావాక్',
 				'as' => 'అస్సామీ',
 				'ast' => 'అస్టురియాన్',
 				'av' => 'అవారిక్',
 				'awa' => 'అవధి',
 				'ay' => 'ఐమారా',
 				'az' => 'అజర్బైజాని',
 				'az@alt=short' => 'అజెరి',
 				'ba' => 'బష్కిర్',
 				'bal' => 'బాలుచి',
 				'ban' => 'బాలినీస్',
 				'bas' => 'బసా',
 				'be' => 'బెలరుశియన్',
 				'bej' => 'బేజా',
 				'bem' => 'బెంబా',
 				'bg' => 'బల్గేరియన్',
 				'bho' => 'భోజ్ పూరి',
 				'bi' => 'బిస్లామా',
 				'bik' => 'బికోల్',
 				'bin' => 'బిని',
 				'bla' => 'సిక్ సికా',
 				'bm' => 'బంబారా',
 				'bn' => 'బెంగాలీ',
 				'bo' => 'టిబెటన్',
 				'br' => 'బ్రెటన్',
 				'bra' => 'బ్రాజ్',
 				'brx' => 'బోడో',
 				'bs' => 'బోస్నియన్',
 				'bua' => 'బురియట్',
 				'bug' => 'బ్యుగినిస్',
 				'byn' => 'బ్లిన్',
 				'ca' => 'కెటలాన్',
 				'cad' => 'కేడ్డో',
 				'car' => 'కేరిబ్',
 				'cch' => 'అట్సామ్',
 				'ce' => 'చెచెన్',
 				'ceb' => 'సేబుఆనో',
 				'ch' => 'చమర్రో',
 				'chb' => 'చిబ్చా',
 				'chg' => 'చాగటై',
 				'chk' => 'చూకిస్',
 				'chm' => 'మారి',
 				'chn' => 'చినూక్ జార్గన్',
 				'cho' => 'చొచ్కతావ్',
 				'chp' => 'చిపెవ్యాన్',
 				'chr' => 'చెరోకీ',
 				'chy' => 'చేయేన్',
 				'ckb' => 'సొరాని కుర్దిష్',
 				'co' => 'కోర్సికన్',
 				'cop' => 'కోప్టిక్',
 				'cr' => 'క్రి',
 				'crh' => 'క్రిమియన్ టర్కిష్',
 				'cs' => 'చెక్',
 				'csb' => 'కషుబియన్',
 				'cu' => 'చర్చ స్లావిక్',
 				'cv' => 'చువాష్',
 				'cy' => 'వెల్ష్',
 				'da' => 'డేనిష్',
 				'dak' => 'డకోటా',
 				'dar' => 'డార్గ్వా',
 				'de' => 'జర్మన్',
 				'de_AT' => 'ఆస్ట్రేలియన్ జర్మన్',
 				'de_CH' => 'స్విస్ హై జర్మన్',
 				'del' => 'డెలావేర్',
 				'den' => 'స్లేవ్',
 				'dgr' => 'డోగ్రిబ్',
 				'din' => 'డింకా',
 				'doi' => 'డోగ్రి',
 				'dsb' => 'లోవర్ సోర్బియన్',
 				'dua' => 'దుఆలా',
 				'dum' => 'మధ్యమ డచ్',
 				'dv' => 'దివేహి',
 				'dyu' => 'డ్యులా',
 				'dz' => 'జొన్ఖా',
 				'ee' => 'ఈవీ',
 				'efi' => 'ఎఫిక్',
 				'egy' => 'ప్రాచీన ఇజిప్షియన్',
 				'eka' => 'ఏకాజక్',
 				'el' => 'గ్రీక్',
 				'elx' => 'ఎలామైట్',
 				'en' => 'ఆంగ్లం',
 				'en_AU' => 'ఆస్ట్రేలియన్ ఇంగ్లీష్',
 				'en_CA' => 'కెనడియన్ ఇంగ్లీష్',
 				'en_GB' => 'బ్రిటిష్ ఇంగ్లీష్',
 				'en_GB@alt=short' => 'యు.కె. ఇంగ్లీష్',
 				'en_US' => 'అమెరికన్ ఇంగ్లీష్',
 				'en_US@alt=short' => 'యు.ఎస్. ఇంగ్లీష్',
 				'enm' => 'మధ్యమ ఆంగ్లం',
 				'eo' => 'ఎస్పరెన్టొ',
 				'es' => 'స్పానిష్',
 				'es_419' => 'లాటిన్ అమెరికెన్ స్పానిష్',
 				'es_ES' => 'యూరోపియన్ స్పానిష్',
 				'es_MX' => 'మెక్సికన్ స్పానిష్',
 				'et' => 'ఈస్టొనియన్',
 				'eu' => 'బాస్క్',
 				'ewo' => 'ఎవోండొ',
 				'fa' => 'పర్షియన్',
 				'fan' => 'ఫాంగ్',
 				'fat' => 'ఫాంటి',
 				'ff' => 'ఫ్యుల',
 				'fi' => 'ఫిన్నిష్',
 				'fil' => 'ఫిలిపినో',
 				'fj' => 'ఫిజియన్',
 				'fo' => 'ఫారోయీజ్',
 				'fon' => 'ఫాన్',
 				'fr' => 'ఫ్రెంచ్',
 				'fr_CA' => 'కెనడియెన్ ఫ్రెంచ్',
 				'fr_CH' => 'స్విస్ ఫ్రెంచ్',
 				'frm' => 'మధ్యమ ప్రెంచ్',
 				'fro' => 'ప్రాచీన ప్రెంచ్',
 				'frr' => 'ఉత్తర ఫ్రిసియన్',
 				'frs' => 'తూర్పు ఫ్రిసియన్',
 				'fur' => 'ఫ్రియులియన్',
 				'fy' => 'పశ్చిమ ఫ్రిసియన్',
 				'ga' => 'ఐరిష్',
 				'gaa' => 'గా',
 				'gay' => 'గాయో',
 				'gba' => 'గ్బాయా',
 				'gd' => 'స్కాటిష్ గేలిక్',
 				'gez' => 'జీజ్',
 				'gil' => 'గిల్బర్టీస్',
 				'gl' => 'గెలిషియన్',
 				'gmh' => 'మధ్యమ హై జర్మన్',
 				'gn' => 'గురాని',
 				'goh' => 'ప్రాచీన హై జర్మన్',
 				'gon' => 'గోండి',
 				'gor' => 'గోరోంటలా',
 				'got' => 'గోథిక్',
 				'grb' => 'గ్రేబో',
 				'grc' => 'ప్రాచీన గ్రీక్',
 				'gsw' => 'స్విస్ జర్మన్',
 				'gu' => 'గుజరాతి',
 				'gv' => 'మంకస్',
 				'gwi' => 'గ్విచిన్',
 				'ha' => 'హౌసా',
 				'hai' => 'హైడా',
 				'haw' => 'హవాయియన్',
 				'he' => 'హీబ్రు',
 				'hi' => 'హిందీ',
 				'hil' => 'హిలి గేయినోన్',
 				'hit' => 'హిట్టిటే',
 				'hmn' => 'మోంగ్',
 				'ho' => 'హిరి మోటు',
 				'hr' => 'క్రొయెషియన్',
 				'hsb' => 'అప్పర్ సోర్బియన్',
 				'ht' => 'హైతియన్',
 				'hu' => 'హన్గేరియన్',
 				'hup' => 'హుపా',
 				'hy' => 'ఆర్మేనియన్',
 				'hz' => 'హిరేరో',
 				'ia' => 'ఇంటర్లింగ్వా',
 				'iba' => 'ఐబాన్',
 				'ibb' => 'ఇబిబియో',
 				'id' => 'ఇండోనేషియన్',
 				'ie' => 'ఇంటర్ లింగ్',
 				'ig' => 'ఇగ్బో',
 				'ii' => 'శిషువన్ ఈ',
 				'ik' => 'ఇనూపైఏక్',
 				'ilo' => 'ఐయోకో',
 				'inh' => 'ఇంగుష్',
 				'io' => 'ఈడౌ',
 				'is' => 'ఐస్లాండిక్',
 				'it' => 'ఇటాలియన్',
 				'iu' => 'ఇనుక్టిటుట్',
 				'ja' => 'జాపనీస్',
 				'jbo' => 'లోజ్బాన్',
 				'jpr' => 'జ్యుడియో-పర్షియన్',
 				'jrb' => 'జ్యుడియో-అరబిక్',
 				'jv' => 'జావనీస్',
 				'ka' => 'జార్జియన్',
 				'kaa' => 'కారా-కల్పాక్',
 				'kab' => 'కాబిల్',
 				'kac' => 'కాచిన్',
 				'kaj' => 'జ్యూ',
 				'kam' => 'కంబా',
 				'kaw' => 'కావి',
 				'kbd' => 'కబార్డియన్',
 				'kcg' => 'ట్యాప్',
 				'kfo' => 'కోరో',
 				'kg' => 'కోంగో',
 				'kha' => 'ఖాసి',
 				'kho' => 'ఖటోనీస్',
 				'ki' => 'కికుయు',
 				'kj' => 'క్వాన్యామ',
 				'kk' => 'కజఖ్',
 				'kl' => 'కలాల్లిసూట్',
 				'km' => 'ఖ్మేర్',
 				'kmb' => 'కిమ్బుండు',
 				'kn' => 'కన్నడ',
 				'ko' => 'కొరియన్',
 				'kok' => 'కొంకణి',
 				'kos' => 'కోస్రేయన్',
 				'kpe' => 'పెల్లే',
 				'kr' => 'కానురి',
 				'krc' => 'కరచే-బల్కార్',
 				'krl' => 'కరేలియన్',
 				'kru' => 'కూరుఖ్',
 				'ks' => 'కాశ్మీరి',
 				'ku' => 'కర్డిష్',
 				'kum' => 'కుమ్యిక్',
 				'kut' => 'కుటేనై',
 				'kv' => 'కోమి',
 				'kw' => 'కోర్నిష్',
 				'ky' => 'కిర్గిజ్',
 				'la' => 'లాటిన్',
 				'lad' => 'లాడినో',
 				'lah' => 'లాహండా',
 				'lam' => 'లాంబా',
 				'lb' => 'లుక్సంబర్గిష్',
 				'lez' => 'లేజ్ఘియన్',
 				'lg' => 'గాండా',
 				'li' => 'లిమ్బర్గిష్',
 				'ln' => 'లింగాల',
 				'lo' => 'లావో',
 				'lol' => 'మొంగో',
 				'loz' => 'లోజి',
 				'lt' => 'లిథుయేనియన్',
 				'lu' => 'లూబ-కటాంగ',
 				'lua' => 'లుబా-లులువ',
 				'lui' => 'లుఇసేనో',
 				'lun' => 'లుండా',
 				'luo' => 'లువో',
 				'lus' => 'లుషై',
 				'lv' => 'లాట్వియన్',
 				'mad' => 'మాదురీస్',
 				'mag' => 'మగాహి',
 				'mai' => 'మైథిలి',
 				'mak' => 'మకాసార్',
 				'man' => 'మండింగో',
 				'mas' => 'మాసాయి',
 				'mdf' => 'మొక్షా',
 				'mdr' => 'మండార్',
 				'men' => 'మెండే',
 				'mfe' => 'మొరిస్యేన్',
 				'mg' => 'మాలాగసి',
 				'mga' => 'మధ్యమ ఐరిష్',
 				'mh' => 'మార్షలీస్',
 				'mi' => 'మయోరి',
 				'mic' => 'మికమాక్',
 				'min' => 'మినాంగ్కాబో',
 				'mk' => 'మసడోనియన్',
 				'ml' => 'మలయాళం',
 				'mn' => 'మంగోలియన్',
 				'mnc' => 'మంచు',
 				'mni' => 'మణిపూరి',
 				'moh' => 'మోహుక్',
 				'mos' => 'మోస్సి',
 				'mr' => 'మరాఠీ',
 				'ms' => 'మలేయ్',
 				'mt' => 'మాల్టీస్',
 				'mul' => 'బహుళ భాషలు',
 				'mus' => 'క్రీక్',
 				'mwl' => 'మిరాండిస్',
 				'mwr' => 'మార్వాడి',
 				'my' => 'బర్మీస్',
 				'myv' => 'ఎర్జియా',
 				'na' => 'నౌరు',
 				'nap' => 'నియాపోలిటన్',
 				'nb' => 'నార్వీజియన్ బొక్మాల్',
 				'nd' => 'ఉత్తర దెబెలె',
 				'nds' => 'లో జర్మన్',
 				'ne' => 'నేపాలి',
 				'new' => 'నెవారి',
 				'ng' => 'దోంగా',
 				'nia' => 'నియాస్',
 				'niu' => 'నియూఇయాన్',
 				'nl' => 'డచ్',
 				'nl_BE' => 'ఫ్లెమిష్',
 				'nn' => 'నార్విజియాన్ న్యోర్స్క్',
 				'no' => 'నార్విజియాన్',
 				'nog' => 'నోగై',
 				'non' => 'ప్రాచిన నోర్స్',
 				'nqo' => 'న్కో',
 				'nr' => 'దక్షిణ దెబెలె',
 				'nso' => 'ఉత్తర సోతో',
 				'nv' => 'నవాహో',
 				'nwc' => 'సాంప్రదాయ న్యుఆరి',
 				'ny' => 'న్యాన్జా',
 				'nym' => 'న్యంవేజి',
 				'nyn' => 'న్యాన్కోలె',
 				'nyo' => 'నిఓరో',
 				'nzi' => 'జీమా',
 				'oc' => 'ఆక్సిటన్',
 				'oj' => 'చేవా',
 				'om' => 'ఒరోమో',
 				'or' => 'ఒరియా',
 				'os' => 'ఒసేటిక్',
 				'osa' => 'ఒసాజ్',
 				'ota' => 'ఒట్టోమన్ టర్కిష్',
 				'pa' => 'పంజాబీ',
 				'pag' => 'పంగా సినాన్',
 				'pal' => 'పహ్లావి',
 				'pam' => 'పంపగ్న',
 				'pap' => 'పపియమేంటో',
 				'pau' => 'పాలుఆన్',
 				'peo' => 'ప్రాచీన పర్షియన్',
 				'phn' => 'ఫోనికన్',
 				'pi' => 'పాలీ',
 				'pl' => 'పోలిష్',
 				'pon' => 'పోహ్న్పెయన్',
 				'pro' => 'ప్రాచీన ప్రోవెంసాల్',
 				'ps' => 'పాష్టో',
 				'ps@alt=variant' => 'పుష్టో',
 				'pt' => 'పోర్చుగీస్',
 				'pt_BR' => 'బ్రెజీలియన్ పోర్చుగీస్',
 				'pt_PT' => 'యూరోపియన్ పోర్చుగీస్',
 				'qu' => 'కెషుయా',
 				'raj' => 'రాజస్తాని',
 				'rap' => 'రాపన్యుయి',
 				'rar' => 'రారోటొంగాన్',
 				'rm' => 'రోమన్ష్',
 				'rn' => 'రండి',
 				'ro' => 'రోమానియన్',
 				'ro_MD' => 'మొల్డావియన్',
 				'rom' => 'రోమానీ',
 				'root' => 'రూట్',
 				'ru' => 'రష్యన్',
 				'rup' => 'ఆరోమేనియన్',
 				'rw' => 'కిన్యర్వాండా',
 				'sa' => 'సంస్కృతం',
 				'sad' => 'సండావి',
 				'sah' => 'యాకుట్',
 				'sam' => 'సమారిటన్ అరమేక్',
 				'sas' => 'ససక్',
 				'sat' => 'సంటాలి',
 				'sc' => 'సార్డీనియన్',
 				'scn' => 'సిసిలియన్',
 				'sco' => 'స్కాట్స్',
 				'sd' => 'సింధీ',
 				'se' => 'ఉత్తర సామి',
 				'sel' => 'సేల్కప్',
 				'sg' => 'సాంగో',
 				'sga' => 'ప్రాచీన ఐరిష్',
 				'sh' => 'సేర్బో-క్రొయేషియన్',
 				'shn' => 'షాన్',
 				'si' => 'సింహళం',
 				'sid' => 'సిడామో',
 				'sk' => 'స్లోవాక్',
 				'sl' => 'స్లోవేనియాన్',
 				'sm' => 'సమోవన్',
 				'sma' => 'దక్షిణ సామి',
 				'smj' => 'లులే సామి',
 				'smn' => 'ఇనారి సామి',
 				'sms' => 'స్కోల్ట్ సామి',
 				'sn' => 'షోన',
 				'snk' => 'సోనింకి',
 				'so' => 'సోమాలి',
 				'sog' => 'సోగ్డియన్',
 				'sq' => 'అల్బేనియన్',
 				'sr' => 'సెర్బియన్',
 				'srn' => 'స్రానన్ టోనగో',
 				'srr' => 'సెరేర్',
 				'ss' => 'స్వాతి',
 				'st' => 'దక్షిణ సోతో',
 				'su' => 'సుడానీస్',
 				'suk' => 'సుకుమా',
 				'sus' => 'సుసు',
 				'sux' => 'సుమేరియాన్',
 				'sv' => 'స్వీడిష్',
 				'sw' => 'స్వాహిలి',
 				'swb' => 'కొమొరియన్',
 				'syc' => 'సాంప్రదాయ సిరియాక్',
 				'syr' => 'సిరియాక్',
 				'ta' => 'తమిళము',
 				'te' => 'తెలుగు',
 				'tem' => 'టింనే',
 				'ter' => 'టెరెనో',
 				'tet' => 'టేటం',
 				'tg' => 'తజిక్',
 				'th' => 'థాయ్',
 				'ti' => 'తిగ్రిన్యా',
 				'tig' => 'టీగ్రె',
 				'tiv' => 'టివ్',
 				'tk' => 'తుర్కమెన్',
 				'tkl' => 'టోకెలావ్',
 				'tl' => 'తగలోగ్',
 				'tlh' => 'క్లింగాన్',
 				'tli' => 'లింగిట్',
 				'tmh' => 'టామషేక్',
 				'tn' => 'సెటస్వానా',
 				'to' => 'టాంగాన్',
 				'tog' => 'న్యాసా టోన్గా',
 				'tpi' => 'టోక్ పిసిన్',
 				'tr' => 'టర్కిష్',
 				'ts' => 'సోంగా',
 				'tsi' => 'శింషీయన్',
 				'tt' => 'టాటర్',
 				'tum' => 'టుంబుకా',
 				'tvl' => 'టువాలు',
 				'tw' => 'ట్వి',
 				'ty' => 'తహితియన్',
 				'tyv' => 'టువినియన్',
 				'udm' => 'ఉడ్ముర్ట్',
 				'ug' => 'ఉయ్‌ఘర్',
 				'uga' => 'ఉగారిటిక్',
 				'uk' => 'ఉక్రేనియన్',
 				'umb' => 'ఉమ్బుండు',
 				'und' => 'తెలియని భాష',
 				'ur' => 'ఉర్దూ',
 				'uz' => 'ఉజ్బెక్',
 				'vai' => 'వాయి',
 				've' => 'వెండా',
 				'vi' => 'వియత్నామీస్',
 				'vo' => 'వోలాపుక్',
 				'vot' => 'వోటిక్',
 				'wa' => 'వాలూన్',
 				'wal' => 'వాలామో',
 				'war' => 'వారే',
 				'was' => 'వాషో',
 				'wo' => 'వొలాఫ్',
 				'xal' => 'కల్మిక్',
 				'xh' => 'షోసా',
 				'yao' => 'యాఒ',
 				'yap' => 'యాపిస్',
 				'yi' => 'ఇడ్డిష్',
 				'yo' => 'యోరుబా',
 				'yue' => 'కాంటనీస్',
 				'za' => 'జువాన్',
 				'zap' => 'జపోటెక్',
 				'zbl' => 'బ్లిసింబల్స్',
 				'zen' => 'జెనాగా',
 				'zgh' => 'ప్రామాణిక మొరొకన్ తమజియట్',
 				'zh' => 'చైనీస్',
 				'zh_Hans' => 'సరళీకృత చైనీస్',
 				'zh_Hant' => 'సాంప్రదాయ చైనీస్',
 				'zu' => 'జూలూ',
 				'zun' => 'జుని',
 				'zxx' => 'లిపి లేదు',
 				'zza' => 'జాజా',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'అరబిక్',
 			'Arab@alt=variant' => 'పెర్‌సో-అరబిక్',
 			'Armi' => 'ఇంపీరియల్ అరామాక్',
 			'Armn' => 'అర్మేనియన్',
 			'Avst' => 'అవేస్టాన్',
 			'Bali' => 'బాలినీస్',
 			'Batk' => 'బాటక్',
 			'Beng' => 'బెంగాలి',
 			'Blis' => 'బ్లిస్సింబల్స్',
 			'Bopo' => 'బోపోమోఫో',
 			'Brah' => 'బ్రాహ్మి',
 			'Brai' => 'బ్రెయిల్',
 			'Bugi' => 'బ్యుగినీస్',
 			'Buhd' => 'బుహిడ్',
 			'Cakm' => 'చక్మా',
 			'Cans' => 'యునిఫైడ్ కెనెడియన్ అబొరిజినల్ సిలబిక్స్',
 			'Cari' => 'కారియన్',
 			'Cham' => 'చామ్',
 			'Cher' => 'చిరోకి',
 			'Cirt' => 'సిర్థ్',
 			'Copt' => 'కోప్టిక్',
 			'Cprt' => 'సైప్రోట్',
 			'Cyrl' => 'సిరిలిక్',
 			'Cyrs' => 'ప్రాచీన చర్చ స్లావోనిక్ సిరిలిక్',
 			'Deva' => 'దేవనాగరి',
 			'Dsrt' => 'డేసెరెట్',
 			'Egyd' => 'ఇజిప్షియన్ డెమోటిక్',
 			'Egyh' => 'ఇజిప్షియన్ హైరాటిక్',
 			'Egyp' => 'ఇజిప్షియన్ హైరోగ్లైఫ్స్',
 			'Ethi' => 'ఇథియోపిక్',
 			'Geok' => 'జార్జియన్ ఖట్సూరి',
 			'Geor' => 'జార్జియన్',
 			'Glag' => 'గ్లాగో లిటిక్',
 			'Goth' => 'గోతిక్',
 			'Grek' => 'గ్రీక్',
 			'Gujr' => 'గుజరాతీ',
 			'Guru' => 'గుర్ముఖి',
 			'Hang' => 'హంగుల్',
 			'Hani' => 'హాన్',
 			'Hano' => 'హనునూ',
 			'Hans' => 'సరళీకృతం',
 			'Hans@alt=stand-alone' => 'సరళీకృత హాన్',
 			'Hant' => 'సాంప్రదాయక',
 			'Hant@alt=stand-alone' => 'సాంప్రదాయక హాన్',
 			'Hebr' => 'హీబ్రు',
 			'Hira' => 'హిరాగాన',
 			'Hmng' => 'పాహవా హ్మోంగ్',
 			'Hrkt' => 'కాటాకాన లేదా హిరాగన',
 			'Hung' => 'ప్రాచీన హంగేరియన్',
 			'Inds' => 'సింధు',
 			'Ital' => 'ప్రాచిన ఐటాలిక్',
 			'Java' => 'జావనీస్',
 			'Jpan' => 'జాపనీస్',
 			'Kali' => 'కాయాహ్ లి',
 			'Kana' => 'కాటాకాన',
 			'Khar' => 'ఖరోషథి',
 			'Khmr' => 'ఖ్మేర్',
 			'Knda' => 'కన్నడ',
 			'Kore' => 'కొరియన్',
 			'Kthi' => 'కైథి',
 			'Lana' => 'లన్నా',
 			'Laoo' => 'లావో',
 			'Latf' => 'ఫ్రాక్టూర్ లాటిన్',
 			'Latg' => 'గేలిక్ లాటిన్',
 			'Latn' => 'లాటిన్',
 			'Lepc' => 'లేప్చా',
 			'Limb' => 'లింబు',
 			'Lina' => 'లినియర్ ఎ',
 			'Linb' => 'లినియర్ బి',
 			'Lyci' => 'లిసియన్',
 			'Lydi' => 'లిడియన్',
 			'Mand' => 'మాన్డియన్',
 			'Mani' => 'మానిచేన్',
 			'Maya' => 'మాయన్ హైరోగ్లైఫ్స్',
 			'Mero' => 'మెరోఇటిక్',
 			'Mlym' => 'మలయాళం',
 			'Mong' => 'మంగోలియన్',
 			'Moon' => 'మూన్',
 			'Mtei' => 'మీటి మయెక్',
 			'Mymr' => 'మయాన్మార్',
 			'Nkoo' => 'న్కో',
 			'Ogam' => 'ఒఘమ్',
 			'Olck' => 'ఓల్ చికి',
 			'Orkh' => 'ఓర్ఖోన్',
 			'Orya' => 'ఒరియా',
 			'Osma' => 'ఓసమాన్య',
 			'Perm' => 'ప్రాచీన పెర్మిక్',
 			'Phag' => 'ఫాగ్స్-పా',
 			'Phli' => 'ఇంస్క్రిప్షనాల్ పహ్లావి',
 			'Phlp' => 'సల్టార్ పహ్లావి',
 			'Phlv' => 'పుస్తక పహ్లావి',
 			'Phnx' => 'ఫోనిశియన్',
 			'Plrd' => 'పోల్లర్డ్ ఫోనెటిక్',
 			'Prti' => 'ఇంస్క్రిప్షనాల్ పార్థియన్',
 			'Rjng' => 'రేజాంగ్',
 			'Roro' => 'రోంగో రోంగో',
 			'Runr' => 'రూనిక్',
 			'Samr' => 'సమారిటన్',
 			'Sara' => 'సరాటి',
 			'Saur' => 'సౌరాష్ట్ర',
 			'Sgnw' => 'సంజ్ఞ లిపి',
 			'Shaw' => 'షవియాన్',
 			'Sinh' => 'సింహళం',
 			'Sund' => 'సుడానీస్',
 			'Sylo' => 'స్లోటి నాగ్రి',
 			'Syrc' => 'సిరియాక్',
 			'Syre' => 'ఎస్ట్రానజీలో సిరియాక్',
 			'Syrj' => 'పశ్చిమ సిరియాక్',
 			'Syrn' => 'తూర్పు సిరియాక్',
 			'Tagb' => 'టాగ్బానవా',
 			'Tale' => 'తై లీ',
 			'Talu' => 'క్రొత్త టై లుఇ',
 			'Taml' => 'తమిళము',
 			'Tavt' => 'టై వియట్',
 			'Telu' => 'తెలుగు',
 			'Teng' => 'టేంగ్వార్',
 			'Tfng' => 'టిఫీనాఘ్',
 			'Tglg' => 'టగలాగ్',
 			'Thaa' => 'థానా',
 			'Thai' => 'థాయ్',
 			'Tibt' => 'టిబెటన్',
 			'Ugar' => 'యుగారిటిక్',
 			'Vaii' => 'వాయి',
 			'Visp' => 'కనిపించే భాష',
 			'Xpeo' => 'ప్రాచీన పర్షియన్',
 			'Xsux' => 'సుమేరో- అక్కడియన్ క్యునిఫార్మ్',
 			'Yiii' => 'యి',
 			'Zinh' => 'వారసత్వం',
 			'Zmth' => 'గణిత సంకేతలిపి',
 			'Zsym' => 'చిహ్నాలు',
 			'Zxxx' => 'లిపి లేని',
 			'Zyyy' => 'సామాన్య',
 			'Zzzz' => 'తెలియని లిపి',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ప్రపంచం',
 			'002' => 'ఆఫ్రికా',
 			'003' => 'ఉత్తర అమెరికా',
 			'005' => 'దక్షిణ అమెరికా',
 			'009' => 'ఒషీనియ',
 			'011' => 'పశ్చిమ ఆఫ్రికా భూభాగం',
 			'013' => 'మధ్యమ అమెరికా',
 			'014' => 'తూర్పు ఆఫ్రికా',
 			'015' => 'ఉత్తర ఆఫ్రికా',
 			'017' => 'మధ్యమ ఆఫ్రికా',
 			'018' => 'దక్షిణ ఆఫ్రికా భూభాగం',
 			'019' => 'అమెరికాలు',
 			'021' => 'ఉత్తర అమెరికా భూభాగం',
 			'029' => 'కరిబ్బియన్',
 			'030' => 'తూర్పు ఆసియా',
 			'034' => 'దక్షిణ ఆసియా',
 			'035' => 'నైరుతి ఆసియా',
 			'039' => 'దక్షిణ ఐరోపా',
 			'053' => 'ఆస్ట్రేలేసియా',
 			'054' => 'మెలనేశియ',
 			'057' => 'మైక్రోనేశియ ప్రాంతం',
 			'061' => 'పాలినేషియా',
 			'142' => 'ఆసియా',
 			'143' => 'మధ్య ఆసియా',
 			'145' => 'పడమటి ఆశియా',
 			'150' => 'ఐరోపా',
 			'151' => 'తూర్పు ఐరోపా',
 			'154' => 'ఉత్తర ఐరోపా',
 			'155' => 'పశ్చిమ ఐరోపా',
 			'419' => 'లాటిన్ అమెరికా',
 			'AC' => 'ఎసెషన్ దీవి',
 			'AD' => 'అండొర్రా',
 			'AE' => 'యునైటెడ్ అరబ్ ఎమిరేట్స్',
 			'AF' => 'ఆఫ్ఘనిస్తాన్',
 			'AG' => 'ఆంటిగ్వా మరియు బార్బుడా',
 			'AI' => 'ఆంగవిల్లా',
 			'AL' => 'అల్బేనియా',
 			'AM' => 'ఆర్మేనియా',
 			'AN' => 'నేదేర్లేండ్స్ అంటిల్లిస్',
 			'AO' => 'అంగోలా',
 			'AQ' => 'అంటార్కటికా',
 			'AR' => 'అర్జెంటీనా',
 			'AS' => 'అమెరికన్ సమోవా',
 			'AT' => 'ఆస్ట్రియా',
 			'AU' => 'ఆస్ట్రేలియా',
 			'AW' => 'అరుబా',
 			'AX' => 'ఆలేండ్ దీవులు',
 			'AZ' => 'అజర్బైజాన్',
 			'BA' => 'బోస్నియా మరియు హెర్జెగొవీనా',
 			'BB' => 'బార్బడోస్',
 			'BD' => 'బంగ్లాదేశ్',
 			'BE' => 'బెల్జియం',
 			'BF' => 'బుర్కినా ఫాసో',
 			'BG' => 'బల్గేరియా',
 			'BH' => 'బహ్రెయిన్',
 			'BI' => 'బురుండి',
 			'BJ' => 'బెనిన్',
 			'BL' => 'సెంట్ బర్తేలెమీ',
 			'BM' => 'బెర్ముడా',
 			'BN' => 'బ్రూనై',
 			'BO' => 'బొలీవియా',
 			'BQ' => 'కరీబియన్ నెదర్లాండ్స్',
 			'BR' => 'బ్రెజిల్',
 			'BS' => 'బహామాస్',
 			'BT' => 'భూటాన్',
 			'BV' => 'బొవెట్ దీవి',
 			'BW' => 'బోట్స్వానా',
 			'BY' => 'బెలారస్',
 			'BZ' => 'బెలిజ్',
 			'CA' => 'కెనడా',
 			'CC' => 'కోకోస్ దీవులు',
 			'CD' => 'కాంగో- కిన్షాసా',
 			'CD@alt=variant' => 'కాంగో (DRC)',
 			'CF' => 'సెంట్రల్ ఆఫ్రికన్ రిపబ్లిక్',
 			'CG' => 'కాంగో- బ్రాజావిల్లి',
 			'CG@alt=variant' => 'కాంగో (రిపబ్లిక్)',
 			'CH' => 'స్విట్జర్లాండ్',
 			'CI' => 'ఐవరీ కోస్ట్',
 			'CK' => 'కుక్ దీవులు',
 			'CL' => 'చిలీ',
 			'CM' => 'కామెరూన్',
 			'CN' => 'చైనా',
 			'CO' => 'కొలంబియా',
 			'CP' => 'క్లిప్పర్టన్ దీవి',
 			'CR' => 'కోస్టారికా',
 			'CU' => 'క్యూబా',
 			'CV' => 'కేప్ వెర్డే',
 			'CW' => 'కురాకవో',
 			'CX' => 'క్రిస్మస్ దీవి',
 			'CY' => 'సైప్రస్',
 			'CZ' => 'చెక్ రిపబ్లిక్',
 			'DE' => 'జర్మనీ',
 			'DG' => 'డియాగో గార్సియా',
 			'DJ' => 'జిబౌటి',
 			'DK' => 'డెన్మార్క్',
 			'DM' => 'డోమెనిక',
 			'DO' => 'డొమెనికన్ రిపబ్లిక్',
 			'DZ' => 'అల్జీరియా',
 			'EA' => 'స్యూటా మరియు మెలిల్లా',
 			'EC' => 'ఈక్వడార్',
 			'EE' => 'ఎస్టోనియా',
 			'EG' => 'ఈజిప్ట్',
 			'EH' => 'పడమటి సహారా',
 			'ER' => 'ఎరిట్రియా',
 			'ES' => 'స్పెయిన్',
 			'ET' => 'ఇథియోపియా',
 			'EU' => 'యురోపియన్ యునియన్',
 			'FI' => 'ఫిన్లాండ్',
 			'FJ' => 'ఫిజీ',
 			'FK' => 'ఫాక్‌ల్యాండ్ దీవులు',
 			'FK@alt=variant' => 'ఫాక్‌ల్యాండ్ దీవులు (Islas Malvinas)',
 			'FM' => 'మైక్రోనేశియ',
 			'FO' => 'ఫారో దీవులు',
 			'FR' => 'ఫ్రాన్స్‌',
 			'GA' => 'గాబన్',
 			'GB' => 'యునైటెడ్ కింగ్‌డమ్',
 			'GB@alt=short' => 'యు.కె.',
 			'GD' => 'గ్రెనెడా',
 			'GE' => 'జార్జియా',
 			'GF' => 'ఫ్రెంచ్ గియానా',
 			'GG' => 'గ్వేర్నసే',
 			'GH' => 'ఘనా',
 			'GI' => 'జిబ్రాల్టార్',
 			'GL' => 'గ్రీన్‌లాండ్',
 			'GM' => 'గాంబియా',
 			'GN' => 'గినియా',
 			'GP' => 'గ్వాడేలోప్',
 			'GQ' => 'ఎక్వేటోరియాల్ గినియా',
 			'GR' => 'గ్రీస్',
 			'GS' => 'దక్షిణ జార్జియా మరియు దక్షిణ సాండ్విచ్ దీవులు',
 			'GT' => 'గ్వాటిమాల',
 			'GU' => 'గ్వామ్',
 			'GW' => 'గినియా-బిస్సావ్',
 			'GY' => 'గయానా',
 			'HK' => 'హాంకాంగ్ ఎస్ఏఆర్ చైనా',
 			'HK@alt=short' => 'హాంకాంగ్',
 			'HM' => 'హెర్డ్ & మాక్ డోనాల్డ్ దీవులు',
 			'HN' => 'హోండురాస్',
 			'HR' => 'క్రోయేషియా',
 			'HT' => 'హైటి',
 			'HU' => 'హంగేరీ',
 			'IC' => 'కేనరీ దీవులు',
 			'ID' => 'ఇండోనేషియా',
 			'IE' => 'ఐర్లాండ్',
 			'IL' => 'ఇజ్రాయిల్',
 			'IM' => 'ఐల్ ఆఫ్ మాన్',
 			'IN' => 'భారత దేశం',
 			'IO' => 'బ్రిటిష్ భారతీయ ఓషన్ ప్రాంతం',
 			'IQ' => 'ఇరాక్',
 			'IR' => 'ఇరాన్',
 			'IS' => 'ఐస్లాండ్',
 			'IT' => 'ఇటలీ',
 			'JE' => 'జెర్సీ',
 			'JM' => 'జమైకా',
 			'JO' => 'జోర్డాన్',
 			'JP' => 'జపాన్',
 			'KE' => 'కెన్యా',
 			'KG' => 'కిర్గిజిస్తాన్',
 			'KH' => 'కంబోడియా',
 			'KI' => 'కిరిబాటి',
 			'KM' => 'కొమొరోస్',
 			'KN' => 'సెంట్ కిట్ట్స్ మరియు నెవిస్',
 			'KP' => 'ఉత్తర కొరియా',
 			'KR' => 'దక్షిణ కొరియా',
 			'KW' => 'కువైట్',
 			'KY' => 'కేమాన్ దీవులు',
 			'KZ' => 'కజకస్తాన్',
 			'LA' => 'లావోస్',
 			'LB' => 'లెబనాన్',
 			'LC' => 'సెంట్ లూసియా',
 			'LI' => 'లిక్టెస్టేన్',
 			'LK' => 'శ్రీలంక',
 			'LR' => 'లైబీరియా',
 			'LS' => 'లెసోతో',
 			'LT' => 'లిథువేనియా',
 			'LU' => 'లక్సంబర్గ్',
 			'LV' => 'లాత్వియా',
 			'LY' => 'లిబియా',
 			'MA' => 'మొరాక్కో',
 			'MC' => 'మొనాకో',
 			'MD' => 'మోల్డోవా',
 			'ME' => 'మోంటేనేగ్రో',
 			'MF' => 'సెంట్ మార్టిన్',
 			'MG' => 'మడగాస్కర్',
 			'MH' => 'మార్షల్ దీవులు',
 			'MK' => 'మేసిడోనియా',
 			'MK@alt=variant' => 'మేసిడోనియా (FYROM)',
 			'ML' => 'మాలి',
 			'MM' => 'మయన్మార్ (బర్మా)',
 			'MN' => 'మంగోలియా',
 			'MO' => 'మాకావ్ ఎస్ఏఆర్ చైనా',
 			'MO@alt=short' => 'మకావు',
 			'MP' => 'ఉత్తర మరియానా దీవులు',
 			'MQ' => 'మార్టినిక్',
 			'MR' => 'మౌరిటేనియా',
 			'MS' => 'మోంట్సేర్రాట్',
 			'MT' => 'మాల్టా',
 			'MU' => 'మారిషస్',
 			'MV' => 'మాల్దీవులు',
 			'MW' => 'మాలావి',
 			'MX' => 'మెక్సికో',
 			'MY' => 'మలేషియా',
 			'MZ' => 'మొజాంబిక్',
 			'NA' => 'నమీబియా',
 			'NC' => 'క్రొత్త కాలెడోనియా',
 			'NE' => 'నైజర్',
 			'NF' => 'నార్ఫాక్ దీవి',
 			'NG' => 'నైజీరియా',
 			'NI' => 'నికరాగువా',
 			'NL' => 'నెదర్లాండ్స్',
 			'NO' => 'నార్వే',
 			'NP' => 'నేపాల్',
 			'NR' => 'నౌరు',
 			'NU' => 'నియు',
 			'NZ' => 'న్యూజిలాండ్',
 			'OM' => 'ఒమన్',
 			'PA' => 'పనామా',
 			'PE' => 'పెరూ',
 			'PF' => 'ఫ్రెంచ్ పోలినిషియా',
 			'PG' => 'పాపువా న్యు గినియా',
 			'PH' => 'ఫిలిప్పీన్స్',
 			'PK' => 'పాకిస్తాన్',
 			'PL' => 'పోలాండ్',
 			'PM' => 'సెంట్ పియెర్ మరియు మికెలాన్',
 			'PN' => 'పిట్‌కెయిర్న్ దీవులు',
 			'PR' => 'ఫ్యూర్టో రికో',
 			'PS' => 'పాలిస్తినియాన్ ప్రాంతం',
 			'PS@alt=short' => 'పాలస్తీనా',
 			'PT' => 'పోర్చుగల్',
 			'PW' => 'పలావు',
 			'PY' => 'పెరగువే',
 			'QA' => 'కతర్',
 			'QO' => 'ఒషీనియా బయటున్నవి',
 			'RE' => 'రియూనియన్',
 			'RO' => 'రోమానియా',
 			'RS' => 'సెర్బియా',
 			'RU' => 'రష్యా',
 			'RW' => 'రువాండా',
 			'SA' => 'సౌదీ అరేబియా',
 			'SB' => 'సోలమన్ దీవులు',
 			'SC' => 'సీషెల్స్',
 			'SD' => 'సూడాన్',
 			'SE' => 'స్వీడన్',
 			'SG' => 'సింగపూర్',
 			'SH' => 'సెంట్ హెలినా',
 			'SI' => 'స్లోవేనియా',
 			'SJ' => 'స్వాల్బార్డ్ మరియు యాన్ మాయేన్',
 			'SK' => 'స్లోవేకియా',
 			'SL' => 'సియెర్రా లియాన్',
 			'SM' => 'సాన్ మారినో',
 			'SN' => 'సెనెగల్',
 			'SO' => 'సోమాలియా',
 			'SR' => 'సురినామ్',
 			'SS' => 'దక్షిణ సూడాన్',
 			'ST' => 'సావోటోమ్ మరియు ప్రిన్సిపే',
 			'SV' => 'ఎల్ సాల్వడోర్',
 			'SX' => 'సింట్ మార్టెన్',
 			'SY' => 'సిరియా',
 			'SZ' => 'స్వాజీలేండ్',
 			'TA' => 'ట్రిస్టన్ డ కన్హా',
 			'TC' => 'తుర్క్ మరియు కాలికోస్ దీవులు',
 			'TD' => 'చాద్',
 			'TF' => 'ఫ్రెంచ్ దక్షిణ ప్రాంతాలు',
 			'TG' => 'టోగో',
 			'TH' => 'థాయిలాండ్',
 			'TJ' => 'తజికిస్తాన్',
 			'TK' => 'టోకేలావ్',
 			'TL' => 'టిమోర్-లెస్టె',
 			'TL@alt=variant' => 'తూర్పు తైమూర్',
 			'TM' => 'తుర్కమేనిస్తాన్',
 			'TN' => 'ట్యునీషియా',
 			'TO' => 'టోంగా',
 			'TR' => 'టర్కీ',
 			'TT' => 'ట్రినిడాడ్ మరియు టొబాగో',
 			'TV' => 'టువాలు',
 			'TW' => 'తైవాన్',
 			'TZ' => 'టాంజానియా',
 			'UA' => 'ఉక్రెయిన్',
 			'UG' => 'ఉగాండా',
 			'UM' => 'సంయుక్త రాజ్య అమెరికా బయట ఉన్న దీవులు',
 			'US' => 'అమెరికా సంయుక్త రాష్ట్రాలు',
 			'US@alt=short' => 'యు.ఎస్.',
 			'UY' => 'ఉరుగువే',
 			'UZ' => 'ఉజ్బెకిస్తాన్',
 			'VA' => 'వాటికన్ నగరం',
 			'VC' => 'సెంట్ విన్సెంట్ మరియు గ్రెనడీన్స్',
 			'VE' => 'వెనుజువేలా',
 			'VG' => 'బ్రిటిష్ వర్జిన్ దీవులు',
 			'VI' => 'యు.ఎస్. వర్జిన్ దీవులు',
 			'VN' => 'వియత్నాం',
 			'VU' => 'వనాటు',
 			'WF' => 'వాలిస్ మరియు ఫ్యుత్యునా',
 			'WS' => 'సమోవా',
 			'XK' => 'కొసోవో',
 			'YE' => 'యెమెన్',
 			'YT' => 'మాయొట్టి',
 			'ZA' => 'దక్షిణ ఆఫ్రికా',
 			'ZM' => 'జాంబియా',
 			'ZW' => 'జింబాబ్వే',
 			'ZZ' => 'తెలియని ప్రాంతం',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ప్రాచీన ఙర్మన వర్ణక్రమం',
 			'1996' => '1996 ఙర్మన వర్ణక్రమం',
 			'MONOTON' => 'మోనోటోనిక్',
 			'PINYIN' => 'పిన్‌యిన్ రోమనైజేషన్',
 			'POLYTON' => 'పాలీటోనిక్',
 			'POSIX' => 'కంప్యూటర్',
 			'REVISED' => 'సవరించబడిన వర్ణక్రమం',
 			'WADEGILE' => 'వేడ్-గైల్స్ రోమనైజేషన్',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'క్యాలెండర్',
 			'colalternate' => 'చిహ్నాలను క్రమబద్ధీకరించడాన్ని విస్మరించు',
 			'colbackwards' => 'వ్యతిరేక ఉచ్ఛారణ క్రమబద్ధీకరణ',
 			'colcasefirst' => 'అప్పర్‌కేస్‌/లోయర్ కేస్ క్రమం',
 			'colcaselevel' => 'కేస్ సెన్సిటివ్ క్రమబద్ధీకరణ',
 			'colhiraganaquaternary' => 'కానా క్రమబద్ధీకరణ',
 			'collation' => 'క్రమబద్ధీకరణ క్రమం',
 			'colnormalization' => 'సాధారణీకరించిన క్రమబద్ధీకరణ',
 			'colnumeric' => 'సంఖ్యాత్మక క్రమబద్ధీకరణ',
 			'colstrength' => 'క్రమబద్ధీకరణ సామర్థ్యం',
 			'currency' => 'కరెన్సీ',
 			'numbers' => 'సంఖ్యలు',
 			'timezone' => 'సమయ మండలి',
 			'va' => 'లొకేల్ రూపాంతరం',
 			'variabletop' => 'చిహ్నాలుగా క్రమబద్ధీకరించు',
 			'x' => 'ప్రైవేట్-ఉపయోగం',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{బుద్ధుల క్యాలెండర్‌},
 				'chinese' => q{చైనీస్ క్యాలెండర్},
 				'coptic' => q{కాప్టిక్ క్యాలెండర్},
 				'ethiopic' => q{ఎపోథిక్ క్యాలెండర్},
 				'ethiopic-amete-alem' => q{ఎథోపిక్ అమేటే అలెమ్ క్యాలెండర్},
 				'gregorian' => q{గ్రేగోరియన్ క్యాలెండర్},
 				'hebrew' => q{హెబ్ర్యూ క్యాలెండర్},
 				'indian' => q{భారతీయ జాతీయ క్యాలెండర్},
 				'islamic' => q{ఇస్లామిక్ క్యాలెండర్},
 				'islamic-civil' => q{ఇస్లామిక్-సివిల్ క్యాలెండర్},
 				'japanese' => q{జపానీయుల క్యాలెండర్},
 				'persian' => q{పర్షియన్ క్యాలెండర్},
 				'roc' => q{మింగ్యూ క్యాలెండర్},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{చిహ్నాలను క్రమబద్ధీకరించు},
 				'shifted' => q{చిహ్నాలను విస్మరించడాన్ని క్రమబద్ధీకరించు},
 			},
 			'colbackwards' => {
 				'no' => q{ఉచ్ఛారణలను సాధారణంగా క్రమబద్ధీకరించు},
 				'yes' => q{ఉచ్ఛారణలను వ్యతిరేక క్రమంలో క్రమబద్ధీకరించు},
 			},
 			'colcasefirst' => {
 				'lower' => q{ముందు లోయర్‌కేస్‌ని క్రమబద్ధీకరించు},
 				'no' => q{సాధారణ కేస్ క్రమాన్ని క్రమబద్ధీకరించు},
 				'upper' => q{ముందు అప్పర్‌కేస్‌ని క్రమబద్ధీకరించు},
 			},
 			'colcaselevel' => {
 				'no' => q{కేస్ ఇన్‌సెన్సిటివ్‌ను క్రమబద్ధీకరించు},
 				'yes' => q{కేస్ సెన్సిటివ్‌ని క్రమబద్ధీకరించు},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{కానాను వేరుగా క్రమబద్ధీకరించు},
 				'yes' => q{కానాని భిన్నంగా క్రమబద్ధీకరించు},
 			},
 			'collation' => {
 				'big5han' => q{సాంప్రదాయ చైనీస్ క్రమబద్ధీకరణ క్రమం - Big5},
 				'dictionary' => q{నిఘంటువు క్రమబద్ధీకరణ క్రమం},
 				'ducet' => q{డిఫాల్ట్ యూనీకోడ్ క్రమబద్ధీకరణ క్రమం},
 				'gb2312han' => q{సరళీకృత చైనీస్ క్రమబద్ధీకరణ క్రమం - GB2312},
 				'phonebook' => q{ఫోన్‌బుక్ క్రమబద్ధీకరణ క్రమం},
 				'phonetic' => q{ధ్వని ఉచ్ఛారిత క్రమబద్ధీకరణ క్రమం},
 				'pinyin' => q{పిన్‌యిన్ క్రమబద్ధీకరణ క్రమం},
 				'reformed' => q{మళ్ళీ ఆకృతీకరించబడిన క్రమబద్ధీకరణ క్రమం},
 				'search' => q{సాధారణ-ప్రయోజన శోధన},
 				'searchjl' => q{హాంగుల్ ప్రారంభ హల్లు ద్వారా శోధించు},
 				'standard' => q{ప్రామాణిక క్రమబద్ధీకరణ క్రమం},
 				'stroke' => q{స్ట్రోక్ క్రమబద్ధీకరణ క్రమం},
 				'traditional' => q{సాంప్రదాయ క్రమబద్ధీకరణ క్రమం},
 				'unihan' => q{రాడికల్-స్ట్రోక్ క్రమబద్ధీకరణ క్రమం},
 			},
 			'colnormalization' => {
 				'no' => q{సాధారణీకరణ చేయకుండా క్రమబద్ధీకరించు},
 				'yes' => q{సాధారణీకరించిన యూనికోడ్‌ని క్రమబద్ధీకరించు},
 			},
 			'colnumeric' => {
 				'no' => q{అంకెలను ఒక్కొక్కటిగా క్రమబద్ధీకరించు},
 				'yes' => q{అంకెలను సంఖ్యాత్మకంగా క్రమబద్ధీకరించు},
 			},
 			'colstrength' => {
 				'identical' => q{అన్నింటినీ క్రమబద్ధీకరించు},
 				'primary' => q{ప్రాథమిక అక్షరాలను మాత్రమే క్రమబద్ధీకరించు},
 				'quaternary' => q{ఉచ్ఛారణలు/కేస్‌/వెడల్పు/కానాను క్రమబద్ధీకరించు},
 				'secondary' => q{ఉచ్ఛారణలని క్రమబద్ధీకరించు},
 				'tertiary' => q{ఉచ్ఛారణలని/కేస్‌ని/వెడల్పుని క్రమబద్ధీకరించు},
 			},
 			'numbers' => {
 				'arab' => q{అరబిక్-ఇండిక్ అంకెలు},
 				'arabext' => q{పొడిగించబడిన అరబిక్-ఇండిక్ అంకెలు},
 				'armn' => q{అమెరికా సంఖ్యలు},
 				'armnlow' => q{అమెరికన్ చిన్న సంఖ్యలు},
 				'beng' => q{బెంగాలీ అంకెలు},
 				'deva' => q{దేవనాగరి అంకెలు},
 				'ethi' => q{ఎథియోపిక్ సంఖ్యలు},
 				'finance' => q{ఆర్థిక సంఖ్యలు},
 				'fullwide' => q{పూర్తి వెడల్పు అంకెలు},
 				'geor' => q{జార్జియన్ సంఖ్యలు},
 				'grek' => q{గ్రీక్ సంఖ్యలు},
 				'greklow' => q{గ్రీక్ చిన్న సంఖ్యలు},
 				'gujr' => q{గుజరాతీ అంకెలు},
 				'guru' => q{గుర్ముఖీ అంకెలు},
 				'hanidec' => q{చైనీయుల దశాంశ సంఖ్యలు},
 				'hans' => q{సరళీకృతం చెయ్యబడిన చైనీయుల సంఖ్యలు},
 				'hansfin' => q{సరళీకృతం చెయ్యబడిన చైనీయుల ఆర్థిక సంఖ్యలు},
 				'hant' => q{సాంప్రదాయ చైనీయుల సంఖ్యలు},
 				'hantfin' => q{సాంప్రదాయ చైనీయుల ఆర్థిక సంఖ్యలు},
 				'hebr' => q{హెర్బ్యూ సంఖ్యలు},
 				'jpan' => q{జపానీయుల సంఖ్యలు},
 				'jpanfin' => q{జపానీయలు ఆర్థిక సంఖ్యలు},
 				'khmr' => q{ఖ్మేర్ అంకెలు},
 				'knda' => q{కన్నడ అంకెలు},
 				'laoo' => q{లావో అంకెలు},
 				'latn' => q{పశ్చిమ అంకెలు},
 				'mlym' => q{మలయాళం అంకెలు},
 				'mong' => q{మంగోలియన్ అంకెలు},
 				'mymr' => q{మియన్మార్ అంకెలు},
 				'native' => q{స్థానిక అంకెలు},
 				'orya' => q{ఒరియా అంకెలు},
 				'roman' => q{రోమన్ సంఖ్యలు},
 				'romanlow' => q{రోమన్ చిన్న సంఖ్యలు},
 				'taml' => q{తమళ సంఖ్యలు},
 				'tamldec' => q{తమిళ అంకెలు},
 				'telu' => q{తెలుగు అంకెలు},
 				'thai' => q{థాయి అంకెలు},
 				'tibt' => q{టిబిటన్ అంకెలు},
 				'traditional' => q{సాంప్రదాయ సంఖ్యలు},
 				'vaii' => q{వాయ్ అంకెలు},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{దశాంశం},
 			'UK' => q{యుకె},
 			'US' => q{యుఎస్},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'సంఖ్య',
 			'tone' => 'టోన్',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'గాఢతలు',
 			'x-fullwidth' => 'పూర్తి వెడల్పు',
 			'x-halfwidth' => 'సగం వెడల్పు',
 			'x-jamo' => 'జమో',
 			'x-pinyin' => 'పిన్యిన్',
 			'x-publishing' => 'ప్రచురించబడుతోంది',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'భాష: {0}',
 			'script' => 'లిపి: {0}',
 			'territory' => 'ప్రాంతం: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ౦ ౧ ౨ ౩ ౪ ౫ ౬ ౭ ౮ ౯])},
			index => ['అ', 'ఆ', 'ఇ', 'ఈ', 'ఉ', 'ఊ', 'ఋ', 'ౠ', 'ఎ', 'ఏ', 'ఐ', 'ఒ', 'ఓ', 'ఔ', 'క', 'ఖ', 'గ', 'ఘ', 'ఙ', 'చ', 'ఛ', 'జ', 'ఝ', 'ఞ', 'ట', 'ఠ', 'డ', 'ఢ', 'ణ', 'త', 'థ', 'ద', 'ధ', 'న', 'ప', 'ఫ', 'బ', 'భ', 'మ', 'య', 'ర', 'ఱ', 'ల', 'వ', 'శ', 'ష', 'స', 'హ', 'ళ'],
			main => qr{(?^u:[అ ఆ ఇ ఈ ఉ ఊ ఋ ౠ ఌ ౡ ఎ ఏ ఐ ఒ ఓ ఔ ఁ ం ః క ఖ గ ఘ ఙ చ ఛ జ ఝ ఞ ట ఠ డ ఢ ణ త థ ద ధ న ప ఫ బ భ మ య ర ఱ ల వ శ ష స హ ళ ా ి ీ ు ూ ృ ౄ ె ే ై ొ ో ౌ ్ ౕ ౖ])},
		};
	},
);

has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} ఎకరం),
						'other' => q({0} ఎకరాలు),
					},
					'arc-minute' => {
						'one' => q({0} నిమిషం),
						'other' => q({0} నిమిషాలు),
					},
					'arc-second' => {
						'one' => q({0} సెకను),
						'other' => q({0} సెకన్లు),
					},
					'celsius' => {
						'one' => q({0}డిగ్రీ సెల్సియస్),
						'other' => q({0}డిగ్రీల సెల్సియస్),
					},
					'centimeter' => {
						'one' => q({0} సెంటీమీటర్),
						'other' => q({0} సెంటీమీటర్లు),
					},
					'cubic-kilometer' => {
						'one' => q({0} క్యూబిక్ కిలోమీటర్),
						'other' => q({0} క్యూబిక్ కిలోమీటర్లు),
					},
					'cubic-mile' => {
						'one' => q({0} క్యూబిక్ మైలు),
						'other' => q({0} క్యూబిక్ మైళ్లు),
					},
					'day' => {
						'one' => q({0} రోజు),
						'other' => q({0} రోజులు),
					},
					'degree' => {
						'one' => q({0} డిగ్రీ),
						'other' => q({0} డిగ్రీలు),
					},
					'fahrenheit' => {
						'one' => q({0}డిగ్రీ ఫారన్హీట్),
						'other' => q({0}డిగ్రీల ఫారన్హీట్),
					},
					'foot' => {
						'one' => q({0} అడుగు),
						'other' => q({0} అడుగులు),
					},
					'g-force' => {
						'one' => q({0} గు-శక్తి),
						'other' => q({0} గు-శక్తి),
					},
					'gram' => {
						'one' => q({0} గ్రాము),
						'other' => q({0} గ్రాములు),
					},
					'hectare' => {
						'one' => q({0} హెక్టారు),
						'other' => q({0} హెక్టార్లు),
					},
					'hectopascal' => {
						'one' => q({0} హెక్టోపాస్కల్),
						'other' => q({0} హెక్టోపాస్కల్‌లు),
					},
					'horsepower' => {
						'one' => q({0} హార్స్‌పవర్),
						'other' => q({0} హార్స్‌పవర్),
					},
					'hour' => {
						'one' => q({0} గంట),
						'other' => q({0} గంటలు),
					},
					'inch' => {
						'one' => q({0} అంగుళం),
						'other' => q({0} అంగుళాలు),
					},
					'inch-hg' => {
						'one' => q({0} అంగుళం పాదరసం),
						'other' => q({0} అంగుళాల పాదరసం),
					},
					'kilogram' => {
						'one' => q({0} కిలోగ్రాము),
						'other' => q({0} కిలోగ్రాములు),
					},
					'kilometer' => {
						'one' => q({0} కిలోమీటర్),
						'other' => q({0} కిలోమీటర్లు),
					},
					'kilometer-per-hour' => {
						'one' => q({0} కిలోమీటర్/గంట),
						'other' => q({0} కిలోమీటర్లు/గంట),
					},
					'kilowatt' => {
						'one' => q({0} కిలోవాట్),
						'other' => q({0} కిలోవాట్లు),
					},
					'light-year' => {
						'one' => q({0} కాంతి సంవత్సరం),
						'other' => q({0} కాంతి సంవత్సరాలు),
					},
					'liter' => {
						'one' => q({0} లీటర్),
						'other' => q({0} లీటర్లు),
					},
					'meter' => {
						'one' => q({0} మీటర్),
						'other' => q({0} మీటర్లు),
					},
					'meter-per-second' => {
						'one' => q({0} మీటర్/సెకను),
						'other' => q({0} మీటర్లు/సెకను),
					},
					'mile' => {
						'one' => q({0} మైలు),
						'other' => q({0} మైళ్లు),
					},
					'mile-per-hour' => {
						'one' => q({0} మైలు/గంట),
						'other' => q({0} మైళ్లు/గంట),
					},
					'millibar' => {
						'one' => q({0} మిల్లీబార్),
						'other' => q({0} మిల్లీబార్‌లు),
					},
					'millimeter' => {
						'one' => q({0} మిల్లీమీటర్),
						'other' => q({0} మిల్లీమీటర్లు),
					},
					'millisecond' => {
						'one' => q({0} మిల్లీసెకను),
						'other' => q({0} మిల్లీసెకన్లు),
					},
					'minute' => {
						'one' => q({0} నిమిషం),
						'other' => q({0} నిమిషాలు),
					},
					'month' => {
						'one' => q({0} నెల),
						'other' => q({0} నెలలు),
					},
					'ounce' => {
						'one' => q({0} ఔన్సు),
						'other' => q({0} ఔన్సులు),
					},
					'per' => {
						'default' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} పికోమీటర్),
						'other' => q({0} పికోమీటర్లు),
					},
					'pound' => {
						'one' => q({0} పౌండు),
						'other' => q({0} పౌండ్లు),
					},
					'second' => {
						'one' => q({0} సెకను),
						'other' => q({0} సెకన్లు),
					},
					'square-foot' => {
						'one' => q({0} చదరపు అడుగు),
						'other' => q({0} చదరపు అడుగులు),
					},
					'square-kilometer' => {
						'one' => q({0} చదరపు కిలోమీటర్),
						'other' => q({0} చదరపు కిలోమీటర్లు),
					},
					'square-meter' => {
						'one' => q({0} చదరపు మీటర్),
						'other' => q({0} చదరపు మీటర్లు),
					},
					'square-mile' => {
						'one' => q({0} చదరపు మైలు),
						'other' => q({0} చదరపు మైళ్లు),
					},
					'watt' => {
						'one' => q({0} వాట్),
						'other' => q({0} వాట్లు),
					},
					'week' => {
						'one' => q({0} వారం),
						'other' => q({0} వారాలు),
					},
					'yard' => {
						'one' => q({0} గజం),
						'other' => q({0} గజాలు),
					},
					'year' => {
						'one' => q({0} సంవత్సరం),
						'other' => q({0} సంవత్సరాలు),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ఎక.),
						'other' => q({0} ఎక.),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} సెం.మీ),
						'other' => q({0} సెం.మీ),
					},
					'cubic-kilometer' => {
						'one' => q({0} కిమీ³),
						'other' => q({0} కిమీ³),
					},
					'cubic-mile' => {
						'one' => q({0} మై³),
						'other' => q({0} మై³),
					},
					'day' => {
						'one' => q({0} రో),
						'other' => q({0} రో),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0} గు),
						'other' => q({0} గు),
					},
					'gram' => {
						'one' => q({0} గ్రా.),
						'other' => q({0} గ్రా.),
					},
					'hectare' => {
						'one' => q({0} హె.),
						'other' => q({0} హె.),
					},
					'hectopascal' => {
						'one' => q({0} హె.పా),
						'other' => q({0} హె.పా),
					},
					'horsepower' => {
						'one' => q({0} హా.ప),
						'other' => q({0} హా.ప),
					},
					'hour' => {
						'one' => q({0}గం),
						'other' => q({0}గం),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q({0} అం.పాద),
						'other' => q({0} అం.పాద),
					},
					'kilogram' => {
						'one' => q({0} కి.గ్రా),
						'other' => q({0} కి.గ్రా),
					},
					'kilometer' => {
						'one' => q({0} కి.మీ),
						'other' => q({0} కి.మీ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} కిమీ/గం.),
						'other' => q({0} కిమీ/గం.),
					},
					'kilowatt' => {
						'one' => q({0} కి.వా),
						'other' => q({0} కి.వా),
					},
					'light-year' => {
						'one' => q({0} కాం. సం),
						'other' => q({0} కాం. సం),
					},
					'liter' => {
						'one' => q({0} లీ.),
						'other' => q({0} లీ.),
					},
					'meter' => {
						'one' => q({0} మీ),
						'other' => q({0} మీ),
					},
					'meter-per-second' => {
						'one' => q({0} మీ/సె),
						'other' => q({0} మీ/సె),
					},
					'mile' => {
						'one' => q({0} మై),
						'other' => q({0} మై),
					},
					'mile-per-hour' => {
						'one' => q({0} మై/గం.),
						'other' => q({0} మై/గం.),
					},
					'millibar' => {
						'one' => q({0} మి.బార్),
						'other' => q({0} మి.బార్),
					},
					'millimeter' => {
						'one' => q({0} మి.మీ),
						'other' => q({0} మి.మీ),
					},
					'millisecond' => {
						'one' => q({0} మి.సె),
						'other' => q({0} మి.సె),
					},
					'minute' => {
						'one' => q({0}ని),
						'other' => q({0} ని),
					},
					'month' => {
						'one' => q({0} నె),
						'other' => q({0} నె),
					},
					'ounce' => {
						'one' => q({0} ఔ.),
						'other' => q({0} ఔ.),
					},
					'per' => {
						'default' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} పి.మీ),
						'other' => q({0} పి.మీ),
					},
					'pound' => {
						'one' => q({0} పౌ.),
						'other' => q({0} పౌ.),
					},
					'second' => {
						'one' => q({0} సె),
						'other' => q({0} సె),
					},
					'square-foot' => {
						'one' => q({0} అ²),
						'other' => q({0} అ²),
					},
					'square-kilometer' => {
						'one' => q({0} కి.మీ²),
						'other' => q({0} కి.మీ²),
					},
					'square-meter' => {
						'one' => q({0} మీ²),
						'other' => q({0} మీ²),
					},
					'square-mile' => {
						'one' => q({0} మై²),
						'other' => q({0} మై²),
					},
					'watt' => {
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'week' => {
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'yard' => {
						'one' => q({0} గ.),
						'other' => q({0} గ.),
					},
					'year' => {
						'one' => q({0}సం),
						'other' => q({0}సం),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} ఎక.),
						'other' => q({0} ఎక.),
					},
					'arc-minute' => {
						'one' => q({0} నిమి.),
						'other' => q({0} నిమి.),
					},
					'arc-second' => {
						'one' => q({0} సెక.),
						'other' => q({0} సెక.),
					},
					'celsius' => {
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'one' => q({0} సెం.మీ),
						'other' => q({0} సెం.మీ),
					},
					'cubic-kilometer' => {
						'one' => q({0} కిమీ³),
						'other' => q({0} కిమీ³),
					},
					'cubic-mile' => {
						'one' => q({0} మై³),
						'other' => q({0} మై³),
					},
					'day' => {
						'one' => q({0} రోజు),
						'other' => q({0} రోజులు),
					},
					'degree' => {
						'one' => q({0} డి.),
						'other' => q({0} డి.),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} అ.),
						'other' => q({0} అ.),
					},
					'g-force' => {
						'one' => q({0} గు),
						'other' => q({0} గు),
					},
					'gram' => {
						'one' => q({0} గ్రా.),
						'other' => q({0} గ్రా.),
					},
					'hectare' => {
						'one' => q({0} హె.),
						'other' => q({0} హె.),
					},
					'hectopascal' => {
						'one' => q({0} హె.పా),
						'other' => q({0} హె.పా),
					},
					'horsepower' => {
						'one' => q({0} హా.ప),
						'other' => q({0} హా.ప),
					},
					'hour' => {
						'one' => q({0} గంట),
						'other' => q({0} గంటలు),
					},
					'inch' => {
						'one' => q({0} అం.),
						'other' => q({0} అం.),
					},
					'inch-hg' => {
						'one' => q({0} అం.పాద),
						'other' => q({0} అం.పాద),
					},
					'kilogram' => {
						'one' => q({0} కి.గ్రా),
						'other' => q({0} కి.గ్రా),
					},
					'kilometer' => {
						'one' => q({0} కి.మీ),
						'other' => q({0} కి.మీ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} కి/గం.),
						'other' => q({0} కిమీ/గం.),
					},
					'kilowatt' => {
						'one' => q({0} కి.వా),
						'other' => q({0} కి.వా),
					},
					'light-year' => {
						'one' => q({0} కాం. సం),
						'other' => q({0} కాం. సం),
					},
					'liter' => {
						'one' => q({0} లీ.),
						'other' => q({0} లీ.),
					},
					'meter' => {
						'one' => q({0} మీ),
						'other' => q({0} మీ),
					},
					'meter-per-second' => {
						'one' => q({0} మీ/సె),
						'other' => q({0} మీ/సె),
					},
					'mile' => {
						'one' => q({0} మై),
						'other' => q({0} మై),
					},
					'mile-per-hour' => {
						'one' => q({0} మై/గం.),
						'other' => q({0} మై/గం.),
					},
					'millibar' => {
						'one' => q({0} మి.బార్),
						'other' => q({0} మి.బార్),
					},
					'millimeter' => {
						'one' => q({0} మి.మీ),
						'other' => q({0} మి.మీ),
					},
					'millisecond' => {
						'one' => q({0} మి.సె),
						'other' => q({0} మి.సె),
					},
					'minute' => {
						'one' => q({0} నిమి.),
						'other' => q({0} నిమి.),
					},
					'month' => {
						'one' => q({0} నెల),
						'other' => q({0} నెలలు),
					},
					'ounce' => {
						'one' => q({0} ఔ.),
						'other' => q({0} ఔ.),
					},
					'per' => {
						'default' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} పి.మీ),
						'other' => q({0} పి.మీ),
					},
					'pound' => {
						'one' => q({0} పౌ.),
						'other' => q({0} పౌ.),
					},
					'second' => {
						'one' => q({0} సెకను),
						'other' => q({0} సెకన్లు),
					},
					'square-foot' => {
						'one' => q({0} చద. అ.),
						'other' => q({0} చద. అ.),
					},
					'square-kilometer' => {
						'one' => q({0} కి.మీ²),
						'other' => q({0} కి.మీ²),
					},
					'square-meter' => {
						'one' => q({0} మీ²),
						'other' => q({0} మీ²),
					},
					'square-mile' => {
						'one' => q({0} చద. మై.),
						'other' => q({0} చద. మై.),
					},
					'watt' => {
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'week' => {
						'one' => q({0} వా.),
						'other' => q({0} వా.),
					},
					'yard' => {
						'one' => q({0} గ.),
						'other' => q({0} గ.),
					},
					'year' => {
						'one' => q({0} సంవత్సరం),
						'other' => q({0} సంవత్సరాలు),
					},
				},
			} }
);


has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:అవును|అ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:వద్దు|వ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} మరియు {1}),
				2 => q({0} మరియు {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'telu',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0వే',
					'other' => '0వే',
				},
				'10000' => {
					'one' => '00వే',
					'other' => '00వే',
				},
				'100000' => {
					'one' => '000వే',
					'other' => '000వే',
				},
				'1000000' => {
					'one' => '0మి',
					'other' => '0మి',
				},
				'10000000' => {
					'one' => '00మి',
					'other' => '00మి',
				},
				'100000000' => {
					'one' => '000మి',
					'other' => '000మి',
				},
				'1000000000' => {
					'one' => '0బి',
					'other' => '0బి',
				},
				'10000000000' => {
					'one' => '00బి',
					'other' => '00బి',
				},
				'100000000000' => {
					'one' => '000బి',
					'other' => '000బి',
				},
				'1000000000000' => {
					'one' => '0ట్రి',
					'other' => '0ట్రి',
				},
				'10000000000000' => {
					'one' => '00ట్రి',
					'other' => '00ట్రి',
				},
				'100000000000000' => {
					'one' => '000ట్రి',
					'other' => '000ట్రి',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 వేయి',
					'other' => '0 వేలు',
				},
				'10000' => {
					'one' => '00 వేలు',
					'other' => '00 వేలు',
				},
				'100000' => {
					'one' => '000 వేలు',
					'other' => '000 వేలు',
				},
				'1000000' => {
					'one' => '0 మిలియన్',
					'other' => '0 మిలియన్',
				},
				'10000000' => {
					'one' => '00 మిలియన్',
					'other' => '00 మిలియన్',
				},
				'100000000' => {
					'one' => '000 మిలియన్',
					'other' => '000 మిలియన్',
				},
				'1000000000' => {
					'one' => '0 బిలియన్',
					'other' => '0 బిలియన్',
				},
				'10000000000' => {
					'one' => '00 బిలియన్',
					'other' => '00 బిలియన్',
				},
				'100000000000' => {
					'one' => '000 బిలియన్',
					'other' => '000 బిలియన్',
				},
				'1000000000000' => {
					'one' => '0 ట్రిలియన్',
					'other' => '0 ట్రిలియన్',
				},
				'10000000000000' => {
					'one' => '00 ట్రిలియన్',
					'other' => '00 ట్రిలియన్',
				},
				'100000000000000' => {
					'one' => '000 ట్రిలియన్',
					'other' => '000 ట్రిలియన్',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0వే',
					'other' => '0వే',
				},
				'10000' => {
					'one' => '00వే',
					'other' => '00వే',
				},
				'100000' => {
					'one' => '000వే',
					'other' => '000వే',
				},
				'1000000' => {
					'one' => '0మి',
					'other' => '0మి',
				},
				'10000000' => {
					'one' => '00మి',
					'other' => '00మి',
				},
				'100000000' => {
					'one' => '000మి',
					'other' => '000మి',
				},
				'1000000000' => {
					'one' => '0బి',
					'other' => '0బి',
				},
				'10000000000' => {
					'one' => '00బి',
					'other' => '00బి',
				},
				'100000000000' => {
					'one' => '000బి',
					'other' => '000బి',
				},
				'1000000000000' => {
					'one' => '0ట్రి',
					'other' => '0ట్రి',
				},
				'10000000000000' => {
					'one' => '00ట్రి',
					'other' => '00ట్రి',
				},
				'100000000000000' => {
					'one' => '000ట్రి',
					'other' => '000ట్రి',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'negative' => '¤#,##0.00',
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'default' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్),
				'one' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్),
				'other' => q(యునైటెడ్ ఆరబ్ ఎమిరేట్స్ దిరామ్‌లు),
			},
		},
		'AFN' => {
			display_name => {
				'default' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
				'one' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
				'other' => q(ఆఫ్ఘాన్ ఆఫ్ఘాని),
			},
		},
		'ALL' => {
			display_name => {
				'default' => q(ఆల్బేనియన్ లేక్),
				'one' => q(ఆల్బేనియన్ లేక్),
				'other' => q(ఆల్బేనియన్ లేక్),
			},
		},
		'AMD' => {
			display_name => {
				'default' => q(అమెరికన్ డ్రామ్),
				'one' => q(అమెరికన్ డ్రామ్),
				'other' => q(అమెరికన్ డ్రామ్‌లు),
			},
		},
		'ANG' => {
			display_name => {
				'default' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్),
				'one' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్),
				'other' => q(నెదర్లాండ్స్ యాంటిల్లియన్ గిల్‌డర్‌లు),
			},
		},
		'AOA' => {
			display_name => {
				'default' => q(అంగోలాన్ క్వాన్‌జా),
				'one' => q(అంగోలాన్ క్వాన్‌జా),
				'other' => q(అంగోలాన్ క్వాన్‌జా‌లు),
			},
		},
		'ARS' => {
			display_name => {
				'default' => q(అర్జెంటీనా పెసో),
				'one' => q(అర్జెంటీనా పెసో),
				'other' => q(అర్జెంటీనా పెసోలు),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'default' => q(ఆస్ట్రేలియన్ డాలర్),
				'one' => q(ఆస్ట్రేలియన్ డాలర్),
				'other' => q(ఆస్ట్రేలియన్ డాలర్‌లు),
			},
		},
		'AWG' => {
			display_name => {
				'default' => q(అరుబన్ ఫ్లోరిన్),
			},
		},
		'AZN' => {
			display_name => {
				'default' => q(అజర్బైజాన్ మానట్),
				'one' => q(అజర్బైజాన్ మానట్),
				'other' => q(అజర్బైజాన్ మానట్‌లు),
			},
		},
		'BAM' => {
			display_name => {
				'default' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్),
				'one' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్),
				'other' => q(బోస్నియా-హెర్జగోవినా మార్పిడి చెయ్యగలిగే మార్క్‌లు),
			},
		},
		'BBD' => {
			display_name => {
				'default' => q(బర్బాడియన్ డాలర్),
				'one' => q(బర్బాడియన్ డాలర్),
				'other' => q(బర్బాడియన్ డాలర్‌లు),
			},
		},
		'BDT' => {
			display_name => {
				'default' => q(బాంగ్లాదేశ్ టాకా),
				'one' => q(బాంగ్లాదేశ్ టాకా),
				'other' => q(బాంగ్లాదేశ్ టాకాలు),
			},
		},
		'BGN' => {
			display_name => {
				'default' => q(బల్గేరియన్ లేవ్),
				'one' => q(బల్గేరియన్ లేవ్),
				'other' => q(బల్గేరియన్ లేవ),
			},
		},
		'BHD' => {
			display_name => {
				'default' => q(బహ్రైని దీనార్),
				'one' => q(బహ్రైని దీనార్),
				'other' => q(బహ్రైని దీనార్‌లు),
			},
		},
		'BIF' => {
			display_name => {
				'default' => q(బురిండియన్ ఫ్రాంక్),
				'one' => q(బురిండియన్ ఫ్రాంక్),
				'other' => q(బురిండియన్ ఫ్రాంక్‌లు),
			},
		},
		'BMD' => {
			display_name => {
				'default' => q(బెర్ముడన్ డాలర్),
				'one' => q(బెర్ముడన్ డాలర్),
				'other' => q(బెర్ముడన్ డాలర్‌లు),
			},
		},
		'BND' => {
			display_name => {
				'default' => q(బ్రూనై డాలర్),
				'one' => q(బ్రూనై డాలర్),
				'other' => q(బ్రూనై డాలర్‌లు),
			},
		},
		'BOB' => {
			display_name => {
				'default' => q(బొలీవియన్ బొలీవియానో),
				'one' => q(బొలీవియన్ బొలీవియానో),
				'other' => q(బొలీవియన్ బొలీవియానోలు),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'default' => q(బ్రెజిలియన్ రియల్),
				'one' => q(బ్రెజిలియన్ రియల్),
				'other' => q(బ్రెజిలియన్ రియల్‌లు),
			},
		},
		'BSD' => {
			display_name => {
				'default' => q(బహామియన్ డాలర్),
				'one' => q(బహామియన్ డాలర్),
				'other' => q(బహామియన్ డాలర్‌లు),
			},
		},
		'BTN' => {
			display_name => {
				'default' => q(భూటానీయుల గుల్‌ట్రుమ్),
				'one' => q(భూటానీయుల గుల్‌ట్రుమ్),
				'other' => q(భూటానీయుల గుల్‌ట్రుమ్‌లు),
			},
		},
		'BWP' => {
			display_name => {
				'default' => q(బోట్స్‌వానా పులా),
				'one' => q(బోట్స్‌వానా పులా),
				'other' => q(బోట్స్‌వానా పులాలు),
			},
		},
		'BYR' => {
			display_name => {
				'default' => q(బెలరూసియన్ రూబుల్),
				'one' => q(బెలరూసియన్ రూబుల్),
				'other' => q(బెలరూసియన్ రూబుల్‌లు),
			},
		},
		'BZD' => {
			display_name => {
				'default' => q(బెలీజ్ డాలర్),
				'one' => q(బెలీజ్ డాలర్),
				'other' => q(బెలీజ్ డాలర్‌లు),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'default' => q(కెనడియన్ డాలర్),
				'one' => q(కెనడియన్ డాలర్),
				'other' => q(కెనడియన్ డాలర్‌లు),
			},
		},
		'CDF' => {
			display_name => {
				'default' => q(కొంగోలిస్ ఫ్రాంక్),
				'one' => q(కొంగోలిస్ ఫ్రాంక్),
				'other' => q(కొంగోలిస్ ఫ్రాంక్‌లు),
			},
		},
		'CHF' => {
			display_name => {
				'default' => q(స్విస్ ఫ్రాంక్),
				'one' => q(స్విస్ ఫ్రాంక్),
				'other' => q(స్విస్ ఫ్రాంక్‌లు),
			},
		},
		'CLP' => {
			display_name => {
				'default' => q(చిలియన్ పెసో),
				'one' => q(చిలియన్ పెసో),
				'other' => q(చిలియన్ పెసోలు),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'default' => q(చైనా దేశ యువాన్),
				'one' => q(చైనా దేశ యువాన్),
				'other' => q(చైనా దేశ యువాన్),
			},
		},
		'COP' => {
			display_name => {
				'default' => q(కొలంబియన్ పెసో),
				'one' => q(కొలంబియన్ పెసో),
				'other' => q(కొలంబియన్ పెసోలు),
			},
		},
		'CRC' => {
			display_name => {
				'default' => q(కోస్టా రికన్ కోలోన్),
				'one' => q(కోస్టా రికన్ కోలోన్),
				'other' => q(కోస్టా రికన్ కోలోన్‌లు),
			},
		},
		'CUC' => {
			display_name => {
				'default' => q(కుబన్ మార్పిడి చెయ్యగలిగే పెసో),
				'one' => q(కుబన్ మార్పిడి చెయ్యగలిగే పెసో),
				'other' => q(కుబన్ మార్పిడి చెయ్యగలిగే పెసోలు),
			},
		},
		'CUP' => {
			display_name => {
				'default' => q(క్యూబన్ పెసో),
				'one' => q(క్యూబన్ పెసో),
				'other' => q(క్యూబన్ పెసోలు),
			},
		},
		'CVE' => {
			display_name => {
				'default' => q(కేప్ వెర్డియన్ ఎస్కుడో),
				'one' => q(కేప్ వెర్డియన్ ఎస్కుడో),
				'other' => q(కేప్ వెర్డియన్ ఎస్కుడోలు),
			},
		},
		'CZK' => {
			display_name => {
				'default' => q(చెక్ రిపబ్లిక్ కోరునా),
				'one' => q(చెక్ రిపబ్లిక్ కోరునా),
				'other' => q(చెక్ రిపబ్లిక్ కోరునాలు),
			},
		},
		'DJF' => {
			display_name => {
				'default' => q(జిబోటియన్ ఫ్రాంక్),
				'one' => q(జిబోటియన్ ఫ్రాంక్),
				'other' => q(జిబోటియన్ ఫ్రాంక్‌లు),
			},
		},
		'DKK' => {
			display_name => {
				'default' => q(డానిష్ క్రోన్),
				'one' => q(డానిష్ క్రోన్),
				'other' => q(డానిష్ క్రోనర్),
			},
		},
		'DOP' => {
			display_name => {
				'default' => q(డోమినికన్ పెసో),
				'one' => q(డోమినికన్ పెసో),
				'other' => q(డోమినికన్ పెసోలు),
			},
		},
		'DZD' => {
			display_name => {
				'default' => q(అల్జీరియన్ దీనార్),
				'one' => q(అల్జీరియన్ దీనార్),
				'other' => q(అల్జీరియన్ దీనార్‌లు),
			},
		},
		'EGP' => {
			display_name => {
				'default' => q(ఈజిప్షియన్ పౌండ్),
				'one' => q(ఈజిప్షియన్ పౌండ్),
				'other' => q(ఈజిప్షియన్ పౌండ్‌లు),
			},
		},
		'ERN' => {
			display_name => {
				'default' => q(ఎరిట్రీన్ నక్ఫా),
				'one' => q(ఎరిట్రీన్ నక్ఫా),
				'other' => q(ఎరిట్రీన్ నక్ఫా‌లు),
			},
		},
		'ETB' => {
			display_name => {
				'default' => q(ఇథియోపియన్ బర్),
				'one' => q(ఇథియోపియన్ బర్),
				'other' => q(ఇథియోపియన్ బర్‌లు),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'default' => q(యురొ),
				'one' => q(యురొ),
				'other' => q(యురోలు),
			},
		},
		'FJD' => {
			display_name => {
				'default' => q(ఫీజియన్ డాలర్),
				'one' => q(ఫీజియన్ డాలర్),
				'other' => q(ఫీజియన్ డాలర్‌లు),
			},
		},
		'FKP' => {
			display_name => {
				'default' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్),
				'one' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్),
				'other' => q(ఫాక్‌ల్యాండ్ దీవులు పౌండ్‌లు),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'default' => q(బ్రిటిష్ పౌండ్ స్టెర్లింగ్),
				'one' => q(బ్రిటిష్ పౌండ్ స్టెర్లింగ్),
				'other' => q(బ్రిటిష్ పౌండ్‌ల స్టెర్లింగ్),
			},
		},
		'GEL' => {
			display_name => {
				'default' => q(జార్జియన్ లారి),
				'one' => q(జార్జియన్ లారి),
				'other' => q(జార్జియన్ లారీలు),
			},
		},
		'GHS' => {
			display_name => {
				'default' => q(గానెయన్ సెడి),
				'one' => q(గానెయన్ సెడి),
				'other' => q(గానెయన్ సెడిలు),
			},
		},
		'GIP' => {
			display_name => {
				'default' => q(జిబ్రల్‌టూర్ పౌండ్),
				'one' => q(జిబ్రల్‌టూర్ పౌండ్),
				'other' => q(జిబ్రల్‌టూర్ పౌండ్‌లు),
			},
		},
		'GMD' => {
			display_name => {
				'default' => q(గాంబియన్ దలాసి),
				'one' => q(గాంబియన్ దలాసి),
				'other' => q(గాంబియన్ దలాసిలు),
			},
		},
		'GNF' => {
			display_name => {
				'default' => q(గ్వినియన్ ఫ్రాంక్),
				'one' => q(గ్వినియన్ ఫ్రాంక్),
				'other' => q(గ్వినియన్ ఫ్రాంక్‌లు),
			},
		},
		'GTQ' => {
			display_name => {
				'default' => q(గ్యుటెమాలన్ క్వెట్‌జల్),
				'one' => q(గ్యుటెమాలన్ క్వెట్‌జల్),
				'other' => q(గ్యుటెమాలన్ క్వెట్‌జల్‌లు),
			},
		},
		'GYD' => {
			display_name => {
				'default' => q(గుయనియాస్ డాలర్),
				'one' => q(గుయనియాస్ డాలర్),
				'other' => q(గుయనియాస్ డాలర్‌లు),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'default' => q(హాంకాంగ్ డాలర్),
				'one' => q(హాంకాంగ్ డాలర్),
				'other' => q(హాంకాంగ్ డాలర్‌లు),
			},
		},
		'HNL' => {
			display_name => {
				'default' => q(హోండురన్ లెమిపిరా),
				'one' => q(హోండురన్ లెమిపిరా),
				'other' => q(హోండురన్ లెమిపిరాలు),
			},
		},
		'HRK' => {
			display_name => {
				'default' => q(క్రొయేషియన్ క్యూన),
				'one' => q(క్రొయేషియన్ క్యూన),
				'other' => q(క్రొయేషియన్ క్యూనాలు),
			},
		},
		'HTG' => {
			display_name => {
				'default' => q(హైటియన్ గ్వోర్డే),
				'one' => q(హైటియన్ గ్వోర్డే),
				'other' => q(హైటియన్ గ్వోర్డేలు),
			},
		},
		'HUF' => {
			display_name => {
				'default' => q(హంగేరియన్ ఫోరిన్ట్),
				'one' => q(హంగేరియన్ ఫోరిన్ట్),
				'other' => q(హంగేరియన్ ఫోరిన్ట్‌లు),
			},
		},
		'IDR' => {
			display_name => {
				'default' => q(ఇండోనేషియా రూపాయి),
				'one' => q(ఇండోనేషియా రూపాయి),
				'other' => q(ఇండోనేషియా రూపాయలు),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'default' => q(ఐరాయిలి న్యూ షెక్యెల్),
				'one' => q(ఐరాయిలి న్యూ షెక్యెల్),
				'other' => q(ఐరాయిలి న్యూ షెక్యెల్‌లు),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'default' => q(రూపాయి),
				'one' => q(రూపాయి),
				'other' => q(రూపాయలు),
			},
		},
		'IQD' => {
			display_name => {
				'default' => q(ఇరాకీ దీనార్),
				'one' => q(ఇరాకీ దీనార్),
				'other' => q(ఇరాకీ దీనార్‌లు),
			},
		},
		'IRR' => {
			display_name => {
				'default' => q(ఇరానియన్ రీయల్),
				'one' => q(ఇరానియన్ రీయల్),
				'other' => q(ఇరానియన్ రీయల్‌లు),
			},
		},
		'ISK' => {
			display_name => {
				'default' => q(ఐస్లాండిక్ క్రోనా),
				'one' => q(ఐస్లాండిక్ క్రోనా),
				'other' => q(ఐస్లాండిక్ క్రోనర్),
			},
		},
		'JMD' => {
			display_name => {
				'default' => q(జమైకన్ డాలర్),
				'one' => q(జమైకన్ డాలర్),
				'other' => q(జమైకన్ డాలర్‌లు),
			},
		},
		'JOD' => {
			display_name => {
				'default' => q(జోర్‌డానియన్ దీనార్),
				'one' => q(జోర్‌డానియన్ దీనార్),
				'other' => q(జోర్‌డానియన్ దీనార్‌లు),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'default' => q(జపాను దేశ యెస్),
				'one' => q(జపాను దేశ యెస్),
				'other' => q(జపాను దేశ యెస్),
			},
		},
		'KES' => {
			display_name => {
				'default' => q(కెన్యాన్ షిల్లింగ్),
				'one' => q(కెన్యాన్ షిల్లింగ్),
				'other' => q(కెన్యాన్ షిల్లింగ్‌లు),
			},
		},
		'KGS' => {
			display_name => {
				'default' => q(కిర్గిస్థాని సౌమ్),
				'one' => q(కిర్గిస్థాని సౌమ్),
				'other' => q(కిర్గిస్థాని సౌమ్‌లు),
			},
		},
		'KHR' => {
			display_name => {
				'default' => q(కాంబోడియన్ రీల్),
				'one' => q(కాంబోడియన్ రీల్),
				'other' => q(కాంబోడియన్ రీల్‌లు),
			},
		},
		'KMF' => {
			display_name => {
				'default' => q(కొమోరియన్ ఫ్రాంక్),
				'one' => q(కొమోరియన్ ఫ్రాంక్),
				'other' => q(కొమోరియన్ ఫ్రాంక్‌లు),
			},
		},
		'KPW' => {
			display_name => {
				'default' => q(ఉత్తర కొరియా వోన్),
				'one' => q(ఉత్తర కొరియా వోన్),
				'other' => q(ఉత్తర కొరియా వోన్),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'default' => q(దక్షిణ కొరియా వోన్),
				'one' => q(దక్షిణ కొరియా వోన్),
				'other' => q(దక్షిణ కొరియా వోన్),
			},
		},
		'KWD' => {
			display_name => {
				'default' => q(కువైట్ దీనార్),
				'one' => q(కువైట్ దీనార్),
				'other' => q(కువైట్ దీనార్‌లు),
			},
		},
		'KYD' => {
			display_name => {
				'default' => q(కేమాన్ దీవుల డాలర్),
				'one' => q(కేమాన్ దీవుల డాలర్),
				'other' => q(కేమాన్ దీవుల డాలర్‌లు),
			},
		},
		'KZT' => {
			display_name => {
				'default' => q(ఖజికిస్థాన్ టెంగే),
				'one' => q(ఖజికిస్థాన్ టెంగే),
				'other' => q(ఖజికిస్థాన్ టెంగేలు),
			},
		},
		'LAK' => {
			display_name => {
				'default' => q(లాటియన్ కిప్),
				'one' => q(లాటియన్ కిప్),
				'other' => q(లాటియన్ కిప్‌లు),
			},
		},
		'LBP' => {
			display_name => {
				'default' => q(లెబనీస్ పౌండ్),
				'one' => q(లెబనీస్ పౌండ్),
				'other' => q(లెబనీస్ పౌండ్‌లు),
			},
		},
		'LKR' => {
			display_name => {
				'default' => q(శ్రీలంక రూపాయి),
				'one' => q(శ్రీలంక రూపాయి),
				'other' => q(శ్రీలంక రూపాయలు),
			},
		},
		'LRD' => {
			display_name => {
				'default' => q(లిబేరియన్ డాలర్),
				'one' => q(లిబేరియన్ డాలర్),
				'other' => q(లిబేరియన్ డాలర్‌లు),
			},
		},
		'LSL' => {
			display_name => {
				'default' => q(లెసోధో లోటి),
			},
		},
		'LTL' => {
			display_name => {
				'default' => q(లిథోనియన్ లీటాస్),
				'one' => q(లిథోనియన్ లీటాస్),
				'other' => q(లిథోనియన్ లీటై),
			},
		},
		'LVL' => {
			display_name => {
				'default' => q(లాత్వియన్ లాట్స్),
				'one' => q(లాత్వియన్ లాట్స్),
				'other' => q(లాత్వియన్ లాటి),
			},
		},
		'LYD' => {
			display_name => {
				'default' => q(లిబియన్ దీనార్),
				'one' => q(లిబియన్ దీనార్),
				'other' => q(లిబియన్ దీనార్‌లు),
			},
		},
		'MAD' => {
			display_name => {
				'default' => q(మోరోకన్ దిర్హుమ్),
				'one' => q(మోరోకన్ దిర్హుమ్),
				'other' => q(మోరోకన్ దిర్హుమ్‌లు),
			},
		},
		'MDL' => {
			display_name => {
				'default' => q(మోల్‌డోవన్ ల్యూ),
				'one' => q(మోల్‌డోవన్ ల్యూ),
				'other' => q(మోల్‌డోవన్ లీ),
			},
		},
		'MGA' => {
			display_name => {
				'default' => q(మలగసీ అరియరీ),
				'one' => q(మలగసీ అరియరీ),
				'other' => q(మలగసీ అరియరీలు),
			},
		},
		'MKD' => {
			display_name => {
				'default' => q(మెసిడోనియన్ దినార్),
				'one' => q(మెసిడోనియన్ దినార్),
				'other' => q(మెసిడోనియన్ దినారి),
			},
		},
		'MMK' => {
			display_name => {
				'default' => q(మ్యాన్మా క్యాట్),
				'one' => q(మ్యాన్మా క్యాట్),
				'other' => q(మ్యాన్మా క్యాట్‌లు),
			},
		},
		'MNT' => {
			display_name => {
				'default' => q(మంగోలియన్ టుగ్రిక్),
				'one' => q(మంగోలియన్ టుగ్రిక్),
				'other' => q(మంగోలియన్ టుగ్రిక్‌లు),
			},
		},
		'MOP' => {
			display_name => {
				'default' => q(మకనీస్ పటాక),
				'one' => q(మకనీస్ పటాక),
				'other' => q(మకనీస్ పటాకాలు),
			},
		},
		'MRO' => {
			display_name => {
				'default' => q(మౌరిటానియన్ ఒగ్యియా),
				'one' => q(మౌరిటానియన్ ఒగ్యియా),
				'other' => q(మౌరిటానియన్ ఒగ్యియాలు),
			},
		},
		'MUR' => {
			display_name => {
				'default' => q(మారిషన్ రూపాయి),
				'one' => q(మారిషన్ రూపాయి),
				'other' => q(మారిషన్ రూపాయలు),
			},
		},
		'MVR' => {
			display_name => {
				'default' => q(మాల్దీవియన్ రుఫియా),
				'one' => q(మాల్దీవియన్ రుఫియా),
				'other' => q(మాల్దీవియన్ రుఫియాలు),
			},
		},
		'MWK' => {
			display_name => {
				'default' => q(మలావియన్ క్వాచా),
				'one' => q(మలావియన్ క్వాచా),
				'other' => q(మలావియన్ క్వాచాలు),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'default' => q(మెక్సికన్ పెసో),
				'one' => q(మెక్సికన్ పెసో),
				'other' => q(మెక్సికన్ పెసోలు),
			},
		},
		'MYR' => {
			display_name => {
				'default' => q(మలేషియా రింగ్గిట్),
				'one' => q(మలేషియా రింగ్గిట్),
				'other' => q(మలేషియా రింగ్గిట్‌లు),
			},
		},
		'MZN' => {
			display_name => {
				'default' => q(మొజాంబికన్ మెటికల్),
				'one' => q(మొజాంబికన్ మెటికల్),
				'other' => q(మొజాంబికన్ మెటికల్‌లు),
			},
		},
		'NAD' => {
			display_name => {
				'default' => q(నమిబియన్ డాలర్),
				'one' => q(నమిబియన్ డాలర్),
				'other' => q(నమిబియన్ డాలర్‌లు),
			},
		},
		'NGN' => {
			display_name => {
				'default' => q(నైజీరియన్ నైరా),
				'one' => q(నైజీరియన్ నైరా),
				'other' => q(నైజీరియన్ నైరాలు),
			},
		},
		'NIO' => {
			display_name => {
				'default' => q(నికరగ్యుయన్ కొర్‌డుబు),
				'one' => q(నికరగ్యుయన్ కొర్‌డుబు),
				'other' => q(నికరగ్యుయన్ కొర్‌డుబులు),
			},
		},
		'NOK' => {
			display_name => {
				'default' => q(నార్వేజీయన్ క్రోన్),
				'one' => q(నార్వేజీయన్ క్రోన్),
				'other' => q(నార్వేజీయన్ క్రోనర్),
			},
		},
		'NPR' => {
			display_name => {
				'default' => q(నేపాలీయుల రూపాయి),
				'one' => q(నేపాలీయుల రూపాయి),
				'other' => q(నేపాలీయుల రూపాయలు),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'default' => q(న్యూజిలాండ్ డాలర్),
				'one' => q(న్యూజిలాండ్ డాలర్),
				'other' => q(న్యూజిలాండ్ డాలర్‌లు),
			},
		},
		'OMR' => {
			display_name => {
				'default' => q(ఒమాని రీయల్),
				'one' => q(ఒమాని రీయల్),
				'other' => q(ఒమాని రీయల్‌లు),
			},
		},
		'PAB' => {
			display_name => {
				'default' => q(పనామనియన్ బల్బోవ),
				'one' => q(పనామనియన్ బల్బోవ),
				'other' => q(పనామనియన్ బల్బోవాలు),
			},
		},
		'PEN' => {
			display_name => {
				'default' => q(పెరువియన్ న్యూవో సోల్),
				'one' => q(పెరువియన్ న్యూవో సోల్),
				'other' => q(పెరువియన్ న్యూవో సోల్‌లు),
			},
		},
		'PGK' => {
			display_name => {
				'default' => q(పప్యూ న్యూ గ్యినియన్ కినా),
				'one' => q(పప్యూ న్యూ గ్యినియన్ కినా),
				'other' => q(పప్యూ న్యూ గ్యినియన్ కినా),
			},
		},
		'PHP' => {
			display_name => {
				'default' => q(ఫిలిప్పిన్ పెసో),
				'one' => q(ఫిలిప్పిన్ పెసో),
				'other' => q(ఫిలిప్పిన్ పెసోలు),
			},
		},
		'PKR' => {
			display_name => {
				'default' => q(పాకిస్థాన్ రూపాయి),
				'one' => q(పాకిస్థాన్ రూపాయి),
				'other' => q(పాకిస్థాన్ రూపాయలు),
			},
		},
		'PLN' => {
			display_name => {
				'default' => q(పోలిష్ జ్లోటీ),
				'one' => q(పోలిష్ జ్లోటీ),
				'other' => q(పోలిష్ జ్లోటీలు),
			},
		},
		'PYG' => {
			display_name => {
				'default' => q(పరగ్వాయన్ గ్వారని),
				'one' => q(పరగ్వాయన్ గ్వారని),
				'other' => q(పరగ్వాయన్ గ్వారనీలు),
			},
		},
		'QAR' => {
			display_name => {
				'default' => q(క్వాటరి రీయల్),
				'one' => q(క్వాటరి రీయల్),
				'other' => q(క్వాటరి రీయల్‌లు),
			},
		},
		'RON' => {
			display_name => {
				'default' => q(రోమానియాన్ లెయు),
				'one' => q(రోమానియాన్ లెయు),
				'other' => q(రోమానియాన్ లీ),
			},
		},
		'RSD' => {
			display_name => {
				'default' => q(సెర్బియన్ దీనార్),
				'one' => q(సెర్బియన్ దీనార్),
				'other' => q(సెర్బియన్ దీనార్‌లు),
			},
		},
		'RUB' => {
			display_name => {
				'default' => q(రష్యా రూబల్),
				'one' => q(రష్యా రూబల్),
				'other' => q(రష్యా రూబల్‌లు),
			},
		},
		'RWF' => {
			display_name => {
				'default' => q(ర్వానడాన్ ఫ్రాంక్),
				'one' => q(ర్వానడాన్ ఫ్రాంక్),
				'other' => q(ర్వానడాన్ ఫ్రాంక్‌లు),
			},
		},
		'SAR' => {
			display_name => {
				'default' => q(సౌది రియల్),
				'one' => q(సౌది రియల్),
				'other' => q(సౌది రియల్‌లు),
			},
		},
		'SBD' => {
			display_name => {
				'default' => q(సోలోమన్ దీవుల డాలర్),
				'one' => q(సోలోమన్ దీవుల డాలర్),
				'other' => q(సోలోమన్ దీవుల డాలర్‌లు),
			},
		},
		'SCR' => {
			display_name => {
				'default' => q(సెయిచెల్లోయిస్ రూపాయి),
				'one' => q(సెయిచెల్లోయిస్ రూపాయి),
				'other' => q(సెయిచెల్లోయిస్ రూపాయలు),
			},
		},
		'SDG' => {
			display_name => {
				'default' => q(సుడానీస్ పౌండ్),
				'one' => q(సుడానీస్ పౌండ్),
				'other' => q(సుడానీస్ పౌండ్‌లు),
			},
		},
		'SEK' => {
			display_name => {
				'default' => q(స్వీడిష్ క్రోనా),
				'one' => q(స్వీడిష్ క్రోనా),
				'other' => q(స్వీడిష్ క్రోనర్),
			},
		},
		'SGD' => {
			display_name => {
				'default' => q(సింగపూర్ డాలర్),
				'one' => q(సింగపూర్ డాలర్),
				'other' => q(సింగపూర్ డాలర్‌లు),
			},
		},
		'SHP' => {
			display_name => {
				'default' => q(సెయింట్ హెలెనా పౌండ్),
				'one' => q(సెయింట్ హెలెనా పౌండ్),
				'other' => q(సెయింట్ హెలెనా పౌండ్‌లు),
			},
		},
		'SLL' => {
			display_name => {
				'default' => q(సీయిరు లియోనియన్ లీయోన్),
				'one' => q(సీయిరు లియోనియన్ లీయోన్),
				'other' => q(సీయిరు లియోనియన్ లీయోన్‌లు),
			},
		},
		'SOS' => {
			display_name => {
				'default' => q(సొమాలి షిల్లింగ్),
				'one' => q(సొమాలి షిల్లింగ్),
				'other' => q(సొమాలి షిల్లింగ్‌లు),
			},
		},
		'SRD' => {
			display_name => {
				'default' => q(సురినామీయుల డాలర్),
				'one' => q(సురినామీయుల డాలర్),
				'other' => q(సురినామీయుల డాలర్‌లు),
			},
		},
		'SSP' => {
			display_name => {
				'default' => q(దక్షిణ సుడానీస్ పౌండ్),
				'one' => q(దక్షిణ సుడానీస్ పౌండ్),
				'other' => q(దక్షిణ సుడానీస్ పౌండ్‌లు),
			},
		},
		'STD' => {
			display_name => {
				'default' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా),
				'one' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రా),
				'other' => q(సావో టోమ్ మరియు ప్రిన్సిపి డోబ్రాలు),
			},
		},
		'SYP' => {
			display_name => {
				'default' => q(సిరీయన్ పౌండ్),
				'one' => q(సిరీయన్ పౌండ్),
				'other' => q(సిరీయన్ పౌండ్‌లు),
			},
		},
		'SZL' => {
			display_name => {
				'default' => q(స్వాజి లిలాన్గేని),
				'one' => q(స్వాజి లిలాన్గేని),
				'other' => q(స్వాజి ఎమలాన్గేని),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'default' => q(థాయ్ బాట్),
				'one' => q(థాయ్ బాట్),
				'other' => q(థాయ్ బాట్),
			},
		},
		'TJS' => {
			display_name => {
				'default' => q(తజికిస్థాన్ సమోని),
				'one' => q(తజికిస్థాన్ సమోని),
				'other' => q(తజికిస్థాన్ సమోనీలు),
			},
		},
		'TMT' => {
			display_name => {
				'default' => q(తుర్క్‌మెనిస్థాని మనాట్),
				'one' => q(తుర్క్‌మెనిస్థాని మనాట్),
				'other' => q(తుర్క్‌మెనిస్థాని మనాట్),
			},
		},
		'TND' => {
			display_name => {
				'default' => q(తునీషియన్ దీనార్),
				'one' => q(తునీషియన్ దీనార్),
				'other' => q(తునీషియన్ దీనార్‌లు),
			},
		},
		'TOP' => {
			display_name => {
				'default' => q(టోంగాన్ పాంʻగా),
				'one' => q(టోంగాన్ పాంʻగా),
				'other' => q(టోంగాన్ పాంʻగా),
			},
		},
		'TRY' => {
			display_name => {
				'default' => q(తుర్కిష్ లిరా),
				'one' => q(తుర్కిష్ లిరా),
				'other' => q(తుర్కిష్ లిరా),
			},
		},
		'TTD' => {
			display_name => {
				'default' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్),
				'one' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్),
				'other' => q(ట్రినిడాడ్ మరియు టొబాగో డాలర్‌లు),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'default' => q(క్రొత్త తైవాన్ డాలర్),
				'one' => q(క్రొత్త తైవాన్ డాలర్),
				'other' => q(క్రొత్త తైవాన్ డాలర్),
			},
		},
		'TZS' => {
			display_name => {
				'default' => q(టాంజానియన్ షిల్లింగ్),
				'one' => q(టాంజానియన్ షిల్లింగ్),
				'other' => q(టాంజానియన్ షిల్లింగ్‌లు),
			},
		},
		'UAH' => {
			display_name => {
				'default' => q(ఉక్రయినియన్ హ్రివ్‌నియా),
				'one' => q(ఉక్రయినియన్ హ్రివ్‌నియా),
				'other' => q(ఉక్రయినియన్ హ్రివ్‌నియాలు),
			},
		},
		'UGX' => {
			display_name => {
				'default' => q(యుగండన్ షిల్లింగ్),
				'one' => q(యుగండన్ షిల్లింగ్),
				'other' => q(యుగండన్ షిల్లింగ్‌లు),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'default' => q(అమెరికా డాలర్),
				'one' => q(అమెరికా డాలర్),
				'other' => q(అమెరికా డాలర్‌లు),
			},
		},
		'UYU' => {
			display_name => {
				'default' => q(ఉరుగ్వెయన్ పెసో),
				'one' => q(ఉరుగ్వెయన్ పెసో),
				'other' => q(ఉరుగ్వెయన్ పెసోలు),
			},
		},
		'UZS' => {
			display_name => {
				'default' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
				'one' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
				'other' => q(ఉజ్‌బెకిస్తాన్ సౌమ్),
			},
		},
		'VEF' => {
			display_name => {
				'default' => q(వెనుజులా బోలివర్),
				'one' => q(వెనుజులా బోలివర్),
				'other' => q(వెనుజులా బోలివర్‌లు),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'default' => q(వియత్నామీయుల డాంగ్),
				'one' => q(వియత్నామీయుల డాంగ్),
				'other' => q(వియత్నామీయుల డాంగ్),
			},
		},
		'VUV' => {
			display_name => {
				'default' => q(వనాటు వటు),
				'one' => q(వనాటు వటు),
				'other' => q(వవాటు వటూలు),
			},
		},
		'WST' => {
			display_name => {
				'default' => q(సమోయన్ తాలా),
				'one' => q(సమోయన్ తాలా),
				'other' => q(సమోయన్ తాలా),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'default' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిఇఏసి),
				'one' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిఇఏసి),
				'other' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిఇఏసి),
			},
		},
		'XAG' => {
			display_name => {
				'default' => q(వెండి),
			},
		},
		'XAU' => {
			display_name => {
				'default' => q(బంగారం),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'default' => q(తూర్పు కరీబియన్ డాలర్),
				'one' => q(తూర్పు కరీబియన్ డాలర్),
				'other' => q(తూర్పు కరీబియన్ డాలర్‌లు),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'default' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిసిఈఏఓ),
				'one' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిసిఈఏఓ),
				'other' => q(సిఎఫ్‌ఎ ఫ్రాంక్ బిసిఈఏఓ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'default' => q(సిఎఫ్‌పి ఫ్రాంక్),
				'one' => q(సిఎఫ్‌పి ఫ్రాంక్),
				'other' => q(సిఎఫ్‌పి ఫ్రాంక్‌లు),
			},
		},
		'XPT' => {
			display_name => {
				'default' => q(ప్లాటినం),
			},
		},
		'XXX' => {
			display_name => {
				'default' => q(తెలియని కరెన్సీ),
				'one' => q(తెలియని కరెన్సీ ప్రమాణం),
				'other' => q(తెలియని కరెన్సీ),
			},
		},
		'YER' => {
			display_name => {
				'default' => q(ఎమునీ రీయల్),
				'one' => q(ఎమునీ రీయల్),
				'other' => q(ఎమునీ రీయల్‌లు),
			},
		},
		'ZAR' => {
			display_name => {
				'default' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
				'one' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
				'other' => q(దక్షిణ ఆఫ్రికా ర్యాండ్),
			},
		},
		'ZMK' => {
			display_name => {
				'default' => q(జాంబియన్ క్వాచా (1968–2012)),
			},
		},
		'ZMW' => {
			display_name => {
				'default' => q(జాంబియన్ క్వాచా),
				'one' => q(జాంబియన్ క్వాచా),
				'other' => q(జాంబియన్ క్వాచాలు),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'జన',
							'ఫిబ్ర',
							'మార్చి',
							'ఏప్రి',
							'మే',
							'జూన్',
							'జులై',
							'ఆగ',
							'సెప్టెం',
							'అక్టో',
							'నవం',
							'డిసెం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'జ',
							'ఫి',
							'మా',
							'ఏ',
							'మే',
							'జూ',
							'జు',
							'ఆ',
							'సె',
							'అ',
							'న',
							'డి'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'జనవరి',
							'ఫిబ్రవరి',
							'మార్చి',
							'ఎప్రిల్',
							'మే',
							'జూన్',
							'జులై',
							'ఆగస్టు',
							'సెప్టెంబర్',
							'అక్టోబర్',
							'నవంబర్',
							'డిసెంబర్'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'జన',
							'ఫిబ్ర',
							'మార్చి',
							'ఏప్రి',
							'మే',
							'జూన్',
							'జులై',
							'ఆగస్టు',
							'సెప్టెం',
							'అక్టో',
							'నవం',
							'డిసెం'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'జ',
							'ఫి',
							'మా',
							'ఏ',
							'మే',
							'జూ',
							'జు',
							'ఆ',
							'సె',
							'అ',
							'న',
							'డి'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'జనవరి',
							'ఫిబ్రవరి',
							'మార్చి',
							'ఎప్రిల్',
							'మే',
							'జూన్',
							'జూలై',
							'ఆగస్టు',
							'సెప్టెంబర్',
							'అక్టోబర్',
							'నవంబర్',
							'డిసెంబర్'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'చైత్రం',
							'వైశాఖం',
							'జ్యేష్ఠం',
							'ఆషాఢం',
							'శ్రావణం',
							'భాద్రపదం',
							'ఆశ్వయుజం',
							'కార్తీకం',
							'మార్గశిరం',
							'పుష్యం',
							'మాఘం',
							'ఫల్గుణం'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'Muharram',
							'Safar',
							'Rabiʻ I',
							'Rabiʻ II',
							'Jumada I',
							'Jumada II',
							'Rajab',
							'Shaʻban',
							'Ramadan',
							'Shawwal',
							'Dhuʻl-Qiʻdah',
							'Dhuʻl-Hijjah'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'సోమ',
						tue => 'మంగళ',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					narrow => {
						mon => 'సో',
						tue => 'మ',
						wed => 'బు',
						thu => 'గు',
						fri => 'శు',
						sat => 'శ',
						sun => 'ఆ'
					},
					short => {
						mon => 'సోమ',
						tue => 'మం',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					wide => {
						mon => 'సోమవారం',
						tue => 'మంగళవారం',
						wed => 'బుధవారం',
						thu => 'గురువారం',
						fri => 'శుక్రవారం',
						sat => 'శనివారం',
						sun => 'ఆదివారం'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'సోమ',
						tue => 'మంగళ',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					narrow => {
						mon => 'సో',
						tue => 'మ',
						wed => 'బు',
						thu => 'గు',
						fri => 'శు',
						sat => 'శ',
						sun => 'ఆ'
					},
					short => {
						mon => 'సోమ',
						tue => 'మం',
						wed => 'బుధ',
						thu => 'గురు',
						fri => 'శుక్ర',
						sat => 'శని',
						sun => 'ఆది'
					},
					wide => {
						mon => 'సోమవారం',
						tue => 'మంగళవారం',
						wed => 'బుధవారం',
						thu => 'గురువారం',
						fri => 'శుక్రవారం',
						sat => 'శనివారం',
						sun => 'ఆదివారం'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'త్రై1',
						1 => 'త్రై2',
						2 => 'త్రై3',
						3 => 'త్రై4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1వ త్రైమాసం',
						1 => '2వ త్రైమాసం',
						2 => '3వ త్రైమాసం',
						3 => '4వ త్రైమాసం'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'త్రై1',
						1 => 'త్రై2',
						2 => 'త్రై3',
						3 => 'త్రై4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'మొదటి త్రైమాసికం',
						1 => 'రెండవ త్రైమాసికం',
						2 => 'మూడవ త్రైమాసికం',
						3 => 'నాల్గవ త్రైమాసికం'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time) = @_;
		SWITCH:
		for ($type) {
			if ($_ eq 'indian') {
				return 'morning' if $time >= 600
					&& $time < 1200;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1500
					&& $time < 1800;
				return 'afternoon' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 300
					&& $time < 600;
				return 'night' if $time >= 1800
					&& $time < 300;
			last SWITCH;
			}
			if ($_ eq 'generic') {
				return 'morning' if $time >= 600
					&& $time < 1200;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1500
					&& $time < 1800;
				return 'afternoon' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 300
					&& $time < 600;
				return 'night' if $time >= 1800
					&& $time < 300;
			last SWITCH;
			}
			if ($_ eq 'islamic') {
				return 'morning' if $time >= 600
					&& $time < 1200;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1500
					&& $time < 1800;
				return 'afternoon' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 300
					&& $time < 600;
				return 'night' if $time >= 1800
					&& $time < 300;
			last SWITCH;
			}
			if ($_ eq 'gregorian') {
				return 'morning' if $time >= 600
					&& $time < 1200;
				return 'noon' if $time == 1200;
				return 'evening' if $time >= 1500
					&& $time < 1800;
				return 'afternoon' if $time > 1200
					&& $time < 1500;
				return 'earlyMorning' if $time >= 300
					&& $time < 600;
				return 'night' if $time >= 1800
					&& $time < 300;
			last SWITCH;
			}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{AM},
					'morning' => q{మధ్యాహ్నం},
					'pm' => q{PM},
					'earlyMorning' => q{ఉదయం},
					'afternoon' => q{రాత్రి},
					'night' => q{తెల్లవారుఝాము},
					'noon' => q{సాయంకాలం},
					'evening' => q{అర్ధరాత్రి},
				},
				'narrow' => {
					'pm' => q{PM},
					'am' => q{AM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'క్రీపూ',
				'1' => 'క్రీశ'
			},
			narrow => {
				'0' => 'ఈసాపూర్వ.',
				'1' => 'సన్.'
			},
			wide => {
				'0' => 'ఈసాపూర్వ.',
				'1' => 'సన్.'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'శక'
			},
		},
		'islamic' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd-MM-y GGGGG},
		},
		'gregorian' => {
			'full' => q{d MMMM y EEEE},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd-MM-yy},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G MMM y},
			GyMMMEd => q{G E, d, MMM y},
			GyMMMd => q{G d, MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d, MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d, MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d, MMM y G},
			GyMMMd => q{d, MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d, MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d, MMM y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d MMM - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y - E, d/M/y},
				d => q{E, d/M/y - E, d/M/y},
				y => q{E, d/M/y - E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, y},
				d => q{E, d MMM - E, d MMM, y},
				y => q{E, d MMM, y - E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM - d MMM, y},
				d => q{d-d MMM, y},
				y => q{d MMM, y - d MMM, y},
			},
			yMd => {
				M => q{d/M/y - d/M/y},
				d => q{d/M/y - d/M/y},
				y => q{d/M/y - d/M/y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM - E, d MMM},
				d => q{E, d MMM - E, d MMM},
			},
			MMMd => {
				M => q{d MMM - d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y - E, d/M/y},
				d => q{E, d/M/y - E, d/M/y},
				y => q{E, d/M/y - E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM - E, d MMM, y},
				d => q{E, d MMM - E, d MMM, y},
				y => q{E, d MMM, y - E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM - d MMM, y},
				d => q{d-d MMM, y},
				y => q{d MMM, y - d MMM, y},
			},
			yMd => {
				M => q{d/M/y - d/M/y},
				d => q{d/M/y - d/M/y},
				y => q{d/M/y - d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} సమయం),
		regionFormat => q({0} పగటి సమయం),
		regionFormat => q({0} ప్రామాణిక సమయం),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(ఏకర్ వేసవి సమయం),
				'generic' => q(ఏకర్ సమయం),
				'standard' => q(ఏకర్ ప్రామాణిక సమయం),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(ఆఫ్ఘనిస్థాన్ సమయం),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#అబిడ్జాన్#,
		},
		'Africa/Accra' => {
			exemplarCity => q#అక్రా#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#యాడిస్ అబాబా#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#అల్జియర్స్#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#అస్మారా#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#బామాకో#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#బాంగుయ్#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#బంజూల్#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#బిస్సావ్#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#బ్లాన్టైర్#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#బ్రాజావిల్లి#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#బుజమ్బురా#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#కైరో#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#కాసాబ్లాంకా#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#స్యూటా#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#కోనాక్రీ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#డకార్#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#దార్ ఎ సలామ్#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#డిజ్బౌటి#,
		},
		'Africa/Douala' => {
			exemplarCity => q#డౌఆలా#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ఎల్ ఎయున్#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ఫ్రీటౌన్#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#గబోరోన్#,
		},
		'Africa/Harare' => {
			exemplarCity => q#హరారే#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#జోహన్నెస్‌బర్గ్#,
		},
		'Africa/Juba' => {
			exemplarCity => q#జుబా#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#కంపాలా#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ఖార్టోమ్#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#కీగలి#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#కిన్షాసా#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#లాగోస్#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#లైబర్విల్#,
		},
		'Africa/Lome' => {
			exemplarCity => q#లోమ్#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#లువాండా#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#లుబంబాషి#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#లుసాకా#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#మలాబో#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#మాపుటో#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#మసేరు#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#బాబెన్#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#మోగాదిషు#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#మోన్రోవియా#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#నైరోబీ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#డ్జామెనా#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#నియామే#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#న్వాక్షోట్#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ఔగాడౌగోవ్#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#పోర్టో-నోవో#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#సావో టోమే#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ట్రిపోలి#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ట్యునిస్#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#విండ్హోక్#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(సెంట్రల్ ఆఫ్రికా సమయం),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(తూర్పు ఆఫ్రికా సమయం),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(దక్షిణాఫ్రికా ప్రామాణిక సమయం),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(పశ్చిమ ఆఫ్రికా వేసవి సమయం),
				'generic' => q(పశ్చిమ ఆఫ్రికా సమయం),
				'standard' => q(పశ్చిమ ఆఫ్రికా ప్రామాణిక సమయం),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(అలాస్కా పగటి సమయం),
				'generic' => q(అలాస్కా సమయం),
				'standard' => q(అలాస్కా ప్రామాణిక సమయం),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(అల్మాటి వేసవి సమయం),
				'generic' => q(అల్మాటి సమయం),
				'standard' => q(అల్మాటి ప్రామాణిక సమయం),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(అమెజాన్ వేసవి సమయం),
				'generic' => q(అమెజాన్ సమయం),
				'standard' => q(అమెజాన్ ప్రామాణిక సమయం),
			},
		},
		'America/Adak' => {
			exemplarCity => q#అడాక్#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ఎంకొరేజ్#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ఆంగ్విలా#,
		},
		'America/Antigua' => {
			exemplarCity => q#అంటిగ్వా#,
		},
		'America/Araguaina' => {
			exemplarCity => q#అరాగ్వేయీనా#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#లా రియోజ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#రియో గల్లేగోస్#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#సల్టా#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#సాన్ జ్యాన్#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#శాన్ లూయిస్#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#టుకుమన్#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ఉష్యూయ#,
		},
		'America/Aruba' => {
			exemplarCity => q#అరుబా#,
		},
		'America/Asuncion' => {
			exemplarCity => q#అసున్సియోన్#,
		},
		'America/Bahia' => {
			exemplarCity => q#బహియ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#బహియా బండరాస్#,
		},
		'America/Barbados' => {
			exemplarCity => q#బార్బడోస్#,
		},
		'America/Belem' => {
			exemplarCity => q#బెలెమ్#,
		},
		'America/Belize' => {
			exemplarCity => q#బెలీజ్#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#బ్లాంక్-సబ్లోన్#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#బోవా విస్టా#,
		},
		'America/Bogota' => {
			exemplarCity => q#బగోటా#,
		},
		'America/Boise' => {
			exemplarCity => q#బొయిసీ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#బ్యూనోస్ ఎయిర్స్#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#కేంబ్రిడ్జ్ బే#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#కాంపో గ్రాండ్#,
		},
		'America/Cancun' => {
			exemplarCity => q#కన్‌కూన్#,
		},
		'America/Caracas' => {
			exemplarCity => q#కారాకస్#,
		},
		'America/Catamarca' => {
			exemplarCity => q#కటమార్కా#,
		},
		'America/Cayenne' => {
			exemplarCity => q#కయేన్#,
		},
		'America/Cayman' => {
			exemplarCity => q#కేమాన్#,
		},
		'America/Chicago' => {
			exemplarCity => q#చికాగో#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#చిహువా#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#అటికోకన్#,
		},
		'America/Cordoba' => {
			exemplarCity => q#కోర్బోడా#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#కోస్టా రికా#,
		},
		'America/Creston' => {
			exemplarCity => q#క్రెస్టన్#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#కుయోబే#,
		},
		'America/Curacao' => {
			exemplarCity => q#కురాకవో#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#డెన్మార్క్శ్వాన్#,
		},
		'America/Dawson' => {
			exemplarCity => q#డాసన్#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#డాసన్ క్రీక్#,
		},
		'America/Denver' => {
			exemplarCity => q#డెన్వెర్#,
		},
		'America/Detroit' => {
			exemplarCity => q#డిట్రోయిట్#,
		},
		'America/Dominica' => {
			exemplarCity => q#డొమినికా#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ఎడ్మోంటన్#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ఇరునెప్#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ఎల్ సాల్వడోర్#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ఫార్ట్లెజా#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#గ్లేస్ బే#,
		},
		'America/Godthab' => {
			exemplarCity => q#గాడ్తాబ్#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#గూస్ బే#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#గ్రాండ్ టర్క్#,
		},
		'America/Grenada' => {
			exemplarCity => q#గ్రెనడా#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#గ్వాడెలోప్#,
		},
		'America/Guatemala' => {
			exemplarCity => q#గ్వాటిమాలా#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#గువాయాక్విల్#,
		},
		'America/Guyana' => {
			exemplarCity => q#గయానా#,
		},
		'America/Halifax' => {
			exemplarCity => q#హలుఫాక్స్#,
		},
		'America/Havana' => {
			exemplarCity => q#హవానా#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#హెర్మోసిల్లో#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#నోక్స్, ఇండియాన#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#మరెంగో, ఇండియాన#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#పెటెర్స్‌బుర్గ్, ఇండియాన#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#టెల్ నగరం, ఇండియాన#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#వెవయ్, ఇండియాన#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#విన్‌సెన్నెస్, ఇండియాన#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#వినిమాక్, ఇండియాన#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ఇండోనెపోలిస్#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ఇనువిక్#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ఇక్వాలిట్#,
		},
		'America/Jamaica' => {
			exemplarCity => q#జమైకా#,
		},
		'America/Jujuy' => {
			exemplarCity => q#జుజుయ్#,
		},
		'America/Juneau' => {
			exemplarCity => q#జోనొవ్#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#మోంటిసెల్లో, కెన్‌టుక్కీ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#క్రలెండ్జిక్#,
		},
		'America/La_Paz' => {
			exemplarCity => q#లా పాజ్#,
		},
		'America/Lima' => {
			exemplarCity => q#లిమా#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#లాస్ ఏంజల్స్#,
		},
		'America/Louisville' => {
			exemplarCity => q#లూయివిల్#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#లోయర్ ప్రిన్సెస్ క్వార్టర్#,
		},
		'America/Maceio' => {
			exemplarCity => q#మాసియో#,
		},
		'America/Managua' => {
			exemplarCity => q#మనాగువా#,
		},
		'America/Manaus' => {
			exemplarCity => q#మనాస్#,
		},
		'America/Marigot' => {
			exemplarCity => q#మారిగోట్#,
		},
		'America/Martinique' => {
			exemplarCity => q#మార్టినీక్#,
		},
		'America/Matamoros' => {
			exemplarCity => q#మాటమొరోస్#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#మాసట్‌లాన్#,
		},
		'America/Mendoza' => {
			exemplarCity => q#మెండోజా#,
		},
		'America/Menominee' => {
			exemplarCity => q#మెనోమినీ#,
		},
		'America/Merida' => {
			exemplarCity => q#మెరిడా#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#మెట్లకట్ల#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#మెక్సికో నగరం#,
		},
		'America/Miquelon' => {
			exemplarCity => q#మిక్వెలాన్#,
		},
		'America/Moncton' => {
			exemplarCity => q#మోన్‌క్టోన్#,
		},
		'America/Monterrey' => {
			exemplarCity => q#మోన్‌టురెయ్#,
		},
		'America/Montevideo' => {
			exemplarCity => q#మోంటెవీడియో#,
		},
		'America/Montserrat' => {
			exemplarCity => q#మోంటిసిరాట్#,
		},
		'America/Nassau' => {
			exemplarCity => q#నాస్సావ్#,
		},
		'America/New_York' => {
			exemplarCity => q#న్యూయార్క్#,
		},
		'America/Nipigon' => {
			exemplarCity => q#నిపిగోన్#,
		},
		'America/Nome' => {
			exemplarCity => q#నోమ్#,
		},
		'America/Noronha' => {
			exemplarCity => q#నరోన్హా#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#బ్యులా, ఉత్తర డకోట#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#సెంట్రల్, ఉత్తర డకోటా#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#న్యూ సలేమ్, దక్షిణ దకోట#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ఒజినగ#,
		},
		'America/Panama' => {
			exemplarCity => q#పనామా#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#పాంగ్‌నీర్‌టుంగ్#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#పరామారిబో#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ఫోనిక్స్#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#పోర్ట్-అవ్-ప్రిన్స్#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#పోర్ట్ ఆఫ్ స్పెయిన్#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#పోర్టో వెల్హో#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ప్యూర్టో రికో#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#వర్షపు నది#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#రన్‌కిన్ ఇన్‌లెట్#,
		},
		'America/Recife' => {
			exemplarCity => q#రెసిఫీ#,
		},
		'America/Regina' => {
			exemplarCity => q#రెజీనా#,
		},
		'America/Resolute' => {
			exemplarCity => q#రిజల్యూట్#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#రియో బ్రాంకో#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#శాంటా ఇసబెల్#,
		},
		'America/Santarem' => {
			exemplarCity => q#సాంటరెమ్#,
		},
		'America/Santiago' => {
			exemplarCity => q#శాంటియాగో#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#శాంటో డోమింగో#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#సావో పాలో#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#స్కోర్స్బైసుండ్#,
		},
		'America/Sitka' => {
			exemplarCity => q#సిట్కా#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#సెయింట్ బర్తెలెమీ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#సె. జాన్స్#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#సెయింట్ కిట్స్#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#సెయింట్ లూసియా#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#సెయింట్ థామస్#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#సెయింట్ విన్సెంట్#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#స్విఫ్ట్ కరెంట్#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#తెగుసిగల్పా#,
		},
		'America/Thule' => {
			exemplarCity => q#ధులే#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#థండర్ బే#,
		},
		'America/Tijuana' => {
			exemplarCity => q#తిజ్యునా#,
		},
		'America/Toronto' => {
			exemplarCity => q#టొరంటో#,
		},
		'America/Tortola' => {
			exemplarCity => q#టోర్టోలా#,
		},
		'America/Vancouver' => {
			exemplarCity => q#వాన్కూవర్#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#వైట్‌హార్స్#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#విన్నిపెగ్#,
		},
		'America/Yakutat' => {
			exemplarCity => q#యకుటాట్#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ఎల్లోనైఫ్#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(మధ్యమ పగటి సమయం),
				'generic' => q(మధ్యమ సమయం),
				'standard' => q(మధ్యమ ప్రామాణిక సమయం),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(తూర్పు పగటి సమయం),
				'generic' => q(తూర్పు సమయం),
				'standard' => q(తూర్పు ప్రామాణిక సమయం),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(మౌంటేన్ పగటి సమయం),
				'generic' => q(మౌంటేన్ సమయం),
				'standard' => q(మౌంటేన్ ప్రామాణిక సమయం),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(పెసిఫిక్ పగటి సమయం),
				'generic' => q(పెసిఫిక్ సమయం),
				'standard' => q(పెసిఫిక్ ప్రామాణిక సమయం),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(అనాన్డ్రి వేసవి సమయం),
				'generic' => q(అనడైర్ సమయం),
				'standard' => q(అనాన్డ్రి ప్రామాణిక సమయం),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#కేసీ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#డేవిస్#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#డ్యుమాంట్ డ్యుర్విల్లీ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#మకారీ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#మాసన్#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#మెక్ముర్డో#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#పామెర్#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#రొతేరా#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#స్యోవా#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#వోస్టోక్#,
		},
		'Aqtau' => {
			long => {
				'daylight' => q(అక్వాటు వేసవి సమయం),
				'generic' => q(అక్వాటు సమయం),
				'standard' => q(అక్వాటు ప్రామాణిక సమయం),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(అక్టోబె వేసవి సమయం),
				'generic' => q(అక్టోబె సమయం),
				'standard' => q(అక్టోబె ప్రామాణిక సమయం),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(అరేబియన్ పగటి వెలుతురు సమయం),
				'generic' => q(అరేబియన్ సమయం),
				'standard' => q(అరేబియన్ ప్రామాణిక సమయం),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#లాంగ్‌యియర్‌బైయన్#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ఆర్జెంటీనా వేసవి సమయం),
				'generic' => q(అర్జెంటీనా సమయం),
				'standard' => q(అర్జెంటీనా ప్రామాణిక సమయం),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(పశ్చిమ అర్జెంటీనా వేసవి సమయం),
				'generic' => q(పశ్చిమ అర్జెంటీనా సమయం),
				'standard' => q(పశ్చిమ అర్జెంటీనా ప్రామాణిక సమయం),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ఆర్మేనియా వేసవి సమయం),
				'generic' => q(ఆర్మేనియా సమయం),
				'standard' => q(ఆర్మేనియా ప్రామాణిక సమయం),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ఎడెన్#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ఆల్మాటి#,
		},
		'Asia/Amman' => {
			exemplarCity => q#అమ్మన్#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#అనడైర్#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#అక్టావ్#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#అక్టోబ్#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#యాష్గాబాట్#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#బాగ్దాద్#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#బహరేన్#,
		},
		'Asia/Baku' => {
			exemplarCity => q#బాకు#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#బ్యాంకాక్#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#బీరట్#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#బిష్కెక్#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#బ్రూనై#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#కోల్‌కతా#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#చోయిబాల్సన్#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#చోంగో‌క్వింగ్#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#కొలంబో#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#డమాస్కస్#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ఢాకా#,
		},
		'Asia/Dili' => {
			exemplarCity => q#డిలి#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#దుబాయి#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#డుషన్బీ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#గాజా#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#హర్బిన్#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#హెబ్రాన్#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#హాంకాంగ్#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#హోవడ్#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ఇర్కుట్స్క్#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#జకార్తా#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#జయపుర#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#జరూసలేం#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#కాబుల్#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#కమ్‌చత్కా#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#కరాచీ#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#కాష్‌గర్#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ఖాట్మండు#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#కంద్యాగ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#క్రసనోయార్స్క్#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#కౌలాలంపూర్#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#కుచింగ్#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#కువైట్#,
		},
		'Asia/Macau' => {
			exemplarCity => q#మకావ్#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#మగడాన్#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#మకాస్సర్#,
		},
		'Asia/Manila' => {
			exemplarCity => q#మనీలా#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#మస్కట్#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#నికోసియా#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#నొవొకుజ్‌నెట్‌స్క్#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#నవోసిబిర్స్క్#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ఓమ్స్క్#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ఓరల్#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#నమ్ పెన్#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#పొన్టియనాక్#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ప్యోంగాంగ్#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ఖతార్#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#క్విజిలోర్డా#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#రంగూన్#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#రియాధ్#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#హో చి మిన్హ్ నగరం#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#సఖాలిన్#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#సమర్కాండ్#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#సియోల్#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#షాంగాయ్#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#సింగపూర్#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#తైపీ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#తాష్కెంట్#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#టిబిలిసి#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#టెహ్రాన్#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#థింఫు#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#టోక్యో#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ఉలాన్బాటర్#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ఉరుమ్‌కీ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#అస్ట్-నెరా#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#వియన్టైన్#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#వ్లాడివోస్టోక్#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#యకుట్స్క్#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#యెకటెరింగ్‌బర్గ్#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#యెరెవన్#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(అట్లాంటిక్ పగటి సమయం),
				'generic' => q(అట్లాంటిక్ సమయం),
				'standard' => q(అట్లాంటిక్ ప్రామాణిక సమయం),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#అజోర్స్#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#బెర్ముడా#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#కెనరీ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#కేప్ వెర్డె#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ఫరోయ్#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#మదైరా#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#రెక్జావిక్#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#దక్షిణ జార్జియా#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#సెయింట్ హెలెనా#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#స్టాన్లీ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#అడెలైడ్#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#బ్రిస్‌బెయిన్#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#విరిగిన హిల్#,
		},
		'Australia/Currie' => {
			exemplarCity => q#కుర్రియే#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#డార్విన్#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#యుక్లా#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#హోబర్ట్#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#లిండేమాన్#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#లార్డ్ హౌ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#మెల్బోర్నే#,
		},
		'Australia/Perth' => {
			exemplarCity => q#పెర్త్#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#సిడ్నీ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ఆస్ట్రేలియా మధ్యమ పగటి సమయం),
				'generic' => q(ఆస్ట్రేలియా మధ్యమ సమయం),
				'standard' => q(ఆస్ట్రేలియా మధ్యమ ప్రామాణిక సమయం),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(మధ్యమ ఆస్ట్రేలియా పశ్చిమ పగటి సమయం),
				'generic' => q(మధ్యమ ఆస్ట్రేలియా పశ్చిమ సమయం),
				'standard' => q(మధ్యమ ఆస్ట్రేలియా పశ్చిమ ప్రామాణిక సమయం),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(తూర్పు ఆస్ట్రేలియా పగటి సమయం),
				'generic' => q(తూర్పు ఆస్ట్రేలియా సమయం),
				'standard' => q(తూర్పు ఆస్ట్రేలియా ప్రామాణిక సమయం),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(పశ్చిమ ఆస్ట్రేలియా పగటి సమయం),
				'generic' => q(పశ్చిమ ఆస్ట్రేలియా సమయం),
				'standard' => q(పశ్చిమ ఆస్ట్రేలియా ప్రామాణిక సమయం),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(అజర్బైజాన్ వేసవి సమయం),
				'generic' => q(అజర్బైజాన్ సమయం),
				'standard' => q(అజర్బైజాన్ ప్రామాణిక సమయం),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(అజోర్స్ వేసవి సమయం),
				'generic' => q(అజోర్స్ సమయం),
				'standard' => q(అజోర్స్ ప్రామాణిక సమయం),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(బంగ్లాదేశ్ వేసవి సమయం),
				'generic' => q(బంగ్లాదేశ్ సమయం),
				'standard' => q(బంగ్లాదేశ్ ప్రామాణిక సమయం),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(భూటాన్ సమయం),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(బొలీవియా సమయం),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(బ్రెసిలియా వేసవి సమయం),
				'generic' => q(బ్రెజిలియా సమయం),
				'standard' => q(బ్రెజీలియా ప్రామాణిక సమయం),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(బ్రూనే దరుసలామ్ సమయం),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(కేప్ వెర్డె వేసవి సమయం),
				'generic' => q(కేప్ వెర్డె సమయం),
				'standard' => q(కేప్ వెర్డె ప్రామాణిక సమయం),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(చామర్రో ప్రామాణిక సమయం),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(చాథమ్ పగటి వెలుతురు సమయం),
				'generic' => q(చాథమ్ సమయం),
				'standard' => q(చాథమ్ ప్రామాణిక సమయం),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(చిలీ వేసవి సమయం),
				'generic' => q(చిలీ సమయం),
				'standard' => q(చిలీ ప్రామాణిక సమయం),
			},
		},
		'China' => {
			long => {
				'daylight' => q(చైనా పగటి వెలుతురు సమయం),
				'generic' => q(చైనా సమయం),
				'standard' => q(చైనా ప్రామాణిక సమయం),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(చోయిబల్సాన్ వేసవి సమయం),
				'generic' => q(చోయిబల్సాన్ సమయం),
				'standard' => q(చోయిబల్సాన్ ప్రామాణిక సమయం),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(క్రిస్మస్ దీవి సమయం),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(కాకోస్ దీవుల సమయం),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(కొలంబియా వేసవి సమయం),
				'generic' => q(కొలంబియా సమయం),
				'standard' => q(కొలంబియా ప్రామాణిక సమయం),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(కుక్ దీవుల అర్థ వేసవి సమయం),
				'generic' => q(కుక్ దీవుల సమయం),
				'standard' => q(కుక్ దీవుల ప్రామాణిక సమయం),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(క్యూబా పగటి వెలుతురు సమయం),
				'generic' => q(క్యూబా సమయం),
				'standard' => q(క్యూబా ప్రామాణిక సమయం),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(డేవిస్ సమయం),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(డ్యూమాంట్-డి’ఉర్విల్లే సమయం),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(తూర్పు తైమూర్ సమయం),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ఈస్టర్ దీవి వేసవి సమయం),
				'generic' => q(ఈస్టర్ దీవి సమయం),
				'standard' => q(ఈస్టర్ దీవి ప్రామాణిక సమయం),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ఈక్వడార్ సమయం),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#తెలియని నగరం#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ఆమ్‌స్టర్‌డామ్#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#అండోరా#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ఏథెన్స్#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#బెల్‌గ్రేడ్#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#బెర్లిన్#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#బ్రటీష్‌వాలా#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#బ్రస్సెల్స్#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#బుకారెస్ట్#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#బుడాపెస్ట్#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#బసింజన్#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#చిసినావ్#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#కోపెన్హాగన్#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#డబ్లిన్#,
			long => {
				'daylight' => q(ఐరిష్ వేసవి సమయం),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#జిబ్రాల్టర్#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#గ్వెర్న్సే#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#హెల్సింకి#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ఐల్ ఆఫ్ మేన్#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ఇస్తాంబుల్#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#జెర్సీ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#కలినిన్‌గ్రద్#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#కీవ్#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#లిస్బన్#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ల్యూబ్ల్యానా#,
		},
		'Europe/London' => {
			exemplarCity => q#లండన్#,
			long => {
				'daylight' => q(బ్రిటీష్ వేసవి సమయం),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#లక్సెంబర్గ్#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#మాడ్రిడ్#,
		},
		'Europe/Malta' => {
			exemplarCity => q#మాల్టా#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#మారీయుహమ్#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#మిన్స్క్#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#మొనాకో#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#మాస్కో#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ఓస్లో#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ప్యారిస్#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#పోడ్గోరికా#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ప్రాగ్#,
		},
		'Europe/Riga' => {
			exemplarCity => q#రీగా#,
		},
		'Europe/Rome' => {
			exemplarCity => q#రోమ్#,
		},
		'Europe/Samara' => {
			exemplarCity => q#సమార#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#శాన్ మారినో#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#సరాజోవో#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#సిమ్‌ఫెరోపోల్#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#స్కోప్‌యే#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#సోఫియా#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#స్టాక్హోమ్#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#తాల్లిన్#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#టిరేన్#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ఉజుగోరోడ్#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#వాడుజ్#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#వాటికన్#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#వియన్నా#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#విల్నియస్#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#వోల్గోగ్రాడ్#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#వార్షా#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#జాగ్రెబ్#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#జపరోజై#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#జ్యూరిచ్#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(సెంట్రల్ యూరోపియన్ వేసవి సమయం),
				'generic' => q(సెంట్రల్ యూరోపియన్ సమయం),
				'standard' => q(సెంట్రల్ యూరోపియన్ ప్రామాణిక సమయం),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(తూర్పు ఐరోపా వేసవి సమయం),
				'generic' => q(తూర్పు ఐరోపా సమయం),
				'standard' => q(తూర్పు ఐరోపా ప్రామాణిక సమయం),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(పశ్చిమ యూరోపియన్ వేసవి సమయం),
				'generic' => q(పశ్చిమ యూరోపియన్ సమయం),
				'standard' => q(పశ్చిమ యూరోపియన్ ప్రామాణిక సమయం),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ఫాక్‌ల్యాండ్ దీవుల వేసవి సమయం),
				'generic' => q(ఫాక్‌ల్యాండ్ దీవుల సమయం),
				'standard' => q(ఫాక్‌ల్యాండ్ దీవుల ప్రామాణిక సమయం),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ఫిజీ వేసవి సమయం),
				'generic' => q(ఫిజీ సమయం),
				'standard' => q(ఫిజీ ప్రామాణిక సమయం),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ఫ్రెంచ్ గయానా సమయం),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ఫ్రెంచ్ దక్షిణ మరియు అంటార్కిటిక్ సమయం),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(గ్రీన్‌విచ్ సగటు సమయం),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(గాలాపాగోస్ సమయం),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(గాంబియర్ సమయం),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(జార్జియా వేసవి సమయం),
				'generic' => q(జార్జియా సమయం),
				'standard' => q(జార్జియా ప్రామాణిక సమయం),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(గిల్బర్ట్ దీవుల సమయం),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(తూర్పు గ్రీన్‌ల్యాండ్ వేసవి సమయం),
				'generic' => q(తూర్పు గ్రీన్‌ల్యాండ్ సమయం),
				'standard' => q(తూర్పు గ్రీన్‌ల్యాండ్ ప్రామాణిక సమయం),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(పశ్చిమ గ్రీన్‌ల్యాండ్ వేసవి సమయం),
				'generic' => q(పశ్చిమ గ్రీన్‌ల్యాండ్ సమయం),
				'standard' => q(పశ్చిమ గ్రీన్‌ల్యాండ్ ప్రామాణిక సమయం),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(గ్వామ్ ప్రామాణిక సమయం),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(గల్ఫ్ ప్రామాణిక సమయం),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(గయానా సమయం),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(హవాయ్-అల్యూషియన్ పగటి వెలుతురు సమయం),
				'generic' => q(హవాయ్-అలూషియన్ సమయం),
				'standard' => q(హవాయ్-అల్యూషియన్ ప్రామాణిక సమయం),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(హాంకాంగ్ వేసవి సమయం),
				'generic' => q(హాంకాంగ్ సమయం),
				'standard' => q(హాంకాంగ్ ప్రామాణిక సమయం),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(హోవ్డ్ వేసవి సమయం),
				'generic' => q(హోవ్డ్ సమయం),
				'standard' => q(హోవ్డ్ ప్రామాణిక సమయం),
			},
		},
		'India' => {
			long => {
				'standard' => q(భారతదేశ సమయం),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#అంటానానారివో#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#చాగోస్#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#క్రిస్మస్#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#కోకాస్#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#కొమోరో#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#కెర్గ్యూలెన్#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#మాహె#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#మాల్దీవులు#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#మోరిషస్#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#మయోట్టి#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#రీయూనియన్#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(హిందూ మహా సముద్ర సమయం),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ఇండోచైనా సమయం),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(సెంట్రల్ ఇండోనేషియా సమయం),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(తూర్పు ఇండోనేషియా సమయం),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(పశ్చిమ ఇండోనేషియా సమయం),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ఇరాన్ పగటి వెలుతురు సమయం),
				'generic' => q(ఇరాన్ సమయం),
				'standard' => q(ఇరాన్ ప్రామాణిక సమయం),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ఇర్కుట్స్క్ వేసవి సమయం),
				'generic' => q(ఇరక్వుట్స్క్ సమయం),
				'standard' => q(ఇర్కుట్స్క్ ప్రామాణిక సమయం),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ఇజ్రాయిల్ పగటి వెలుతురు సమయం),
				'generic' => q(ఇజ్రాయిల్ సమయం),
				'standard' => q(ఇజ్రాయిల్ ప్రామాణిక సమయం),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(జపాన్ పగటి వెలుతురు సమయం),
				'generic' => q(జపాన్ సమయం),
				'standard' => q(జపాన్ ప్రామాణిక సమయం),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి వేసవి సమయం),
				'generic' => q(పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి సమయం),
				'standard' => q(పెట్రోపావ్లోవ్స్క్-కామ్ఛాట్స్కి ప్రామాణిక సమయం),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(తూర్పు కజకి‌స్థాన్ సమయం),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(పశ్చిమ కజకిస్థాన్ సమయం),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(కొరియన్ పగటి వెలుతురు సమయం),
				'generic' => q(కొరియన్ సమయం),
				'standard' => q(కొరియన్ ప్రామాణిక సమయం),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(కోస్రాయి సమయం),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(క్రాస్నోయార్స్క్ వేసవి సమయం),
				'generic' => q(క్రస్నోయార్స్క్ సమయం),
				'standard' => q(క్రాస్నోయార్స్క్ ప్రామాణిక సమయం),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(కిర్గిస్థాన్ సమయం),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(లంకా సమయం),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(లైన్ దీవుల సమయం),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(లార్డ్ హోవ్ పగటి సమయం),
				'generic' => q(లార్డ్ హోవ్ సమయం),
				'standard' => q(లార్డ్ హోవ్ ప్రామాణిక సమయం),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(మకావ్ వేసవి సమయం),
				'generic' => q(మకావ్ సమయం),
				'standard' => q(మకావ్ ప్రామాణిక సమయం),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(మాక్క్వారీ దీవి సమయం),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(మగాడాన్ వేసవి సమయం),
				'generic' => q(మగడాన్ సమయం),
				'standard' => q(మగడాన్ ప్రామాణిక సమయం),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(మలేషియా సమయం),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(మాల్దీవుల సమయం),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(మార్క్వేసాస్ సమయం),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(మార్షల్ దీవుల సమయం),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(మారిషస్ వేసవి సమయం),
				'generic' => q(మారిషస్ సమయం),
				'standard' => q(మారిషస్ ప్రామాణిక సమయం),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(మాసన్ సమయం),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(యులాన్ బాటోర్ వేసవి సమయం),
				'generic' => q(ఉలన్ బతోర్ సమయం),
				'standard' => q(ఉలన్ బతోర్ ప్రామాణిక సమయం),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(మాస్కో వేసవి సమయం),
				'generic' => q(మాస్కో సమయం),
				'standard' => q(మాస్కో ప్రామాణిక సమయం),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(మయన్మార్ సమయం),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(నౌరు సమయం),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(నేపాల్ సమయం),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(న్యూ కాలెడోనియా వేసవి సమయం),
				'generic' => q(న్యూ కాలెడోనియా సమయం),
				'standard' => q(న్యూ కాలెడోనియా ప్రామాణిక సమయం),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(న్యూజిల్యాండ్ పగటి వెలుతురు సమయం),
				'generic' => q(న్యూజిల్యాండ్ సమయం),
				'standard' => q(న్యూజిల్యాండ్ ప్రామాణిక సమయం),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(న్యూఫౌండ్ ల్యాండ్ పగటి సమయం),
				'generic' => q(న్యూఫౌండ్ ల్యాండ్ సమయం),
				'standard' => q(న్యూఫౌండ్ ల్యాండ్ ప్రామాణిక సమయం),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(నియూ సమయం),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(నార్ఫోక్ దీవుల సమయం),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ఫెర్డినాన్డో డి నోరోన్హా పగటి సమయం),
				'generic' => q(ఫెర్నాండో డి నొరోన్హా సమయం),
				'standard' => q(ఫెర్నాండో డి నొరోన్హా ప్రామాణిక సమయం),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(ఉత్తర మారియానా దీవుల సమయం),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(నోవోసిబిర్స్క్ వేసవి సమయం),
				'generic' => q(నోవోసిబిర్స్క్ సమయం),
				'standard' => q(నోవోసిబిర్క్స్ ప్రామాణిక సమయం),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ఓమ్స్క్ వేసవి సమయం),
				'generic' => q(ఓమ్స్క్ సమయం),
				'standard' => q(ఓమ్స్క్ ప్రామాణిక సమయం),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ఏపియా#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ఆక్లాండ్#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ఛతం#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ఈస్టర్#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ఇఫేట్#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ఎండర్బెరీ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ఫాకావ్ఫో#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ఫీజీ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ఫునాఫుటి#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#గాలాపాగోస్#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#గాంబియేర్#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#గ్వాడల్కెనాల్#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#గ్వామ్#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#హోనోలులు#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#జాన్సటన్#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#కిరీటిమాటి#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#కోస్రే#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#క్వాజాలైన్#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#మజురో#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#మార్క్వేసాస్#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#మిడ్వే#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#నౌరు#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#నియూ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#నోర్ఫోక్#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#నౌమియా#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#పాగో పాగో#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#పాలావ్#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#పిట్కేరన్#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#పోన్‌పై#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#పోర్ట్ మోరెస్బే#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#రరోటోంగా#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#సాయ్పాన్#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#తహితి#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#టరావా#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#టోంగాటాపు#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#చుక్#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#వేక్#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#వాల్లిస్#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(పాకిస్థాన్ వేసవి సమయం),
				'generic' => q(పాకిస్థాన్ సమయం),
				'standard' => q(పాకిస్తాన్ ప్రామాణిక సమయం),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(పాలావ్ సమయం),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(పాపువా న్యూ గినియా సమయం),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(పరాగ్వే వేసవి సమయం),
				'generic' => q(పరాగ్వే సమయం),
				'standard' => q(పరాగ్వే ప్రామాణిక సమయం),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(పెరు వేసవి సమయం),
				'generic' => q(పెరు సమయం),
				'standard' => q(పెరు ప్రామాణిక సమయం),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ఫిలిప్పైన్ వేసవి సమయం),
				'generic' => q(ఫిలిప్పైన్ సమయం),
				'standard' => q(ఫిలిప్పైన్ ప్రామాణిక సమయం),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ఫినిక్స్ దీవుల సమయం),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(సెంట్ పియెర్ మరియు మికెలాన్ పగటి వెలుతురు సమయం),
				'generic' => q(సెంట్ పియెర్ మరియు మికెలాన్ సమయం),
				'standard' => q(సెంట్ పియెర్ మరియు మికెలాన్ ప్రామాణిక సమయం),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(పిట్కైరన్ సమయం),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(పొనేప్ సమయం),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(కిజిలోర్డా వేసవి సమయం),
				'generic' => q(కిజిలోర్డా సమయం),
				'standard' => q(కిజిలోర్డా ప్రామాణిక సమయం),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(రీయూనియన్ సమయం),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(రొతేరా సమయం),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(సఖాలిన్ వేసవి సమయం),
				'generic' => q(సఖాలిన్ సమయం),
				'standard' => q(సఖాలిన్ ప్రామాణిక సమయం),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(సమారా వేసవి సమయం),
				'generic' => q(సమారా సమయం),
				'standard' => q(సమారా ప్రామాణిక సమయం),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(సమోవా వేసవి సమయం),
				'generic' => q(సమోవా సమయం),
				'standard' => q(సమోవా ప్రామాణిక సమయం),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(సీషెల్స్ సమయం),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(సింగపూర్ ప్రామాణిక సమయం),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(సొలొమన్ దీవుల సమయం),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(దక్షణ జార్జియా సమయం),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(సూరినామ్ సమయం),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(స్యోవా సమయం),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(తహితి సమయం),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(తైపీ పగటి వెలుతరు సమయం),
				'generic' => q(తైపీ సమయం),
				'standard' => q(తైపీ ప్రామాణిక సమయం),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(తజికిస్థాన్ సమయం),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(టోకెలావ్ సమయం),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(టాంగా వేసవి సమయం),
				'generic' => q(టాంగా సమయం),
				'standard' => q(టాంగా ప్రామాణిక సమయం),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(చక్ సమయం),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(తుర్క్మెనిస్థాన్ వేసవి సమయం),
				'generic' => q(తుర్క్మెనిస్థాన్ సమయం),
				'standard' => q(తుర్క్మెనిస్థాన్ ప్రామాణిక సమయం),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(తువాలు సమయం),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ఉరుగ్వే వేసవి సమయం),
				'generic' => q(ఉరుగ్వే సమయం),
				'standard' => q(ఉరుగ్వే ప్రామాణిక సమయం),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ఉజ్బెకిస్థాన్ వేసవి సమయం),
				'generic' => q(ఉజ్బెకిస్థాన్ సమయం),
				'standard' => q(ఉజ్బెకిస్థాన్ ప్రామాణిక సమయం),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(వనౌటు వేసవి సమయం),
				'generic' => q(వనౌటు సమయం),
				'standard' => q(వనౌటు ప్రామాణిక సమయం),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(వెనిజులా సమయం),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(వ్లాడివోస్టోక్ వేసవి సమయం),
				'generic' => q(వ్లాడివోస్టోక్ సమయం),
				'standard' => q(వ్లాడివోస్టోక్ ప్రామాణిక సమయం),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(వోల్గోగ్రాడ్ వేసవి సమయం),
				'generic' => q(వోల్గోగ్రాడ్ సమయం),
				'standard' => q(వోల్గోగ్రాడ్ ప్రామాణిక సమయం),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(వోస్టోక్ సమయం),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(వేక్ దీవి సమయం),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(వాలీస్ మరియు ఫుటునా సమయం),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(యాకుట్స్క్ వేసవి సమయం),
				'generic' => q(యాకుట్స్క్ సమయం),
				'standard' => q(యాకుట్స్క్ ప్రామాణిక సమయం),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ఏకాటెరిన్బర్గ్ వేసవి సమయం),
				'generic' => q(ఏకాటెరిన్బర్గ్ సమయం),
				'standard' => q(ఏకాటెరిన్బర్గ్ ప్రామాణిక సమయం),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
