use v6.c;
use Test;
use Date::Calendar::FrenchRevolutionary;

my @tests = (("0001-01-01", 1792,  9, 22),
             ("0002-02-02", 1793, 10, 23),
             ("0002-11-09", 1794,  7, 27),
             ("0003-03-03", 1794, 11, 23),
             ("0004-01-13", 1795, 10,  5),
             ("0004-04-04", 1795, 12, 25),
             ("0005-05-05", 1797,  1, 24),
             ("0006-06-06", 1798,  2, 24),
             ("0008-02-18", 1799, 11,  9),
             ("0009-07-08", 1801,  3, 29),
             ("0012-08-10", 1804,  4, 30),
             ("0015-09-12", 1807,  6,  1),
             ("0018-10-14", 1810,  7,  3),
             ("0021-11-16", 1813,  8,  4),
             ("0024-12-18", 1816,  9,  4),
             ("0208-04-12", 2000,  1,  1), # Y2K compatible?
             ("0209-08-22", 2001,  5, 11),
             ("1208-04-12", 3000,  1,  1),
             ("1209-04-11", 3001,  1,  1),
             ("2208-04-12", 4000,  1,  1),
             ("2209-04-12", 4001,  1,  1),
             ("3208-04-12", 5000,  1,  1),
             ("3209-04-11", 5001,  1,  1),
             ("4208-04-13", 6000,  1,  1),
             ("4209-04-13", 6001,  1,  1),
             );
plan @tests.elems;

for @tests -> $test {
  my ($str, $y, $m, $d) = $test;
  my Date $d-gr .= new(year => $y, month => $m, day => $d);
  my Date::Calendar::FrenchRevolutionary $d-fr .= new-from-date($d-gr);
  is($d-fr.gist, $str);
}

done-testing;
