#!/bin/perl

use strict;
use warnings;
use Test::More;

use Arcus::Client;

open(STDERR, '>', '/dev/null');

my %params = (
  zk_address => [ "127.0.0.1:2181" ],
  service_code => "test",
  namespace => "",
);

my $cache = Arcus::Client->new(\%params);

use constant THRESHOLD => 1024 * 1024 - 1024;

my $key         = 'big_value';
my $value       = 'x' x THRESHOLD;
my $small_value = 'x' x ( THRESHOLD - 2048 );
my $big_value   = 'x' x ( THRESHOLD + 2048 );

ok $cache->set( $key, $value ), 'Store value uncompressed';
is $cache->get($key), $value, 'Fetch';
ok !$cache->set( $key, $big_value ), 'Values greater than 1MB should be rejected by server';

my @res = $cache->set_multi(
  [ "$key-1", $small_value ],
  [ "$key-2", $big_value ],
  [ "$key-3", $small_value ]
);

is_deeply \@res, [ 1, undef, 1 ];
ok $cache->delete ("$key-1" );
ok $cache->delete( "$key-3" );
#ok $cache->delete_multi( "$key-1", "$key-3" );
done_testing;
