#############################################################
# This file was automatically generated on 2019-05-21.      #
#                                                           #
# Perl Bindings Version 2.1.22                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletAirQuality - Measures IAQ index, temperature, humidity and air pressure

=cut

package Tinkerforge::BrickletAirQuality;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Air Quality Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 297;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Air Quality Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Air Quality Bricklet';

=item CALLBACK_ALL_VALUES

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_VALUES callback.

=cut

use constant CALLBACK_ALL_VALUES => 6;

=item CALLBACK_IAQ_INDEX

This constant is used with the register_callback() subroutine to specify
the CALLBACK_IAQ_INDEX callback.

=cut

use constant CALLBACK_IAQ_INDEX => 10;

=item CALLBACK_TEMPERATURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE callback.

=cut

use constant CALLBACK_TEMPERATURE => 14;

=item CALLBACK_HUMIDITY

This constant is used with the register_callback() subroutine to specify
the CALLBACK_HUMIDITY callback.

=cut

use constant CALLBACK_HUMIDITY => 18;

=item CALLBACK_AIR_PRESSURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_AIR_PRESSURE callback.

=cut

use constant CALLBACK_AIR_PRESSURE => 22;

=item FUNCTION_GET_ALL_VALUES

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_VALUES => 1;

=item FUNCTION_SET_TEMPERATURE_OFFSET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_OFFSET => 2;

=item FUNCTION_GET_TEMPERATURE_OFFSET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_OFFSET => 3;

=item FUNCTION_SET_ALL_VALUES_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_VALUES_CALLBACK_CONFIGURATION => 4;

=item FUNCTION_GET_ALL_VALUES_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_VALUES_CALLBACK_CONFIGURATION => 5;

=item FUNCTION_GET_IAQ_INDEX

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IAQ_INDEX => 7;

=item FUNCTION_SET_IAQ_INDEX_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_IAQ_INDEX_CALLBACK_CONFIGURATION => 8;

=item FUNCTION_GET_IAQ_INDEX_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IAQ_INDEX_CALLBACK_CONFIGURATION => 9;

=item FUNCTION_GET_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE => 11;

=item FUNCTION_SET_TEMPERATURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_CALLBACK_CONFIGURATION => 12;

=item FUNCTION_GET_TEMPERATURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_CALLBACK_CONFIGURATION => 13;

=item FUNCTION_GET_HUMIDITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_HUMIDITY => 15;

=item FUNCTION_SET_HUMIDITY_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_HUMIDITY_CALLBACK_CONFIGURATION => 16;

=item FUNCTION_GET_HUMIDITY_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_HUMIDITY_CALLBACK_CONFIGURATION => 17;

=item FUNCTION_GET_AIR_PRESSURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AIR_PRESSURE => 19;

=item FUNCTION_SET_AIR_PRESSURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_AIR_PRESSURE_CALLBACK_CONFIGURATION => 20;

=item FUNCTION_GET_AIR_PRESSURE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AIR_PRESSURE_CALLBACK_CONFIGURATION => 21;

=item FUNCTION_REMOVE_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_REMOVE_CALIBRATION => 23;

=item FUNCTION_SET_BACKGROUND_CALIBRATION_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BACKGROUND_CALIBRATION_DURATION => 24;

=item FUNCTION_GET_BACKGROUND_CALIBRATION_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BACKGROUND_CALIBRATION_DURATION => 25;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant ACCURACY_UNRELIABLE => 0;
use constant ACCURACY_LOW => 1;
use constant ACCURACY_MEDIUM => 2;
use constant ACCURACY_HIGH => 3;
use constant THRESHOLD_OPTION_OFF => 'x';
use constant THRESHOLD_OPTION_OUTSIDE => 'o';
use constant THRESHOLD_OPTION_INSIDE => 'i';
use constant THRESHOLD_OPTION_SMALLER => '<';
use constant THRESHOLD_OPTION_GREATER => '>';
use constant DURATION_4_DAYS => 0;
use constant DURATION_28_DAYS => 1;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1]);

	$self->{response_expected}->{&FUNCTION_GET_ALL_VALUES} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_OFFSET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_OFFSET} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_VALUES_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_VALUES_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IAQ_INDEX} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_IAQ_INDEX_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IAQ_INDEX_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_HUMIDITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_HUMIDITY_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_HUMIDITY_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_AIR_PRESSURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_AIR_PRESSURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_AIR_PRESSURE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_REMOVE_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_BACKGROUND_CALIBRATION_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_BACKGROUND_CALIBRATION_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_ALL_VALUES} = 'l C l l l';
	$self->{callback_formats}->{&CALLBACK_IAQ_INDEX} = 'l C';
	$self->{callback_formats}->{&CALLBACK_TEMPERATURE} = 'l';
	$self->{callback_formats}->{&CALLBACK_HUMIDITY} = 'l';
	$self->{callback_formats}->{&CALLBACK_AIR_PRESSURE} = 'l';



	bless($self, $class);

	return $self;
}


=item get_all_values()

Returns all values measured by the Air Quality Bricklet. The values are
IAQ (Indoor Air Quality) Index, IAQ Index Accuracy, Temperature, Humidity and
Air Pressure.

.. image:: /Images/Misc/bricklet_air_quality_iaq_index.png
   :scale: 100 %
   :alt: Air Quality Index description
   :align: center
   :target: ../../_images/Misc/bricklet_air_quality_iaq_index.png

The values have these ranges and units:

* IAQ Index: 0 to 500, higher value means greater level of air pollution
* IAQ Index Accuracy: 0 = unreliable to 3 = high
* Temperature: in steps of 0.01 °C
* Humidity: in steps of 0.01 %RH
* Air Pressure: in steps of 0.01 mbar

=cut

sub get_all_values
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_VALUES, [], '', 'l C l l l');
}

=item set_temperature_offset()

Sets a temperature offset with resolution 1/100°C. A offset of 10 will decrease
the measured temperature by 0.1°C.

If you install this Bricklet into an enclosure and you want to measure the ambient
temperature, you may have to decrease the measured temperature by some value to
compensate for the error because of the heating inside of the enclosure.

We recommend that you leave the parts in the enclosure running for at least
24 hours such that a temperature equilibrium can be reached. After that you can measure
the temperature directly outside of enclosure and set the difference as offset.

This temperature offset is used to calculate the relative humidity and
IAQ index measurements. In case the Bricklet is installed in an enclosure, we
recommend to measure and set the temperature offset to imporve the accuracy of
the measurements.

=cut

sub set_temperature_offset
{
	my ($self, $offset) = @_;

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_OFFSET, [$offset], 'l', '');
}

=item get_temperature_offset()

Returns the temperature offset as set by
:func:`Set Temperature Offset`.

=cut

sub get_temperature_offset
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_OFFSET, [], '', 'l');
}

=item set_all_values_callback_configuration()

The period in ms is the period with which the :cb:`All Values`
callback is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after at least one of the values has changed. If the values didn't
change within the period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_all_values_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_VALUES_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_all_values_callback_configuration()

Returns the callback configuration as set by
:func:`Set All Values Callback Configuration`.

=cut

sub get_all_values_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_VALUES_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_iaq_index()

Returns the IAQ index and accuracy. The IAQ index goes from
0 to 500. The higher the IAQ index, the greater the level of air pollution.

.. image:: /Images/Misc/bricklet_air_quality_iaq_index.png
   :scale: 100 %
   :alt: IAQ index description
   :align: center
   :target: ../../_images/Misc/bricklet_air_quality_iaq_index.png

If you want to get the value periodically, it is recommended to use the
:cb:`IAQ Index` callback. You can set the callback configuration
with :func:`Set IAQ Index Callback Configuration`.

=cut

sub get_iaq_index
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IAQ_INDEX, [], '', 'l C');
}

=item set_iaq_index_callback_configuration()

The period in ms is the period with which the :cb:`IAQ Index`
callback is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after at least one of the values has changed. If the values didn't
change within the period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_iaq_index_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_IAQ_INDEX_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_iaq_index_callback_configuration()

Returns the callback configuration as set by
:func:`Set IAQ Index Callback Configuration`.

=cut

sub get_iaq_index_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IAQ_INDEX_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item get_temperature()

Returns temperature in steps of 0.01 °C.


If you want to get the value periodically, it is recommended to use the
:cb:`Temperature` callback. You can set the callback configuration
with :func:`Set Temperature Callback Configuration`.

=cut

sub get_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE, [], '', 'l');
}

=item set_temperature_callback_configuration()

The period in ms is the period with which the :cb:`Temperature` callback is triggered
periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change
within the period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

It is furthermore possible to constrain the callback with thresholds.

The `option`-parameter together with min/max sets a threshold for the :cb:`Temperature` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Threshold is turned off"
 "'o'",    "Threshold is triggered when the value is *outside* the min and max values"
 "'i'",    "Threshold is triggered when the value is *inside* or equal to the min and max values"
 "'<'",    "Threshold is triggered when the value is smaller than the min value (max is ignored)"
 "'>'",    "Threshold is triggered when the value is greater than the min value (max is ignored)"

If the option is set to 'x' (threshold turned off) the callback is triggered with the fixed period.

The default value is (0, false, 'x', 0, 0).

=cut

sub set_temperature_callback_configuration
{
	my ($self, $period, $value_has_to_change, $option, $min, $max) = @_;

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_CALLBACK_CONFIGURATION, [$period, $value_has_to_change, $option, $min, $max], 'L ? a l l', '');
}

=item get_temperature_callback_configuration()

Returns the callback configuration as set by :func:`Set Temperature Callback Configuration`.

=cut

sub get_temperature_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_CALLBACK_CONFIGURATION, [], '', 'L ? a l l');
}

=item get_humidity()

Returns relative humidity in steps of 0.01 %RH.


If you want to get the value periodically, it is recommended to use the
:cb:`Humidity` callback. You can set the callback configuration
with :func:`Set Humidity Callback Configuration`.

=cut

sub get_humidity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_HUMIDITY, [], '', 'l');
}

=item set_humidity_callback_configuration()

The period in ms is the period with which the :cb:`Humidity` callback is triggered
periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change
within the period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

It is furthermore possible to constrain the callback with thresholds.

The `option`-parameter together with min/max sets a threshold for the :cb:`Humidity` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Threshold is turned off"
 "'o'",    "Threshold is triggered when the value is *outside* the min and max values"
 "'i'",    "Threshold is triggered when the value is *inside* or equal to the min and max values"
 "'<'",    "Threshold is triggered when the value is smaller than the min value (max is ignored)"
 "'>'",    "Threshold is triggered when the value is greater than the min value (max is ignored)"

If the option is set to 'x' (threshold turned off) the callback is triggered with the fixed period.

The default value is (0, false, 'x', 0, 0).

=cut

sub set_humidity_callback_configuration
{
	my ($self, $period, $value_has_to_change, $option, $min, $max) = @_;

	$self->_send_request(&FUNCTION_SET_HUMIDITY_CALLBACK_CONFIGURATION, [$period, $value_has_to_change, $option, $min, $max], 'L ? a l l', '');
}

=item get_humidity_callback_configuration()

Returns the callback configuration as set by :func:`Set Humidity Callback Configuration`.

=cut

sub get_humidity_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_HUMIDITY_CALLBACK_CONFIGURATION, [], '', 'L ? a l l');
}

=item get_air_pressure()

Returns air pressure in steps of 0.01 mbar.


If you want to get the value periodically, it is recommended to use the
:cb:`Air Pressure` callback. You can set the callback configuration
with :func:`Set Air Pressure Callback Configuration`.

=cut

sub get_air_pressure
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_AIR_PRESSURE, [], '', 'l');
}

=item set_air_pressure_callback_configuration()

The period in ms is the period with which the :cb:`Air Pressure` callback is triggered
periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change
within the period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

It is furthermore possible to constrain the callback with thresholds.

The `option`-parameter together with min/max sets a threshold for the :cb:`Air Pressure` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Threshold is turned off"
 "'o'",    "Threshold is triggered when the value is *outside* the min and max values"
 "'i'",    "Threshold is triggered when the value is *inside* or equal to the min and max values"
 "'<'",    "Threshold is triggered when the value is smaller than the min value (max is ignored)"
 "'>'",    "Threshold is triggered when the value is greater than the min value (max is ignored)"

If the option is set to 'x' (threshold turned off) the callback is triggered with the fixed period.

The default value is (0, false, 'x', 0, 0).

=cut

sub set_air_pressure_callback_configuration
{
	my ($self, $period, $value_has_to_change, $option, $min, $max) = @_;

	$self->_send_request(&FUNCTION_SET_AIR_PRESSURE_CALLBACK_CONFIGURATION, [$period, $value_has_to_change, $option, $min, $max], 'L ? a l l', '');
}

=item get_air_pressure_callback_configuration()

Returns the callback configuration as set by :func:`Set Air Pressure Callback Configuration`.

=cut

sub get_air_pressure_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_AIR_PRESSURE_CALLBACK_CONFIGURATION, [], '', 'L ? a l l');
}

=item remove_calibration()

Deletes the calibration from flash. After you call this function,
you need to power cycle the Air Quality Bricklet.

On the next power up the Bricklet will start a new calibration, as
if it was started for the very first time.

The calibration is based on the data of the last four days, so it takes
four days until a full calibration is re-established.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub remove_calibration
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_REMOVE_CALIBRATION, [], '', '');
}

=item set_background_calibration_duration()

The Air Quality Bricklet uses an automatic background calibration mechanism to
calculate the IAQ Index. This calibration mechanism considers a history of
measured data. The duration of this history can be configured to either be
4 days or 28 days.

If you keep the Bricklet mostly at one place and it does not get moved around
to different environments, we recommend that you use a duration of 28 days.

If you change the duration, the current calibration will be discarded and
the calibration will start from beginning again. The configuration of the
duration is saved in flash, so you should only have to call this function
once in the lifetime of the Bricklet.

The Bricklet has to be power cycled after this function is called 
for a duration change to take effect.

Before firmware version 2.0.3 this was not configurable and the duration was
4 days.

The default value (since firmware version 2.0.3) is 28 days.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub set_background_calibration_duration
{
	my ($self, $duration) = @_;

	$self->_send_request(&FUNCTION_SET_BACKGROUND_CALIBRATION_DURATION, [$duration], 'C', '');
}

=item get_background_calibration_duration()

Returns the background calibration duration as set by 
:func:`Set Background Calibration Duration`.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub get_background_calibration_duration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BACKGROUND_CALIBRATION_DURATION, [], '', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
