#!/usr/bin/perl -w

# $Id: pod_merge.PL,v 1.1.1.1 2002/01/24 12:26:38 m_ilya Exp $

use 5.006;

use strict;

use File::Find;
use File::Spec;

require 't/utils.pl';

my ($sourcedir, $in_file, $out_file) = @ARGV;

my $plugin_dir = File::Spec->catdir($sourcedir, qw(HTTP WebTest Plugin));

# get list of plugins
my @plugins = (File::Spec->catfile($sourcedir, qw(HTTP WebTest ReportPlugin.pm)));
find({ no_chdir => 1,
       wanted   => sub {
	   return unless -f and /\.pm$/;
	   push @plugins, $_;
       } },
    $plugin_dir);
# this is not a plugin but we need its TEST PARAMETERS section anyway
push @plugins, File::Spec->catfile($sourcedir, qw(HTTP WebTest.pm.in));

my $merged_data = <<WARNING;
# WARNING: This file is autogenerated from following files:
#
WARNING

for my $file (sort $in_file, @plugins) {
    $merged_data .= <<WARNING;
#            $file
WARNING
}

$merged_data .= <<WARNING;
#
# Do not modify this file but edit those files. All changes in this
# file will be lost.


WARNING

$merged_data .= read_file($in_file);

# strip CVS ID mark - it caused some minor pain for me
$merged_data =~ s/\n# \$Id.*//;

# find all TEST PARAMETERS sections
my %sections = ();
$sections{params} = '';
for my $plugin (@plugins) {
    $sections{params} .= file_scan($plugin, 'params');
}

# sort content of sections
my @sections = map "=head2$_", grep /\S/, split '=head2', $sections{params};
@sections = map $_->[1],
            sort { $a->[0] cmp $b->[0] }
            map { my($name) = $_ =~ /=head2\s+([a-z_]+)/; [ $name => $_ ] }
            @sections;
$sections{params} = join '', @sections;

# find Apache Directory and Files section
my $apache_pm = File::Spec->catfile($sourcedir, qw(HTTP WebTest Plugin Apache.pm));
$sections{apache} = file_scan($apache_pm, 'apache');

# replace sections in out file
for my $type (qw(params apache)) {
    my $regex = section_replace_re($type);
    $merged_data =~ s/$regex/$sections{$type}/xs;
}

write_file($out_file, $merged_data);

# retrieves section of specified type from file
sub file_scan {
    my $file = shift;
    my $type = shift;

    my $data = read_file($file);

    my $regex = section_copy_re($type);
    my @sections = $data =~ /$regex/g;

    return join '', @sections;
}

# returns regexps which gets content between =for pod_merge copy
# and =cut
sub section_copy_re {
    my $type = shift;
    my $regex = qr/\n
                   =for\ pod_merge\ copy\ \Q$type\E
                   (.*?) # content of the section
                   \n =cut  # find the end of section
                  /sx;

    return $regex;
}

# returns regexp used to replace everthing between =for pod_merge
# replace and =cut
sub section_replace_re {
    my $type = shift;
    my $regex = qr/(?<= \n)
                   =for\ pod_merge\ replace\ \Q$type\E
                   (?: .*?)  # content of the section
                   (?= \n =cut) # find the end of section
                  /sx;

    return $regex;
}
