#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More 0.82;

eval 'use Map::Tube::London';
plan skip_all => 'Map::Tube::London required for this test' if $@;

plan tests => 23;

my $tube = Map::Tube::London->new();

my $ret;

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines' );
is( $ret, 'Bakerloo', 'Finding Bakerloo exactly (up to case)' );

$ret = $tube->fuzzy_find( 'BAKERLOO', objects => 'lines' );
is( $ret, 'Bakerloo', 'Finding Bakerloo exactly (all caps)' );

$ret = $tube->fuzzy_find( 'Waterloo', objects => 'lines' );
is( $ret, undef, 'Finding Waterloo exactly should fail' );

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines', method => 'start' );
is( $ret, 'Bakerloo', 'Finding Bakerloo at start' );

$ret = $tube->fuzzy_find( 'Waterloo', objects => 'lines', method => 'start' );
is( $ret, 'Waterloo & City', 'Finding Waterloo at start' );

$ret = $tube->fuzzy_find( 'kerloo', objects => 'lines', method => 'start' );
is( $ret, undef, 'Finding kerloo at start should fail' );

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines', method => 'in' );
is( $ret, 'Bakerloo', 'Finding Bakerloo somewhere' );

$ret = $tube->fuzzy_find( 'Waterloo', objects => 'lines', method => 'in' );
is( $ret, 'Waterloo & City', 'Finding Waterloo somewhere' );

$ret = $tube->fuzzy_find( 'kerloo', objects => 'lines', method => 'in' );
is( $ret, 'Bakerloo', 'Finding kerloo somewhere' );

$ret = $tube->fuzzy_find( 'xerloo', objects => 'lines', method => 'in' );
is( $ret, undef, 'Finding xerloo somewhere should fail' );

$ret = $tube->fuzzy_find( '[kx]erloo', objects => 'lines', method => 're' );
is( $ret, 'Bakerloo', 'Finding regex [kx]erloo' );

$ret = $tube->fuzzy_find( '[tx]erloo', objects => 'lines', method => 're' );
is( $ret, 'Waterloo & City', 'Finding regex [tx]erloo' );

$ret = $tube->fuzzy_find( '[ktx]erloo', objects => 'lines', method => 're' );
is( $ret, 'Bakerloo', 'Finding regex [ktx]erloo' );

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines', method => 'levenshtein' );
is( $ret, 'Bakerloo', 'Finding Bakerloo fuzzy' );

$ret = $tube->fuzzy_find( 'Packalu',, objects => 'lines', method => 'levenshtein', maxdist => 6 );
is( $ret, 'Bakerloo', 'Finding Packalu fuzzy with distance 6' );

$ret = $tube->fuzzy_find( 'Packalu', objects => 'lines', method => 'levenshtein' );
is( $ret, undef, 'Finding Packalu fuzzy with standard distance should fail' );

$ret = $tube->fuzzy_find( 'Packalu',, objects => 'lines', method => 'levenshtein', maxdist => 5 );
is( $ret, undef, 'Finding Packalu fuzzy with distance 5 should fail' );

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines', method => 'soundex' );
is( $ret, 'Bakerloo', 'Finding Bakerloo based on soundex' );

$ret = $tube->fuzzy_find( 'Bkrl', objects => 'lines', method => 'soundex' );
is( $ret, 'Bakerloo', 'Finding Bkrl based on soundex' );

$ret = $tube->fuzzy_find( 'Bxqxq', objects => 'lines', method => 'soundex' );
is( $ret, undef, 'Finding Bxqxq based on soundex should fail' );

$ret = $tube->fuzzy_find( 'Bakerloo', objects => 'lines', method => 'metaphone' );
is( $ret, 'Bakerloo', 'Finding Bakerloo based on metaphone' );

$ret = $tube->fuzzy_find( 'Bkrl', objects => 'lines', method => 'metaphone' );
is( $ret, 'Bakerloo', 'Finding Bkrl based on metaphone' );

$ret = $tube->fuzzy_find( 'Bxqxq', objects => 'lines', method => 'metaphone' );
is( $ret, undef, 'Finding Bxqxq based on metaphone' );

