#!/usr/bin/perl

use Test::Simple tests => 4;
use Graph::SocialMap;
use Graph::Writer::GraphViz;
use IO::All;
use YAML;

my $relation = {
    1357 => [qw/Marry Rose Autrijus/],
    3579 => [qw/Marry Peacock/],
    2468 => [qw/Joan/],
    4680 => [qw/Rose Joan/],
    OSSF => [qw/Gugod Autrijus/],
    GGYY => [qw/Gugod Autrijus Joan Peacock/],
    1234 => [qw/Tifa Dora Charlee Angie/],
    5555 => [qw/A B C D E F G H I J K/],
};

my $gsm = sm(-relation => $relation);
my $writer = Graph::Writer::GraphViz->new(-format=>'dot');
$writer->write_graph($gsm->type2,'t/graphtest1.dot');

my $tmp = io('t/graphtest1.dot');
my $d2 = $tmp->slurp;
my $d1;
{
    local $/ = undef;
    $d1 = <DATA>;
}
ok($d1 eq $d2);
$tmp->unlink;

ok($gsm->dos('Marry','Autrijus') == 1);

my $alldos = $gsm->all_dos;
ok($alldos->{Marry}->{Autrijus} == 1);
ok($alldos->{Marry}->{Joan} == 2);

__DATA__
digraph test {
	node [label="\N", color=black];
	edge [color=black];
	graph [bb="0,0,1976,948"];
	A [label=A, pos="633,788", width="0.75", height="0.50"];
	Angie [label=Angie, pos="1579,788", width="0.94", height="0.50"];
	Autrijus [label=Autrijus, pos="1841,788", width="1.17", height="0.50"];
	B [label=B, pos="835,716", width="0.75", height="0.50"];
	C [label=C, pos="735,68", width="0.75", height="0.50"];
	Charlee [label=Charlee, pos="1503,716", width="1.08", height="0.50"];
	D [label=D, pos="691,140", width="0.75", height="0.50"];
	Dora [label=Dora, pos="1570,572", width="0.83", height="0.50"];
	E [label=E, pos="899,212", width="0.75", height="0.50"];
	F [label=F, pos="543,284", width="0.75", height="0.50"];
	G [label=G, pos="811,356", width="0.75", height="0.50"];
	Gugod [label=Gugod, pos="1768,716", width="1.00", height="0.50"];
	H [label=H, pos="411,428", width="0.75", height="0.50"];
	I [label=I, pos="699,500", width="0.75", height="0.50"];
	J [label=J, pos="859,572", width="0.75", height="0.50"];
	Joan [label=Joan, pos="1775,428", width="0.81", height="0.50"];
	K [label=K, pos="515,644", width="0.75", height="0.50"];
	Marry [label=Marry, pos="1880,572", width="0.97", height="0.50"];
	Peacock [label=Peacock, pos="1824,644", width="1.11", height="0.50"];
	Rose [label=Rose, pos="1880,500", width="0.81", height="0.50"];
	Tifa [label=Tifa, pos="1570,644", width="0.75", height="0.50"];
	A -> B [pos="e,810,723 656,778 691,764 759,740 800,726"];
	A -> C [pos="e,708,68 606,787 591,787 573,787 557,786 545,785 541,785 528,784 427,775 159,786 71,734 30,708 10,692 10,644 10,644 10,644 10,21\
2 10,145 71,153 129,122 190,89 208,81 275,70 281,68 589,68 698,68"];
	A -> D [pos="e,664,140 606,787 593,787 578,787 565,786 533,783 525,781 493,778 296,754 66,842 66,644 66,644 66,644 66,428 66,217 286,281 477,\
194 543,163 560,151 631,142 635,141 644,141 654,140"];
	A -> E [pos="e,921,223 660,786 708,780 721,778 770,770 914,745 1418,790 1418,644 1418,644 1418,644 1418,500 1418,281 1220,265 1004,234 987,23\
1 945,236 930,230 930,230 929,230 929,230"];
	A -> F [pos="e,516,284 606,787 547,783 407,770 297,734 215,706 122,731 122,644 122,644 122,644 122,500 122,334 292,377 443,310 467,299 472,29\
2 497,286 499,285 502,285 506,285"];
	A -> G [pos="e,833,366 660,784 749,772 790,793 862,734 888,711 884,695 894,662 928,555 938,502 875,410 862,391 855,381 842,371"];
	A -> H [pos="e,387,436 606,786 458,744 290,797 290,644 290,644 290,644 290,572 290,501 323,478 378,442"];
	A -> I [pos="e,691,518 634,770 641,721 671,586 688,528"];
	A -> J [pos="e,833,578 650,774 666,764 688,749 705,734 770,676 762,628 825,584"];
	A -> K [pos="e,525,661 617,773 593,749 553,700 531,669"];
	Angie -> Charlee [pos="e,1516,733 1558,773 1547,763 1534,751 1523,740"];
	Angie -> Dora [pos="e,1577,589 1582,770 1591,740 1612,676 1597,626 1594,616 1588,606 1583,597"];
	Angie -> Tifa [pos="e,1566,662 1573,770 1569,745 1566,701 1566,672"];
	Autrijus -> Gugod [pos="e,1780,733 1819,772 1809,763 1797,751 1787,740"];
	Autrijus -> Joan [pos="e,1751,439 1801,783 1760,771 1743,767 1714,734 1686,701 1682,686 1682,644 1682,644 1682,644 1682,572 1682,508 1701,483 1743,446"];
	Autrijus -> Marry [pos="e,1873,590 1840,770 1845,746 1857,701 1864,662 1867,641 1869,618 1872,600"];
	Autrijus -> Peacock [pos="e,1822,662 1834,770 1829,745 1823,701 1822,672"];
	Autrijus -> Rose [pos="e,1891,517 1849,770 1856,760 1866,747 1873,734 1902,674 1905,655 1915,590 1917,574 1920,569 1915,554 1911,543 1905,533 1898,525"];
	B -> A [pos="e,658,781 812,726 777,739 709,763 668,778"];
	B -> C [pos="e,762,68 862,716 948,714 1213,705 1286,662 1401,594 1474,561 1474,428 1474,428 1474,428 1474,212 1474,127 1382,160 1307,122 1257\
,96 1247,79 1193,70 1187,68 881,68 772,68"];
	B -> D [pos="e,718,142 860,709 975,676 1446,536 1313,338 1211,185 1102,245 926,194 838,168 814,157 728,144"];
	B -> E [pos="e,926,214 862,714 945,708 1193,689 1217,662 1264,607 1469,948 1160,338 1118,255 1070,257 982,230 961,223 954,219 936,216"];
	B -> F [pos="e,535,301 809,711 808,711 808,710 807,710 787,688 781,684 761,662 679,569 651,550 584,446 552,394 546,375 537,311"];
	B -> G [pos="e,818,373 841,698 847,688 856,675 862,662 884,617 893,602 886,554 877,487 872,469 842,410 836,397 831,389 825,381"];
	B -> H [pos="e,417,446 808,713 760,704 643,687 603,662 517,608 447,504 422,455"];
	B -> I [pos="e,703,518 816,703 770,642 726,567 707,527"];
	B -> J [pos="e,851,590 833,698 835,673 842,628 849,600"];
	B -> K [pos="e,534,657 808,713 756,707 641,691 547,662 546,662 545,661 543,661"];
	C -> A [pos="e,606,787 708,68 612,68 299,68 293,70 226,81 208,89 147,122 89,153 28,145 28,212 28,644 28,644 28,644 28,692 48,708 89,734 177,7\
86 445,775 546,784 559,785 563,785 575,786 582,786 589,786 596,787"];
	C -> B [pos="e,862,716 762,68 862,68 1205,68 1211,70 1265,79 1275,96 1325,122 1400,160 1492,127 1492,212 1492,428 1492,428 1492,428 1492,561 \
1419,594 1304,662 1232,704 970,713 872,716"];
	C -> D [pos="e,706,125 730,86 725,95 718,107 712,117"];
	C -> E [pos="e,889,195 757,79 773,90 794,106 811,122 836,143 864,169 882,188"];
	C -> F [pos="e,557,268 710,76 652,104 644,135 603,194 588,215 574,241 563,259"];
	C -> G [pos="e,810,338 743,85 760,133 796,269 808,328"];
	C -> H [pos="e,388,418 708,70 500,107 252,0 252,212 252,284 252,284 252,284 252,351 332,394 379,414"];
	C -> I [pos="e,726,498 762,69 763,69 764,70 765,70 921,109 1100,50 1100,212 1100,356 1100,356 1100,356 1100,529 908,460 736,496"];
	C -> J [pos="e,886,570 762,68 823,69 964,70 986,74 1145,101 1324,50 1324,212 1324,284 1324,284 1324,284 1324,458 1167,444 1009,518 957,541 94\
4,553 896,567"];
	C -> K [pos="e,488,643 708,68 613,68 308,68 305,70 215,103 140,115 140,212 140,284 140,284 140,284 140,456 251,473 378,590 414,622 429,634 47\
8,642"];
	Charlee -> Angie [pos="e,1567,771 1524,731 1535,741 1549,753 1560,764"];
	Charlee -> Dora [pos="e,1545,582 1501,698 1504,679 1514,650 1525,626 1531,610 1533,599 1539,590"];
	Charlee -> Tifa [pos="e,1552,658 1513,699 1522,688 1534,675 1545,665"];
	D -> A [pos="e,606,787 664,141 658,141 652,141 649,142 578,151 561,163 495,194 304,281 84,217 84,428 84,644 84,644 84,644 84,842 314,754 511,\
778 543,781 551,783 583,786 587,786 592,786 596,787"];
	D -> B [pos="e,861,710 718,140 725,141 731,141 734,142 830,156 852,167 944,194 1120,245 1229,185 1331,338 1463,534 1004,674 871,708"];
	D -> C [pos="e,720,83 696,122 701,113 708,102 714,92"];
	D -> E [pos="e,880,199 717,146 752,155 815,174 867,194 868,195 869,195 871,195"];
	D -> F [pos="e,561,270 679,156 654,183 600,235 569,263"];
	D -> G [pos="e,799,340 701,157 713,188 733,254 765,302 773,313 783,324 792,333"];
	D -> H [pos="e,425,412 665,146 637,158 631,171 603,194 564,224 551,229 516,266 490,294 486,304 465,338 453,359 440,385 430,403"];
	D -> I [pos="e,702,482 695,158 701,216 705,401 702,472"];
	D -> J [pos="e,870,555 710,153 746,182 822,257 856,338 888,412 884,437 877,518 876,527 875,537 873,545"];
	D -> K [pos="e,488,642 664,142 664,142 663,142 663,142 609,155 594,161 549,194 449,267 411,292 369,410 342,487 354,528 407,590 434,619 446,63\
1 478,640"];
	Dora -> Angie [pos="e,1592,771 1590,586 1600,596 1610,611 1615,626 1630,672 1612,729 1597,762"];
	Dora -> Charlee [pos="e,1514,699 1558,588 1551,598 1550,609 1543,626 1534,646 1525,671 1518,690"];
	Dora -> Tifa [pos="e,1576,626 1576,590 1577,598 1577,607 1577,616"];
	E -> A [pos="e,660,787 926,213 927,214 927,214 928,214 929,214 930,214 932,216 939,221 939,226 948,230 963,236 1005,231 1022,234 1238,265 143\
6,281 1436,500 1436,644 1436,644 1436,644 1436,790 932,745 788,770 738,778 725,780 674,786 673,786 671,786 670,786"];
	E -> B [pos="e,862,715 926,212 934,213 941,213 945,214 970,218 975,222 1000,230 1088,257 1136,255 1178,338 1487,948 1282,607 1235,662 1212,68\
9 967,708 872,714"];
	E -> C [pos="e,748,84 880,199 859,181 824,148 793,122 781,111 768,99 756,90"];
	E -> D [pos="e,715,149 874,204 866,201 857,197 849,194 807,178 757,162 725,152"];
	E -> F [pos="e,568,276 872,215 819,221 697,237 597,266 591,267 584,270 577,272"];
	E -> G [pos="e,825,340 893,230 879,255 851,303 831,332"];
	E -> H [pos="e,435,420 873,218 684,269 640,313 457,406 451,409 447,412 443,414"];
	E -> I [pos="e,725,494 902,230 900,261 885,326 856,374 834,411 822,416 788,446 764,466 756,477 734,489"];
	E -> J [pos="e,881,561 923,221 994,250 1191,349 1123,446 1095,485 1064,461 1021,482 996,493 930,534 890,556"];
	E -> K [pos="e,542,643 926,213 932,213 936,213 939,214 998,227 1014,233 1065,266 1139,314 1195,369 1151,446 1087,556 1023,548 904,590 757,641\
 711,625 552,642"];
	F -> A [pos="e,606,786 516,286 516,286 515,286 515,286 490,292 485,299 461,310 310,377 140,334 140,500 140,644 140,644 140,644 140,731 233,70\
6 315,734 413,766 535,779 596,785"];
	F -> B [pos="e,818,702 553,301 553,304 554,307 554,310 564,373 568,391 602,446 669,550 697,569 779,662 793,678 800,685 811,695"];
	F -> C [pos="e,708,69 545,266 552,247 569,217 585,194 627,134 634,103 699,73"];
	F -> D [pos="e,673,154 555,268 580,241 633,190 665,161"];
	F -> E [pos="e,872,214 563,271 568,269 574,267 579,266 679,237 801,222 862,215"];
	F -> G [pos="e,792,343 570,288 614,295 705,313 779,338 780,338 781,339 783,339"];
	F -> H [pos="e,428,414 532,301 511,327 464,378 435,407"];
	F -> I [pos="e,681,487 553,301 567,332 591,400 629,446 641,460 658,472 672,481"];
	F -> J [pos="e,842,557 560,298 613,345 768,495 834,550"];
	F -> K [pos="e,490,638 517,290 447,319 417,336 384,410 350,485 386,522 434,590 451,614 461,623 481,634"];
	G -> A [pos="e,660,786 838,360 867,373 875,382 893,410 956,502 946,555 912,662 902,695 906,711 880,734 807,794 766,772 670,785"];
	G -> B [pos="e,853,702 831,368 844,381 850,389 860,410 890,469 895,487 904,554 911,602 902,617 880,662 875,673 867,684 860,694"];
	G -> C [pos="e,736,86 803,338 786,290 750,155 738,96"];
	G -> D [pos="e,690,158 790,345 776,335 759,319 747,302 718,259 699,202 692,168"];
	G -> E [pos="e,885,228 817,338 831,313 860,265 879,236"];
	G -> F [pos="e,569,290 787,348 779,345 769,341 761,338 698,317 623,301 579,292"];
	G -> H [pos="e,435,420 784,360 714,368 523,392 461,410 456,411 450,413 444,416"];
	G -> I [pos="e,715,485 802,373 785,400 746,449 722,477"];
	G -> J [pos="e,859,554 819,374 830,411 850,499 857,544"];
	G -> K [pos="e,531,629 786,363 681,413 671,461 589,554 570,576 552,603 537,621"];
	Gugod -> Autrijus [pos="e,1829,771 1789,731 1800,740 1812,752 1822,763"];
	Gugod -> Joan [pos="e,1771,446 1765,698 1762,649 1765,515 1770,456"];
	Gugod -> Peacock [pos="e,1806,660 1776,698 1782,689 1790,678 1799,668"];
	H -> A [pos="e,608,781 395,442 341,478 308,501 308,572 308,644 308,644 308,644 308,789 456,750 598,779"];
	H -> B [pos="e,809,710 424,444 454,486 527,603 621,662 655,683 744,699 799,708"];
	H -> C [pos="e,708,68 386,421 337,405 234,361 234,284 234,284 234,284 234,212 234,0 482,107 690,70 692,69 694,69 698,69"];
	H -> D [pos="e,664,141 413,410 419,391 433,362 447,338 468,304 472,294 498,266 533,229 546,224 585,194 614,171 619,157 654,144"];
	H -> E [pos="e,872,213 427,413 430,411 434,409 439,406 624,313 667,268 862,216"];
	H -> F [pos="e,526,298 422,411 443,384 490,334 519,305"];
	H -> G [pos="e,784,359 430,415 434,413 439,411 443,410 504,392 693,369 774,360"];
	H -> I [pos="e,674,493 437,434 489,445 606,474 664,490"];
	H -> J [pos="e,833,568 435,437 497,461 667,532 823,566"];
	H -> K [pos="e,497,630 416,446 420,477 424,543 453,590 462,604 476,616 489,624"];
	I -> A [pos="e,640,770 698,518 691,567 660,702 643,760"];
	I -> B [pos="e,830,698 712,516 733,549 777,625 824,690"];
	I -> C [pos="e,761,73 725,495 894,461 1082,527 1082,356 1082,356 1082,356 1082,212 1082,58 921,104 771,75"];
	I -> D [pos="e,688,158 695,482 689,424 685,239 688,168"];
	I -> E [pos="e,891,230 719,488 739,476 747,466 770,446 804,416 816,411 838,374 865,331 879,274 888,240"];
	I -> F [pos="e,543,302 675,492 655,482 629,466 611,446 577,405 554,346 545,312"];
	I -> G [pos="e,795,371 708,483 725,457 764,408 788,379"];
	I -> H [pos="e,436,435 673,494 621,483 504,454 446,438"];
	I -> J [pos="e,838,560 723,509 751,521 798,541 829,556"];
	I -> K [pos="e,535,631 684,515 652,542 583,597 543,625"];
	J -> A [pos="e,656,779 841,585 780,629 787,677 723,734 706,749 684,764 665,774"];
	J -> B [pos="e,842,699 861,590 859,615 852,660 845,689"];
	J -> C [pos="e,762,68 884,565 927,551 942,540 991,518 1149,444 1306,458 1306,284 1306,284 1306,284 1306,212 1306,50 1127,101 968,74 949,70 83\
3,69 772,68"];
	J -> D [pos="e,704,156 855,554 856,544 858,530 859,518 866,437 870,412 838,338 808,265 744,198 711,163"];
	J -> E [pos="e,921,223 876,558 908,536 977,494 1003,482 1046,461 1077,485 1105,446 1168,355 1001,263 930,227"];
	J -> F [pos="e,556,300 834,565 786,530 621,369 563,308"];
	J -> G [pos="e,811,374 851,555 839,517 820,429 813,384"];
	J -> H [pos="e,432,439 832,571 829,570 827,570 826,570 677,541 510,474 441,443"];
	J -> I [pos="e,720,512 835,563 807,551 760,531 729,516"];
	J -> K [pos="e,541,639 833,578 773,591 621,623 551,637"];
	Joan -> Autrijus [pos="e,1805,779 1762,444 1719,482 1700,507 1700,572 1700,644 1700,644 1700,644 1700,686 1704,701 1732,734 1754,760 1770,767 1795,776"];
	Joan -> Gugod [pos="e,1772,698 1778,446 1781,495 1778,629 1773,688"];
	Joan -> Peacock [pos="e,1824,626 1783,446 1795,483 1815,571 1822,616"];
	Joan -> Rose [pos="e,1863,485 1797,440 1814,450 1837,467 1855,479"];
	K -> A [pos="e,624,771 531,659 554,683 595,733 618,763"];
	K -> B [pos="e,808,712 540,652 548,655 557,659 565,662 646,687 745,703 798,711"];
	K -> C [pos="e,708,68 488,643 478,643 468,642 463,642 413,635 398,624 360,590 233,473 122,456 122,284 122,284 122,284 122,212 122,115 197,103\
 287,70 290,68 591,68 698,68"];
	K -> D [pos="e,664,140 488,643 481,643 475,642 472,642 430,633 418,622 389,590 336,528 324,487 351,410 393,292 431,267 531,194 576,161 591,15\
5 645,142 647,141 650,141 654,141"];
	K -> E [pos="e,926,215 542,641 693,625 739,641 886,590 1005,548 1069,556 1133,446 1177,369 1121,314 1047,266 1000,236 983,228 936,217"];
	K -> F [pos="e,516,285 488,643 485,643 483,642 482,642 448,628 438,620 416,590 368,522 332,485 366,410 400,335 430,318 506,289"];
	K -> G [pos="e,784,357 520,626 530,607 551,577 571,554 654,461 664,413 775,361"];
	K -> H [pos="e,405,446 491,635 473,626 449,610 435,590 409,548 403,490 404,456"];
	K -> I [pos="e,679,512 530,629 561,602 631,547 671,518"];
	K -> J [pos="e,833,577 541,638 601,624 752,592 823,579"];
	Marry -> Autrijus [pos="e,1852,770 1886,590 1888,608 1886,637 1882,662 1876,696 1866,736 1856,761"];
	Marry -> Peacock [pos="e,1842,628 1872,590 1866,599 1857,610 1849,620"];
	Marry -> Rose [pos="e,1874,518 1874,554 1873,546 1873,537 1873,528"];
	Peacock -> Autrijus [pos="e,1844,770 1831,662 1836,687 1842,731 1843,760"];
	Peacock -> Gugod [pos="e,1786,700 1816,662 1810,671 1801,683 1793,692"];
	Peacock -> Joan [pos="e,1775,446 1816,626 1804,589 1784,501 1777,456"];
	Peacock -> Marry [pos="e,1862,588 1832,626 1838,617 1847,605 1855,596"];
	Rose -> Autrijus [pos="e,1863,772 1902,512 1914,522 1927,537 1933,554 1938,569 1935,574 1933,590 1923,655 1920,674 1891,734 1886,745 1878,756 1870,765"];
	Rose -> Joan [pos="e,1791,443 1858,488 1841,478 1817,461 1799,449"];
	Rose -> Marry [pos="e,1886,554 1886,518 1887,526 1887,535 1887,544"];
	Tifa -> Angie [pos="e,1583,770 1576,662 1580,686 1583,731 1583,760"];
	Tifa -> Charlee [pos="e,1523,700 1560,661 1552,671 1541,682 1530,693"];
	Tifa -> Dora [pos="e,1564,590 1564,626 1563,618 1563,609 1563,600"];
}
