package Gtk2::Gdk::Event::Key;

# $Id: Key.pm,v 1.3 2002/11/09 16:23:15 gthyni Exp $
# Copyright 2002, Gran Thyni, kirra.net
# licensed with Lesser General Public License (LGPL)
# see http://www.fsf.org/licenses/lgpl.txt

our $rcsid = '$Id: Key.pm,v 1.3 2002/11/09 16:23:15 gthyni Exp $';
our $VERSION = $1 if $rcsid =~ /(\d+\.[\d\.]+)/;

BEGIN { do 'Gtk2/_config.pm'; }

use Gtk2::Gdk::Event;
@ISA=qw(Gtk2::Gdk::Event);

# keysyms; put them here for simplicity
sub Sym_VoidSymbol { 0xFFFFFF }
sub Sym_BackSpace { 0xFF08 }
sub Sym_Tab { 0xFF09 }
sub Sym_Linefeed { 0xFF0A }
sub Sym_Clear { 0xFF0B }
sub Sym_Return { 0xFF0D }
sub Sym_Pause { 0xFF13 }
sub Sym_Scroll_Lock { 0xFF14 }
sub Sym_Sys_Req { 0xFF15 }
sub Sym_Escape { 0xFF1B }
sub Sym_Delete { 0xFFFF }
sub Sym_Multi_key { 0xFF20 }
sub Sym_Codeinput { 0xFF37 }
sub Sym_SingleCandidate { 0xFF3C }
sub Sym_MultipleCandidate { 0xFF3D }
sub Sym_PreviousCandidate { 0xFF3E }
sub Sym_Kanji { 0xFF21 }
sub Sym_Muhenkan { 0xFF22 }
sub Sym_Henkan_Mode { 0xFF23 }
sub Sym_Henkan { 0xFF23 }
sub Sym_Romaji { 0xFF24 }
sub Sym_Hiragana { 0xFF25 }
sub Sym_Katakana { 0xFF26 }
sub Sym_Hiragana_Katakana { 0xFF27 }
sub Sym_Zenkaku { 0xFF28 }
sub Sym_Hankaku { 0xFF29 }
sub Sym_Zenkaku_Hankaku { 0xFF2A }
sub Sym_Touroku { 0xFF2B }
sub Sym_Massyo { 0xFF2C }
sub Sym_Kana_Lock { 0xFF2D }
sub Sym_Kana_Shift { 0xFF2E }
sub Sym_Eisu_Shift { 0xFF2F }
sub Sym_Eisu_toggle { 0xFF30 }
sub Sym_Kanji_Bangou { 0xFF37 }
sub Sym_Zen_Koho { 0xFF3D }
sub Sym_Mae_Koho { 0xFF3E }
sub Sym_Home { 0xFF50 }
sub Sym_Left { 0xFF51 }
sub Sym_Up { 0xFF52 }
sub Sym_Right { 0xFF53 }
sub Sym_Down { 0xFF54 }
sub Sym_Prior { 0xFF55 }
sub Sym_Page_Up { 0xFF55 }
sub Sym_Next { 0xFF56 }
sub Sym_Page_Down { 0xFF56 }
sub Sym_End { 0xFF57 }
sub Sym_Begin { 0xFF58 }
sub Sym_Select { 0xFF60 }
sub Sym_Print { 0xFF61 }
sub Sym_Execute { 0xFF62 }
sub Sym_Insert { 0xFF63 }
sub Sym_Undo { 0xFF65 }
sub Sym_Redo { 0xFF66 }
sub Sym_Menu { 0xFF67 }
sub Sym_Find { 0xFF68 }
sub Sym_Cancel { 0xFF69 }
sub Sym_Help { 0xFF6A }
sub Sym_Break { 0xFF6B }
sub Sym_Mode_switch { 0xFF7E }
sub Sym_script_switch { 0xFF7E }
sub Sym_Num_Lock { 0xFF7F }
sub Sym_KP_Space { 0xFF80 }
sub Sym_KP_Tab { 0xFF89 }
sub Sym_KP_Enter { 0xFF8D }
sub Sym_KP_F1 { 0xFF91 }
sub Sym_KP_F2 { 0xFF92 }
sub Sym_KP_F3 { 0xFF93 }
sub Sym_KP_F4 { 0xFF94 }
sub Sym_KP_Home { 0xFF95 }
sub Sym_KP_Left { 0xFF96 }
sub Sym_KP_Up { 0xFF97 }
sub Sym_KP_Right { 0xFF98 }
sub Sym_KP_Down { 0xFF99 }
sub Sym_KP_Prior { 0xFF9A }
sub Sym_KP_Page_Up { 0xFF9A }
sub Sym_KP_Next { 0xFF9B }
sub Sym_KP_Page_Down { 0xFF9B }
sub Sym_KP_End { 0xFF9C }
sub Sym_KP_Begin { 0xFF9D }
sub Sym_KP_Insert { 0xFF9E }
sub Sym_KP_Delete { 0xFF9F }
sub Sym_KP_Equal { 0xFFBD }
sub Sym_KP_Multiply { 0xFFAA }
sub Sym_KP_Add { 0xFFAB }
sub Sym_KP_Separator { 0xFFAC }
sub Sym_KP_Subtract { 0xFFAD }
sub Sym_KP_Decimal { 0xFFAE }
sub Sym_KP_Divide { 0xFFAF }
sub Sym_KP_0 { 0xFFB0 }
sub Sym_KP_1 { 0xFFB1 }
sub Sym_KP_2 { 0xFFB2 }
sub Sym_KP_3 { 0xFFB3 }
sub Sym_KP_4 { 0xFFB4 }
sub Sym_KP_5 { 0xFFB5 }
sub Sym_KP_6 { 0xFFB6 }
sub Sym_KP_7 { 0xFFB7 }
sub Sym_KP_8 { 0xFFB8 }
sub Sym_KP_9 { 0xFFB9 }
sub Sym_F1 { 0xFFBE }
sub Sym_F2 { 0xFFBF }
sub Sym_F3 { 0xFFC0 }
sub Sym_F4 { 0xFFC1 }
sub Sym_F5 { 0xFFC2 }
sub Sym_F6 { 0xFFC3 }
sub Sym_F7 { 0xFFC4 }
sub Sym_F8 { 0xFFC5 }
sub Sym_F9 { 0xFFC6 }
sub Sym_F10 { 0xFFC7 }
sub Sym_F11 { 0xFFC8 }
sub Sym_L1 { 0xFFC8 }
sub Sym_F12 { 0xFFC9 }
sub Sym_L2 { 0xFFC9 }
sub Sym_F13 { 0xFFCA }
sub Sym_L3 { 0xFFCA }
sub Sym_F14 { 0xFFCB }
sub Sym_L4 { 0xFFCB }
sub Sym_F15 { 0xFFCC }
sub Sym_L5 { 0xFFCC }
sub Sym_F16 { 0xFFCD }
sub Sym_L6 { 0xFFCD }
sub Sym_F17 { 0xFFCE }
sub Sym_L7 { 0xFFCE }
sub Sym_F18 { 0xFFCF }
sub Sym_L8 { 0xFFCF }
sub Sym_F19 { 0xFFD0 }
sub Sym_L9 { 0xFFD0 }
sub Sym_F20 { 0xFFD1 }
sub Sym_L10 { 0xFFD1 }
sub Sym_F21 { 0xFFD2 }
sub Sym_R1 { 0xFFD2 }
sub Sym_F22 { 0xFFD3 }
sub Sym_R2 { 0xFFD3 }
sub Sym_F23 { 0xFFD4 }
sub Sym_R3 { 0xFFD4 }
sub Sym_F24 { 0xFFD5 }
sub Sym_R4 { 0xFFD5 }
sub Sym_F25 { 0xFFD6 }
sub Sym_R5 { 0xFFD6 }
sub Sym_F26 { 0xFFD7 }
sub Sym_R6 { 0xFFD7 }
sub Sym_F27 { 0xFFD8 }
sub Sym_R7 { 0xFFD8 }
sub Sym_F28 { 0xFFD9 }
sub Sym_R8 { 0xFFD9 }
sub Sym_F29 { 0xFFDA }
sub Sym_R9 { 0xFFDA }
sub Sym_F30 { 0xFFDB }
sub Sym_R10 { 0xFFDB }
sub Sym_F31 { 0xFFDC }
sub Sym_R11 { 0xFFDC }
sub Sym_F32 { 0xFFDD }
sub Sym_R12 { 0xFFDD }
sub Sym_F33 { 0xFFDE }
sub Sym_R13 { 0xFFDE }
sub Sym_F34 { 0xFFDF }
sub Sym_R14 { 0xFFDF }
sub Sym_F35 { 0xFFE0 }
sub Sym_R15 { 0xFFE0 }
sub Sym_Shift_L { 0xFFE1 }
sub Sym_Shift_R { 0xFFE2 }
sub Sym_Control_L { 0xFFE3 }
sub Sym_Control_R { 0xFFE4 }
sub Sym_Caps_Lock { 0xFFE5 }
sub Sym_Shift_Lock { 0xFFE6 }
sub Sym_Meta_L { 0xFFE7 }
sub Sym_Meta_R { 0xFFE8 }
sub Sym_Alt_L { 0xFFE9 }
sub Sym_Alt_R { 0xFFEA }
sub Sym_Super_L { 0xFFEB }
sub Sym_Super_R { 0xFFEC }
sub Sym_Hyper_L { 0xFFED }
sub Sym_Hyper_R { 0xFFEE }
sub Sym_ISO_Lock { 0xFE01 }
sub Sym_ISO_Level2_Latch { 0xFE02 }
sub Sym_ISO_Level3_Shift { 0xFE03 }
sub Sym_ISO_Level3_Latch { 0xFE04 }
sub Sym_ISO_Level3_Lock { 0xFE05 }
sub Sym_ISO_Group_Shift { 0xFF7E }
sub Sym_ISO_Group_Latch { 0xFE06 }
sub Sym_ISO_Group_Lock { 0xFE07 }
sub Sym_ISO_Next_Group { 0xFE08 }
sub Sym_ISO_Next_Group_Lock { 0xFE09 }
sub Sym_ISO_Prev_Group { 0xFE0A }
sub Sym_ISO_Prev_Group_Lock { 0xFE0B }
sub Sym_ISO_First_Group { 0xFE0C }
sub Sym_ISO_First_Group_Lock { 0xFE0D }
sub Sym_ISO_Last_Group { 0xFE0E }
sub Sym_ISO_Last_Group_Lock { 0xFE0F }
sub Sym_ISO_Left_Tab { 0xFE20 }
sub Sym_ISO_Move_Line_Up { 0xFE21 }
sub Sym_ISO_Move_Line_Down { 0xFE22 }
sub Sym_ISO_Partial_Line_Up { 0xFE23 }
sub Sym_ISO_Partial_Line_Down { 0xFE24 }
sub Sym_ISO_Partial_Space_Left { 0xFE25 }
sub Sym_ISO_Partial_Space_Right { 0xFE26 }
sub Sym_ISO_Set_Margin_Left { 0xFE27 }
sub Sym_ISO_Set_Margin_Right { 0xFE28 }
sub Sym_ISO_Release_Margin_Left { 0xFE29 }
sub Sym_ISO_Release_Margin_Right { 0xFE2A }
sub Sym_ISO_Release_Both_Margins { 0xFE2B }
sub Sym_ISO_Fast_Cursor_Left { 0xFE2C }
sub Sym_ISO_Fast_Cursor_Right { 0xFE2D }
sub Sym_ISO_Fast_Cursor_Up { 0xFE2E }
sub Sym_ISO_Fast_Cursor_Down { 0xFE2F }
sub Sym_ISO_Continuous_Underline { 0xFE30 }
sub Sym_ISO_Discontinuous_Underline { 0xFE31 }
sub Sym_ISO_Emphasize { 0xFE32 }
sub Sym_ISO_Center_Object { 0xFE33 }
sub Sym_ISO_Enter { 0xFE34 }
sub Sym_dead_grave { 0xFE50 }
sub Sym_dead_acute { 0xFE51 }
sub Sym_dead_circumflex { 0xFE52 }
sub Sym_dead_tilde { 0xFE53 }
sub Sym_dead_macron { 0xFE54 }
sub Sym_dead_breve { 0xFE55 }
sub Sym_dead_abovedot { 0xFE56 }
sub Sym_dead_diaeresis { 0xFE57 }
sub Sym_dead_abovering { 0xFE58 }
sub Sym_dead_doubleacute { 0xFE59 }
sub Sym_dead_caron { 0xFE5A }
sub Sym_dead_cedilla { 0xFE5B }
sub Sym_dead_ogonek { 0xFE5C }
sub Sym_dead_iota { 0xFE5D }
sub Sym_dead_voiced_sound { 0xFE5E }
sub Sym_dead_semivoiced_sound { 0xFE5F }
sub Sym_dead_belowdot { 0xFE60 }
sub Sym_First_Virtual_Screen { 0xFED0 }
sub Sym_Prev_Virtual_Screen { 0xFED1 }
sub Sym_Next_Virtual_Screen { 0xFED2 }
sub Sym_Last_Virtual_Screen { 0xFED4 }
sub Sym_Terminate_Server { 0xFED5 }
sub Sym_AccessX_Enable { 0xFE70 }
sub Sym_AccessX_Feedback_Enable { 0xFE71 }
sub Sym_RepeatKeys_Enable { 0xFE72 }
sub Sym_SlowKeys_Enable { 0xFE73 }
sub Sym_BounceKeys_Enable { 0xFE74 }
sub Sym_StickyKeys_Enable { 0xFE75 }
sub Sym_MouseKeys_Enable { 0xFE76 }
sub Sym_MouseKeys_Accel_Enable { 0xFE77 }
sub Sym_Overlay1_Enable { 0xFE78 }
sub Sym_Overlay2_Enable { 0xFE79 }
sub Sym_AudibleBell_Enable { 0xFE7A }
sub Sym_Pointer_Left { 0xFEE0 }
sub Sym_Pointer_Right { 0xFEE1 }
sub Sym_Pointer_Up { 0xFEE2 }
sub Sym_Pointer_Down { 0xFEE3 }
sub Sym_Pointer_UpLeft { 0xFEE4 }
sub Sym_Pointer_UpRight { 0xFEE5 }
sub Sym_Pointer_DownLeft { 0xFEE6 }
sub Sym_Pointer_DownRight { 0xFEE7 }
sub Sym_Pointer_Button_Dflt { 0xFEE8 }
sub Sym_Pointer_Button1 { 0xFEE9 }
sub Sym_Pointer_Button2 { 0xFEEA }
sub Sym_Pointer_Button3 { 0xFEEB }
sub Sym_Pointer_Button4 { 0xFEEC }
sub Sym_Pointer_Button5 { 0xFEED }
sub Sym_Pointer_DblClick_Dflt { 0xFEEE }
sub Sym_Pointer_DblClick1 { 0xFEEF }
sub Sym_Pointer_DblClick2 { 0xFEF0 }
sub Sym_Pointer_DblClick3 { 0xFEF1 }
sub Sym_Pointer_DblClick4 { 0xFEF2 }
sub Sym_Pointer_DblClick5 { 0xFEF3 }
sub Sym_Pointer_Drag_Dflt { 0xFEF4 }
sub Sym_Pointer_Drag1 { 0xFEF5 }
sub Sym_Pointer_Drag2 { 0xFEF6 }
sub Sym_Pointer_Drag3 { 0xFEF7 }
sub Sym_Pointer_Drag4 { 0xFEF8 }
sub Sym_Pointer_Drag5 { 0xFEFD }
sub Sym_Pointer_EnableKeys { 0xFEF9 }
sub Sym_Pointer_Accelerate { 0xFEFA }
sub Sym_Pointer_DfltBtnNext { 0xFEFB }
sub Sym_Pointer_DfltBtnPrev { 0xFEFC }
sub Sym_3270_Duplicate { 0xFD01 }
sub Sym_3270_FieldMark { 0xFD02 }
sub Sym_3270_Right2 { 0xFD03 }
sub Sym_3270_Left2 { 0xFD04 }
sub Sym_3270_BackTab { 0xFD05 }
sub Sym_3270_EraseEOF { 0xFD06 }
sub Sym_3270_EraseInput { 0xFD07 }
sub Sym_3270_Reset { 0xFD08 }
sub Sym_3270_Quit { 0xFD09 }
sub Sym_3270_PA1 { 0xFD0A }
sub Sym_3270_PA2 { 0xFD0B }
sub Sym_3270_PA3 { 0xFD0C }
sub Sym_3270_Test { 0xFD0D }
sub Sym_3270_Attn { 0xFD0E }
sub Sym_3270_CursorBlink { 0xFD0F }
sub Sym_3270_AltCursor { 0xFD10 }
sub Sym_3270_KeyClick { 0xFD11 }
sub Sym_3270_Jump { 0xFD12 }
sub Sym_3270_Ident { 0xFD13 }
sub Sym_3270_Rule { 0xFD14 }
sub Sym_3270_Copy { 0xFD15 }
sub Sym_3270_Play { 0xFD16 }
sub Sym_3270_Setup { 0xFD17 }
sub Sym_3270_Record { 0xFD18 }
sub Sym_3270_ChangeScreen { 0xFD19 }
sub Sym_3270_DeleteWord { 0xFD1A }
sub Sym_3270_ExSelect { 0xFD1B }
sub Sym_3270_CursorSelect { 0xFD1C }
sub Sym_3270_PrintScreen { 0xFD1D }
sub Sym_3270_Enter { 0xFD1E }
sub Sym_space { 0x020 }
sub Sym_exclam { 0x021 }
sub Sym_quotedbl { 0x022 }
sub Sym_numbersign { 0x023 }
sub Sym_dollar { 0x024 }
sub Sym_percent { 0x025 }
sub Sym_ampersand { 0x026 }
sub Sym_apostrophe { 0x027 }
sub Sym_quoteright { 0x027 }
sub Sym_parenleft { 0x028 }
sub Sym_parenright { 0x029 }
sub Sym_asterisk { 0x02a }
sub Sym_plus { 0x02b }
sub Sym_comma { 0x02c }
sub Sym_minus { 0x02d }
sub Sym_period { 0x02e }
sub Sym_slash { 0x02f }
sub Sym_0 { 0x030 }
sub Sym_1 { 0x031 }
sub Sym_2 { 0x032 }
sub Sym_3 { 0x033 }
sub Sym_4 { 0x034 }
sub Sym_5 { 0x035 }
sub Sym_6 { 0x036 }
sub Sym_7 { 0x037 }
sub Sym_8 { 0x038 }
sub Sym_9 { 0x039 }
sub Sym_colon { 0x03a }
sub Sym_semicolon { 0x03b }
sub Sym_less { 0x03c }
sub Sym_equal { 0x03d }
sub Sym_greater { 0x03e }
sub Sym_question { 0x03f }
sub Sym_at { 0x040 }
sub Sym_A { 0x041 }
sub Sym_B { 0x042 }
sub Sym_C { 0x043 }
sub Sym_D { 0x044 }
sub Sym_E { 0x045 }
sub Sym_F { 0x046 }
sub Sym_G { 0x047 }
sub Sym_H { 0x048 }
sub Sym_I { 0x049 }
sub Sym_J { 0x04a }
sub Sym_K { 0x04b }
sub Sym_L { 0x04c }
sub Sym_M { 0x04d }
sub Sym_N { 0x04e }
sub Sym_O { 0x04f }
sub Sym_P { 0x050 }
sub Sym_Q { 0x051 }
sub Sym_R { 0x052 }
sub Sym_S { 0x053 }
sub Sym_T { 0x054 }
sub Sym_U { 0x055 }
sub Sym_V { 0x056 }
sub Sym_W { 0x057 }
sub Sym_X { 0x058 }
sub Sym_Y { 0x059 }
sub Sym_Z { 0x05a }
sub Sym_bracketleft { 0x05b }
sub Sym_backslash { 0x05c }
sub Sym_bracketright { 0x05d }
sub Sym_asciicircum { 0x05e }
sub Sym_underscore { 0x05f }
sub Sym_grave { 0x060 }
sub Sym_quoteleft { 0x060 }
sub Sym_a { 0x061 }
sub Sym_b { 0x062 }
sub Sym_c { 0x063 }
sub Sym_d { 0x064 }
sub Sym_e { 0x065 }
sub Sym_f { 0x066 }
sub Sym_g { 0x067 }
sub Sym_h { 0x068 }
sub Sym_i { 0x069 }
sub Sym_j { 0x06a }
sub Sym_k { 0x06b }
sub Sym_l { 0x06c }
sub Sym_m { 0x06d }
sub Sym_n { 0x06e }
sub Sym_o { 0x06f }
sub Sym_p { 0x070 }
sub Sym_q { 0x071 }
sub Sym_r { 0x072 }
sub Sym_s { 0x073 }
sub Sym_t { 0x074 }
sub Sym_u { 0x075 }
sub Sym_v { 0x076 }
sub Sym_w { 0x077 }
sub Sym_x { 0x078 }
sub Sym_y { 0x079 }
sub Sym_z { 0x07a }
sub Sym_braceleft { 0x07b }
sub Sym_bar { 0x07c }
sub Sym_braceright { 0x07d }
sub Sym_asciitilde { 0x07e }
sub Sym_nobreakspace { 0x0a0 }
sub Sym_exclamdown { 0x0a1 }
sub Sym_cent { 0x0a2 }
sub Sym_sterling { 0x0a3 }
sub Sym_currency { 0x0a4 }
sub Sym_yen { 0x0a5 }
sub Sym_brokenbar { 0x0a6 }
sub Sym_section { 0x0a7 }
sub Sym_diaeresis { 0x0a8 }
sub Sym_copyright { 0x0a9 }
sub Sym_ordfeminine { 0x0aa }
sub Sym_guillemotleft { 0x0ab }
sub Sym_notsign { 0x0ac }
sub Sym_hyphen { 0x0ad }
sub Sym_registered { 0x0ae }
sub Sym_macron { 0x0af }
sub Sym_degree { 0x0b0 }
sub Sym_plusminus { 0x0b1 }
sub Sym_twosuperior { 0x0b2 }
sub Sym_threesuperior { 0x0b3 }
sub Sym_acute { 0x0b4 }
sub Sym_mu { 0x0b5 }
sub Sym_paragraph { 0x0b6 }
sub Sym_periodcentered { 0x0b7 }
sub Sym_cedilla { 0x0b8 }
sub Sym_onesuperior { 0x0b9 }
sub Sym_masculine { 0x0ba }
sub Sym_guillemotright { 0x0bb }
sub Sym_onequarter { 0x0bc }
sub Sym_onehalf { 0x0bd }
sub Sym_threequarters { 0x0be }
sub Sym_questiondown { 0x0bf }
sub Sym_Agrave { 0x0c0 }
sub Sym_Aacute { 0x0c1 }
sub Sym_Acircumflex { 0x0c2 }
sub Sym_Atilde { 0x0c3 }
sub Sym_Adiaeresis { 0x0c4 }
sub Sym_Aring { 0x0c5 }
sub Sym_AE { 0x0c6 }
sub Sym_Ccedilla { 0x0c7 }
sub Sym_Egrave { 0x0c8 }
sub Sym_Eacute { 0x0c9 }
sub Sym_Ecircumflex { 0x0ca }
sub Sym_Ediaeresis { 0x0cb }
sub Sym_Igrave { 0x0cc }
sub Sym_Iacute { 0x0cd }
sub Sym_Icircumflex { 0x0ce }
sub Sym_Idiaeresis { 0x0cf }
sub Sym_ETH { 0x0d0 }
sub Sym_Eth { 0x0d0 }
sub Sym_Ntilde { 0x0d1 }
sub Sym_Ograve { 0x0d2 }
sub Sym_Oacute { 0x0d3 }
sub Sym_Ocircumflex { 0x0d4 }
sub Sym_Otilde { 0x0d5 }
sub Sym_Odiaeresis { 0x0d6 }
sub Sym_multiply { 0x0d7 }
sub Sym_Ooblique { 0x0d8 }
sub Sym_Ugrave { 0x0d9 }
sub Sym_Uacute { 0x0da }
sub Sym_Ucircumflex { 0x0db }
sub Sym_Udiaeresis { 0x0dc }
sub Sym_Yacute { 0x0dd }
sub Sym_THORN { 0x0de }
sub Sym_Thorn { 0x0de }
sub Sym_ssharp { 0x0df }
sub Sym_agrave { 0x0e0 }
sub Sym_aacute { 0x0e1 }
sub Sym_acircumflex { 0x0e2 }
sub Sym_atilde { 0x0e3 }
sub Sym_adiaeresis { 0x0e4 }
sub Sym_aring { 0x0e5 }
sub Sym_ae { 0x0e6 }
sub Sym_ccedilla { 0x0e7 }
sub Sym_egrave { 0x0e8 }
sub Sym_eacute { 0x0e9 }
sub Sym_ecircumflex { 0x0ea }
sub Sym_ediaeresis { 0x0eb }
sub Sym_igrave { 0x0ec }
sub Sym_iacute { 0x0ed }
sub Sym_icircumflex { 0x0ee }
sub Sym_idiaeresis { 0x0ef }
sub Sym_eth { 0x0f0 }
sub Sym_ntilde { 0x0f1 }
sub Sym_ograve { 0x0f2 }
sub Sym_oacute { 0x0f3 }
sub Sym_ocircumflex { 0x0f4 }
sub Sym_otilde { 0x0f5 }
sub Sym_odiaeresis { 0x0f6 }
sub Sym_division { 0x0f7 }
sub Sym_oslash { 0x0f8 }
sub Sym_ugrave { 0x0f9 }
sub Sym_uacute { 0x0fa }
sub Sym_ucircumflex { 0x0fb }
sub Sym_udiaeresis { 0x0fc }
sub Sym_yacute { 0x0fd }
sub Sym_thorn { 0x0fe }
sub Sym_ydiaeresis { 0x0ff }
sub Sym_Aogonek { 0x1a1 }
sub Sym_breve { 0x1a2 }
sub Sym_Lstroke { 0x1a3 }
sub Sym_Lcaron { 0x1a5 }
sub Sym_Sacute { 0x1a6 }
sub Sym_Scaron { 0x1a9 }
sub Sym_Scedilla { 0x1aa }
sub Sym_Tcaron { 0x1ab }
sub Sym_Zacute { 0x1ac }
sub Sym_Zcaron { 0x1ae }
sub Sym_Zabovedot { 0x1af }
sub Sym_aogonek { 0x1b1 }
sub Sym_ogonek { 0x1b2 }
sub Sym_lstroke { 0x1b3 }
sub Sym_lcaron { 0x1b5 }
sub Sym_sacute { 0x1b6 }
sub Sym_caron { 0x1b7 }
sub Sym_scaron { 0x1b9 }
sub Sym_scedilla { 0x1ba }
sub Sym_tcaron { 0x1bb }
sub Sym_zacute { 0x1bc }
sub Sym_doubleacute { 0x1bd }
sub Sym_zcaron { 0x1be }
sub Sym_zabovedot { 0x1bf }
sub Sym_Racute { 0x1c0 }
sub Sym_Abreve { 0x1c3 }
sub Sym_Lacute { 0x1c5 }
sub Sym_Cacute { 0x1c6 }
sub Sym_Ccaron { 0x1c8 }
sub Sym_Eogonek { 0x1ca }
sub Sym_Ecaron { 0x1cc }
sub Sym_Dcaron { 0x1cf }
sub Sym_Dstroke { 0x1d0 }
sub Sym_Nacute { 0x1d1 }
sub Sym_Ncaron { 0x1d2 }
sub Sym_Odoubleacute { 0x1d5 }
sub Sym_Rcaron { 0x1d8 }
sub Sym_Uring { 0x1d9 }
sub Sym_Udoubleacute { 0x1db }
sub Sym_Tcedilla { 0x1de }
sub Sym_racute { 0x1e0 }
sub Sym_abreve { 0x1e3 }
sub Sym_lacute { 0x1e5 }
sub Sym_cacute { 0x1e6 }
sub Sym_ccaron { 0x1e8 }
sub Sym_eogonek { 0x1ea }
sub Sym_ecaron { 0x1ec }
sub Sym_dcaron { 0x1ef }
sub Sym_dstroke { 0x1f0 }
sub Sym_nacute { 0x1f1 }
sub Sym_ncaron { 0x1f2 }
sub Sym_odoubleacute { 0x1f5 }
sub Sym_udoubleacute { 0x1fb }
sub Sym_rcaron { 0x1f8 }
sub Sym_uring { 0x1f9 }
sub Sym_tcedilla { 0x1fe }
sub Sym_abovedot { 0x1ff }
sub Sym_Hstroke { 0x2a1 }
sub Sym_Hcircumflex { 0x2a6 }
sub Sym_Iabovedot { 0x2a9 }
sub Sym_Gbreve { 0x2ab }
sub Sym_Jcircumflex { 0x2ac }
sub Sym_hstroke { 0x2b1 }
sub Sym_hcircumflex { 0x2b6 }
sub Sym_idotless { 0x2b9 }
sub Sym_gbreve { 0x2bb }
sub Sym_jcircumflex { 0x2bc }
sub Sym_Cabovedot { 0x2c5 }
sub Sym_Ccircumflex { 0x2c6 }
sub Sym_Gabovedot { 0x2d5 }
sub Sym_Gcircumflex { 0x2d8 }
sub Sym_Ubreve { 0x2dd }
sub Sym_Scircumflex { 0x2de }
sub Sym_cabovedot { 0x2e5 }
sub Sym_ccircumflex { 0x2e6 }
sub Sym_gabovedot { 0x2f5 }
sub Sym_gcircumflex { 0x2f8 }
sub Sym_ubreve { 0x2fd }
sub Sym_scircumflex { 0x2fe }
sub Sym_kra { 0x3a2 }
sub Sym_kappa { 0x3a2 }
sub Sym_Rcedilla { 0x3a3 }
sub Sym_Itilde { 0x3a5 }
sub Sym_Lcedilla { 0x3a6 }
sub Sym_Emacron { 0x3aa }
sub Sym_Gcedilla { 0x3ab }
sub Sym_Tslash { 0x3ac }
sub Sym_rcedilla { 0x3b3 }
sub Sym_itilde { 0x3b5 }
sub Sym_lcedilla { 0x3b6 }
sub Sym_emacron { 0x3ba }
sub Sym_gcedilla { 0x3bb }
sub Sym_tslash { 0x3bc }
sub Sym_ENG { 0x3bd }
sub Sym_eng { 0x3bf }
sub Sym_Amacron { 0x3c0 }
sub Sym_Iogonek { 0x3c7 }
sub Sym_Eabovedot { 0x3cc }
sub Sym_Imacron { 0x3cf }
sub Sym_Ncedilla { 0x3d1 }
sub Sym_Omacron { 0x3d2 }
sub Sym_Kcedilla { 0x3d3 }
sub Sym_Uogonek { 0x3d9 }
sub Sym_Utilde { 0x3dd }
sub Sym_Umacron { 0x3de }
sub Sym_amacron { 0x3e0 }
sub Sym_iogonek { 0x3e7 }
sub Sym_eabovedot { 0x3ec }
sub Sym_imacron { 0x3ef }
sub Sym_ncedilla { 0x3f1 }
sub Sym_omacron { 0x3f2 }
sub Sym_kcedilla { 0x3f3 }
sub Sym_uogonek { 0x3f9 }
sub Sym_utilde { 0x3fd }
sub Sym_umacron { 0x3fe }
sub Sym_OE { 0x13bc }
sub Sym_oe { 0x13bd }
sub Sym_Ydiaeresis { 0x13be }
sub Sym_overline { 0x47e }
sub Sym_kana_fullstop { 0x4a1 }
sub Sym_kana_openingbracket { 0x4a2 }
sub Sym_kana_closingbracket { 0x4a3 }
sub Sym_kana_comma { 0x4a4 }
sub Sym_kana_conjunctive { 0x4a5 }
sub Sym_kana_middledot { 0x4a5 }
sub Sym_kana_WO { 0x4a6 }
sub Sym_kana_a { 0x4a7 }
sub Sym_kana_i { 0x4a8 }
sub Sym_kana_u { 0x4a9 }
sub Sym_kana_e { 0x4aa }
sub Sym_kana_o { 0x4ab }
sub Sym_kana_ya { 0x4ac }
sub Sym_kana_yu { 0x4ad }
sub Sym_kana_yo { 0x4ae }
sub Sym_kana_tsu { 0x4af }
sub Sym_kana_tu { 0x4af }
sub Sym_prolongedsound { 0x4b0 }
sub Sym_kana_A { 0x4b1 }
sub Sym_kana_I { 0x4b2 }
sub Sym_kana_U { 0x4b3 }
sub Sym_kana_E { 0x4b4 }
sub Sym_kana_O { 0x4b5 }
sub Sym_kana_KA { 0x4b6 }
sub Sym_kana_KI { 0x4b7 }
sub Sym_kana_KU { 0x4b8 }
sub Sym_kana_KE { 0x4b9 }
sub Sym_kana_KO { 0x4ba }
sub Sym_kana_SA { 0x4bb }
sub Sym_kana_SHI { 0x4bc }
sub Sym_kana_SU { 0x4bd }
sub Sym_kana_SE { 0x4be }
sub Sym_kana_SO { 0x4bf }
sub Sym_kana_TA { 0x4c0 }
sub Sym_kana_CHI { 0x4c1 }
sub Sym_kana_TI { 0x4c1 }
sub Sym_kana_TSU { 0x4c2 }
sub Sym_kana_TU { 0x4c2 }
sub Sym_kana_TE { 0x4c3 }
sub Sym_kana_TO { 0x4c4 }
sub Sym_kana_NA { 0x4c5 }
sub Sym_kana_NI { 0x4c6 }
sub Sym_kana_NU { 0x4c7 }
sub Sym_kana_NE { 0x4c8 }
sub Sym_kana_NO { 0x4c9 }
sub Sym_kana_HA { 0x4ca }
sub Sym_kana_HI { 0x4cb }
sub Sym_kana_FU { 0x4cc }
sub Sym_kana_HU { 0x4cc }
sub Sym_kana_HE { 0x4cd }
sub Sym_kana_HO { 0x4ce }
sub Sym_kana_MA { 0x4cf }
sub Sym_kana_MI { 0x4d0 }
sub Sym_kana_MU { 0x4d1 }
sub Sym_kana_ME { 0x4d2 }
sub Sym_kana_MO { 0x4d3 }
sub Sym_kana_YA { 0x4d4 }
sub Sym_kana_YU { 0x4d5 }
sub Sym_kana_YO { 0x4d6 }
sub Sym_kana_RA { 0x4d7 }
sub Sym_kana_RI { 0x4d8 }
sub Sym_kana_RU { 0x4d9 }
sub Sym_kana_RE { 0x4da }
sub Sym_kana_RO { 0x4db }
sub Sym_kana_WA { 0x4dc }
sub Sym_kana_N { 0x4dd }
sub Sym_voicedsound { 0x4de }
sub Sym_semivoicedsound { 0x4df }
sub Sym_kana_switch { 0xFF7E }
sub Sym_Arabic_comma { 0x5ac }
sub Sym_Arabic_semicolon { 0x5bb }
sub Sym_Arabic_question_mark { 0x5bf }
sub Sym_Arabic_hamza { 0x5c1 }
sub Sym_Arabic_maddaonalef { 0x5c2 }
sub Sym_Arabic_hamzaonalef { 0x5c3 }
sub Sym_Arabic_hamzaonwaw { 0x5c4 }
sub Sym_Arabic_hamzaunderalef { 0x5c5 }
sub Sym_Arabic_hamzaonyeh { 0x5c6 }
sub Sym_Arabic_alef { 0x5c7 }
sub Sym_Arabic_beh { 0x5c8 }
sub Sym_Arabic_tehmarbuta { 0x5c9 }
sub Sym_Arabic_teh { 0x5ca }
sub Sym_Arabic_theh { 0x5cb }
sub Sym_Arabic_jeem { 0x5cc }
sub Sym_Arabic_hah { 0x5cd }
sub Sym_Arabic_khah { 0x5ce }
sub Sym_Arabic_dal { 0x5cf }
sub Sym_Arabic_thal { 0x5d0 }
sub Sym_Arabic_ra { 0x5d1 }
sub Sym_Arabic_zain { 0x5d2 }
sub Sym_Arabic_seen { 0x5d3 }
sub Sym_Arabic_sheen { 0x5d4 }
sub Sym_Arabic_sad { 0x5d5 }
sub Sym_Arabic_dad { 0x5d6 }
sub Sym_Arabic_tah { 0x5d7 }
sub Sym_Arabic_zah { 0x5d8 }
sub Sym_Arabic_ain { 0x5d9 }
sub Sym_Arabic_ghain { 0x5da }
sub Sym_Arabic_tatweel { 0x5e0 }
sub Sym_Arabic_feh { 0x5e1 }
sub Sym_Arabic_qaf { 0x5e2 }
sub Sym_Arabic_kaf { 0x5e3 }
sub Sym_Arabic_lam { 0x5e4 }
sub Sym_Arabic_meem { 0x5e5 }
sub Sym_Arabic_noon { 0x5e6 }
sub Sym_Arabic_ha { 0x5e7 }
sub Sym_Arabic_heh { 0x5e7 }
sub Sym_Arabic_waw { 0x5e8 }
sub Sym_Arabic_alefmaksura { 0x5e9 }
sub Sym_Arabic_yeh { 0x5ea }
sub Sym_Arabic_fathatan { 0x5eb }
sub Sym_Arabic_dammatan { 0x5ec }
sub Sym_Arabic_kasratan { 0x5ed }
sub Sym_Arabic_fatha { 0x5ee }
sub Sym_Arabic_damma { 0x5ef }
sub Sym_Arabic_kasra { 0x5f0 }
sub Sym_Arabic_shadda { 0x5f1 }
sub Sym_Arabic_sukun { 0x5f2 }
sub Sym_Arabic_switch { 0xFF7E }
sub Sym_Serbian_dje { 0x6a1 }
sub Sym_Macedonia_gje { 0x6a2 }
sub Sym_Cyrillic_io { 0x6a3 }
sub Sym_Ukrainian_ie { 0x6a4 }
sub Sym_Ukranian_je { 0x6a4 }
sub Sym_Macedonia_dse { 0x6a5 }
sub Sym_Ukrainian_i { 0x6a6 }
sub Sym_Ukranian_i { 0x6a6 }
sub Sym_Ukrainian_yi { 0x6a7 }
sub Sym_Ukranian_yi { 0x6a7 }
sub Sym_Cyrillic_je { 0x6a8 }
sub Sym_Serbian_je { 0x6a8 }
sub Sym_Cyrillic_lje { 0x6a9 }
sub Sym_Serbian_lje { 0x6a9 }
sub Sym_Cyrillic_nje { 0x6aa }
sub Sym_Serbian_nje { 0x6aa }
sub Sym_Serbian_tshe { 0x6ab }
sub Sym_Macedonia_kje { 0x6ac }
sub Sym_Byelorussian_shortu { 0x6ae }
sub Sym_Cyrillic_dzhe { 0x6af }
sub Sym_Serbian_dze { 0x6af }
sub Sym_numerosign { 0x6b0 }
sub Sym_Serbian_DJE { 0x6b1 }
sub Sym_Macedonia_GJE { 0x6b2 }
sub Sym_Cyrillic_IO { 0x6b3 }
sub Sym_Ukrainian_IE { 0x6b4 }
sub Sym_Ukranian_JE { 0x6b4 }
sub Sym_Macedonia_DSE { 0x6b5 }
sub Sym_Ukrainian_I { 0x6b6 }
sub Sym_Ukranian_I { 0x6b6 }
sub Sym_Ukrainian_YI { 0x6b7 }
sub Sym_Ukranian_YI { 0x6b7 }
sub Sym_Cyrillic_JE { 0x6b8 }
sub Sym_Serbian_JE { 0x6b8 }
sub Sym_Cyrillic_LJE { 0x6b9 }
sub Sym_Serbian_LJE { 0x6b9 }
sub Sym_Cyrillic_NJE { 0x6ba }
sub Sym_Serbian_NJE { 0x6ba }
sub Sym_Serbian_TSHE { 0x6bb }
sub Sym_Macedonia_KJE { 0x6bc }
sub Sym_Byelorussian_SHORTU { 0x6be }
sub Sym_Cyrillic_DZHE { 0x6bf }
sub Sym_Serbian_DZE { 0x6bf }
sub Sym_Cyrillic_yu { 0x6c0 }
sub Sym_Cyrillic_a { 0x6c1 }
sub Sym_Cyrillic_be { 0x6c2 }
sub Sym_Cyrillic_tse { 0x6c3 }
sub Sym_Cyrillic_de { 0x6c4 }
sub Sym_Cyrillic_ie { 0x6c5 }
sub Sym_Cyrillic_ef { 0x6c6 }
sub Sym_Cyrillic_ghe { 0x6c7 }
sub Sym_Cyrillic_ha { 0x6c8 }
sub Sym_Cyrillic_i { 0x6c9 }
sub Sym_Cyrillic_shorti { 0x6ca }
sub Sym_Cyrillic_ka { 0x6cb }
sub Sym_Cyrillic_el { 0x6cc }
sub Sym_Cyrillic_em { 0x6cd }
sub Sym_Cyrillic_en { 0x6ce }
sub Sym_Cyrillic_o { 0x6cf }
sub Sym_Cyrillic_pe { 0x6d0 }
sub Sym_Cyrillic_ya { 0x6d1 }
sub Sym_Cyrillic_er { 0x6d2 }
sub Sym_Cyrillic_es { 0x6d3 }
sub Sym_Cyrillic_te { 0x6d4 }
sub Sym_Cyrillic_u { 0x6d5 }
sub Sym_Cyrillic_zhe { 0x6d6 }
sub Sym_Cyrillic_ve { 0x6d7 }
sub Sym_Cyrillic_softsign { 0x6d8 }
sub Sym_Cyrillic_yeru { 0x6d9 }
sub Sym_Cyrillic_ze { 0x6da }
sub Sym_Cyrillic_sha { 0x6db }
sub Sym_Cyrillic_e { 0x6dc }
sub Sym_Cyrillic_shcha { 0x6dd }
sub Sym_Cyrillic_che { 0x6de }
sub Sym_Cyrillic_hardsign { 0x6df }
sub Sym_Cyrillic_YU { 0x6e0 }
sub Sym_Cyrillic_A { 0x6e1 }
sub Sym_Cyrillic_BE { 0x6e2 }
sub Sym_Cyrillic_TSE { 0x6e3 }
sub Sym_Cyrillic_DE { 0x6e4 }
sub Sym_Cyrillic_IE { 0x6e5 }
sub Sym_Cyrillic_EF { 0x6e6 }
sub Sym_Cyrillic_GHE { 0x6e7 }
sub Sym_Cyrillic_HA { 0x6e8 }
sub Sym_Cyrillic_I { 0x6e9 }
sub Sym_Cyrillic_SHORTI { 0x6ea }
sub Sym_Cyrillic_KA { 0x6eb }
sub Sym_Cyrillic_EL { 0x6ec }
sub Sym_Cyrillic_EM { 0x6ed }
sub Sym_Cyrillic_EN { 0x6ee }
sub Sym_Cyrillic_O { 0x6ef }
sub Sym_Cyrillic_PE { 0x6f0 }
sub Sym_Cyrillic_YA { 0x6f1 }
sub Sym_Cyrillic_ER { 0x6f2 }
sub Sym_Cyrillic_ES { 0x6f3 }
sub Sym_Cyrillic_TE { 0x6f4 }
sub Sym_Cyrillic_U { 0x6f5 }
sub Sym_Cyrillic_ZHE { 0x6f6 }
sub Sym_Cyrillic_VE { 0x6f7 }
sub Sym_Cyrillic_SOFTSIGN { 0x6f8 }
sub Sym_Cyrillic_YERU { 0x6f9 }
sub Sym_Cyrillic_ZE { 0x6fa }
sub Sym_Cyrillic_SHA { 0x6fb }
sub Sym_Cyrillic_E { 0x6fc }
sub Sym_Cyrillic_SHCHA { 0x6fd }
sub Sym_Cyrillic_CHE { 0x6fe }
sub Sym_Cyrillic_HARDSIGN { 0x6ff }
sub Sym_Greek_ALPHAaccent { 0x7a1 }
sub Sym_Greek_EPSILONaccent { 0x7a2 }
sub Sym_Greek_ETAaccent { 0x7a3 }
sub Sym_Greek_IOTAaccent { 0x7a4 }
sub Sym_Greek_IOTAdiaeresis { 0x7a5 }
sub Sym_Greek_OMICRONaccent { 0x7a7 }
sub Sym_Greek_UPSILONaccent { 0x7a8 }
sub Sym_Greek_UPSILONdieresis { 0x7a9 }
sub Sym_Greek_OMEGAaccent { 0x7ab }
sub Sym_Greek_accentdieresis { 0x7ae }
sub Sym_Greek_horizbar { 0x7af }
sub Sym_Greek_alphaaccent { 0x7b1 }
sub Sym_Greek_epsilonaccent { 0x7b2 }
sub Sym_Greek_etaaccent { 0x7b3 }
sub Sym_Greek_iotaaccent { 0x7b4 }
sub Sym_Greek_iotadieresis { 0x7b5 }
sub Sym_Greek_iotaaccentdieresis { 0x7b6 }
sub Sym_Greek_omicronaccent { 0x7b7 }
sub Sym_Greek_upsilonaccent { 0x7b8 }
sub Sym_Greek_upsilondieresis { 0x7b9 }
sub Sym_Greek_upsilonaccentdieresis { 0x7ba }
sub Sym_Greek_omegaaccent { 0x7bb }
sub Sym_Greek_ALPHA { 0x7c1 }
sub Sym_Greek_BETA { 0x7c2 }
sub Sym_Greek_GAMMA { 0x7c3 }
sub Sym_Greek_DELTA { 0x7c4 }
sub Sym_Greek_EPSILON { 0x7c5 }
sub Sym_Greek_ZETA { 0x7c6 }
sub Sym_Greek_ETA { 0x7c7 }
sub Sym_Greek_THETA { 0x7c8 }
sub Sym_Greek_IOTA { 0x7c9 }
sub Sym_Greek_KAPPA { 0x7ca }
sub Sym_Greek_LAMDA { 0x7cb }
sub Sym_Greek_LAMBDA { 0x7cb }
sub Sym_Greek_MU { 0x7cc }
sub Sym_Greek_NU { 0x7cd }
sub Sym_Greek_XI { 0x7ce }
sub Sym_Greek_OMICRON { 0x7cf }
sub Sym_Greek_PI { 0x7d0 }
sub Sym_Greek_RHO { 0x7d1 }
sub Sym_Greek_SIGMA { 0x7d2 }
sub Sym_Greek_TAU { 0x7d4 }
sub Sym_Greek_UPSILON { 0x7d5 }
sub Sym_Greek_PHI { 0x7d6 }
sub Sym_Greek_CHI { 0x7d7 }
sub Sym_Greek_PSI { 0x7d8 }
sub Sym_Greek_OMEGA { 0x7d9 }
sub Sym_Greek_alpha { 0x7e1 }
sub Sym_Greek_beta { 0x7e2 }
sub Sym_Greek_gamma { 0x7e3 }
sub Sym_Greek_delta { 0x7e4 }
sub Sym_Greek_epsilon { 0x7e5 }
sub Sym_Greek_zeta { 0x7e6 }
sub Sym_Greek_eta { 0x7e7 }
sub Sym_Greek_theta { 0x7e8 }
sub Sym_Greek_iota { 0x7e9 }
sub Sym_Greek_kappa { 0x7ea }
sub Sym_Greek_lamda { 0x7eb }
sub Sym_Greek_lambda { 0x7eb }
sub Sym_Greek_mu { 0x7ec }
sub Sym_Greek_nu { 0x7ed }
sub Sym_Greek_xi { 0x7ee }
sub Sym_Greek_omicron { 0x7ef }
sub Sym_Greek_pi { 0x7f0 }
sub Sym_Greek_rho { 0x7f1 }
sub Sym_Greek_sigma { 0x7f2 }
sub Sym_Greek_finalsmallsigma { 0x7f3 }
sub Sym_Greek_tau { 0x7f4 }
sub Sym_Greek_upsilon { 0x7f5 }
sub Sym_Greek_phi { 0x7f6 }
sub Sym_Greek_chi { 0x7f7 }
sub Sym_Greek_psi { 0x7f8 }
sub Sym_Greek_omega { 0x7f9 }
sub Sym_Greek_switch { 0xFF7E }
sub Sym_leftradical { 0x8a1 }
sub Sym_topleftradical { 0x8a2 }
sub Sym_horizconnector { 0x8a3 }
sub Sym_topintegral { 0x8a4 }
sub Sym_botintegral { 0x8a5 }
sub Sym_vertconnector { 0x8a6 }
sub Sym_topleftsqbracket { 0x8a7 }
sub Sym_botleftsqbracket { 0x8a8 }
sub Sym_toprightsqbracket { 0x8a9 }
sub Sym_botrightsqbracket { 0x8aa }
sub Sym_topleftparens { 0x8ab }
sub Sym_botleftparens { 0x8ac }
sub Sym_toprightparens { 0x8ad }
sub Sym_botrightparens { 0x8ae }
sub Sym_leftmiddlecurlybrace { 0x8af }
sub Sym_rightmiddlecurlybrace { 0x8b0 }
sub Sym_topleftsummation { 0x8b1 }
sub Sym_botleftsummation { 0x8b2 }
sub Sym_topvertsummationconnector { 0x8b3 }
sub Sym_botvertsummationconnector { 0x8b4 }
sub Sym_toprightsummation { 0x8b5 }
sub Sym_botrightsummation { 0x8b6 }
sub Sym_rightmiddlesummation { 0x8b7 }
sub Sym_lessthanequal { 0x8bc }
sub Sym_notequal { 0x8bd }
sub Sym_greaterthanequal { 0x8be }
sub Sym_integral { 0x8bf }
sub Sym_therefore { 0x8c0 }
sub Sym_variation { 0x8c1 }
sub Sym_infinity { 0x8c2 }
sub Sym_nabla { 0x8c5 }
sub Sym_approximate { 0x8c8 }
sub Sym_similarequal { 0x8c9 }
sub Sym_ifonlyif { 0x8cd }
sub Sym_implies { 0x8ce }
sub Sym_identical { 0x8cf }
sub Sym_radical { 0x8d6 }
sub Sym_includedin { 0x8da }
sub Sym_includes { 0x8db }
sub Sym_intersection { 0x8dc }
sub Sym_union { 0x8dd }
sub Sym_logicaland { 0x8de }
sub Sym_logicalor { 0x8df }
sub Sym_partialderivative { 0x8ef }
sub Sym_function { 0x8f6 }
sub Sym_leftarrow { 0x8fb }
sub Sym_uparrow { 0x8fc }
sub Sym_rightarrow { 0x8fd }
sub Sym_downarrow { 0x8fe }
sub Sym_blank { 0x9df }
sub Sym_soliddiamond { 0x9e0 }
sub Sym_checkerboard { 0x9e1 }
sub Sym_ht { 0x9e2 }
sub Sym_ff { 0x9e3 }
sub Sym_cr { 0x9e4 }
sub Sym_lf { 0x9e5 }
sub Sym_nl { 0x9e8 }
sub Sym_vt { 0x9e9 }
sub Sym_lowrightcorner { 0x9ea }
sub Sym_uprightcorner { 0x9eb }
sub Sym_upleftcorner { 0x9ec }
sub Sym_lowleftcorner { 0x9ed }
sub Sym_crossinglines { 0x9ee }
sub Sym_horizlinescan1 { 0x9ef }
sub Sym_horizlinescan3 { 0x9f0 }
sub Sym_horizlinescan5 { 0x9f1 }
sub Sym_horizlinescan7 { 0x9f2 }
sub Sym_horizlinescan9 { 0x9f3 }
sub Sym_leftt { 0x9f4 }
sub Sym_rightt { 0x9f5 }
sub Sym_bott { 0x9f6 }
sub Sym_topt { 0x9f7 }
sub Sym_vertbar { 0x9f8 }
sub Sym_emspace { 0xaa1 }
sub Sym_enspace { 0xaa2 }
sub Sym_em3space { 0xaa3 }
sub Sym_em4space { 0xaa4 }
sub Sym_digitspace { 0xaa5 }
sub Sym_punctspace { 0xaa6 }
sub Sym_thinspace { 0xaa7 }
sub Sym_hairspace { 0xaa8 }
sub Sym_emdash { 0xaa9 }
sub Sym_endash { 0xaaa }
sub Sym_signifblank { 0xaac }
sub Sym_ellipsis { 0xaae }
sub Sym_doubbaselinedot { 0xaaf }
sub Sym_onethird { 0xab0 }
sub Sym_twothirds { 0xab1 }
sub Sym_onefifth { 0xab2 }
sub Sym_twofifths { 0xab3 }
sub Sym_threefifths { 0xab4 }
sub Sym_fourfifths { 0xab5 }
sub Sym_onesixth { 0xab6 }
sub Sym_fivesixths { 0xab7 }
sub Sym_careof { 0xab8 }
sub Sym_figdash { 0xabb }
sub Sym_leftanglebracket { 0xabc }
sub Sym_decimalpoint { 0xabd }
sub Sym_rightanglebracket { 0xabe }
sub Sym_marker { 0xabf }
sub Sym_oneeighth { 0xac3 }
sub Sym_threeeighths { 0xac4 }
sub Sym_fiveeighths { 0xac5 }
sub Sym_seveneighths { 0xac6 }
sub Sym_trademark { 0xac9 }
sub Sym_signaturemark { 0xaca }
sub Sym_trademarkincircle { 0xacb }
sub Sym_leftopentriangle { 0xacc }
sub Sym_rightopentriangle { 0xacd }
sub Sym_emopencircle { 0xace }
sub Sym_emopenrectangle { 0xacf }
sub Sym_leftsinglequotemark { 0xad0 }
sub Sym_rightsinglequotemark { 0xad1 }
sub Sym_leftdoublequotemark { 0xad2 }
sub Sym_rightdoublequotemark { 0xad3 }
sub Sym_prescription { 0xad4 }
sub Sym_minutes { 0xad6 }
sub Sym_seconds { 0xad7 }
sub Sym_latincross { 0xad9 }
sub Sym_hexagram { 0xada }
sub Sym_filledrectbullet { 0xadb }
sub Sym_filledlefttribullet { 0xadc }
sub Sym_filledrighttribullet { 0xadd }
sub Sym_emfilledcircle { 0xade }
sub Sym_emfilledrect { 0xadf }
sub Sym_enopencircbullet { 0xae0 }
sub Sym_enopensquarebullet { 0xae1 }
sub Sym_openrectbullet { 0xae2 }
sub Sym_opentribulletup { 0xae3 }
sub Sym_opentribulletdown { 0xae4 }
sub Sym_openstar { 0xae5 }
sub Sym_enfilledcircbullet { 0xae6 }
sub Sym_enfilledsqbullet { 0xae7 }
sub Sym_filledtribulletup { 0xae8 }
sub Sym_filledtribulletdown { 0xae9 }
sub Sym_leftpointer { 0xaea }
sub Sym_rightpointer { 0xaeb }
sub Sym_club { 0xaec }
sub Sym_diamond { 0xaed }
sub Sym_heart { 0xaee }
sub Sym_maltesecross { 0xaf0 }
sub Sym_dagger { 0xaf1 }
sub Sym_doubledagger { 0xaf2 }
sub Sym_checkmark { 0xaf3 }
sub Sym_ballotcross { 0xaf4 }
sub Sym_musicalsharp { 0xaf5 }
sub Sym_musicalflat { 0xaf6 }
sub Sym_malesymbol { 0xaf7 }
sub Sym_femalesymbol { 0xaf8 }
sub Sym_telephone { 0xaf9 }
sub Sym_telephonerecorder { 0xafa }
sub Sym_phonographcopyright { 0xafb }
sub Sym_caret { 0xafc }
sub Sym_singlelowquotemark { 0xafd }
sub Sym_doublelowquotemark { 0xafe }
sub Sym_cursor { 0xaff }
sub Sym_leftcaret { 0xba3 }
sub Sym_rightcaret { 0xba6 }
sub Sym_downcaret { 0xba8 }
sub Sym_upcaret { 0xba9 }
sub Sym_overbar { 0xbc0 }
sub Sym_downtack { 0xbc2 }
sub Sym_upshoe { 0xbc3 }
sub Sym_downstile { 0xbc4 }
sub Sym_underbar { 0xbc6 }
sub Sym_jot { 0xbca }
sub Sym_quad { 0xbcc }
sub Sym_uptack { 0xbce }
sub Sym_circle { 0xbcf }
sub Sym_upstile { 0xbd3 }
sub Sym_downshoe { 0xbd6 }
sub Sym_rightshoe { 0xbd8 }
sub Sym_leftshoe { 0xbda }
sub Sym_lefttack { 0xbdc }
sub Sym_righttack { 0xbfc }
sub Sym_hebrew_doublelowline { 0xcdf }
sub Sym_hebrew_aleph { 0xce0 }
sub Sym_hebrew_bet { 0xce1 }
sub Sym_hebrew_beth { 0xce1 }
sub Sym_hebrew_gimel { 0xce2 }
sub Sym_hebrew_gimmel { 0xce2 }
sub Sym_hebrew_dalet { 0xce3 }
sub Sym_hebrew_daleth { 0xce3 }
sub Sym_hebrew_he { 0xce4 }
sub Sym_hebrew_waw { 0xce5 }
sub Sym_hebrew_zain { 0xce6 }
sub Sym_hebrew_zayin { 0xce6 }
sub Sym_hebrew_chet { 0xce7 }
sub Sym_hebrew_het { 0xce7 }
sub Sym_hebrew_tet { 0xce8 }
sub Sym_hebrew_teth { 0xce8 }
sub Sym_hebrew_yod { 0xce9 }
sub Sym_hebrew_finalkaph { 0xcea }
sub Sym_hebrew_kaph { 0xceb }
sub Sym_hebrew_lamed { 0xcec }
sub Sym_hebrew_finalmem { 0xced }
sub Sym_hebrew_mem { 0xcee }
sub Sym_hebrew_finalnun { 0xcef }
sub Sym_hebrew_nun { 0xcf0 }
sub Sym_hebrew_samech { 0xcf1 }
sub Sym_hebrew_samekh { 0xcf1 }
sub Sym_hebrew_ayin { 0xcf2 }
sub Sym_hebrew_finalpe { 0xcf3 }
sub Sym_hebrew_pe { 0xcf4 }
sub Sym_hebrew_finalzade { 0xcf5 }
sub Sym_hebrew_finalzadi { 0xcf5 }
sub Sym_hebrew_zade { 0xcf6 }
sub Sym_hebrew_zadi { 0xcf6 }
sub Sym_hebrew_qoph { 0xcf7 }
sub Sym_hebrew_kuf { 0xcf7 }
sub Sym_hebrew_resh { 0xcf8 }
sub Sym_hebrew_shin { 0xcf9 }
sub Sym_hebrew_taw { 0xcfa }
sub Sym_hebrew_taf { 0xcfa }
sub Sym_Hebrew_switch { 0xFF7E }
sub Sym_Thai_kokai { 0xda1 }
sub Sym_Thai_khokhai { 0xda2 }
sub Sym_Thai_khokhuat { 0xda3 }
sub Sym_Thai_khokhwai { 0xda4 }
sub Sym_Thai_khokhon { 0xda5 }
sub Sym_Thai_khorakhang { 0xda6 }
sub Sym_Thai_ngongu { 0xda7 }
sub Sym_Thai_chochan { 0xda8 }
sub Sym_Thai_choching { 0xda9 }
sub Sym_Thai_chochang { 0xdaa }
sub Sym_Thai_soso { 0xdab }
sub Sym_Thai_chochoe { 0xdac }
sub Sym_Thai_yoying { 0xdad }
sub Sym_Thai_dochada { 0xdae }
sub Sym_Thai_topatak { 0xdaf }
sub Sym_Thai_thothan { 0xdb0 }
sub Sym_Thai_thonangmontho { 0xdb1 }
sub Sym_Thai_thophuthao { 0xdb2 }
sub Sym_Thai_nonen { 0xdb3 }
sub Sym_Thai_dodek { 0xdb4 }
sub Sym_Thai_totao { 0xdb5 }
sub Sym_Thai_thothung { 0xdb6 }
sub Sym_Thai_thothahan { 0xdb7 }
sub Sym_Thai_thothong { 0xdb8 }
sub Sym_Thai_nonu { 0xdb9 }
sub Sym_Thai_bobaimai { 0xdba }
sub Sym_Thai_popla { 0xdbb }
sub Sym_Thai_phophung { 0xdbc }
sub Sym_Thai_fofa { 0xdbd }
sub Sym_Thai_phophan { 0xdbe }
sub Sym_Thai_fofan { 0xdbf }
sub Sym_Thai_phosamphao { 0xdc0 }
sub Sym_Thai_moma { 0xdc1 }
sub Sym_Thai_yoyak { 0xdc2 }
sub Sym_Thai_rorua { 0xdc3 }
sub Sym_Thai_ru { 0xdc4 }
sub Sym_Thai_loling { 0xdc5 }
sub Sym_Thai_lu { 0xdc6 }
sub Sym_Thai_wowaen { 0xdc7 }
sub Sym_Thai_sosala { 0xdc8 }
sub Sym_Thai_sorusi { 0xdc9 }
sub Sym_Thai_sosua { 0xdca }
sub Sym_Thai_hohip { 0xdcb }
sub Sym_Thai_lochula { 0xdcc }
sub Sym_Thai_oang { 0xdcd }
sub Sym_Thai_honokhuk { 0xdce }
sub Sym_Thai_paiyannoi { 0xdcf }
sub Sym_Thai_saraa { 0xdd0 }
sub Sym_Thai_maihanakat { 0xdd1 }
sub Sym_Thai_saraaa { 0xdd2 }
sub Sym_Thai_saraam { 0xdd3 }
sub Sym_Thai_sarai { 0xdd4 }
sub Sym_Thai_saraii { 0xdd5 }
sub Sym_Thai_saraue { 0xdd6 }
sub Sym_Thai_sarauee { 0xdd7 }
sub Sym_Thai_sarau { 0xdd8 }
sub Sym_Thai_sarauu { 0xdd9 }
sub Sym_Thai_phinthu { 0xdda }
sub Sym_Thai_maihanakat_maitho { 0xdde }
sub Sym_Thai_baht { 0xddf }
sub Sym_Thai_sarae { 0xde0 }
sub Sym_Thai_saraae { 0xde1 }
sub Sym_Thai_sarao { 0xde2 }
sub Sym_Thai_saraaimaimuan { 0xde3 }
sub Sym_Thai_saraaimaimalai { 0xde4 }
sub Sym_Thai_lakkhangyao { 0xde5 }
sub Sym_Thai_maiyamok { 0xde6 }
sub Sym_Thai_maitaikhu { 0xde7 }
sub Sym_Thai_maiek { 0xde8 }
sub Sym_Thai_maitho { 0xde9 }
sub Sym_Thai_maitri { 0xdea }
sub Sym_Thai_maichattawa { 0xdeb }
sub Sym_Thai_thanthakhat { 0xdec }
sub Sym_Thai_nikhahit { 0xded }
sub Sym_Thai_leksun { 0xdf0 }
sub Sym_Thai_leknung { 0xdf1 }
sub Sym_Thai_leksong { 0xdf2 }
sub Sym_Thai_leksam { 0xdf3 }
sub Sym_Thai_leksi { 0xdf4 }
sub Sym_Thai_lekha { 0xdf5 }
sub Sym_Thai_lekhok { 0xdf6 }
sub Sym_Thai_lekchet { 0xdf7 }
sub Sym_Thai_lekpaet { 0xdf8 }
sub Sym_Thai_lekkao { 0xdf9 }
sub Sym_Hangul { 0xff31 }
sub Sym_Hangul_Start { 0xff32 }
sub Sym_Hangul_End { 0xff33 }
sub Sym_Hangul_Hanja { 0xff34 }
sub Sym_Hangul_Jamo { 0xff35 }
sub Sym_Hangul_Romaja { 0xff36 }
sub Sym_Hangul_Codeinput { 0xff37 }
sub Sym_Hangul_Jeonja { 0xff38 }
sub Sym_Hangul_Banja { 0xff39 }
sub Sym_Hangul_PreHanja { 0xff3a }
sub Sym_Hangul_PostHanja { 0xff3b }
sub Sym_Hangul_SingleCandidate { 0xff3c }
sub Sym_Hangul_MultipleCandidate { 0xff3d }
sub Sym_Hangul_PreviousCandidate { 0xff3e }
sub Sym_Hangul_Special { 0xff3f }
sub Sym_Hangul_switch { 0xFF7E }
sub Sym_Hangul_Kiyeog { 0xea1 }
sub Sym_Hangul_SsangKiyeog { 0xea2 }
sub Sym_Hangul_KiyeogSios { 0xea3 }
sub Sym_Hangul_Nieun { 0xea4 }
sub Sym_Hangul_NieunJieuj { 0xea5 }
sub Sym_Hangul_NieunHieuh { 0xea6 }
sub Sym_Hangul_Dikeud { 0xea7 }
sub Sym_Hangul_SsangDikeud { 0xea8 }
sub Sym_Hangul_Rieul { 0xea9 }
sub Sym_Hangul_RieulKiyeog { 0xeaa }
sub Sym_Hangul_RieulMieum { 0xeab }
sub Sym_Hangul_RieulPieub { 0xeac }
sub Sym_Hangul_RieulSios { 0xead }
sub Sym_Hangul_RieulTieut { 0xeae }
sub Sym_Hangul_RieulPhieuf { 0xeaf }
sub Sym_Hangul_RieulHieuh { 0xeb0 }
sub Sym_Hangul_Mieum { 0xeb1 }
sub Sym_Hangul_Pieub { 0xeb2 }
sub Sym_Hangul_SsangPieub { 0xeb3 }
sub Sym_Hangul_PieubSios { 0xeb4 }
sub Sym_Hangul_Sios { 0xeb5 }
sub Sym_Hangul_SsangSios { 0xeb6 }
sub Sym_Hangul_Ieung { 0xeb7 }
sub Sym_Hangul_Jieuj { 0xeb8 }
sub Sym_Hangul_SsangJieuj { 0xeb9 }
sub Sym_Hangul_Cieuc { 0xeba }
sub Sym_Hangul_Khieuq { 0xebb }
sub Sym_Hangul_Tieut { 0xebc }
sub Sym_Hangul_Phieuf { 0xebd }
sub Sym_Hangul_Hieuh { 0xebe }
sub Sym_Hangul_A { 0xebf }
sub Sym_Hangul_AE { 0xec0 }
sub Sym_Hangul_YA { 0xec1 }
sub Sym_Hangul_YAE { 0xec2 }
sub Sym_Hangul_EO { 0xec3 }
sub Sym_Hangul_E { 0xec4 }
sub Sym_Hangul_YEO { 0xec5 }
sub Sym_Hangul_YE { 0xec6 }
sub Sym_Hangul_O { 0xec7 }
sub Sym_Hangul_WA { 0xec8 }
sub Sym_Hangul_WAE { 0xec9 }
sub Sym_Hangul_OE { 0xeca }
sub Sym_Hangul_YO { 0xecb }
sub Sym_Hangul_U { 0xecc }
sub Sym_Hangul_WEO { 0xecd }
sub Sym_Hangul_WE { 0xece }
sub Sym_Hangul_WI { 0xecf }
sub Sym_Hangul_YU { 0xed0 }
sub Sym_Hangul_EU { 0xed1 }
sub Sym_Hangul_YI { 0xed2 }
sub Sym_Hangul_I { 0xed3 }
sub Sym_Hangul_J_Kiyeog { 0xed4 }
sub Sym_Hangul_J_SsangKiyeog { 0xed5 }
sub Sym_Hangul_J_KiyeogSios { 0xed6 }
sub Sym_Hangul_J_Nieun { 0xed7 }
sub Sym_Hangul_J_NieunJieuj { 0xed8 }
sub Sym_Hangul_J_NieunHieuh { 0xed9 }
sub Sym_Hangul_J_Dikeud { 0xeda }
sub Sym_Hangul_J_Rieul { 0xedb }
sub Sym_Hangul_J_RieulKiyeog { 0xedc }
sub Sym_Hangul_J_RieulMieum { 0xedd }
sub Sym_Hangul_J_RieulPieub { 0xede }
sub Sym_Hangul_J_RieulSios { 0xedf }
sub Sym_Hangul_J_RieulTieut { 0xee0 }
sub Sym_Hangul_J_RieulPhieuf { 0xee1 }
sub Sym_Hangul_J_RieulHieuh { 0xee2 }
sub Sym_Hangul_J_Mieum { 0xee3 }
sub Sym_Hangul_J_Pieub { 0xee4 }
sub Sym_Hangul_J_PieubSios { 0xee5 }
sub Sym_Hangul_J_Sios { 0xee6 }
sub Sym_Hangul_J_SsangSios { 0xee7 }
sub Sym_Hangul_J_Ieung { 0xee8 }
sub Sym_Hangul_J_Jieuj { 0xee9 }
sub Sym_Hangul_J_Cieuc { 0xeea }
sub Sym_Hangul_J_Khieuq { 0xeeb }
sub Sym_Hangul_J_Tieut { 0xeec }
sub Sym_Hangul_J_Phieuf { 0xeed }
sub Sym_Hangul_J_Hieuh { 0xeee }
sub Sym_Hangul_RieulYeorinHieuh { 0xeef }
sub Sym_Hangul_SunkyeongeumMieum { 0xef0 }
sub Sym_Hangul_SunkyeongeumPieub { 0xef1 }
sub Sym_Hangul_PanSios { 0xef2 }
sub Sym_Hangul_KkogjiDalrinIeung { 0xef3 }
sub Sym_Hangul_SunkyeongeumPhieuf { 0xef4 }
sub Sym_Hangul_YeorinHieuh { 0xef5 }
sub Sym_Hangul_AraeA { 0xef6 }
sub Sym_Hangul_AraeAE { 0xef7 }
sub Sym_Hangul_J_PanSios { 0xef8 }
sub Sym_Hangul_J_KkogjiDalrinIeung { 0xef9 }
sub Sym_Hangul_J_YeorinHieuh { 0xefa }
sub Sym_Korean_Won { 0xeff }
sub Sym_EcuSign { 0x20a0 }
sub Sym_ColonSign { 0x20a1 }
sub Sym_CruzeiroSign { 0x20a2 }
sub Sym_FFrancSign { 0x20a3 }
sub Sym_LiraSign { 0x20a4 }
sub Sym_MillSign { 0x20a5 }
sub Sym_NairaSign { 0x20a6 }
sub Sym_PesetaSign { 0x20a7 }
sub Sym_RupeeSign { 0x20a8 }
sub Sym_WonSign { 0x20a9 }
sub Sym_NewSheqelSign { 0x20aa }
sub Sym_DongSign { 0x20ab }
sub Sym_EuroSign { 0x20ac }

1;



