package utf8;

$^U = 1 if caller and caller eq 'main';	# they are unicode aware
					# XXX split this out?

sub import {
    $^H |= 0x00800000;
    $enc{caller()} = $_[1] if $_[1];
}

sub unimport {
    $^H &= ~0x00800000;
}

sub AUTOLOAD {
    require "utf8_heavy.pl";
    goto &$AUTOLOAD;
}

1;
__END__

=head1 NAME

utf8 - Perl pragma to enable/disable UTF-8 in source code

=head1 SYNOPSIS

    use utf8;
    no utf8;

=head1 DESCRIPTION

WARNING: The implementation of Unicode support in Perl is incomplete.
Expect sudden and unannounced changes!

The C<use utf8> pragma tells the Perl parser to allow UTF-8 in the
program text in the current lexical scope.  The C<no utf8> pragma
tells Perl to switch back to treating the source text as literal
bytes in the current lexical scope.

This pragma is primarily a compatibility device.  Perl versions
earlier than 5.6 allowed arbitrary bytes in source code, whereas
in future we would like to standardize on the UTF-8 encoding for
source text.  Until UTF-8 becomes the default format for source
text, this pragma should be used to recognize UTF-8 in the source.
When UTF-8 becomes the standard source format, this pragma will
effectively become a no-op.

Enabling the C<utf8> pragma has the following effects:

=over

=item *

Bytes in the source text that have their high-bit set will be treated
as being part of a literal UTF-8 character.  This includes most literals
such as identifiers, string constants, constant regular expression patterns
and package names.

=item *

As a side effect, when this pragma is used within the main package,
it also enables Unicode character semantics for the entire program.
See L<perlunicode> for more on that.

[XXX: split this out into separate "pragma" and/or -C command-line
switch?]

=item *

In the absence of inputs marked as UTF-8, regular expressions within the
scope of this pragma will default to using character semantics instead
of byte semantics.

    @bytes_or_chars = split //, $data;	# may split to bytes if data
					# $data isn't UTF-8
    {
	use utf8;			# force char semantics
	@chars = split //, $data;	# splits characters
    }

[XXX: Should this should be enabled like chr()/sprintf("%c") by looking
at $^U instead?]

=head1 SEE ALSO

L<perlunicode>, L<byte>

=cut
