#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.06';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 65 => 0x69 },
	'about' => { 252 => 'about' },
	'abspeakaudiofilepath' => { 258 => 'absPeakAudioFilePath' },
	'accessorytype' => { 195 => 0x53 },
	'actionadvised' => { 76 => 0x2a },
	'activearea' => { 70 => 0xc68d },
	'actived-lighting' => { 137 => 0x22, 163 => 0x24 },
	'actived-lightingmode' => { 163 => 0x25 },
	'addaspectratioinfo' => { 47 => 0x80e },
	'additionalmodelinformation' => { 245 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 47 => 0x80f, 48 => 0x11, 49 => 0x13, 52 => 0x14 },
	'address' => { 101 => 'Address' },
	'adjustmentmode' => { 224 => 0x15 },
	'adultcontentwarning' => { 248 => 'AdultContentWarning', 251 => 'adultContentWarning' },
	'advancedraw' => { 165 => 0x76a43203 },
	'advancedscenemode' => { 195 => 0x3d },
	'advisory' => { 256 => 'Advisory' },
	'ae_iso' => { 198 => 0x2 },
	'aeaperture' => { 198 => 0x1 },
	'aebautocancel' => { 47 => 0x104 },
	'aebbracketvalue' => { 42 => 0x11 },
	'aebsequence' => { 47 => 0x105 },
	'aebsequenceautocancel' => { 45 => 0x9, 46 => 0x9, 48 => 0x8, 49 => 0x9, 52 => 0x9, 53 => 0x7 },
	'aebshotcount' => { 47 => 0x106 },
	'aebxv' => { 198 => 0x4 },
	'aeexposuretime' => { 198 => 0x0 },
	'aeextra' => { 198 => 0x7 },
	'aelbutton' => { 113 => 0x45 },
	'aelexposureindicator' => { 113 => 0x51 },
	'aelock' => { 113 => 0x5b, 173 => '4.2', 175 => '4.2', 177 => 0x201, 209 => 0x48 },
	'aelockbutton' => { 172 => '16.1', 173 => '4.1', 174 => '15.1', 175 => '4.1', 176 => '17.1' },
	'aelockbuttonplusdials' => { 172 => '16.2' },
	'aelockformb-d80' => { 176 => '3.1' },
	'aemaxaperture' => { 198 => 0x9 },
	'aemaxaperture2' => { 198 => 0xa },
	'aemeteringmode' => { 198 => 0xc },
	'aemeteringsegments' => { 209 => 0x209 },
	'aemicroadjustment' => { 47 => 0x111 },
	'aeminaperture' => { 198 => 0xb },
	'aeminexposuretime' => { 198 => 0x5 },
	'aeprogrammode' => { 198 => 0x6 },
	'aesetting' => { 20 => 0x21 },
	'aexv' => { 198 => 0x3 },
	'af-cpriorityselection' => { 172 => '1.1' },
	'af-onformb-d10' => { 172 => '3.3' },
	'af-spriorityselection' => { 172 => '1.2' },
	'afactivation' => { 172 => '2.1' },
	'afadjustment' => { 209 => 0x72 },
	'afaperture' => { 135 => 0x5, 136 => 0x5 },
	'afareaheight' => { 119 => 0x1a },
	'afareaillumination' => { 113 => 0x4b, 175 => '15.3' },
	'afareamode' => { 113 => 0xe, 118 => 0x0, 119 => 0x5, 195 => 0xf, 225 => 0x11, 226 => 0x11 },
	'afareamodesetting' => { 173 => '11.1', 174 => '0.1', 175 => '16.1', 176 => '2.1' },
	'afareas' => { 177 => 0x304 },
	'afareawidth' => { 119 => 0x18 },
	'afareaxposition' => { 119 => 0x14 },
	'afareayposition' => { 119 => 0x16 },
	'afassist' => { 45 => 0x5, 53 => 0x5, 113 => 0x48, 172 => '2.5', 173 => '0.2', 174 => '0.2', 175 => '0.2', 176 => '2.3' },
	'afassistbeam' => { 47 => 0x50e, 48 => 0x4, 49 => 0x5, 50 => 0x4, 51 => 0x4, 52 => 0x5 },
	'afassistlamp' => { 195 => 0x31 },
	'afdefocus' => { 199 => 0x6 },
	'afduringliveview' => { 47 => 0x511 },
	'affinetune' => { 120 => 0x0 },
	'affinetuneadj' => { 120 => 0x2, 145 => 0x2d1, 146 => 0x2dc, 177 => 0x307 },
	'affinetuneindex' => { 120 => 0x1 },
	'afilluminator' => { 225 => 0x29 },
	'afimageheight' => { 119 => 0x12 },
	'afimagewidth' => { 119 => 0x10 },
	'afintegrationtime' => { 199 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 47 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 67 => 0x3009, 224 => 0x5 },
	'afonaelockbuttonswitch' => { 47 => 0x702 },
	'afonbutton' => { 172 => '3.1' },
	'afpoint' => { 20 => 0x13, 66 => 0x18, 118 => 0x1, 180 => 0x308, 224 => 0x1f },
	'afpointactivationarea' => { 46 => 0x11, 52 => 0x11 },
	'afpointareaexpansion' => { 47 => 0x508 },
	'afpointautoselection' => { 47 => 0x50b },
	'afpointbrightness' => { 47 => 0x50d, 172 => '2.4' },
	'afpointdisplayduringfocus' => { 47 => 0x50c },
	'afpointillumination' => { 46 => 0xa, 172 => '2.3', 176 => '2.4' },
	'afpointmode' => { 202 => 0x3 },
	'afpointposition' => { 67 => 0x2021, 195 => 0x4d },
	'afpointregistration' => { 45 => 0x7 },
	'afpoints' => { 112 => 0x10 },
	'afpointselected' => { 177 => 0x305, 209 => 0xe },
	'afpointselected2' => { 202 => 0x4 },
	'afpointselection' => { 46 => 0xb, 172 => '1.3' },
	'afpointselectionmethod' => { 47 => 0x50f, 48 => 0xc, 49 => 0xd, 52 => 0xd },
	'afpointsinfocus' => { 42 => 0xe, 118 => 0x2, 199 => 0xb, 209 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 13 => 0x38 },
	'afpointspotmetering' => { 46 => 0xd },
	'afpointsunknown1' => { 199 => 0x0 },
	'afpointsunknown2' => { 199 => 0x2 },
	'afpointsused' => { 119 => 0x8 },
	'afpredictor' => { 199 => 0x4 },
	'afresponse' => { 137 => 0xad },
	'afresult' => { 182 => 0x1038 },
	'afsearch' => { 177 => 0x303 },
	'afwithshutter' => { 225 => 0x2a },
	'aggregationtype' => { 249 => 'aggregationType' },
	'agreement' => { 251 => 'agreement' },
	'aiservocontinuousshooting' => { 46 => 0x15 },
	'aiservoimagepriority' => { 47 => 0x503 },
	'aiservotrackingmethod' => { 47 => 0x504 },
	'aiservotrackingsensitivity' => { 46 => 0x14, 47 => 0x502 },
	'album' => { 258 => 'album' },
	'alreadyapplied' => { 239 => 'AlreadyApplied' },
	'alternatetitle' => { 249 => 'alternateTitle' },
	'alttapename' => { 258 => 'altTapeName' },
	'alttimecodetimeformat' => { 258 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 258 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 258 => 'altTimecodeValue' },
	'anti-blur' => { 227 => 0xb04b },
	'antialiasstrength' => { 70 => 0xc632 },
	'aperturerange' => { 47 => 0x10d },
	'apertureringuse' => { 202 => '1.4' },
	'aperturevalue' => { 56 => 0x2, 70 => 0x9202, 182 => 0x1002, 243 => 'ApertureValue' },
	'applekeywords' => { 186 => 'AAPL:Keywords' },
	'applicationnotes' => { 70 => 0x2bc, 197 => 0x2bc },
	'applicationrecordversion' => { 76 => 0x0 },
	'applyshootingmeteringmode' => { 47 => 0x10e },
	'approximatefnumber' => { 191 => 0x313 },
	'armidentifier' => { 77 => 0x78 },
	'armversion' => { 77 => 0x7a },
	'artfilter' => { 177 => 0x529 },
	'artist' => { 70 => 0x13b, 188 => 'Artist', 254 => 'Artist', 258 => 'artist' },
	'artworkcopyrightnotice' => { 245 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 245 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 245 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 245 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 245 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 245 => 'ArtworkOrObjectAOTitle' },
	'aspectframe' => { 181 => 0x1113 },
	'aspectratio' => { 181 => 0x1112, 225 => 0x55 },
	'asshoticcprofile' => { 70 => 0xc68f },
	'asshotneutral' => { 70 => 0xc628 },
	'asshotpreprofilematrix' => { 70 => 0xc690 },
	'asshotprofilename' => { 70 => 0xc6f6 },
	'asshotwhitexy' => { 70 => 0xc629 },
	'assignfuncbutton' => { 47 => 0x70b },
	'assistbuttonfunction' => { 45 => 0xd },
	'attributionname' => { 238 => 'attributionName' },
	'attributionurl' => { 238 => 'attributionURL' },
	'audio' => { 195 => 0x20 },
	'audiochanneltype' => { 258 => 'audioChannelType' },
	'audiocompression' => { 95 => 'Compression' },
	'audiocompressor' => { 258 => 'audioCompressor' },
	'audioduration' => { 76 => 0x99 },
	'audiomoddate' => { 258 => 'audioModDate' },
	'audiooutcue' => { 76 => 0x9a },
	'audiosamplerate' => { 258 => 'audioSampleRate' },
	'audiosampletype' => { 258 => 'audioSampleType' },
	'audiosamplingrate' => { 76 => 0x97 },
	'audiosamplingresolution' => { 76 => 0x98 },
	'audiotype' => { 76 => 0x96 },
	'author' => { 97 => 'Author', 186 => 'Author', 188 => 'Author', 217 => 'Author', 236 => 'author', 246 => 'Author' },
	'authorsposition' => { 247 => 'AuthorsPosition' },
	'autoaperture' => { 206 => '0.1' },
	'autobracket' => { 224 => 0x19 },
	'autobracketing' => { 74 => 0x1100, 209 => 0x18 },
	'autobracketmodem' => { 172 => '21.2' },
	'autobracketorder' => { 113 => 0x43, 172 => '21.3', 175 => '2.2', 176 => '13.2' },
	'autobracketset' => { 172 => '21.1', 174 => '11.1', 175 => '2.1', 176 => '13.1' },
	'autobrightness' => { 239 => 'AutoBrightness' },
	'autocontrast' => { 239 => 'AutoContrast' },
	'autodistortioncontrol' => { 127 => 0x4 },
	'autoexposure' => { 239 => 'AutoExposure' },
	'autoexposurebracketing' => { 42 => 0x10 },
	'autofocus' => { 180 => 0x209 },
	'autofp' => { 175 => '7.3', 176 => '31.4' },
	'autohdr' => { 227 => 0x200a },
	'autoiso' => { 42 => 0x1, 67 => 0x3008, 173 => '1.1', 175 => '1.1' },
	'autoisomax' => { 173 => '1.2', 175 => '1.2' },
	'autoisominshutterspeed' => { 173 => '1.3', 175 => '1.3' },
	'autolightingoptimizer' => { 10 => 0xbe, 11 => 0xbf, 14 => 0xbf, 33 => 0x2, 47 => 0x204, 65 => 0x6f },
	'autolightingoptimizeron' => { 65 => 0x6e },
	'autoredeye' => { 165 => 0xfe28a44f },
	'autorotate' => { 42 => 0x1b },
	'autoshadows' => { 239 => 'AutoShadows' },
	'auxiliarylens' => { 137 => 0x82 },
	'avaperturesetting' => { 202 => 0x13 },
	'avsettingwithoutlens' => { 47 => 0x707 },
	'azimuth' => { 105 => 'Azimuth' },
	'babyage' => { 195 => [0x8010,0x33] },
	'backgroundalpha' => { 253 => 'bgalpha' },
	'baseexposurecompensation' => { 202 => 0x15 },
	'baseiso' => { 42 => 0x2, 60 => 0x101c },
	'baselineexposure' => { 70 => 0xc62a },
	'baselinenoise' => { 70 => 0xc62b },
	'baselinesharpness' => { 70 => 0xc62c },
	'baseurl' => { 256 => 'BaseURL' },
	'batteryadbodyload' => { 200 => 0x3 },
	'batteryadbodynoload' => { 200 => 0x2 },
	'batteryadgripload' => { 200 => 0x5 },
	'batteryadgripnoload' => { 200 => 0x4 },
	'batterylevel' => { 113 => 0x60 },
	'batteryorder' => { 172 => '12.5' },
	'batterystates' => { 200 => 0x1 },
	'bayergreensplit' => { 70 => 0xc62d },
	'bayerpattern' => { 80 => 0xf902, 115 => 0x17 },
	'beatspliceparamsriseindecibel' => { 258 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 258 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 258 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 258 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 172 => '13.1', 173 => '0.1', 174 => '2.1', 175 => '0.1', 176 => '4.1' },
	'bestqualityscale' => { 70 => 0xc65c },
	'bestshotmode' => { 67 => 0x3007 },
	'bitdepth' => { 102 => 'BitDepth', 115 => 0x11, 142 => 0x41 },
	'bitspercomponent' => { 78 => 0x87 },
	'bitspersample' => { 70 => 0x102, 254 => 'BitsPerSample' },
	'blacklevel' => { 70 => 0xc61a, 182 => 0x1012 },
	'blacklevel2' => { 181 => 0x600, 185 => 0x600 },
	'blackpoint' => { 209 => 0x200 },
	'bluebalance' => { 126 => 0x271, 182 => 0x1018, 197 => 0x12, 209 => 0x1b },
	'bluecurvelimits' => { 64 => 0x1fe },
	'bluecurvepoints' => { 64 => 0x1d4 },
	'bluehue' => { 239 => 'BlueHue' },
	'bluesaturation' => { 239 => 'BlueSaturation' },
	'blurwarning' => { 74 => 0x1300 },
	'bodyfirmware' => { 220 => 0x0 },
	'bodyfirmwareversion' => { 178 => 0x104, 179 => 0x100, 182 => 0x104 },
	'bodyserialnumber' => { 220 => 0x10 },
	'bracketmode' => { 30 => 0x3 },
	'bracketsequence' => { 67 => 0x301d },
	'bracketshotnumber' => { 30 => 0x5, 202 => 0x9 },
	'bracketstep' => { 110 => 0xe },
	'bracketvalue' => { 30 => 0x4 },
	'brightness' => { 70 => 0xfe53, 96 => 'Brightness', 110 => 0x2c, 139 => 0x34, 225 => 0x22, 239 => 'Brightness' },
	'brightnessadj' => { 64 => 0x114, 158 => 0x0, 168 => 0x2d, 229 => 0x8018 },
	'brightnessvalue' => { 70 => 0x9203, 182 => 0x1003, 243 => 'BrightnessValue' },
	'bulbduration' => { 42 => 0x18 },
	'burstmode' => { 83 => 0xa, 195 => 0x2a },
	'burstmode2' => { 83 => 0x18 },
	'buttonfunctioncontroloff' => { 47 => 0x70a },
	'bwfilter' => { 110 => 0x2a, 116 => 0x39 },
	'bwmode' => { 182 => 0x203 },
	'by-line' => { 76 => 0x50 },
	'by-linetitle' => { 76 => 0x55 },
	'bytecount' => { 249 => 'byteCount' },
	'calibration' => { 224 => 0x24 },
	'calibrationilluminant1' => { 70 => 0xc65a },
	'calibrationilluminant2' => { 70 => 0xc65b },
	'cameracalibrationsig' => { 70 => 0xc6f3 },
	'cameracolorcalibration01' => { 22 => 0x4b, 23 => 0xa4, 24 => 0x85, 25 => 0xa8, 26 => 0xba },
	'cameracolorcalibration02' => { 22 => 0x4f, 23 => 0xa8, 24 => 0x89, 25 => 0xac, 26 => 0xbf },
	'cameracolorcalibration03' => { 22 => 0x53, 23 => 0xac, 24 => 0x8d, 25 => 0xb0, 26 => 0xc4 },
	'cameracolorcalibration04' => { 22 => 0x57, 23 => 0xb0, 24 => 0x91, 25 => 0xb4, 26 => 0xc9 },
	'cameracolorcalibration05' => { 22 => 0x5b, 23 => 0xb4, 24 => 0x95, 25 => 0xb8, 26 => 0xce },
	'cameracolorcalibration06' => { 22 => 0x5f, 23 => 0xb8, 24 => 0x99, 25 => 0xbc, 26 => 0xd3 },
	'cameracolorcalibration07' => { 22 => 0x63, 23 => 0xbc, 24 => 0x9d, 25 => 0xc0, 26 => 0xd8 },
	'cameracolorcalibration08' => { 22 => 0x67, 23 => 0xc0, 24 => 0xa1, 25 => 0xc4, 26 => 0xdd },
	'cameracolorcalibration09' => { 22 => 0x6b, 23 => 0xc4, 24 => 0xa5, 25 => 0xc8, 26 => 0xe2 },
	'cameracolorcalibration10' => { 22 => 0x6f, 23 => 0xc8, 24 => 0xa9, 25 => 0xcc, 26 => 0xe7 },
	'cameracolorcalibration11' => { 22 => 0x73, 23 => 0xcc, 24 => 0xad, 25 => 0xd0, 26 => 0xec },
	'cameracolorcalibration12' => { 22 => 0x77, 23 => 0xd0, 24 => 0xb1, 25 => 0xd4, 26 => 0xf1 },
	'cameracolorcalibration13' => { 22 => 0x7b, 23 => 0xd4, 24 => 0xb5, 25 => 0xd8, 26 => 0xf6 },
	'cameracolorcalibration14' => { 22 => 0x7f, 23 => 0xd8, 24 => 0xb9, 25 => 0xdc, 26 => 0xfb },
	'cameracolorcalibration15' => { 22 => 0x83, 23 => 0xdc, 24 => 0xbd, 25 => 0xe0, 26 => 0x100 },
	'cameraid' => { 182 => 0x209, 223 => 0x209 },
	'cameraiso' => { 20 => 0x10 },
	'cameraorientation' => { 2 => 0x30, 5 => 0x30, 7 => 0x35, 8 => 0x30, 9 => 0x30, 10 => 0x31, 11 => 0x31, 12 => 0x35, 13 => 0x27, 14 => 0x31, 16 => 0x11 },
	'cameraparameters' => { 182 => 0x2050 },
	'cameraprofile' => { 239 => 'CameraProfile' },
	'cameraprofiledigest' => { 239 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 70 => 0xc62f, 235 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 177 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x19, 8 => 0x18, 9 => 0x18, 10 => 0x19, 11 => 0x19, 12 => 0x19, 13 => 0x17, 14 => 0x19, 15 => 0x19, 17 => [0x87,0x91], 18 => [0x99,0x9f,0xa4,0xa8], 19 => [0x64,0x47,0x53,0x5b,0x5c], 191 => 0x320, 209 => 0x47, 222 => 0x43 },
	'cameratype' => { 42 => 0x1a, 182 => 0x207 },
	'cameratype2' => { 178 => 0x100 },
	'canonexposuremode' => { 20 => 0x14 },
	'canonfiledescription' => { 60 => 0x805 },
	'canonfilelength' => { 34 => 0xe },
	'canonfirmwareversion' => { 34 => 0x7, 60 => 0x80b },
	'canonflashinfo' => { 60 => 0x1028 },
	'canonflashmode' => { 20 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 20 => 0xa },
	'canonimagetype' => { 34 => 0x6, 60 => 0x815 },
	'canonmodelid' => { 34 => 0x10, 60 => 0x1834 },
	'canonvrd' => { 71 => 'CanonVRD' },
	'caption' => { 236 => 'caption' },
	'caption-abstract' => { 76 => 0x78 },
	'captionsauthornames' => { 242 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 242 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 247 => 'CaptionWriter' },
	'captureframerate' => { 67 => 0x4001 },
	'cardshutterlock' => { 113 => 0x49 },
	'casioimagesize' => { 67 => 0x9 },
	'catalogsets' => { 234 => 'CatalogSets' },
	'categories' => { 34 => 0x23, 236 => 'categories' },
	'category' => { 76 => 0xf, 247 => 'Category' },
	'ccdboardversion' => { 191 => 0x331 },
	'ccdscanmode' => { 182 => 0x1039 },
	'ccdsensitivity' => { 155 => 0x6 },
	'ccdversion' => { 191 => 0x330 },
	'celllength' => { 70 => 0x109 },
	'cellwidth' => { 70 => 0x108 },
	'centerafarea' => { 175 => '15.1' },
	'centerfocuspoint' => { 176 => '2.2' },
	'centerweightedareasize' => { 172 => '7.1', 175 => '6.3', 176 => '8.1' },
	'certificate' => { 262 => 'Certificate' },
	'cfapattern' => { 70 => 0xa302 },
	'cfapatterncolumns' => { 243 => 'CFAPatternColumns' },
	'cfapatternrows' => { 243 => 'CFAPatternRows' },
	'cfapatternvalues' => { 243 => 'CFAPatternValues' },
	'channel' => { 249 => 'channel' },
	'channels' => { 95 => 'Channels' },
	'checkmark' => { 64 => 0x26a },
	'childfontfiles' => { 263 => 'FontsChildFontFiles' },
	'chmodeshootingspeed' => { 172 => '10.3' },
	'chromablurradius' => { 70 => 0xc631 },
	'chromaticaberration' => { 65 => 0x66 },
	'chromaticaberrationb' => { 239 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 65 => 0x6b },
	'chromaticaberrationon' => { 65 => 0x62 },
	'chromaticaberrationr' => { 239 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 65 => 0x6a },
	'chrominancenoisereduction' => { 65 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 65 => 0x60 },
	'city' => { 76 => 0x5a, 101 => 'City', 195 => 0x6d, 247 => 'City' },
	'clarity' => { 239 => 'Clarity' },
	'classifystate' => { 76 => 0xe1 },
	'clmodeshootingspeed' => { 172 => '10.2', 176 => '11.1' },
	'cmcontrast' => { 185 => 0x2022 },
	'cmexposurecompensation' => { 185 => 0x2000 },
	'cmhue' => { 185 => 0x2021 },
	'cmsaturation' => { 185 => 0x2020 },
	'cmsharpness' => { 185 => 0x2023 },
	'cmwhitebalance' => { 185 => 0x2001 },
	'cmwhitebalancecomp' => { 185 => 0x2002 },
	'cmwhitebalancegraypoint' => { 185 => 0x2010 },
	'codec' => { 109 => 'Codec' },
	'codedcharacterset' => { 77 => 0x5a },
	'coloraberrationcontrol' => { 165 => 0xc89224b },
	'coloradjustment' => { 224 => 0x14 },
	'coloradjustmentmode' => { 223 => 0x210 },
	'coloranta' => { 263 => 'ColorantsA' },
	'colorantb' => { 263 => 'ColorantsB' },
	'colorantblack' => { 263 => 'ColorantsBlack' },
	'colorantblue' => { 263 => 'ColorantsBlue' },
	'colorantcyan' => { 263 => 'ColorantsCyan' },
	'colorantgreen' => { 263 => 'ColorantsGreen' },
	'colorantl' => { 263 => 'ColorantsL' },
	'colorantmagenta' => { 263 => 'ColorantsMagenta' },
	'colorantmode' => { 263 => 'ColorantsMode' },
	'colorantred' => { 263 => 'ColorantsRed' },
	'colorantswatchname' => { 263 => 'ColorantsSwatchName' },
	'coloranttype' => { 263 => 'ColorantsType' },
	'colorantyellow' => { 263 => 'ColorantsYellow' },
	'colorbalance' => { 96 => 'ColorBalance' },
	'colorbalanceadj' => { 165 => 0x76a43202 },
	'colorbalanceblue' => { 110 => 0x1e },
	'colorbalancegreen' => { 110 => 0x1d },
	'colorbalancered' => { 110 => 0x1c },
	'colorblur' => { 65 => 0x65 },
	'colorbooster' => { 165 => 0x5f0e7d23 },
	'colorboostlevel' => { 159 => 0x1 },
	'colorboosttype' => { 159 => 0x0 },
	'colorclass' => { 212 => 0xde },
	'colorcompensationfilter' => { 113 => [0x3a,0x5f], 114 => 0x111, 227 => 0xb022 },
	'colorcontrol' => { 182 => 0x102b },
	'colorcorrection' => { 229 => 0x8015 },
	'colordataversion' => { 24 => 0x0, 25 => 0x0 },
	'coloreffect' => { 195 => 0x28 },
	'colorfilter' => { 66 => 0x17, 67 => 0x3017, 110 => 0x29, 116 => 0x38, 211 => 0x17 },
	'colorgain' => { 142 => 0x51 },
	'colorhue' => { 137 => 0x8d },
	'colorimetricreference' => { 70 => 0xc6bf },
	'colormatrix' => { 181 => 0x200, 182 => 0x1011 },
	'colormatrix2' => { 185 => 0x200 },
	'colormatrixa' => { 209 => 0x203 },
	'colormatrixb' => { 209 => 0x204 },
	'colormatrixnumber' => { 182 => 0x1019 },
	'colormode' => { 67 => 0x3015, 74 => 0x1210, 83 => 0x66, 110 => 0x28, 113 => 0x16, 114 => 0x101, 116 => 0x7, 137 => 0x3, 155 => 0x4, 195 => 0x32, 227 => 0xb029, 247 => 'ColorMode' },
	'colormoirereduction' => { 166 => 0x15 },
	'colormoirereductionmode' => { 166 => 0x5 },
	'colornoisereduction' => { 229 => 0x8029, 239 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 166 => 0x18 },
	'colornoisereductionsharpness' => { 166 => 0x1c },
	'colorplanes' => { 73 => 0x2 },
	'colorprofile' => { 110 => 0x33 },
	'colorrepresentation' => { 78 => 0x3c },
	'colorreproduction' => { 227 => 0xb020 },
	'colorsequence' => { 78 => 0x41 },
	'colorspace' => { 27 => 0x3, 34 => 0xb4, 60 => 0x10b4, 70 => 0xa001, 102 => 'ColorSpace', 111 => 0x2f, 112 => 0x25, 113 => 0x17, 137 => 0x1e, 177 => 0x507, 209 => 0x37, 224 => 0xb, 243 => 'ColorSpace' },
	'colortempasshot' => { 22 => 0x1d, 23 => 0x26, 24 => 0x43, 25 => 0x43, 26 => 0x4b },
	'colortempauto' => { 22 => 0x22, 23 => 0x1c, 24 => 0x48, 25 => 0x48, 26 => 0x50 },
	'colortempcloudy' => { 22 => 0x31, 23 => 0x35, 24 => 0x5c, 25 => 0x61, 26 => 0x69 },
	'colortempcustom' => { 24 => 0x84 },
	'colortempcustom1' => { 22 => 0x45 },
	'colortempcustom2' => { 22 => 0x4a },
	'colortempdaylight' => { 22 => 0x27, 23 => 0x2b, 24 => 0x52, 25 => 0x57, 26 => 0x5f },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 8 => 0x73, 9 => 0x73, 10 => 0x77, 11 => 0x73, 12 => 0x7c, 13 => 0x58, 14 => 0x73, 16 => 0x57, 34 => 0xae, 40 => 0x9, 60 => 0x10ae, 74 => 0x1005, 81 => 0x846, 96 => 'ColorTemperature', 111 => [0x6e,0x49], 112 => 0x3f, 113 => [0x39,0x5e], 114 => 0x10b, 116 => 0x3c, 191 => 0x321, 209 => 0x50, 227 => 0xb021 },
	'colortemperatureadj' => { 229 => 0x8013 },
	'colortemperaturebg' => { 182 => 0x1013 },
	'colortemperaturerg' => { 182 => 0x1014 },
	'colortemperaturesetting' => { 113 => 0x25 },
	'colortempflash' => { 22 => 0x40, 23 => 0x49, 24 => 0x70, 25 => 0x75, 26 => 0x7d },
	'colortempflashdata' => { 24 => 0x24a },
	'colortempfluorescent' => { 22 => 0x3b, 23 => 0x3f, 24 => 0x66, 25 => 0x6b, 26 => 0x73 },
	'colortempkelvin' => { 23 => 0x44, 24 => 0x6b, 25 => 0x70, 26 => 0x78 },
	'colortempmeasured' => { 24 => 0x4d, 25 => 0x4d, 26 => 0x55 },
	'colortemppc1' => { 23 => 0x94, 24 => 0x75 },
	'colortemppc2' => { 23 => 0x99, 24 => 0x7a },
	'colortemppc3' => { 23 => 0x9e, 24 => 0x7f },
	'colortempshade' => { 22 => 0x2c, 23 => 0x30, 24 => 0x57, 25 => 0x5c, 26 => 0x64 },
	'colortemptungsten' => { 22 => 0x36, 23 => 0x3a, 24 => 0x61, 25 => 0x66, 26 => 0x6e },
	'colortempunknown' => { 23 => 0x21, 25 => 0x52, 26 => 0x5a },
	'colortempunknown10' => { 23 => 0x76, 25 => 0xa2, 26 => 0xaa },
	'colortempunknown11' => { 23 => 0x7b, 25 => 0xa7, 26 => 0xaf },
	'colortempunknown12' => { 23 => 0x80, 26 => 0xb4 },
	'colortempunknown13' => { 23 => 0x85, 26 => 0xb9 },
	'colortempunknown14' => { 23 => 0x8a },
	'colortempunknown15' => { 23 => 0x8f },
	'colortempunknown16' => { 23 => 0xa3 },
	'colortempunknown2' => { 23 => 0x4e, 25 => 0x7a, 26 => 0x82 },
	'colortempunknown3' => { 23 => 0x53, 25 => 0x7f, 26 => 0x87 },
	'colortempunknown4' => { 23 => 0x58, 25 => 0x84, 26 => 0x8c },
	'colortempunknown5' => { 23 => 0x5d, 25 => 0x89, 26 => 0x91 },
	'colortempunknown6' => { 23 => 0x62, 25 => 0x8e, 26 => 0x96 },
	'colortempunknown7' => { 23 => 0x67, 25 => 0x93, 26 => 0x9b },
	'colortempunknown8' => { 23 => 0x6c, 25 => 0x98, 26 => 0xa0 },
	'colortempunknown9' => { 23 => 0x71, 25 => 0x9d, 26 => 0xa5 },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 20 => 0x2a, 27 => 0x2 },
	'colortoneadj' => { 64 => 0x11e },
	'colortonefaithful' => { 13 => 0x107 },
	'colortonelandscape' => { 13 => 0x105 },
	'colortoneneutral' => { 13 => 0x106 },
	'colortoneportrait' => { 13 => 0x104 },
	'colortonestandard' => { 13 => 0x103 },
	'colortoneuserdef1' => { 13 => 0x109 },
	'colortoneuserdef2' => { 13 => 0x10a },
	'colortoneuserdef3' => { 13 => 0x10b },
	'commanddials' => { 175 => '5.1' },
	'commanddialsaperturesetting' => { 172 => '17.3' },
	'commanddialschangemainsub' => { 172 => '17.2' },
	'commanddialsmenuandplayback' => { 172 => '17.4' },
	'commanddialsreverserotation' => { 172 => '17.1', 174 => '16.2', 176 => '18.1' },
	'commanderchannel' => { 175 => '10.2' },
	'commandergroupa_manualoutput' => { 175 => '13.2' },
	'commandergroupa_ttl-aacomp' => { 175 => '13.1' },
	'commandergroupa_ttlcomp' => { 176 => '32.1' },
	'commandergroupamode' => { 175 => '11.2' },
	'commandergroupb_manualoutput' => { 175 => '14.2' },
	'commandergroupb_ttl-aacomp' => { 175 => '14.1' },
	'commandergroupb_ttlcomp' => { 176 => '33.1' },
	'commandergroupbmode' => { 175 => '11.3' },
	'commanderinternalflash' => { 175 => '11.1' },
	'commanderinternalmanualoutput' => { 175 => '12.2' },
	'commanderinternalttlcomp' => { 175 => '12.1', 176 => '31.2' },
	'comment' => { 0 => 0x2, 71 => 'Comment', 97 => 'Comment', 188 => 'Comment' },
	'complianceprofile' => { 249 => 'complianceProfile' },
	'componentsconfiguration' => { 70 => 0x9101, 102 => 'Components', 243 => 'ComponentsConfiguration' },
	'componentversion' => { 60 => 0x80c },
	'composer' => { 258 => 'composer' },
	'compressedbitsperpixel' => { 70 => 0x9102, 243 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 114 => 0x40, 182 => 0x40 },
	'compression' => { 70 => 0x103, 254 => 'Compression' },
	'compressionfactor' => { 177 => 0x50d },
	'compressionratio' => { 102 => 'Compression', 182 => 0x1034 },
	'constrainedcropheight' => { 64 => 0x266, 212 => 0xd6 },
	'constrainedcropwidth' => { 64 => 0x262, 212 => 0xd5 },
	'contact' => { 76 => 0x76 },
	'contentlocationcode' => { 76 => 0x1a },
	'contentlocationname' => { 76 => 0x1b },
	'continuousbracketing' => { 113 => 0x20 },
	'continuousdrive' => { 20 => 0x5 },
	'continuousshootingspeed' => { 47 => 0x610 },
	'continuousshotlimit' => { 47 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 20 => 0xd, 66 => 0xc, 67 => [0x3012,0x20], 70 => [0xa408,0xfe54], 74 => [0x1004,0x1006], 96 => 'Contrast', 110 => 0x20, 111 => 0x31, 112 => 0x27, 113 => 0x19, 116 => 0x2, 139 => 0x33, 182 => 0x1029, 195 => 0x39, 209 => 0x20, 211 => 0xc, 224 => 0xd, 225 => 0x1d, 226 => 0x1a, 239 => 'Contrast', 243 => 'Contrast' },
	'contrastadj' => { 64 => 0x115, 168 => 0x2c, 229 => 0x8017 },
	'contrastdetectaf' => { 119 => 0x4 },
	'contrastdetectafinfocus' => { 119 => 0x1c },
	'contrastfaithful' => { 13 => 0xec },
	'contrastlandscape' => { 13 => 0xea },
	'contrastmode' => { 195 => 0x2c },
	'contrastmonochrome' => { 13 => 0xed },
	'contrastneutral' => { 13 => 0xeb },
	'contrastportrait' => { 13 => 0xe9 },
	'contrastsetting' => { 177 => 0x505, 185 => 0x1012 },
	'contraststandard' => { 13 => 0xe8 },
	'contrastuserdef1' => { 13 => 0xee },
	'contrastuserdef2' => { 13 => 0xef },
	'contrastuserdef3' => { 13 => 0xf0 },
	'contributedmediadurationscale' => { 258 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 258 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 258 => 'contributedMediaManaged' },
	'contributedmediapath' => { 258 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 258 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 258 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 258 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 258 => 'contributedMediaWebStatement' },
	'contributor' => { 240 => 'contributor' },
	'contributors' => { 97 => 'Contributors' },
	'controldialset' => { 113 => 0x46 },
	'controlledvocabularyterm' => { 245 => 'CVterm' },
	'controllerboardversion' => { 191 => 0x332 },
	'controlmode' => { 42 => 0x12 },
	'conversionlens' => { 195 => 0x35 },
	'converter' => { 70 => 0xfe4d, 155 => 0xb, 239 => 'Converter' },
	'converttograyscale' => { 239 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 70 => 0x8298, 97 => 'Copyright', 188 => 'Copyright', 217 => 'Copyright', 246 => 'Copyright', 249 => 'copyright', 251 => 'copyright', 254 => 'Copyright', 258 => 'copyright' },
	'copyrightflag' => { 215 => 0x40a },
	'copyrightnotice' => { 76 => 0x74 },
	'copyrightownerid' => { 248 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 248 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 248 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 248 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 248 => 'CopyrightStatus' },
	'coringfilter' => { 181 => 0x310, 182 => 0x102d, 185 => 0x310 },
	'coringvalues' => { 181 => 0x311, 185 => 0x311 },
	'corporateentity' => { 249 => 'corporateEntity' },
	'country' => { 101 => 'Country', 195 => 0x69, 247 => 'Country' },
	'country-primarylocationcode' => { 76 => 0x64 },
	'country-primarylocationname' => { 76 => 0x65 },
	'countrycode' => { 213 => 'CountryCode', 244 => 'CountryCode' },
	'coverage' => { 240 => 'coverage' },
	'coverdate' => { 249 => 'coverDate' },
	'coverdisplaydate' => { 249 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 209 => 0x28 },
	'crc32' => { 241 => 'crc32' },
	'createdate' => { 70 => 0x9004, 97 => 'CreateDate', 186 => 'CreationDate', 188 => 'create-date', 217 => 'CreationDate', 256 => 'CreateDate' },
	'creationdate' => { 246 => 'CreationDate', 249 => 'creationDate' },
	'creationtime' => { 188 => 'Creation Time' },
	'creativestyle' => { 225 => 0x1a, 226 => 0x18 },
	'creativestylewaschanged' => { 229 => 0x8001 },
	'creator' => { 186 => 'Creator', 217 => 'Creator', 240 => 'creator', 246 => 'Creator' },
	'creatoraddress' => { 244 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 244 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 244 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 244 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 244 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 256 => 'CreatorTool' },
	'creatorworkemail' => { 244 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 244 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 244 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 76 => 0x6e, 247 => 'Credit' },
	'creditline' => { 251 => 'creditLine' },
	'creditlinereq' => { 261 => 'CreditLineReq' },
	'creditlinerequired' => { 248 => 'CreditLineRequired' },
	'cropactive' => { 64 => 0x244 },
	'cropangle' => { 239 => 'CropAngle' },
	'cropaspectratio' => { 64 => 0x260 },
	'cropbottom' => { 73 => 0x9, 160 => 0x36, 212 => 0xdc, 239 => 'CropBottom' },
	'cropheight' => { 64 => 0x24c, 181 => 0x615, 185 => 0x615, 239 => 'CropHeight' },
	'crophispeed' => { 137 => 0x1b },
	'cropleft' => { 64 => 0x246, 73 => 0x6, 160 => 0x1e, 181 => 0x612, 185 => 0x612, 212 => 0xd9, 239 => 'CropLeft' },
	'cropoutputheight' => { 160 => 0xce },
	'cropoutputheightinches' => { 160 => 0x96 },
	'cropoutputpixels' => { 160 => 0xd6 },
	'cropoutputresolution' => { 160 => 0xb6 },
	'cropoutputscale' => { 160 => 0xbe },
	'cropoutputwidth' => { 160 => 0xc6 },
	'cropoutputwidthinches' => { 160 => 0x8e },
	'cropright' => { 73 => 0x8, 160 => 0x2e, 212 => 0xdb, 239 => 'CropRight' },
	'croprotation' => { 73 => 0xb },
	'cropscaledresolution' => { 160 => 0x9e },
	'cropsourceresolution' => { 160 => 0xae },
	'croptop' => { 64 => 0x248, 73 => 0x7, 160 => 0x26, 181 => 0x613, 185 => 0x613, 212 => 0xda, 239 => 'CropTop' },
	'cropunit' => { 239 => 'CropUnit' },
	'cropunits' => { 239 => 'CropUnits' },
	'cropwidth' => { 64 => 0x24a, 181 => 0x614, 185 => 0x614, 239 => 'CropWidth' },
	'currenticcprofile' => { 70 => 0xc691 },
	'currentpreprofilematrix' => { 70 => 0xc692 },
	'currentversion' => { 229 => 0xd000 },
	'curves' => { 165 => 0x76a43201 },
	'custom1' => { 248 => 'Custom1' },
	'custom10' => { 248 => 'Custom10' },
	'custom2' => { 248 => 'Custom2' },
	'custom3' => { 248 => 'Custom3' },
	'custom4' => { 248 => 'Custom4' },
	'custom5' => { 248 => 'Custom5' },
	'custom6' => { 248 => 'Custom6' },
	'custom7' => { 248 => 'Custom7' },
	'custom8' => { 248 => 'Custom8' },
	'custom9' => { 248 => 'Custom9' },
	'customcontrols' => { 47 => 0x70c },
	'customrendered' => { 70 => 0xa401, 243 => 'CustomRendered' },
	'customsaturation' => { 177 => 0x503 },
	'customsettingsalldefault' => { 172 => '0.2' },
	'customsettingsbank' => { 172 => '0.1' },
	'customwbbluelevel' => { 113 => 0x36 },
	'customwberror' => { 113 => 0x37 },
	'customwbgreenlevel' => { 113 => 0x35 },
	'customwbredlevel' => { 113 => 0x34 },
	'customwbsetting' => { 113 => 0x26 },
	'd-lightinghq' => { 165 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 161 => 0x2 },
	'd-lightinghqhighlight' => { 161 => 0x1 },
	'd-lightinghqselected' => { 165 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 161 => 0x0 },
	'd-lightinghs' => { 165 => 0xce5554aa },
	'd-lightinghsadjustment' => { 162 => 0x0 },
	'd-lightinghscolorboost' => { 162 => 0x1 },
	'd-rangeoptimizerhighlight' => { 229 => 0x8024 },
	'd-rangeoptimizermode' => { 229 => 0x8022 },
	'd-rangeoptimizershadow' => { 229 => 0x802d },
	'd-rangeoptimizervalue' => { 229 => 0x8023 },
	'datacompressionmethod' => { 78 => 0x6e },
	'dataimprint' => { 110 => 0x34 },
	'date' => { 209 => 0x6, 240 => 'date' },
	'dateacquired' => { 235 => 'DateAcquired' },
	'datecreated' => { 76 => 0x37, 247 => 'DateCreated' },
	'datedisplayformat' => { 157 => 0x3 },
	'dateimprint' => { 174 => '4.2' },
	'daterecieved' => { 249 => 'dateRecieved' },
	'datesent' => { 77 => 0x46 },
	'datestampmode' => { 34 => 0x1c },
	'datetime' => { 236 => 'datetime', 254 => 'DateTime' },
	'datetimedigitized' => { 243 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 63 => 0x0, 70 => 0x9003, 94 => 0x14, 97 => 'OriginalDate', 243 => 'DateTimeOriginal' },
	'datetimestamp' => { 83 => 0x64 },
	'daylightsavings' => { 157 => 0x2 },
	'declination' => { 105 => 'Declination' },
	'decposition' => { 110 => 0x32 },
	'defaultcroporigin' => { 70 => 0xc61f },
	'defaultcropsize' => { 70 => 0xc620 },
	'defaultscale' => { 70 => 0xc61e },
	'defringe' => { 239 => 'Defringe' },
	'deletedimagecount' => { 137 => 0xa6, 143 => 0x6e },
	'derivedfromalternatepaths' => { 259 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 259 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 259 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 259 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 259 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 259 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 259 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 259 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 259 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 259 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 259 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 259 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 259 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 259 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 259 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 259 => 'DerivedFromVersionID' },
	'description' => { 188 => 'Description', 240 => 'description' },
	'destination' => { 77 => 0x5 },
	'destinationcity' => { 209 => 0x24 },
	'destinationcitycode' => { 211 => 0x1001 },
	'destinationdst' => { 209 => 0x26 },
	'developmentdynamicrange' => { 74 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 243 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 243 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 243 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 47 => 0x706 },
	'digitalcreationdate' => { 76 => 0x3e },
	'digitalcreationtime' => { 76 => 0x3f },
	'digitaldeehighlightadj' => { 142 => 0x202 },
	'digitaldeeshadowadj' => { 142 => 0x200 },
	'digitaldeethreshold' => { 142 => 0x201 },
	'digitalgain' => { 40 => 0xb },
	'digitalgem' => { 132 => 0x0 },
	'digitalice' => { 142 => 0x100 },
	'digitalimageguid' => { 245 => 'DigImageGUID' },
	'digitalroc' => { 141 => 0x0 },
	'digitalsourcefiletype' => { 245 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 245 => 'DigitalSourceType' },
	'digitalzoom' => { 20 => 0xc, 66 => 0xa, 83 => 0x68, 96 => 'DigitalZoom', 110 => 0xc, 137 => 0x86, 155 => 0xa, 182 => 0x204, 209 => 0x1e, 211 => 0xa, 223 => 0x204 },
	'digitalzoomon' => { 223 => 0x21b },
	'digitalzoomratio' => { 70 => 0xa404, 243 => 'DigitalZoomRatio' },
	'directory' => { 71 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 8 => 0x13f, 9 => 0x133, 10 => 0x1df, 11 => [0x1a3,0x1a7], 12 => 0x1f0, 14 => [0x1a3,0x1c7], 16 => 0x1d3 },
	'directorynumber' => { 128 => 0x6 },
	'disclaimer' => { 188 => 'Disclaimer' },
	'displayallafpoints' => { 47 => 0x514 },
	'displayaperture' => { 20 => 0x23 },
	'displayedunitsx' => { 216 => 0x2 },
	'displayedunitsy' => { 216 => 0x6 },
	'distance1' => { 83 => 0x28 },
	'distance2' => { 83 => 0x2c },
	'distance3' => { 83 => 0x30 },
	'distance4' => { 83 => 0x34 },
	'distortioncontrol' => { 143 => 0x10 },
	'distortioncorrection' => { 65 => 0x67, 177 => 0x50b },
	'distortioncorrection2' => { 181 => 0x1011 },
	'distortioncorrectionon' => { 65 => 0x63 },
	'distributor' => { 249 => 'distributor' },
	'dngbackwardversion' => { 70 => 0xc613 },
	'dnglensinfo' => { 70 => 0xc630 },
	'dngversion' => { 70 => 0xc612 },
	'document' => { 188 => 'Document' },
	'documenthistory' => { 76 => 0xe7 },
	'documentid' => { 259 => 'DocumentID' },
	'documentname' => { 70 => 0x10d },
	'documentnotes' => { 76 => 0xe6 },
	'doi' => { 249 => 'doi' },
	'dotrange' => { 70 => 0x150 },
	'drivemode' => { 110 => 0x6, 113 => 0x1e, 177 => 0x600, 209 => 0x34, 224 => 0x3, 225 => 0x4 },
	'drivemode2' => { 113 => 0xa, 202 => 0x7 },
	'dspfirmwareversion' => { 209 => 0x27 },
	'duration' => { 95 => 'Duration', 109 => 'Duration' },
	'durationscale' => { 258 => 'durationScale' },
	'durationvalue' => { 258 => 'durationValue' },
	'dynamicafarea' => { 172 => '1.4' },
	'dynamicrange' => { 74 => 0x1400 },
	'dynamicrangeexpansion' => { 209 => 0x69 },
	'dynamicrangemax' => { 64 => 0x7c },
	'dynamicrangemin' => { 64 => 0x7a },
	'dynamicrangeoptimizer' => { 113 => 0x15, 227 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 225 => 0x19, 226 => 0x17 },
	'dynamicrangeoptimizermode' => { 225 => 0x18, 226 => 0x16 },
	'dynamicrangeoptimizersetting' => { 113 => 0x27 },
	'dynamicrangesetting' => { 74 => 0x1402 },
	'e-dialinprogram' => { 202 => '1.3' },
	'easyexposurecomp' => { 176 => '6.1' },
	'easyexposurecompensation' => { 172 => '6.4' },
	'easymode' => { 20 => 0xb },
	'edgenoisereduction' => { 166 => 0x4, 229 => 0x8028 },
	'edition' => { 249 => 'edition' },
	'editorialupdate' => { 76 => 0x8 },
	'editstatus' => { 76 => 0x7, 213 => 'EditStatus' },
	'effectivelv' => { 209 => 0x2d },
	'effectivemaxaperture' => { 135 => 0x12, 136 => 0x13 },
	'eissn' => { 249 => 'eIssn' },
	'elevation' => { 105 => 'Elevation' },
	'email' => { 97 => 'EMail' },
	'embargodate' => { 249 => 'embargoDate', 251 => 'embargoDate' },
	'endingpage' => { 249 => 'endingPage' },
	'enduserid' => { 248 => 'EndUserEndUserID' },
	'endusername' => { 248 => 'EndUserEndUserName' },
	'engineer' => { 258 => 'engineer' },
	'enhancedarktones' => { 158 => 0x8 },
	'enhancement' => { 66 => 0x16, 67 => 0x3016 },
	'enhancer' => { 181 => 0x300 },
	'enhancervalues' => { 181 => 0x301 },
	'envelopenumber' => { 77 => 0x28 },
	'envelopepriority' => { 77 => 0x3c },
	'enveloperecordversion' => { 77 => 0x0 },
	'epsonimageheight' => { 182 => 0x20c },
	'epsonimagewidth' => { 182 => 0x20b },
	'epsonsoftware' => { 182 => 0x20d },
	'equipmentinstitution' => { 231 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 231 => 'EquipmentManufacturer' },
	'equipmentversion' => { 178 => 0x0 },
	'ettlii' => { 47 => 0x304, 48 => 0xd, 49 => 0xe, 50 => 0x7, 51 => 0x7, 52 => 0xe },
	'event' => { 234 => 'Event', 245 => 'Event', 249 => 'event' },
	'evsteps' => { 202 => '1.2', 204 => 0x0 },
	'evstepsize' => { 174 => '5.1', 175 => '0.7' },
	'exclusivityenddate' => { 251 => 'exclusivityEndDate' },
	'excursiontolerance' => { 78 => 0x82 },
	'exif' => { 71 => 'EXIF' },
	'exifbyteorder' => { 71 => 'ExifByteOrder' },
	'exifcamerainfo' => { 76 => 0xe8 },
	'exifimageheight' => { 70 => 0xa003, 243 => 'PixelYDimension' },
	'exifimagewidth' => { 70 => 0xa002, 243 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 71 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 70 => 0x9000, 243 => 'ExifVersion' },
	'exitpupilposition' => { 135 => 0x4, 136 => 0x4 },
	'expirationdate' => { 76 => 0x25, 249 => 'expirationDate', 251 => 'expirationDate' },
	'expirationtime' => { 76 => 0x26 },
	'exposure' => { 70 => 0xfe51, 239 => 'Exposure' },
	'exposureadj' => { 163 => 0x0 },
	'exposureadj2' => { 163 => 0x12 },
	'exposurebracketingindicatorlast' => { 113 => 0x52 },
	'exposurebracketstepsize' => { 202 => 0x8 },
	'exposurebracketvalue' => { 137 => 0x19 },
	'exposurecompensation' => { 42 => 0x6, 56 => 0x0, 70 => 0x9204, 83 => 0x24, 96 => 'ExposureComp', 110 => 0xd, 111 => 0x53, 112 => 0x1e, 182 => 0x1006, 209 => 0x16, 222 => 0xa013, 224 => [0xc,0x35], 243 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 113 => 0x47 },
	'exposurecompensationsetting' => { 113 => 0x1 },
	'exposurecompstepsize' => { 172 => '6.3' },
	'exposurecontrolstepsize' => { 172 => '6.2', 176 => '7.1' },
	'exposuredelaymode' => { 172 => '10.1', 174 => '9.1', 175 => '6.4', 176 => '11.2' },
	'exposuredifference' => { 137 => 0xe },
	'exposureindex' => { 70 => 0xa215, 243 => 'ExposureIndex' },
	'exposureindicator' => { 113 => 0x50 },
	'exposurelevelincrements' => { 45 => 0x6, 46 => 0x6, 47 => 0x101, 48 => 0x5, 49 => 0x6, 50 => 0x5, 51 => 0x5, 52 => 0x6, 53 => 0x4, 225 => 0x58 },
	'exposuremode' => { 70 => 0xa402, 96 => 'ExposureMode', 110 => 0x1, 111 => 0xa, 112 => 0x0, 113 => 0x0, 177 => 0x200, 193 => 0x40d, 224 => 0x8, 227 => 0xb041, 243 => 'ExposureMode' },
	'exposuremodeinmanual' => { 47 => 0x10b },
	'exposureprogram' => { 70 => 0x8822, 225 => 0x3c, 226 => 0x3c, 243 => 'ExposureProgram' },
	'exposureshift' => { 177 => 0x203 },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 17 => 0x6, 18 => 0x7, 42 => 0x16, 70 => 0x829a, 80 => 0xfd05, 83 => 0x20, 84 => 0xfa24, 86 => 0xf104, 89 => 0x12, 91 => 0x38, 94 => 0x10, 96 => 'ExposureTime', 110 => 0x9, 111 => 0x35, 112 => 0x48, 113 => 0x8, 209 => 0x12, 222 => 0xa018, 224 => 0x32, 243 => 'ExposureTime' },
	'exposuretime2' => { 224 => 0x33 },
	'exposuretuning' => { 137 => 0x1c },
	'exposurevalue' => { 81 => 0x3 },
	'exposurewarning' => { 74 => 0x1302 },
	'exrauto' => { 74 => 0x1033 },
	'exrmode' => { 74 => 0x1034 },
	'extendedwbdetect' => { 177 => 0x902 },
	'extender' => { 178 => 0x301 },
	'extenderfirmwareversion' => { 178 => 0x304 },
	'extendermagnification' => { 98 => 'Magnification' },
	'extendermake' => { 98 => 'Make' },
	'extendermodel' => { 98 => 'Model', 178 => 0x303 },
	'extenderserialnumber' => { 98 => 'SerialNumber', 178 => 0x302 },
	'externalflash' => { 180 => 0x1201 },
	'externalflashae1' => { 182 => 0x101f },
	'externalflashae1_0' => { 182 => 0x101b },
	'externalflashae2' => { 182 => 0x1020 },
	'externalflashae2_0' => { 182 => 0x101c },
	'externalflashbounce' => { 180 => 0x1204, 182 => 0x1026, 205 => 0x1a },
	'externalflashexposurecomp' => { 205 => 0x19 },
	'externalflashfirmware' => { 129 => 0x6, 130 => 0x6, 131 => 0x6 },
	'externalflashflags' => { 129 => 0x8, 130 => 0x8, 131 => 0x8 },
	'externalflashguidenumber' => { 180 => 0x1203, 205 => '24.1' },
	'externalflashgvalue' => { 182 => 0x1025 },
	'externalflashmode' => { 182 => 0x1028, 205 => 0x2 },
	'externalflashzoom' => { 180 => 0x1205, 182 => 0x1027 },
	'externalsensorbrightnessvalue' => { 191 => 0x311 },
	'eyestartaf' => { 113 => 0x40 },
	'face0position' => { 28 => 0x8 },
	'face1position' => { 28 => 0xa, 189 => 0x1 },
	'face2position' => { 28 => 0xc, 189 => 0x5 },
	'face3position' => { 28 => 0xe, 189 => 0x9 },
	'face4position' => { 28 => 0x10, 189 => 0xd },
	'face5position' => { 28 => 0x12, 189 => 0x11 },
	'face6position' => { 28 => 0x14 },
	'face7position' => { 28 => 0x16 },
	'face8position' => { 28 => 0x18 },
	'facedetect' => { 181 => 0x1200 },
	'facedetectarea' => { 181 => 0x1201 },
	'facedetectframeheight' => { 28 => 0x4 },
	'facedetectframewidth' => { 28 => 0x3 },
	'facepositions' => { 74 => 0x4103 },
	'facesdetected' => { 28 => 0x2, 29 => 0x2, 74 => 0x4100, 195 => 0x3f },
	'facesrecognized' => { 190 => 0x0 },
	'femicroadjustment' => { 47 => 0x110 },
	'ffid' => { 241 => 'ffid' },
	'fieldcount' => { 182 => 0x103f },
	'filedatarate' => { 258 => 'fileDataRate' },
	'fileformat' => { 58 => 0x0, 77 => 0x14, 224 => 0x22, 227 => 0xb000 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 8 => 0x133, 9 => 0x13f, 10 => 0x1d3, 11 => [0x197,0x19b], 12 => 0x1e4, 14 => [0x197,0x1bb], 16 => 0x1c7 },
	'filemodifydate' => { 71 => 'FileModifyDate' },
	'filename' => { 71 => 'FileName' },
	'filenameasdelivered' => { 248 => 'FileNameAsDelivered' },
	'filenumber' => { 30 => 0x1, 34 => 0x8, 60 => 0x1817, 68 => 'FileNumber', 128 => 0x8 },
	'filenumbermemory' => { 110 => 0x1a },
	'filenumbersequence' => { 172 => '12.2', 174 => '3.1', 176 => '5.2' },
	'filesource' => { 70 => 0xa300, 74 => 0x8000, 243 => 'FileSource' },
	'fileversion' => { 77 => 0x16 },
	'fillflashautoreduction' => { 45 => 0xe, 46 => 0xe, 53 => 0xa },
	'filllight' => { 239 => 'FillLight' },
	'fillorder' => { 70 => 0x10a },
	'filmmode' => { 74 => 0x1401, 193 => 0x412, 195 => 0x42 },
	'filmtype' => { 142 => 0x2 },
	'filtereffect' => { 30 => 0xe, 139 => 0x37 },
	'filtereffectmonochrome' => { 13 => 0xff },
	'finderdisplayduringexposure' => { 46 => 0x1 },
	'finetuneoptcenterweighted' => { 172 => '7.2', 176 => '9.1' },
	'finetuneoptmatrixmetering' => { 172 => '8.1', 176 => '8.2' },
	'finetuneoptspotmetering' => { 172 => '8.2', 176 => '9.2' },
	'firmware' => { 182 => 0x405, 224 => [0x17,0x3b], 237 => 'Firmware' },
	'firmwaredate' => { 66 => 0x15, 67 => 0x2001 },
	'firmwareid' => { 115 => 0x0 },
	'firmwarename' => { 222 => 0xa001 },
	'firmwarerevision' => { 13 => 0xa4, 34 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 8 => 0xff, 9 => 0x107, 81 => 0xce5, 94 => 0x57, 96 => 'FirmwareVersion', 195 => 0x2, 196 => 0x3109, 209 => 0x230, 219 => 0x2 },
	'firstpublicationdate' => { 248 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 76 => 0x16 },
	'flash' => { 70 => 0x9209, 111 => 0x1f, 112 => 0x15 },
	'flashactivity' => { 20 => 0x1c },
	'flashbatterylevel' => { 24 => 0x249 },
	'flashbias' => { 195 => 0x24 },
	'flashbits' => { 20 => 0x1d },
	'flashchargelevel' => { 182 => 0x1010 },
	'flashcolorfilter' => { 131 => 0x10 },
	'flashcommandermode' => { 129 => '9.1', 130 => '9.1', 131 => '9.1' },
	'flashcompensation' => { 237 => 'FlashCompensation' },
	'flashcontrolmode' => { 129 => '9.2', 130 => '9.2', 131 => '9.2', 177 => 0x404 },
	'flashdefault' => { 113 => 0x42 },
	'flashdevice' => { 182 => 0x1005 },
	'flashdistance' => { 67 => 0x2034 },
	'flashenergy' => { 70 => 0xa20b, 243 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 137 => 0x18 },
	'flashexposurecomp' => { 42 => 0xf, 74 => 0x1011, 99 => 'ExposureComp', 110 => 0x23, 114 => 0x104, 129 => 0xa, 130 => 0xa, 131 => 0xa, 137 => [0x12,0x17], 177 => 0x401, 182 => 0x1023, 209 => 0x4d, 224 => 0x3a, 227 => 0x104 },
	'flashexposurecompset' => { 198 => 0xe },
	'flashexposurecompsetting' => { 113 => 0x10 },
	'flashexposureindicator' => { 113 => 0x54 },
	'flashexposureindicatorlast' => { 113 => 0x56 },
	'flashexposureindicatornext' => { 113 => 0x55 },
	'flashexposurelock' => { 30 => 0x19 },
	'flashfired' => { 83 => 0x5d, 99 => 'Fired', 110 => 0x14, 153 => '590.3', 195 => 0x8007, 243 => 'FlashFired' },
	'flashfiring' => { 47 => 0x306, 48 => 0x6, 49 => 0x7, 52 => 0x7 },
	'flashfirmwareversion' => { 178 => 0x1002 },
	'flashfocallength' => { 129 => 0xb, 130 => 0xc, 131 => 0xc },
	'flashfunction' => { 243 => 'FlashFunction' },
	'flashgndistance' => { 129 => 0xe, 130 => 0xf, 131 => 0xf },
	'flashgroupacontrolmode' => { 129 => 0xf, 130 => '16.1', 131 => '17.1' },
	'flashgroupaexposurecomp' => { 129 => 0x11, 130 => 0x12, 131 => 0x13 },
	'flashgroupaoutput' => { 129 => 0x11, 130 => 0x12, 131 => 0x13 },
	'flashgroupbcontrolmode' => { 129 => 0x10, 130 => '17.1', 131 => '18.1' },
	'flashgroupbexposurecomp' => { 129 => 0x12, 130 => 0x13, 131 => 0x14 },
	'flashgroupboutput' => { 129 => 0x12, 130 => 0x13, 131 => 0x14 },
	'flashgroupccontrolmode' => { 130 => '17.2', 131 => '18.2' },
	'flashgroupcexposurecomp' => { 130 => 0x14, 131 => 0x15 },
	'flashgroupcoutput' => { 130 => 0x14, 131 => 0x15 },
	'flashguidenumber' => { 42 => 0xd, 57 => 0x0, 99 => 'GuideNumber' },
	'flashintensity' => { 66 => [0x19,0x5], 177 => 0x405 },
	'flashlevel' => { 173 => 0x9 },
	'flashmake' => { 99 => 'Make' },
	'flashmanufacturer' => { 235 => 'FlashManufacturer' },
	'flashmetering' => { 110 => 0x3f, 113 => 0x1c },
	'flashmeteringmode' => { 2 => 0x15, 7 => 0x15, 8 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 14 => 0x15, 15 => 0x15 },
	'flashmeteringsegments' => { 209 => 0x20a },
	'flashmode' => { 66 => 0x4, 83 => 0x5c, 99 => 'Mode', 110 => 0x2, 111 => 0x20, 112 => 0x16, 113 => 0xf, 137 => 0x87, 177 => 0x400, 182 => 0x1004, 209 => 0xc, 211 => 0x4, 218 => 0x20, 223 => 0x225, 225 => 0x23, 226 => 0x23, 243 => 'FlashMode' },
	'flashmodel' => { 99 => 'Model', 178 => 0x1001, 235 => 'FlashModel' },
	'flashoptions' => { 202 => 0x2 },
	'flashoptions2' => { 202 => 0x10 },
	'flashoutput' => { 24 => 0x248, 42 => 0x21, 129 => 0xa, 130 => 0xa, 131 => 0xa },
	'flashpixversion' => { 70 => 0xa000, 243 => 'FlashpixVersion' },
	'flashredeyemode' => { 243 => 'FlashRedEyeMode' },
	'flashremotecontrol' => { 177 => 0x403 },
	'flashreturn' => { 243 => 'FlashReturn' },
	'flashserialnumber' => { 99 => 'SerialNumber', 178 => 0x1003 },
	'flashsetting' => { 137 => 0x8 },
	'flashshutterspeed' => { 172 => '20.2', 175 => '7.2', 176 => '23.1' },
	'flashsource' => { 129 => 0x4, 130 => 0x4, 131 => 0x4 },
	'flashstatus' => { 205 => 0x0 },
	'flashsyncspeed' => { 172 => '20.1' },
	'flashsyncspeedav' => { 45 => 0x3, 47 => 0x10f, 48 => 0x2, 49 => 0x3, 50 => 0x2, 51 => 0x2, 52 => 0x3, 53 => 0x6 },
	'flashthreshold' => { 57 => 0x1 },
	'flashtype' => { 99 => 'Type', 113 => 0x59, 137 => 0x9, 178 => 0x1000 },
	'flashwarning' => { 175 => '7.1', 176 => '31.1', 195 => 0x62 },
	'flickerreduce' => { 223 => 0x218 },
	'fliphorizontal' => { 165 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 17 => 0x5, 18 => 0x6, 42 => 0x15, 70 => 0x829d, 80 => 0xfd04, 83 => 0x1e, 84 => 0xfa23, 86 => 0xf103, 89 => 0x13, 91 => 0x3c, 94 => 0xc, 103 => 'FNumber', 110 => 0xa, 111 => 0x36, 112 => 0x47, 113 => 0x9, 209 => 0x13, 222 => 0xa019, 224 => 0x31, 243 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1e, 8 => 0x1d, 9 => 0x1d, 10 => 0x1e, 11 => 0x1e, 12 => 0x1e, 13 => 0x28, 14 => 0x1e, 15 => 0x1e, 32 => 0x1, 67 => 0x1d, 70 => 0x920a, 89 => 0x1d, 103 => 'FocalLength', 110 => 0x12, 135 => 0xa, 136 => 0xb, 206 => 0x9, 209 => 0x1d, 243 => 'FocalLength' },
	'focallengthin35mmformat' => { 70 => 0xa405, 222 => 0xa01a, 243 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 178 => 0x103, 182 => 0x205 },
	'focalplaneresolutionunit' => { 70 => 0xa210, 243 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 70 => 0xa20e, 243 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 32 => 0x2 },
	'focalplanexunknown' => { 32 => 0x2 },
	'focalplaneyresolution' => { 70 => 0xa20f, 243 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 32 => 0x3 },
	'focalplaneyunknown' => { 32 => 0x3 },
	'focaltype' => { 4 => 0x2d, 32 => 0x0 },
	'focalunits' => { 20 => 0x19 },
	'focus' => { 155 => 0x8 },
	'focusarea' => { 110 => 0x31 },
	'focusareaselection' => { 175 => '15.2' },
	'focuscontinuous' => { 20 => 0x20 },
	'focusdisplayaiservoandmf' => { 47 => 0x515 },
	'focusdistance' => { 103 => 'FocusDistance', 110 => 0x13, 135 => 0x9, 136 => 0xa, 180 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x56, 8 => 0x45, 9 => 0x45, 10 => 0x52, 11 => 0x52, 12 => 0x56, 14 => 0x52, 16 => 0x32, 42 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x54, 8 => 0x43, 9 => 0x43, 10 => 0x50, 11 => 0x50, 12 => 0x54, 14 => 0x50, 16 => 0x30, 42 => 0x13 },
	'focusholdbutton' => { 113 => 0x44 },
	'focusinfoversion' => { 180 => 0x0 },
	'focusingscreen' => { 46 => 0x0, 47 => 0x80b, 52 => 0x0 },
	'focusmode' => { 20 => 0x7, 66 => 0x3, 67 => [0x3003,0xd], 74 => 0x1021, 83 => 0x38, 96 => 'FocusMode', 110 => 0x30, 112 => 0xe, 113 => 0xc, 137 => 0x7, 177 => 0x301, 182 => 0x100b, 195 => 0x7, 209 => 0xd, 211 => 0x3, 225 => 0x10, 226 => 0x10 },
	'focusmode2' => { 202 => '3.1' },
	'focusmodesetting' => { 173 => '10.1' },
	'focusmodeswitch' => { 113 => 0x58 },
	'focuspixel' => { 74 => 0x1023 },
	'focuspointwrap' => { 172 => '2.2', 176 => '2.5' },
	'focusposition' => { 135 => 0x8, 136 => 0x8, 209 => 0x10 },
	'focusprocess' => { 177 => 0x302 },
	'focusrange' => { 20 => 0x12, 182 => 0x100a },
	'focussetting' => { 224 => 0x6 },
	'focusstepcount' => { 180 => 0x301, 182 => 0x100e },
	'focusstepinfinity' => { 180 => 0x303 },
	'focusstepnear' => { 180 => 0x304 },
	'focustrackinglockon' => { 172 => '1.5' },
	'focuswarning' => { 74 => 0x1301 },
	'foldername' => { 110 => 0x27 },
	'fontcomposite' => { 263 => 'FontsComposite' },
	'fontface' => { 263 => 'FontsFontFace' },
	'fontfamily' => { 263 => 'FontsFontFamily' },
	'fontfilename' => { 263 => 'FontsFontFileName' },
	'fontname' => { 263 => 'FontsFontName' },
	'fonttype' => { 263 => 'FontsFontType' },
	'fontversion' => { 263 => 'FontsVersionString' },
	'for' => { 217 => 'For' },
	'format' => { 240 => 'format' },
	'forwardlock' => { 253 => 'forwardlock' },
	'forwardmatrix1' => { 70 => 0xc714 },
	'forwardmatrix2' => { 70 => 0xc715 },
	'framenum' => { 212 => 0xd7 },
	'framenumber' => { 74 => 0x8003, 209 => 0x29 },
	'freebytes' => { 60 => 0x1 },
	'freememorycardimages' => { 111 => [0x37,0x54], 112 => [0x2d,0x4a], 113 => 0x32 },
	'fujiflashmode' => { 74 => 0x1010 },
	'fullimagesize' => { 227 => 0xb02b },
	'fullsizeimage' => { 102 => 'data' },
	'fullsizeimagename' => { 102 => '1Name' },
	'fullsizeimagetype' => { 102 => '0Type' },
	'funcbutton' => { 172 => ['14.1','15.1'], 176 => '14.1' },
	'funcbuttonplusdials' => { 172 => ['14.2','15.2'] },
	'functionbutton' => { 175 => '5.2' },
	'gainbase' => { 181 => 0x610 },
	'gaincontrol' => { 70 => 0xa407, 243 => 'GainControl' },
	'gamma' => { 70 => 0xa500 },
	'gammacompensatedvalue' => { 78 => 0x91 },
	'genre' => { 249 => 'genre', 258 => 'genre' },
	'geography' => { 250 => 'geography' },
	'geosync' => { 71 => 'Geosync' },
	'geotag' => { 71 => 'Geotag' },
	'geotime' => { 71 => 'Geotime' },
	'globalaltitude' => { 215 => 0x419 },
	'globalangle' => { 215 => 0x40d },
	'gpsaltitude' => { 75 => 0x6, 100 => 'Altitude', 243 => 'GPSAltitude' },
	'gpsaltituderef' => { 75 => 0x5, 243 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 75 => 0x1c, 243 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 75 => 0x1d },
	'gpsdatetime' => { 100 => 'DateTime', 243 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 75 => 0x18, 100 => 'Bearing', 243 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 75 => 0x17, 243 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 75 => 0x1a, 100 => 'Distance', 243 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 75 => 0x19, 243 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 75 => 0x14, 243 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 75 => 0x13 },
	'gpsdestlongitude' => { 75 => 0x16, 243 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 75 => 0x15 },
	'gpsdifferential' => { 75 => 0x1e, 100 => 'Differential', 243 => 'GPSDifferential' },
	'gpsdop' => { 75 => 0xb, 243 => 'GPSDOP' },
	'gpsimgdirection' => { 75 => 0x11, 243 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 75 => 0x10, 243 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 75 => 0x2, 100 => 'Latitude', 243 => 'GPSLatitude' },
	'gpslatituderef' => { 75 => 0x1 },
	'gpslongitude' => { 75 => 0x4, 100 => 'Longitude', 243 => 'GPSLongitude' },
	'gpslongituderef' => { 75 => 0x3 },
	'gpsmapdatum' => { 75 => 0x12, 100 => 'Datum', 243 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 75 => 0xa, 100 => 'MeasureMode', 243 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 75 => 0x1b, 243 => 'GPSProcessingMethod' },
	'gpssatellites' => { 75 => 0x8, 100 => 'Satellites', 243 => 'GPSSatellites' },
	'gpsspeed' => { 75 => 0xd, 100 => 'Speed', 243 => 'GPSSpeed' },
	'gpsspeedref' => { 75 => 0xc, 243 => 'GPSSpeedRef' },
	'gpsstatus' => { 75 => 0x9, 243 => 'GPSStatus' },
	'gpstimestamp' => { 75 => 0x7 },
	'gpstrack' => { 75 => 0xf, 100 => 'Heading', 243 => 'GPSTrack' },
	'gpstrackref' => { 75 => 0xe, 243 => 'GPSTrackRef' },
	'gpsversionid' => { 75 => 0x0, 243 => 'GPSVersionID' },
	'gradation' => { 177 => 0x50f },
	'graymixeraqua' => { 239 => 'GrayMixerAqua' },
	'graymixerblue' => { 239 => 'GrayMixerBlue' },
	'graymixergreen' => { 239 => 'GrayMixerGreen' },
	'graymixermagenta' => { 239 => 'GrayMixerMagenta' },
	'graymixerorange' => { 239 => 'GrayMixerOrange' },
	'graymixerpurple' => { 239 => 'GrayMixerPurple' },
	'graymixerred' => { 239 => 'GrayMixerRed' },
	'graymixeryellow' => { 239 => 'GrayMixerYellow' },
	'graypoint' => { 229 => 0x8021 },
	'grayresponseunit' => { 70 => 0x122 },
	'greencurvelimits' => { 64 => 0x1c4 },
	'greencurvepoints' => { 64 => 0x19a },
	'greenhue' => { 239 => 'GreenHue' },
	'greensaturation' => { 239 => 'GreenSaturation' },
	'griddisplay' => { 172 => '13.3', 174 => '2.2', 175 => '6.1', 176 => '4.2' },
	'halftonehints' => { 70 => 0x141 },
	'hasalternative' => { 249 => 'hasAlternative' },
	'hascorrection' => { 249 => 'hasCorrection' },
	'hascrop' => { 239 => 'HasCrop' },
	'hasextendedxmp' => { 260 => 'HasExtendedXMP' },
	'haspreviousversion' => { 249 => 'hasPreviousVersion' },
	'hassettings' => { 239 => 'HasSettings' },
	'hastranslation' => { 249 => 'hasTranslation' },
	'headline' => { 76 => 0x69, 247 => 'Headline' },
	'hierarchicalsubject' => { 232 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 10 => 0xbc, 11 => 0xbd, 14 => 0xbd, 16 => 0xa5, 47 => 0x202, 137 => 0xb1, 209 => 0x71, 225 => 0x2c },
	'highlight' => { 224 => 0xf },
	'highlightcolordistortreduct' => { 229 => 0x8026 },
	'highlightprotection' => { 164 => 0x6 },
	'highlightrecovery' => { 239 => 'HighlightRecovery' },
	'highlighttonepriority' => { 7 => 0x7, 10 => 0x7, 11 => 0x7, 12 => 0x7, 14 => 0x7, 15 => 0x7, 47 => 0x203 },
	'highspeedsync' => { 113 => 0x5 },
	'history' => { 247 => 'History' },
	'historyaction' => { 259 => 'HistoryAction' },
	'historychanged' => { 259 => 'HistoryChanged' },
	'historyinstanceid' => { 259 => 'HistoryInstanceID' },
	'historyparameters' => { 259 => 'HistoryParameters' },
	'historysoftwareagent' => { 259 => 'HistorySoftwareAgent' },
	'historywhen' => { 259 => 'HistoryWhen' },
	'hometowncity' => { 67 => 0x3006, 209 => 0x23 },
	'hometowncitycode' => { 211 => 0x1000 },
	'hometowndst' => { 209 => 0x25 },
	'hostcomputer' => { 70 => 0x13c },
	'hue' => { 116 => 0x3b },
	'hueadj' => { 168 => 0x2f, 229 => 0x8019 },
	'hueadjustment' => { 111 => 0x4a, 112 => 0x40, 137 => 0x92, 139 => 0x36 },
	'hueadjustmentaqua' => { 239 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 239 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 239 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 239 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 239 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 239 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 239 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 239 => 'HueAdjustmentYellow' },
	'huesetting' => { 185 => 0x1011 },
	'icc_profile' => { 71 => 'ICC_Profile' },
	'iccprofilename' => { 247 => 'ICCProfile' },
	'idccreativestyle' => { 229 => 0x8000 },
	'idcpreviewlength' => { 229 => 0x202 },
	'idcpreviewstart' => { 229 => 0x201 },
	'identifier' => { 240 => 'identifier', 256 => 'Identifier' },
	'illumination' => { 175 => '0.5' },
	'imageadjustment' => { 137 => 0x80, 155 => 0x5 },
	'imagealterationconstraints' => { 248 => 'ImageAlterationConstraints' },
	'imagearea' => { 150 => 0x10 },
	'imageareaoffset' => { 209 => 0x38 },
	'imageauthentication' => { 137 => 0x20 },
	'imageboundary' => { 137 => 0x16 },
	'imagecount' => { 137 => 0xa5 },
	'imagecreatorid' => { 248 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 248 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 248 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 137 => 0xa2 },
	'imagedescription' => { 70 => 0x10e, 254 => 'ImageDescription' },
	'imageduplicationconstraints' => { 248 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 165 => 0xfe443a45 },
	'imagefileconstraints' => { 248 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 248 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 248 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 70 => 0x101, 115 => 0xc, 254 => 'ImageLength' },
	'imagehistory' => { 70 => 0x9213 },
	'imageidnumber' => { 191 => 0x340 },
	'imagenumber' => { 13 => 0xd0, 70 => 0x9211, 96 => 'ImageNumber', 111 => 0xae, 112 => 0x5e, 237 => 'ImageNumber' },
	'imagenumber2' => { 112 => 0x62 },
	'imageoptimization' => { 137 => 0xa9 },
	'imageorientation' => { 76 => 0x83 },
	'imageprocessing' => { 137 => 0x1a, 209 => 0x32 },
	'imageprocessingcount' => { 209 => 0x41 },
	'imageprocessingversion' => { 181 => 0x0 },
	'imagequality' => { 96 => 'ImageQuality', 149 => '723.2', 150 => '732.2', 153 => '708.1', 195 => 0x1 },
	'imagequality2' => { 177 => 0x603 },
	'imagereview' => { 173 => '0.4', 175 => '0.4' },
	'imagereviewtime' => { 173 => '2.1', 174 => '19.1', 176 => '21.2' },
	'imagesize' => { 102 => 'ImageSize' },
	'imagesizerestriction' => { 251 => 'imageSizeRestriction' },
	'imagesourcedata' => { 70 => 0x935c },
	'imagestabilization' => { 20 => 0x22, 67 => 0x3020, 96 => 'ImageStabilization', 111 => 0xbd, 112 => 0x71, 113 => 0x57, 114 => [0x18,0x107,0x113], 137 => 0xac, 177 => 0x604, 180 => 0x1600, 195 => 0x1a, 225 => 0x3d, 227 => 0xb026 },
	'imagestyle' => { 225 => 0x2d },
	'imagesupplierid' => { 248 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 248 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 248 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 209 => 0x4f },
	'imagetype' => { 76 => 0x82, 248 => 'ImageType' },
	'imageuniqueid' => { 34 => 0x28, 70 => 0xa420, 243 => 'ImageUniqueID' },
	'imagewidth' => { 70 => 0x100, 115 => 0xe, 254 => 'ImageWidth' },
	'incrementaltemperature' => { 239 => 'IncrementalTemperature' },
	'incrementaltint' => { 239 => 'IncrementalTint' },
	'industry' => { 249 => 'industry', 250 => 'industry' },
	'infinitylensstep' => { 182 => 0x103b },
	'infobuttonwhenshooting' => { 47 => 0x409 },
	'ingredientsalternatepaths' => { 259 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 259 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 259 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 259 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 259 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 259 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 259 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 259 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 259 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 259 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 259 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 259 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 259 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 259 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 259 => 'IngredientsToPart' },
	'ingredientsversionid' => { 259 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 172 => '9.3' },
	'inkset' => { 70 => 0x14c },
	'instanceid' => { 259 => 'InstanceID' },
	'instantplaybacksetup' => { 113 => 0x3e },
	'instantplaybacktime' => { 113 => 0x3d },
	'instructions' => { 247 => 'Instructions' },
	'instrument' => { 258 => 'instrument' },
	'intellectualgenre' => { 244 => 'IntellectualGenre' },
	'intelligentauto' => { 227 => 0xb052 },
	'intelligentexposure' => { 195 => 0x5d },
	'intelligentresolution' => { 195 => 0x70 },
	'interchangecolorspace' => { 78 => 0x40 },
	'internalflash' => { 110 => 0x2b, 172 => '23.1', 173 => '8.1', 174 => '22.1', 175 => '8.1', 176 => '24.1', 180 => 0x1208 },
	'internalflashae1' => { 182 => 0x1021 },
	'internalflashae1_0' => { 182 => 0x101d },
	'internalflashae2' => { 182 => 0x1022 },
	'internalflashae2_0' => { 182 => 0x101e },
	'internalflashmode' => { 205 => 0x1 },
	'internalflashstrength' => { 205 => 0x3 },
	'internalflashtable' => { 182 => 0x1024 },
	'internalserialnumber' => { 34 => 0x96, 41 => 0x9, 74 => 0x10, 178 => 0x102, 195 => 0x25, 201 => 0x4, 219 => 0x5 },
	'interopindex' => { 70 => 0x1 },
	'interopversion' => { 70 => 0x2 },
	'intervallength' => { 110 => 0x10 },
	'intervalmode' => { 110 => 0x26 },
	'intervalnumber' => { 110 => 0x11 },
	'introtimescale' => { 258 => 'introTimeScale' },
	'introtimevalue' => { 258 => 'introTimeValue' },
	'iptc-naa' => { 70 => 0x83bb, 197 => 0x83bb },
	'iptcbitspersample' => { 78 => 0x56 },
	'iptcdigest' => { 215 => 0x425 },
	'iptcimageheight' => { 78 => 0x1e },
	'iptcimagerotation' => { 78 => 0x66 },
	'iptcimagewidth' => { 78 => 0x14 },
	'iptclastedited' => { 245 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 78 => 0xa },
	'iptcpixelheight' => { 78 => 0x32 },
	'iptcpixelwidth' => { 78 => 0x28 },
	'isbn' => { 249 => 'isbn' },
	'iscorrectionof' => { 249 => 'isCorrectionOf' },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 17 => 0x0, 18 => 0x1, 66 => 0x14, 67 => [0x3014,0x14], 70 => 0x8827, 80 => 0xfd06, 81 => 0x1784, 83 => 0x60, 84 => [0xfa2e,0xfa46], 85 => [0x27,0x28], 86 => 0xf105, 89 => 0x14, 91 => 0x4e, 94 => 0x34, 96 => 'ISO', 110 => 0x8, 133 => 0x0, 137 => 0x2, 197 => 0x17, 209 => 0x14, 211 => 0x14, 222 => 0xa014, 243 => 'ISOSpeedRatings' },
	'iso2' => { 133 => 0x6, 144 => 0x265, 145 => 0x25c, 146 => 0x265, 147 => 0x221, 148 => 0x25d, 149 => 0x256, 150 => 0x25d, 152 => 0x2b5, 154 => 0x2b5 },
	'isodisplay' => { 174 => '2.3', 176 => '4.3' },
	'isoexpansion' => { 47 => 0x103, 48 => 0x7, 49 => 0x8, 52 => 0x8, 133 => 0x4 },
	'isoexpansion2' => { 133 => 0xa },
	'isofloor' => { 202 => 0x6 },
	'isoselection' => { 137 => 0xf },
	'isosetting' => { 83 => 0x5e, 96 => 'ISOSetting', 110 => 0x24, 111 => 0x26, 112 => 0x1c, 113 => 0x13, 116 => 0x6, 137 => 0x13, 202 => '17.3', 218 => 0x27, 225 => 0x16, 226 => 0x14 },
	'isospeedexpansion' => { 46 => 0x3 },
	'isospeedincrements' => { 47 => 0x102 },
	'isospeedrange' => { 47 => 0x103 },
	'isostepsize' => { 172 => '6.1' },
	'isovalue' => { 182 => 0x1001 },
	'issn' => { 249 => 'issn' },
	'issueidentifier' => { 249 => 'issueIdentifier' },
	'issuename' => { 249 => 'issueName' },
	'istranslationof' => { 249 => 'isTranslationOf' },
	'jobid' => { 76 => 0xb8 },
	'jobrefid' => { 257 => 'JobRefId' },
	'jobrefname' => { 257 => 'JobRefName' },
	'jobrefurl' => { 257 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66 },
	'jpgfromraw' => { 60 => 0x2007, 68 => 'JpgFromRaw', 197 => 0x2e },
	'jpgfromrawlength' => { 70 => [0x117,0x202] },
	'jpgfromrawstart' => { 70 => [0x111,0x201] },
	'jpgrecordedpixels' => { 202 => 0xe },
	'key' => { 258 => 'key' },
	'keyword' => { 249 => 'keyword' },
	'keywords' => { 76 => 0x19, 97 => 'Keywords', 186 => 'Keywords', 217 => 'Keywords', 236 => 'keywords', 246 => 'Keywords' },
	'killdate' => { 249 => 'killDate' },
	'kodakimageheight' => { 80 => 0xf908, 83 => 0xe, 84 => [0xfa1e,0xfa52], 90 => 0x70 },
	'kodakimagewidth' => { 80 => 0xf907, 83 => 0xc, 84 => [0xfa1d,0xfa51], 90 => 0x6c },
	'kodakinfotype' => { 80 => 0xfa00 },
	'kodakmaker' => { 90 => 0x8 },
	'kodakmodel' => { 83 => 0x0, 90 => 0x28 },
	'label' => { 188 => 'Label', 256 => 'Label' },
	'landmark' => { 195 => 0x6f },
	'language' => { 240 => 'language' },
	'languageidentifier' => { 76 => 0x87 },
	'lastfilenumber' => { 110 => 0x1b },
	'lastkeywordiptc' => { 235 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 235 => 'LastKeywordXMP' },
	'lasturl' => { 259 => 'LastURL' },
	'lc1' => { 206 => 0x2 },
	'lc10' => { 206 => 0xb },
	'lc11' => { 206 => 0xc },
	'lc12' => { 206 => 0xd },
	'lc14' => { 206 => 0xf },
	'lc15' => { 206 => 0x10 },
	'lc2' => { 206 => 0x3 },
	'lc3' => { 206 => 0x4 },
	'lc4' => { 206 => 0x5 },
	'lc5' => { 206 => 0x6 },
	'lc6' => { 206 => 0x7 },
	'lc7' => { 206 => 0x8 },
	'lcddisplayatpoweron' => { 47 => 0x811, 51 => 0xa },
	'lcddisplayreturntoshoot' => { 52 => 0x12 },
	'lcdillumination' => { 172 => '17.5', 176 => '5.4' },
	'lcdilluminationduringbulb' => { 47 => 0x408 },
	'lcdpanels' => { 46 => 0x8 },
	'lcheditor' => { 165 => 0x8ae85e },
	'legacyiptcdigest' => { 247 => 'LegacyIPTCDigest' },
	'lens' => { 70 => 0xfdea, 137 => 0x84, 224 => 0xa, 237 => 'Lens' },
	'lensafstopbutton' => { 45 => 0x11, 46 => 0x13, 47 => 0x506, 48 => 0x10, 49 => 0x12, 52 => 0x13, 53 => 0x9 },
	'lensaperturerange' => { 224 => 0x30 },
	'lensdistortionparams' => { 182 => 0x206 },
	'lensdrivenoaf' => { 47 => 0x505 },
	'lensfirmware' => { 220 => 0x20 },
	'lensfirmwareversion' => { 178 => 0x204 },
	'lensfstops' => { 134 => 0x7, 135 => 0xc, 136 => 0xd, 137 => 0x8b, 206 => '0.3' },
	'lensid' => { 237 => 'LensID' },
	'lensidnumber' => { 134 => 0x6, 135 => 0xb, 136 => 0xc },
	'lensinfo' => { 237 => 'LensInfo' },
	'lenskind' => { 206 => 0x1 },
	'lensmake' => { 103 => 'Make' },
	'lensmanufacturer' => { 235 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 8 => 0x92b, 9 => 0x933, 34 => 0x95, 103 => 'Model', 235 => 'LensModel' },
	'lensproperties' => { 178 => 0x20b },
	'lensserialnumber' => { 103 => 'SerialNumber', 178 => 0x202, 195 => 0x52, 220 => 0x30 },
	'lensshutterlock' => { 113 => 0x4a },
	'lenstemperature' => { 182 => 0x1008 },
	'lenstype' => { 2 => 0xe2, 3 => 0xd, 4 => 0xc, 5 => 0x111, 6 => 0xc, 8 => 0xd6, 9 => 0xde, 10 => 0xf6, 11 => 0xea, 12 => 0xff, 13 => [0xc,0x97], 14 => 0xe6, 16 => 0xee, 20 => 0x16, 114 => 0x10c, 137 => 0x83, 178 => 0x201, 191 => 0x310, 194 => 0x303, 195 => 0x51, 196 => 0x3405, 207 => 0x0, 208 => 0x0, 209 => 0x3f, 222 => 0xa003, 227 => 0xb027 },
	'levelgaugepitch' => { 177 => 0x904 },
	'levelgaugeroll' => { 177 => 0x903 },
	'license' => { 238 => 'license' },
	'licenseeid' => { 248 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 248 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 248 => 'LicenseeImageNotes' },
	'licenseename' => { 248 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 248 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 248 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 248 => 'LicenseeTransactionID' },
	'licenseid' => { 248 => 'LicenseID' },
	'licensestartdate' => { 248 => 'LicenseStartDate' },
	'licensetransactiondate' => { 248 => 'LicenseTransactionDate' },
	'licensetype' => { 241 => 'licensetype' },
	'licensorcity' => { 248 => 'LicensorLicensorCity' },
	'licensorcountry' => { 248 => 'LicensorLicensorCountry' },
	'licensoremail' => { 248 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 248 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 248 => 'LicensorLicensorID' },
	'licensorimageid' => { 248 => 'LicensorImageID' },
	'licensorname' => { 248 => 'LicensorLicensorName' },
	'licensornotes' => { 248 => 'LicensorNotes' },
	'licensorpostalcode' => { 248 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 248 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 248 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 248 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 248 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 248 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 248 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 248 => 'LicensorTransactionID' },
	'licensorurl' => { 248 => 'LicensorLicensorURL' },
	'lightcondition' => { 182 => 0x1009 },
	'lightingmode' => { 67 => 0x302a },
	'lightreading' => { 209 => 0x15 },
	'lightsource' => { 70 => 0x9208, 137 => 0x90, 185 => 0x1000, 243 => 'LightSource' },
	'lightsourcespecial' => { 223 => 0x21d },
	'lightswitch' => { 176 => '0.1' },
	'lightvaluecenter' => { 182 => 0x103d },
	'lightvalueperiphery' => { 182 => 0x103e },
	'linearresponselimit' => { 70 => 0xc62e },
	'liveviewaf' => { 174 => '32.1', 176 => '34.1' },
	'liveviewexposuresimulation' => { 47 => 0x810 },
	'liveviewshooting' => { 30 => 0x13 },
	'localafareapoint' => { 113 => 0xd, 225 => 0x12, 226 => 0x12 },
	'localcaption' => { 76 => 0x79 },
	'localizedcameramodel' => { 70 => 0xc615 },
	'location' => { 234 => 'Location', 244 => 'Location', 249 => 'location' },
	'locationcreatedcity' => { 245 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 245 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 245 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 245 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 245 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 245 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 245 => 'LocationShownCity' },
	'locationshowncountrycode' => { 245 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 245 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 245 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 245 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 245 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 47 => 0x709 },
	'logcomment' => { 258 => 'logComment' },
	'longexposurenoisereduction' => { 47 => 0x201, 48 => 0x1, 49 => 0x2, 50 => 0x1, 51 => 0x1, 52 => 0x2, 53 => 0x1, 225 => 0x2b, 227 => 0xb04e },
	'longexposurenoisereduction2' => { 30 => 0x8 },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 8 => 0xda, 10 => 0xfa, 11 => 0xee, 12 => 0x103, 13 => 0x95, 14 => 0xea, 16 => 0xf2, 20 => 0x17 },
	'loop' => { 258 => 'loop' },
	'luminanceadjustmentaqua' => { 239 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 239 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 239 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 239 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 239 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 239 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 239 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 239 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 65 => 0x5f },
	'luminancenr_tiff_jpeg' => { 65 => 0x6d },
	'luminancesmoothing' => { 239 => 'LuminanceSmoothing' },
	'm16cversion' => { 191 => 0x333 },
	'macro' => { 74 => 0x1020, 182 => 0x202, 218 => 0x21, 223 => 0x202, 227 => 0xb040 },
	'macromagnification' => { 2 => 0x1b, 5 => 0x1b, 8 => 0x1b, 9 => 0x1b, 13 => 0x1b, 14 => 0x1b, 30 => 0x10 },
	'macromode' => { 20 => 0x1, 110 => 0xb, 177 => 0x300, 195 => 0x1c },
	'magnifiedview' => { 49 => 0x11, 51 => 0x9 },
	'maindialexposurecomp' => { 175 => '0.6' },
	'make' => { 61 => 0x0, 70 => 0x10f, 96 => 'Make', 188 => 'Make', 197 => 0x10f, 254 => 'Make' },
	'makernote' => { 243 => 'MakerNote' },
	'makernotecanon' => { 69 => 'MakN', 70 => 0x927c },
	'makernotecasio' => { 69 => 'MakN', 70 => 0x927c },
	'makernotecasio2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotefujifilm' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotehp6' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteisl' => { 69 => 'MakN', 70 => 0x927c },
	'makernotejvc' => { 69 => 'MakN', 70 => 0x927c },
	'makernotejvctext' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak10' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak1a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak1b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak5' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak6a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak6b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak7' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak8a' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak8b' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodak9' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekodakunknown' => { 69 => 'MakN', 70 => 0x927c },
	'makernotekyocera' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica2' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica3' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica4' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica5' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteleica6' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta2' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteminolta3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotenikon3' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteoffset' => { 223 => 0xff },
	'makernoteolympus' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteolympus2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepanasonic' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepanasonic2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotepentax4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotericoh' => { 69 => 'MakN', 70 => 0x927c },
	'makernotericohtext' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesafety' => { 70 => 0xc635 },
	'makernotesamsung' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesamsung2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyo' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyoc4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesanyopatch' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesigma' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony2' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony3' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesony4' => { 69 => 'MakN', 70 => 0x927c },
	'makernotesonysrf' => { 69 => 'MakN', 70 => 0x927c },
	'makernotetype' => { 219 => 0x1 },
	'makernoteunknown' => { 69 => 'MakN', 70 => 0x927c },
	'makernoteversion' => { 114 => 0x0, 137 => 0x1, 182 => 0x0, 195 => 0x8000, 222 => 0x1, 224 => 0x1d },
	'managedfromalternatepaths' => { 259 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 259 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 259 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 259 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 259 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 259 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 259 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 259 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 259 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 259 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 259 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 259 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 259 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 259 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 259 => 'ManagedFromToPart' },
	'managedfromversionid' => { 259 => 'ManagedFromVersionID' },
	'manager' => { 259 => 'Manager' },
	'managervariant' => { 259 => 'ManagerVariant' },
	'manageto' => { 259 => 'ManageTo' },
	'manageui' => { 259 => 'ManageUI' },
	'manometerpressure' => { 177 => 0x900 },
	'manometerreading' => { 177 => 0x901 },
	'manualafpointselectpattern' => { 47 => 0x513 },
	'manualexposuretime' => { 113 => 0x6 },
	'manualflash' => { 180 => 0x1209 },
	'manualflashoutput' => { 20 => 0x29, 173 => '8.2', 174 => '22.2', 175 => '8.2', 176 => '24.2' },
	'manualflashstrength' => { 177 => 0x406 },
	'manualfnumber' => { 113 => 0x7 },
	'manualfocusdistance' => { 137 => 0x85, 182 => 0x100c, 223 => 0x223 },
	'manualtv' => { 46 => 0x5, 47 => 0x705 },
	'manufacturedate' => { 201 => 0x1 },
	'manufacturedate1' => { 221 => 0x4 },
	'manufacturedate2' => { 221 => 0x5 },
	'marked' => { 246 => 'Marked', 262 => 'Marked' },
	'markerscomment' => { 258 => 'markersComment' },
	'markerscuepointparamskey' => { 258 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 258 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 258 => 'markersCuePointType' },
	'markersduration' => { 258 => 'markersDuration' },
	'markerslocation' => { 258 => 'markersLocation' },
	'markersname' => { 258 => 'markersName' },
	'markersprobability' => { 258 => 'markersProbability' },
	'markersspeaker' => { 258 => 'markersSpeaker' },
	'markersstarttime' => { 258 => 'markersStartTime' },
	'markerstarget' => { 258 => 'markersTarget' },
	'markerstype' => { 258 => 'markersType' },
	'maskedareas' => { 70 => 0xc68e },
	'masterdocumentid' => { 76 => 0xb9 },
	'mastergain' => { 142 => 0x50 },
	'maxaperture' => { 20 => 0x1a, 86 => 0x6103, 103 => 'MaxAperture', 110 => 0x17, 206 => '14.1' },
	'maxapertureatcurrentfocal' => { 178 => 0x20a },
	'maxapertureatmaxfocal' => { 74 => 0x1407, 103 => 'MaxApertureAtMaxFocal', 134 => 0xb, 135 => 0x10, 136 => 0x11, 178 => 0x206 },
	'maxapertureatminfocal' => { 74 => 0x1406, 134 => 0xa, 135 => 0xf, 136 => 0x10, 178 => 0x205 },
	'maxaperturevalue' => { 70 => 0x9205, 243 => 'MaxApertureValue' },
	'maxavailheight' => { 245 => 'MaxAvailHeight' },
	'maxavailwidth' => { 245 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 172 => 0xb },
	'maxfocallength' => { 74 => 0x1405, 103 => 'MaxFocalLength', 134 => 0x9, 135 => 0xe, 136 => 0xf, 178 => 0x208 },
	'maximumdensityrange' => { 78 => 0x8c },
	'maxpagesizeh' => { 263 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 263 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 263 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 70 => 0x119 },
	'mb-d10batteries' => { 172 => '12.6' },
	'mb-d80batteries' => { 175 => '6.5' },
	'mb-d80batterytype' => { 176 => '3.2' },
	'mcuversion' => { 134 => 0xc, 135 => 0x11, 136 => 0x12 },
	'md5digest' => { 104 => 'zmd5' },
	'measuredev' => { 42 => 0x3, 60 => 0x1814, 96 => 'MeasuredEV' },
	'measuredev2' => { 42 => 0x17 },
	'measuredlv' => { 191 => 0x312 },
	'measuredrggb' => { 35 => 0x1 },
	'measuredrggbdata' => { 24 => 0x287 },
	'mediaconstraints' => { 248 => 'MediaConstraints' },
	'mediasummarycode' => { 248 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 45 => 0xb, 48 => 0xa, 49 => 0xb, 52 => 0xb },
	'menubuttonreturn' => { 53 => 0xb },
	'menumonitorofftime' => { 176 => '22.1' },
	'metadatadate' => { 256 => 'MetadataDate' },
	'metadatamoddate' => { 258 => 'metadataModDate' },
	'metering' => { 173 => '6.1' },
	'meteringmode' => { 20 => 0x11, 70 => 0x9207, 83 => 0x1c, 110 => 0x7, 111 => 0x25, 113 => 0x12, 177 => 0x202, 209 => 0x17, 224 => 0x9, 225 => 0x15, 226 => 0x13, 243 => 'MeteringMode' },
	'meteringmode2' => { 202 => '2.1' },
	'meteringmode3' => { 202 => '16.1' },
	'meteringoffscaleindicator' => { 113 => 0x53 },
	'meteringtime' => { 172 => '22.2', 173 => '3.2', 174 => '17.1', 175 => '3.2', 176 => '19.1' },
	'mieversion' => { 104 => '0Vers' },
	'minaperture' => { 20 => 0x1b, 103 => 'MinAperture', 206 => '0.2' },
	'minfocallength' => { 74 => 0x1404, 103 => 'MinFocalLength', 134 => 0x8, 135 => 0xd, 136 => 0xe, 178 => 0x207 },
	'minoltadate' => { 110 => 0x15 },
	'minoltaimagesize' => { 110 => 0x4, 111 => 0xc, 112 => 0x2, 114 => 0x103 },
	'minoltamodelid' => { 110 => 0x25 },
	'minoltaquality' => { 110 => 0x5, 111 => 0xd, 112 => 0x3, 114 => [0x102,0x103] },
	'minoltatime' => { 110 => 0x16 },
	'minormodelagedisclosure' => { 248 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 70 => 0x118 },
	'mirrorlockup' => { 45 => 0xc, 46 => 0xc, 47 => 0x60f, 48 => 0xb, 49 => 0xc, 50 => 0x6, 51 => 0x6, 52 => 0xc, 53 => 0x3 },
	'moddate' => { 188 => 'modify-date', 246 => 'ModDate' },
	'model' => { 61 => 0x6, 70 => 0x110, 96 => 'Model', 188 => 'Model', 197 => 0x110, 254 => 'Model' },
	'modelage' => { 245 => 'ModelAge' },
	'modelingflash' => { 172 => '21.4', 175 => '7.4', 176 => '31.3' },
	'modelreleaseid' => { 248 => 'ModelReleaseID' },
	'modelreleasestatus' => { 248 => 'ModelReleaseStatus' },
	'modificationdate' => { 249 => 'modificationDate' },
	'modifiedcolortemp' => { 36 => 0x9 },
	'modifieddigitalgain' => { 36 => 0xb },
	'modifiedparamflag' => { 31 => 0x1 },
	'modifiedpicturestyle' => { 36 => 0xa },
	'modifiedsaturation' => { 177 => 0x504 },
	'modifiedsensorbluelevel' => { 36 => 0x5 },
	'modifiedsensorredlevel' => { 36 => 0x4 },
	'modifiedsharpness' => { 36 => 0x2 },
	'modifiedsharpnessfreq' => { 36 => 0x3 },
	'modifiedtonecurve' => { 36 => 0x1 },
	'modifiedwhitebalance' => { 36 => 0x8 },
	'modifiedwhitebalanceblue' => { 36 => 0x7 },
	'modifiedwhitebalancered' => { 36 => 0x6 },
	'modifydate' => { 70 => 0x132, 97 => 'ModifyDate', 186 => 'ModDate', 187 => 'tIME', 217 => 'ModDate', 256 => 'ModifyDate' },
	'moirefilter' => { 70 => 0xfe58, 239 => 'MoireFilter' },
	'monitordisplayoff' => { 113 => 0x4c },
	'monitorofftime' => { 172 => '18.2', 173 => '3.1', 175 => '3.1' },
	'monochromecontrast' => { 65 => 0x3c },
	'monochromefiltereffect' => { 65 => 0x3a },
	'monochromelinear' => { 65 => 0x3d },
	'monochromesharpness' => { 65 => 0x3e },
	'monochrometoningeffect' => { 65 => 0x3b },
	'monthdaycreated' => { 83 => 0x12, 91 => 0xe },
	'morepermissions' => { 238 => 'morePermissions' },
	'multicontrollerwhilemetering' => { 47 => 0x517 },
	'multiexposureautogain' => { 138 => 0x3 },
	'multiexposuremode' => { 138 => 0x1 },
	'multiexposureshots' => { 138 => 0x2 },
	'multipleexposuremode' => { 181 => 0x101c },
	'multipleexposureset' => { 202 => '10.1' },
	'multisample' => { 142 => 0x40 },
	'multiselector' => { 172 => '9.4' },
	'multiselectorplaybackmode' => { 172 => '9.2' },
	'multiselectorshootmode' => { 172 => '9.1' },
	'mycolormode' => { 37 => 0x2 },
	'nativedigest' => { 243 => 'NativeDigest', 254 => 'NativeDigest' },
	'ncdfileinfo' => { 81 => 0x414 },
	'ndfilter' => { 42 => 0x1c },
	'nearlensstep' => { 182 => 0x103c },
	'nefbitdepth' => { 137 => 0xe22 },
	'nefcompression' => { 137 => 0x93 },
	'newsphotoversion' => { 78 => 0x0 },
	'nickname' => { 256 => 'Nickname' },
	'nikoncaptureversion' => { 137 => 0xe09 },
	'nikoniccprofile' => { 137 => 0xe1d },
	'nikonimagesize' => { 149 => '723.1', 150 => '732.1', 153 => 0x2c4 },
	'noisefilter' => { 177 => 0x527 },
	'noisereduction' => { 74 => 0x100b, 111 => 0xb0, 112 => 0x60, 113 => 0x3f, 137 => 0x95, 165 => 0x753dcbc0, 166 => 0x17, 177 => 0x50a, 182 => 0x103a, 195 => 0x2d, 209 => 0x49 },
	'noisereduction2' => { 181 => 0x1010 },
	'noisereductionapplied' => { 70 => 0xc6f7 },
	'noisereductionintensity' => { 166 => 0x9 },
	'noisereductionmethod' => { 166 => 0x11 },
	'noisereductionmode' => { 229 => 0x801e },
	'noisereductionsharpness' => { 166 => 0xd },
	'noisereductionvalue' => { 229 => 0x8027 },
	'nomemorycard' => { 172 => '22.1', 173 => '0.3', 174 => '2.4', 175 => '0.3', 176 => '4.5' },
	'nominalmaxaperture' => { 206 => 0xa },
	'nominalminaperture' => { 206 => '10.1' },
	'notes' => { 230 => 'Notes', 236 => 'notes' },
	'npages' => { 263 => 'NPages' },
	'nullrecord' => { 60 => 0x0 },
	'number' => { 249 => 'number' },
	'numberofbeats' => { 258 => 'numberOfBeats' },
	'numfacepositions' => { 189 => 0x0 },
	'numindexentries' => { 78 => 0x54 },
	'object' => { 249 => 'object' },
	'objectattributereference' => { 76 => 0x4 },
	'objectcycle' => { 76 => 0x4b },
	'objectdistance' => { 66 => 0x6, 67 => 0x2022 },
	'objectname' => { 76 => 0x5 },
	'objectpreviewdata' => { 76 => 0xca },
	'objectpreviewfileformat' => { 76 => 0xc8 },
	'objectpreviewfileversion' => { 76 => 0xc9 },
	'objecttypereference' => { 76 => 0x3 },
	'oecfcolumns' => { 243 => 'OECFColumns' },
	'oecfnames' => { 243 => 'OECFNames' },
	'oecfrows' => { 243 => 'OECFRows' },
	'oecfvalues' => { 243 => 'OECFValues' },
	'offsetschema' => { 70 => 0xea1d },
	'okbutton' => { 176 => '16.1' },
	'oldsubfiletype' => { 70 => 0xff },
	'olympusimageheight' => { 182 => 0x102f },
	'olympusimagewidth' => { 182 => 0x102e },
	'onetouchwb' => { 182 => 0x302 },
	'opticalzoom' => { 84 => 0xfa3d, 86 => [0x6006,0xf006], 87 => 0x1000, 88 => 0xf, 91 => 0x1e, 103 => 'OpticalZoom' },
	'opticalzoomcode' => { 42 => 0xa },
	'opticalzoommode' => { 195 => 0x34 },
	'opticalzoomon' => { 223 => 0x219 },
	'optionenddate' => { 251 => 'optionEndDate' },
	'ordernumber' => { 74 => 0x8002 },
	'organisationinimagecode' => { 245 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 245 => 'OrganisationInImageName' },
	'organization' => { 249 => 'organization' },
	'orientation' => { 70 => 0x112, 197 => 0x112, 254 => 'Orientation' },
	'orientationlinkedafpoint' => { 47 => 0x516 },
	'originaldecisiondata' => { 68 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 34 => 0x83 },
	'originaldirectory' => { 193 => 0x408 },
	'originaldocumentid' => { 259 => 'OriginalDocumentID' },
	'originalfilename' => { 60 => 0x816, 81 => 0x3e9, 92 => 0x20, 193 => 0x407 },
	'originalimageheight' => { 43 => 0xc, 73 => 0x1 },
	'originalimagewidth' => { 43 => 0xb, 73 => 0x0 },
	'originalrawfiledata' => { 70 => 0xc68c },
	'originalrawfiledigest' => { 70 => 0xc71d },
	'originalrawfilename' => { 70 => 0xc68b },
	'originaltransmissionreference' => { 76 => 0x67 },
	'originatingprogram' => { 76 => 0x41 },
	'originplatform' => { 249 => 'originPlatform' },
	'os' => { 241 => 'os' },
	'otherconditions' => { 248 => 'OtherConditions' },
	'otherconstraints' => { 248 => 'OtherConstraints' },
	'otherimageinfo' => { 248 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 248 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 248 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 248 => 'OtherLicenseRequirements' },
	'outcuescale' => { 258 => 'outCueScale' },
	'outcuevalue' => { 258 => 'outCueValue' },
	'outputimageheight' => { 121 => 0x3 },
	'outputimagewidth' => { 121 => 0x2 },
	'outputresolution' => { 121 => 0x4 },
	'owner' => { 262 => 'Owner' },
	'ownerid' => { 76 => 0xbc },
	'ownername' => { 34 => 0x9, 60 => 0x810, 70 => 0xfde8, 96 => 'OwnerName', 237 => 'OwnerName' },
	'padding' => { 70 => 0xea1c },
	'pageimage' => { 256 => 'PageInfoImage' },
	'pageimageformat' => { 256 => 'PageInfoFormat' },
	'pageimageheight' => { 256 => 'PageInfoHeight' },
	'pageimagepagenumber' => { 256 => 'PageInfoPageNumber' },
	'pageimagewidth' => { 256 => 'PageInfoWidth' },
	'pagename' => { 70 => 0x11d },
	'pagenumber' => { 70 => 0x129 },
	'pagerange' => { 249 => 'pageRange' },
	'panasonicexifversion' => { 195 => 0x26 },
	'panasonicrawversion' => { 197 => 0x1 },
	'panasonictitle' => { 70 => 0xc6d2 },
	'panasonictitle2' => { 70 => 0xc6d3 },
	'panoramadirection' => { 38 => 0x5 },
	'panoramaframenumber' => { 38 => 0x2 },
	'panoramamode' => { 83 => 0x3c, 177 => 0x601 },
	'parallax' => { 74 => 0xb211 },
	'parametricdarks' => { 239 => 'ParametricDarks' },
	'parametrichighlights' => { 239 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 239 => 'ParametricHighlightSplit' },
	'parametriclights' => { 239 => 'ParametricLights' },
	'parametricmidtonesplit' => { 239 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 239 => 'ParametricShadows' },
	'parametricshadowsplit' => { 239 => 'ParametricShadowSplit' },
	'patientid' => { 231 => 'PatientID' },
	'patientsbirthdate' => { 231 => 'PatientDOB' },
	'patientsname' => { 231 => 'PatientName' },
	'patientssex' => { 231 => 'PatientSex' },
	'pdfversion' => { 246 => 'PDFVersion' },
	'pentaximagesize' => { 209 => 0x9 },
	'pentaxmodelid' => { 201 => 0x0, 209 => 0x5 },
	'pentaxmodeltype' => { 209 => 0x1 },
	'pentaxversion' => { 209 => 0x0 },
	'people' => { 234 => 'People' },
	'peripheralillumcentralradius' => { 229 => 0x8030 },
	'peripheralillumcentralvalue' => { 229 => 0x8031 },
	'peripheralillumination' => { 65 => 0x68 },
	'peripheralilluminationon' => { 65 => 0x64 },
	'peripheralillumperiphvalue' => { 229 => 0x8032 },
	'peripherallighting' => { 43 => 0x2 },
	'peripherallightingsetting' => { 44 => 0x5 },
	'peripherallightingvalue' => { 43 => 0x6 },
	'permissions' => { 251 => 'permissions' },
	'person' => { 249 => 'person' },
	'personinimage' => { 245 => 'PersonInImage' },
	'pf0customfuncregistration' => { 55 => 0x1 },
	'pf10retainprogramshift' => { 55 => 0xb },
	'pf13drivepriority' => { 55 => 0xe },
	'pf14disablefocussearch' => { 55 => 0xf },
	'pf15disableafassistbeam' => { 55 => 0x10 },
	'pf16autofocuspointshoot' => { 55 => 0x11 },
	'pf17disableafpointsel' => { 55 => 0x12 },
	'pf18enableautoafpointsel' => { 55 => 0x13 },
	'pf19continuousshootspeed' => { 55 => 0x14 },
	'pf19shootingspeedhigh' => { 54 => 0xa },
	'pf19shootingspeedlow' => { 54 => 0x9 },
	'pf1disableshootingmodes' => { 55 => 0x2 },
	'pf1value' => { 54 => 0x1 },
	'pf20limitcontinousshots' => { 55 => 0x15 },
	'pf20maxcontinousshots' => { 54 => 0xb },
	'pf21enablequietoperation' => { 55 => 0x16 },
	'pf23felocktime' => { 54 => 0xd },
	'pf23postreleasetime' => { 54 => 0xe },
	'pf23settimerlengths' => { 55 => 0x18 },
	'pf23shutterbuttontime' => { 54 => 0xc },
	'pf24lightlcdduringbulb' => { 55 => 0x19 },
	'pf25aemode' => { 54 => 0xf },
	'pf25afmode' => { 54 => 0x12 },
	'pf25afpointsel' => { 54 => 0x13 },
	'pf25colormatrix' => { 54 => 0x17 },
	'pf25defaultclearsettings' => { 55 => 0x1a },
	'pf25drivemode' => { 54 => 0x11 },
	'pf25imagesize' => { 54 => 0x14 },
	'pf25meteringmode' => { 54 => 0x10 },
	'pf25parameters' => { 54 => 0x16 },
	'pf25wbmode' => { 54 => 0x15 },
	'pf26shortenreleaselag' => { 55 => 0x1b },
	'pf27reversedialrotation' => { 55 => 0x1c },
	'pf27value' => { 54 => 0x18 },
	'pf28noquickdialexpcomp' => { 55 => 0x1d },
	'pf29quickdialswitchoff' => { 55 => 0x1e },
	'pf2disablemeteringmodes' => { 55 => 0x3 },
	'pf2value' => { 54 => 0x2 },
	'pf30enlargementmode' => { 55 => 0x1f },
	'pf31originaldecisiondata' => { 55 => 0x20 },
	'pf3manualexposuremetering' => { 55 => 0x4 },
	'pf3value' => { 54 => 0x3 },
	'pf4exposuretimelimits' => { 55 => 0x5 },
	'pf4exposuretimemax' => { 54 => 0x5 },
	'pf4exposuretimemin' => { 54 => 0x4 },
	'pf5aperturelimits' => { 55 => 0x6 },
	'pf5aperturemax' => { 54 => 0x7 },
	'pf5aperturemin' => { 54 => 0x6 },
	'pf6presetshootingmodes' => { 55 => 0x7 },
	'pf7bracketcontinuousshoot' => { 55 => 0x8 },
	'pf8bracketshots' => { 54 => 0x8 },
	'pf8setbracketshots' => { 55 => 0x9 },
	'pf9changebracketsequence' => { 55 => 0xa },
	'phasedetectaf' => { 119 => 0x6 },
	'phonenumber' => { 97 => 'Phone' },
	'photoeffect' => { 20 => 0x28 },
	'photoeffects' => { 165 => 0xab5eca5e },
	'photoeffectsblue' => { 167 => 0x8 },
	'photoeffectsgreen' => { 167 => 0x6 },
	'photoeffectsred' => { 167 => 0x4 },
	'photoeffectstype' => { 167 => 0x0 },
	'photoinfoplayback' => { 172 => '17.6' },
	'photometricinterpretation' => { 70 => 0x106, 254 => 'PhotometricInterpretation' },
	'photoshopquality' => { 214 => 0x0 },
	'pictinfo' => { 223 => 0x208 },
	'picturecontrol' => { 165 => 0xe2173c47 },
	'picturecontrolactive' => { 168 => 0x0 },
	'picturecontroladjust' => { 139 => 0x30 },
	'picturecontrolbase' => { 139 => 0x18 },
	'picturecontrolmode' => { 168 => 0x13 },
	'picturecontrolname' => { 139 => 0x4 },
	'picturecontrolquickadjust' => { 139 => 0x31 },
	'picturefinish' => { 111 => 0x71 },
	'picturemode' => { 74 => 0x1031, 177 => 0x520, 209 => [0xb,0x33] },
	'picturemode2' => { 202 => 0x0 },
	'picturemodebwfilter' => { 177 => 0x525 },
	'picturemodecontrast' => { 177 => 0x523 },
	'picturemodehue' => { 177 => 0x522 },
	'picturemodesaturation' => { 177 => 0x521 },
	'picturemodesharpness' => { 177 => 0x524 },
	'picturemodetone' => { 177 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 10 => 0xab, 11 => 0xa7, 12 => 0xb0, 13 => 0x6c, 14 => 0xa7, 40 => 0xa, 65 => 0x2 },
	'picturewizard' => { 222 => 0x21 },
	'planarconfiguration' => { 70 => 0x11c, 254 => 'PlanarConfiguration' },
	'platenames' => { 263 => 'PlateNames' },
	'playbackmenustime' => { 174 => '20.1' },
	'playbackmonitorofftime' => { 176 => '21.1' },
	'playdisplay' => { 113 => 0x4e },
	'plusversion' => { 248 => 'Version' },
	'pngwarning' => { 188 => 'Warning' },
	'portraitrefiner' => { 67 => 0x302b },
	'postalcode' => { 101 => 'PostalCode' },
	'postcropvignetteamount' => { 239 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 239 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 239 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 239 => 'PostCropVignetteRoundness' },
	'powersource' => { 200 => 0x0 },
	'poweruptime' => { 137 => 0xb6 },
	'precaptureframes' => { 182 => 0x300 },
	'predictor' => { 70 => 0x13d },
	'preflashreturnstrength' => { 150 => 0x28a },
	'prefs' => { 76 => 0xdd, 213 => 'Prefs' },
	'preservedfilename' => { 259 => 'PreservedFileName' },
	'presetwhitebalance' => { 113 => 0x24, 229 => 0x8002 },
	'presetwhitebalanceadj' => { 229 => 0x8014 },
	'previewapplicationname' => { 70 => 0xc716 },
	'previewapplicationversion' => { 70 => 0xc717 },
	'previewbutton' => { 172 => ['14.1','15.1'] },
	'previewbuttonplusdials' => { 172 => ['14.2','15.2'] },
	'previewcolorspace' => { 70 => 0xc71a },
	'previewcropbottom' => { 212 => 0xef },
	'previewcropleft' => { 212 => 0xec },
	'previewcropright' => { 212 => 0xee },
	'previewcroptop' => { 212 => 0xed },
	'previewdatetime' => { 70 => 0xc71b },
	'previewheight' => { 84 => 0xfa58 },
	'previewimage' => { 67 => 0x2000, 68 => 'PreviewImage', 71 => 'PreviewImage', 72 => 0x4, 106 => 'data', 114 => 0x81, 182 => 0x280, 194 => 0x300, 227 => 0x2001 },
	'previewimageborders' => { 209 => 0x3e },
	'previewimageheight' => { 39 => 0x4 },
	'previewimagelength' => { 39 => 0x2, 67 => 0x3, 70 => [0x117,0x202], 114 => 0x89, 140 => 0x202, 177 => 0x102, 182 => 0x1037, 209 => 0x3, 218 => 0x1e, 224 => 0x1b },
	'previewimagename' => { 106 => '1Name' },
	'previewimagesize' => { 67 => 0x2, 89 => 0x2, 106 => 'ImageSize', 209 => 0x2, 224 => 0x1c, 227 => 0xb02c },
	'previewimagestart' => { 39 => 0x5, 67 => 0x4, 70 => [0x111,0x201], 114 => 0x88, 140 => 0x201, 177 => 0x101, 182 => 0x1036, 209 => 0x4, 218 => 0x1c, 224 => 0x1a },
	'previewimagetype' => { 106 => '0Type' },
	'previewimagevalid' => { 177 => 0x100, 182 => 0x1035 },
	'previewimagewidth' => { 39 => 0x3 },
	'previewquality' => { 39 => 0x1 },
	'previewsettingsdigest' => { 70 => 0xc719 },
	'previewsettingsname' => { 70 => 0xc718 },
	'previewwidth' => { 84 => 0xfa57 },
	'primaryafpoint' => { 119 => 0x7 },
	'primarychromaticities' => { 70 => 0x13f, 254 => 'PrimaryChromaticities' },
	'printim' => { 70 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 113 => 0x1d, 225 => 0x28 },
	'privatertkinfo' => { 232 => 'privateRTKInfo' },
	'processingsoftware' => { 70 => 0xb },
	'producer' => { 186 => 'Producer', 246 => 'Producer' },
	'productid' => { 77 => 0x32 },
	'productioncode' => { 201 => 0x2 },
	'productorserviceconstraints' => { 248 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 70 => 0xc6f4 },
	'profilecopyright' => { 70 => 0xc6fe },
	'profileembedpolicy' => { 70 => 0xc6fd },
	'profilehuesatmapdata1' => { 70 => 0xc6fa },
	'profilehuesatmapdata2' => { 70 => 0xc6fb },
	'profilehuesatmapdims' => { 70 => 0xc6f9 },
	'profilelooktabledata' => { 70 => 0xc726 },
	'profilelooktabledims' => { 70 => 0xc725 },
	'profilename' => { 70 => 0xc6f8 },
	'profiletonecurve' => { 70 => 0xc6fc },
	'programiso' => { 195 => 0x3c },
	'programline' => { 202 => '1.1' },
	'programmode' => { 116 => 0x5 },
	'programshift' => { 137 => 0xd },
	'programversion' => { 76 => 0x46 },
	'projectrefpath' => { 258 => 'projectRefPath' },
	'projectreftype' => { 258 => 'projectRefType' },
	'propertyreleaseid' => { 248 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 248 => 'PropertyReleaseStatus' },
	'province-state' => { 76 => 0x5f },
	'publicationdate' => { 249 => 'publicationDate' },
	'publicationname' => { 249 => 'publicationName' },
	'publisher' => { 240 => 'publisher' },
	'pulldown' => { 258 => 'pullDown' },
	'quality' => { 0 => 0x1, 20 => 0x3, 66 => 0x2, 67 => 0x3002, 74 => 0x1000, 83 => 0x9, 137 => 0x4, 155 => 0x3, 182 => 0x201, 191 => 0x300, 209 => 0x8, 211 => 0x2, 224 => 0x16, 225 => 0x56, 227 => [0x102,0xb047] },
	'qualitymode' => { 67 => 0x8 },
	'quantizationmethod' => { 78 => 0x78 },
	'quickadjust' => { 168 => 0x2a },
	'quickcontroldialinmeter' => { 47 => 0x703 },
	'quickshot' => { 223 => 0x213 },
	'rangefinder' => { 174 => '4.1' },
	'rasterizedcaption' => { 76 => 0x7d },
	'rating' => { 70 => 0x4746, 212 => 0xdf, 236 => 'rating', 241 => 'rating', 256 => 'Rating' },
	'ratingpercent' => { 70 => 0x4749, 235 => 'Rating' },
	'rawandjpgrecording' => { 45 => 0x8, 114 => 0x109, 202 => 0xd },
	'rawbrightnessadj' => { 64 => 0x38 },
	'rawcoloradj' => { 64 => 0x2e },
	'rawcolortoneadj' => { 65 => 0xd },
	'rawcontrastadj' => { 65 => 0xf },
	'rawcropbottom' => { 212 => 0xd4 },
	'rawcropleft' => { 212 => 0xd1 },
	'rawcropright' => { 212 => 0xd3 },
	'rawcroptop' => { 212 => 0xd2 },
	'rawcustomsaturation' => { 64 => 0x30 },
	'rawcustomtone' => { 64 => 0x34 },
	'rawdatauniqueid' => { 70 => 0xc65d },
	'rawdepth' => { 115 => 0x10 },
	'rawdevautogradation' => { 184 => 0x119 },
	'rawdevcolorspace' => { 183 => 0x108, 184 => 0x109 },
	'rawdevcontrastvalue' => { 183 => 0x106, 184 => 0x105 },
	'rawdeveditstatus' => { 183 => 0x10b },
	'rawdevengine' => { 183 => 0x109, 184 => 0x10b },
	'rawdevexposurebiasvalue' => { 183 => 0x100, 184 => 0x100 },
	'rawdevgradation' => { 184 => 0x112 },
	'rawdevgraypoint' => { 183 => 0x103, 184 => 0x104 },
	'rawdevmemorycoloremphasis' => { 183 => 0x105, 184 => 0x108 },
	'rawdevnoisereduction' => { 183 => 0x10a, 184 => 0x10a },
	'rawdevpicturemode' => { 184 => 0x10c },
	'rawdevpm_bwfilter' => { 184 => 0x110 },
	'rawdevpmcontrast' => { 184 => 0x10e },
	'rawdevpmnoisefilter' => { 184 => 0x120 },
	'rawdevpmpicturetone' => { 184 => 0x111 },
	'rawdevpmsaturation' => { 184 => 0x10d },
	'rawdevpmsharpness' => { 184 => 0x10f },
	'rawdevsaturation3' => { 184 => 0x113 },
	'rawdevsaturationemphasis' => { 183 => 0x104, 184 => 0x107 },
	'rawdevsettings' => { 183 => 0x10c },
	'rawdevsharpnessvalue' => { 183 => 0x107, 184 => 0x106 },
	'rawdevversion' => { 183 => 0x0, 184 => 0x0 },
	'rawdevwbfineadjustment' => { 183 => 0x102, 184 => 0x103 },
	'rawdevwhitebalance' => { 184 => 0x101 },
	'rawdevwhitebalancevalue' => { 183 => 0x101, 184 => 0x102 },
	'rawfile' => { 70 => 0xfe4c },
	'rawfilename' => { 239 => 'RawFileName' },
	'rawhighlightpoint' => { 65 => 0x12 },
	'rawimagecenter' => { 137 => 0x99 },
	'rawimagedigest' => { 70 => 0xc71c },
	'rawimagesize' => { 209 => 0x39 },
	'rawinfoversion' => { 185 => 0x0 },
	'rawjpgheight' => { 62 => 0x4 },
	'rawjpgquality' => { 30 => 0x6, 62 => 0x1 },
	'rawjpgsize' => { 30 => 0x7, 62 => 0x2 },
	'rawjpgwidth' => { 62 => 0x3 },
	'rawlinear' => { 65 => 0x10 },
	'rawmeasuredrggb' => { 23 => 0x26a, 25 => 0x280 },
	'rawsaturationadj' => { 65 => 0xe },
	'rawshadowpoint' => { 65 => 0x13 },
	'rawsharpnessadj' => { 65 => 0x11 },
	'reardisplay' => { 172 => '12.3' },
	'recognizedface1age' => { 190 => 0x20 },
	'recognizedface1name' => { 190 => 0x4 },
	'recognizedface1position' => { 190 => 0x18 },
	'recognizedface2age' => { 190 => 0x50 },
	'recognizedface2name' => { 190 => 0x34 },
	'recognizedface2position' => { 190 => 0x48 },
	'recognizedface3age' => { 190 => 0x80 },
	'recognizedface3name' => { 190 => 0x64 },
	'recognizedface3position' => { 190 => 0x78 },
	'recognizedfaceflags' => { 195 => 0x63 },
	'recorddisplay' => { 113 => 0x4d },
	'recordid' => { 60 => 0x1804 },
	'recordingmode' => { 66 => 0x1, 211 => 0x1 },
	'recordmode' => { 20 => 0x9, 67 => 0x3000 },
	'recordshutterrelease' => { 223 => 0x217 },
	'redbalance' => { 126 => 0x270, 182 => 0x1017, 197 => 0x11, 209 => 0x1c },
	'redcurvelimits' => { 64 => 0x18a },
	'redcurvepoints' => { 64 => 0x160 },
	'redeyecorrection' => { 169 => 0x0 },
	'redeyeinfo' => { 239 => 'RedEyeInfo' },
	'redeyereduction' => { 113 => 0x41 },
	'redhue' => { 239 => 'RedHue' },
	'redsaturation' => { 239 => 'RedSaturation' },
	'referenceblackwhite' => { 70 => 0x214, 254 => 'ReferenceBlackWhite' },
	'referencedate' => { 76 => 0x2f },
	'referencenumber' => { 76 => 0x32 },
	'references' => { 97 => 'References' },
	'referenceservice' => { 76 => 0x2d },
	'regionconstraints' => { 248 => 'RegionConstraints' },
	'regionpersondisplayname' => { 233 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 233 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 245 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 245 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 95 => 'data' },
	'relatedaudiofilename' => { 95 => '1Name' },
	'relatedaudiofiletype' => { 95 => '0Type' },
	'relatedimagefileformat' => { 70 => 0x1000 },
	'relatedimageheight' => { 70 => 0x1002 },
	'relatedimagewidth' => { 70 => 0x1001 },
	'relatedsoundfile' => { 70 => 0xa004, 243 => 'RelatedSoundFile' },
	'relatedvideofile' => { 109 => 'data' },
	'relatedvideofilename' => { 109 => '1Name' },
	'relatedvideofiletype' => { 109 => '0Type' },
	'relation' => { 240 => 'relation' },
	'relativepeakaudiofilepath' => { 258 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 258 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 258 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 172 => '17.8' },
	'releasedate' => { 76 => 0x1e, 258 => 'releaseDate' },
	'releasemode' => { 67 => 0x3001 },
	'releasesetting' => { 60 => 0x1016 },
	'releasetime' => { 76 => 0x23 },
	'remoteonduration' => { 173 => '3.4', 174 => '17.2', 175 => '4.3', 176 => '19.2' },
	'renditionclass' => { 259 => 'RenditionClass' },
	'renditionofalternatepaths' => { 259 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 259 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 259 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 259 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 259 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 259 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 259 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 259 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 259 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 259 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 259 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 259 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 259 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 259 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 259 => 'RenditionOfToPart' },
	'renditionofversionid' => { 259 => 'RenditionOfVersionID' },
	'renditionparams' => { 259 => 'RenditionParams' },
	'repeatingflashcount' => { 129 => 0xd, 130 => 0xe, 131 => 0xe, 175 => '9.2', 176 => '25.2' },
	'repeatingflashoutput' => { 175 => '9.1', 176 => '25.1' },
	'repeatingflashrate' => { 129 => 0xc, 130 => 0xd, 131 => 0xd, 175 => '10.1', 176 => '26.1' },
	'resampleparamsquality' => { 258 => 'resampleParamsQuality' },
	'resaved' => { 223 => 0x21e },
	'resolution' => { 102 => 'Resolution' },
	'resolutionmode' => { 224 => 0x4 },
	'resolutionunit' => { 70 => 0x128, 79 => 0x2, 254 => 'ResolutionUnit' },
	'restrictions' => { 251 => 'restrictions' },
	'retouchhistory' => { 137 => 0x9e },
	'retouchinfo' => { 239 => 'RetouchInfo' },
	'reuse' => { 248 => 'Reuse' },
	'reuseallowed' => { 261 => 'ReuseAllowed' },
	'reuseprohibited' => { 251 => 'reuseProhibited' },
	'reverseindicators' => { 172 => '12.1', 174 => '4.3', 176 => '6.2' },
	'revision' => { 241 => 'revision' },
	'rgbcurvelimits' => { 64 => 0x238 },
	'rgbcurvepoints' => { 64 => 0x20e },
	'ricohdate' => { 218 => 0x6 },
	'ricohimageheight' => { 218 => 0x2 },
	'ricohimagewidth' => { 218 => 0x0 },
	'rightascension' => { 105 => 'RightAscension' },
	'rights' => { 240 => 'rights' },
	'rightsagent' => { 249 => 'rightsAgent', 251 => 'rightsAgent' },
	'rightsowner' => { 251 => 'rightsOwner' },
	'romoperationmode' => { 60 => 0x80d },
	'rotation' => { 17 => 0x17, 18 => 0x18, 59 => 0x3, 64 => 0x26e, 73 => 0x4, 105 => 'Rotation', 111 => [0x65,0x50], 112 => 0x46, 113 => 0x5a, 153 => '590.1', 165 => 0x76a43207, 195 => 0x30, 202 => '17.2', 212 => 0xd8, 225 => 0x3f, 226 => 0x3f },
	'routing' => { 217 => 'Routing' },
	'rowsperstrip' => { 70 => 0x116 },
	'rpp' => { 236 => 'rpp' },
	'safetyshift' => { 47 => 0x108 },
	'safetyshiftinavortv' => { 45 => 0x10, 46 => 0x10, 48 => 0xf, 49 => 0x10, 52 => 0x10 },
	'samplebits' => { 95 => 'SampleBits' },
	'samplerate' => { 95 => 'SampleRate' },
	'samplesperpixel' => { 70 => 0x115, 254 => 'SamplesPerPixel' },
	'samplestructure' => { 78 => 0x5a },
	'sanyoquality' => { 223 => 0x201 },
	'sanyothumbnail' => { 223 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 20 => 0xe, 27 => 0x1, 66 => 0xd, 67 => [0x3013,0x1f], 70 => [0xa409,0xfe55], 74 => 0x1003, 96 => 'Saturation', 110 => 0x1f, 111 => 0x32, 112 => 0x28, 113 => 0x1a, 116 => 0x1, 137 => [0x94,0xaa], 139 => 0x35, 195 => 0x40, 209 => 0x1f, 211 => 0xd, 218 => 0x28, 224 => 0x10, 225 => 0x1e, 226 => 0x1b, 239 => 'Saturation', 243 => 'Saturation' },
	'saturationadj' => { 64 => 0x116, 164 => 0x1, 168 => 0x2e, 229 => 0x8016 },
	'saturationadjustmentaqua' => { 239 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 239 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 239 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 239 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 239 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 239 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 239 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 239 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 13 => 0xfe },
	'saturationlandscape' => { 13 => 0xfc },
	'saturationneutral' => { 13 => 0xfd },
	'saturationportrait' => { 13 => 0xfb },
	'saturationsetting' => { 185 => 0x1010 },
	'saturationstandard' => { 13 => 0xfa },
	'saturationuserdef1' => { 13 => 0x100 },
	'saturationuserdef2' => { 13 => 0x101 },
	'saturationuserdef3' => { 13 => 0x102 },
	'saveid' => { 259 => 'SaveID' },
	'scaletype' => { 258 => 'scaleType' },
	'scanimageenhancer' => { 142 => 0x60 },
	'scanningdirection' => { 78 => 0x64 },
	'scene' => { 244 => 'Scene', 258 => 'scene' },
	'scenearea' => { 180 => 0x211, 182 => 0x1031 },
	'sceneassist' => { 137 => 0x9c },
	'scenecapturetype' => { 70 => 0xa406, 243 => 'SceneCaptureType' },
	'scenedetect' => { 180 => 0x210, 182 => 0x1030 },
	'scenedetectdata' => { 180 => 0x212, 182 => 0x1033 },
	'scenemode' => { 84 => 0xfa02, 114 => 0x100, 137 => 0x8f, 177 => 0x509, 182 => 0x403, 195 => 0x8001, 227 => 0xb023 },
	'scenemodeused' => { 86 => [0x6002,0xf002] },
	'sceneselect' => { 223 => 0x21f },
	'scenetype' => { 70 => 0xa301, 243 => 'SceneType' },
	'screentips' => { 176 => '5.1' },
	'section' => { 249 => 'section' },
	'securityclassification' => { 70 => 0x9212 },
	'selectableafpoint' => { 47 => 0x509 },
	'selectafareaselectmode' => { 47 => 0x512 },
	'selftimer' => { 20 => 0x2, 195 => 0x2e, 223 => 0x214 },
	'selftimer2' => { 42 => 0x1d },
	'selftimermode' => { 70 => 0x882b },
	'selftimershotcount' => { 174 => '18.2', 176 => '20.2' },
	'selftimertime' => { 60 => 0x1806, 113 => 0x1f, 172 => '18.1', 173 => '3.3', 174 => '18.1', 175 => '3.3', 176 => '20.1' },
	'seminfo' => { 70 => 0x8546 },
	'sensingmethod' => { 70 => 0xa217, 243 => 'SensingMethod' },
	'sensitivityadjust' => { 209 => 0x40 },
	'sensitivitysteps' => { 202 => '17.4', 204 => 0x1 },
	'sensorareas' => { 222 => 0xa010 },
	'sensorbluelevel' => { 40 => 0x5 },
	'sensorcleaning' => { 53 => 0xd },
	'sensorfullheight' => { 80 => 0xf904 },
	'sensorfullwidth' => { 80 => 0xf903 },
	'sensorheight' => { 80 => 0xf901, 84 => 0xfa21, 115 => 0x8, 196 => 0x312c },
	'sensorpixelsize' => { 137 => 0x9a },
	'sensorredlevel' => { 40 => 0x4 },
	'sensorsize' => { 96 => 'SensorSize' },
	'sensortemperature' => { 180 => 0x1500, 182 => 0x1007 },
	'sensorwidth' => { 80 => 0xf900, 84 => 0xfa20, 115 => 0xa, 196 => 0x312b },
	'sequencenumber' => { 42 => 0x9, 67 => 0x301c, 74 => 0x1101, 83 => 0x1d, 195 => 0x2b },
	'sequenceshotinterval' => { 223 => 0x224 },
	'sequentialshot' => { 223 => 0x20e },
	'serialnumber' => { 34 => 0xc, 60 => 0x180b, 70 => 0xfde9, 80 => 0xfa04, 82 => 0xfa00, 84 => 0xfa19, 93 => 0x0, 94 => 0xa8, 96 => 'SerialNumber', 137 => [0xa0,0x1d], 178 => 0x101, 182 => [0x404,0x101a], 191 => 0x303, 209 => 0x229, 219 => 0x5, 224 => 0x2, 237 => 'SerialNumber' },
	'serialnumberformat' => { 34 => 0x15, 60 => 0x183b },
	'seriesdatetime' => { 231 => 'SeriesDateTime' },
	'seriesdescription' => { 231 => 'SeriesDescription' },
	'seriesmodality' => { 231 => 'SeriesModality' },
	'seriesnumber' => { 231 => 'SeriesNumber' },
	'serviceidentifier' => { 77 => 0x1e },
	'setbuttoncrosskeysfunc' => { 50 => 0x0, 51 => 0x0 },
	'setbuttonwhenshooting' => { 45 => 0x1, 47 => 0x704, 53 => 0xc },
	'setfunctionwhenshooting' => { 48 => 0x0, 49 => 0x1, 52 => 0x1 },
	'shadingcompensation' => { 177 => 0x50c },
	'shadingcompensation2' => { 181 => 0x1012 },
	'shadow' => { 224 => 0xe },
	'shadowprotection' => { 164 => 0x0 },
	'shadows' => { 70 => 0xfe52, 239 => 'Shadows' },
	'shadowscale' => { 70 => 0xc633 },
	'shadowtint' => { 239 => 'ShadowTint' },
	'shakereduction' => { 210 => 0x1 },
	'sharpendetail' => { 239 => 'SharpenDetail' },
	'sharpenedgemasking' => { 239 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 168 => 0x2b },
	'sharpenradius' => { 239 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 20 => 0xf, 40 => 0x2, 66 => 0xb, 67 => [0x3011,0x21], 70 => [0xa40a,0xfe56], 74 => 0x1001, 83 => 0x6b, 91 => 0x37, 96 => 'Sharpness', 110 => 0x21, 111 => 0x30, 112 => 0x26, 113 => 0x18, 116 => 0x3, 137 => 0x6, 139 => 0x32, 182 => 0x100f, 195 => 0x41, 209 => 0x21, 211 => 0xb, 218 => 0x22, 219 => 0x1003, 224 => 0x11, 225 => 0x1c, 226 => 0x19, 239 => 'Sharpness', 243 => 'Sharpness' },
	'sharpnessadj' => { 64 => 0x25a, 229 => 0x801a },
	'sharpnessfactor' => { 182 => 0x102a },
	'sharpnessfaithful' => { 13 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 40 => 0x3 },
	'sharpnesslandscape' => { 13 => 0xf3 },
	'sharpnessmonochrome' => { 13 => 0xf6 },
	'sharpnessneutral' => { 13 => 0xf4 },
	'sharpnessovershoot' => { 229 => 0x801b },
	'sharpnessportrait' => { 13 => 0xf2 },
	'sharpnesssetting' => { 177 => 0x506, 185 => 0x1013 },
	'sharpnessstandard' => { 13 => 0xf1 },
	'sharpnessthreshold' => { 229 => 0x801d },
	'sharpnessundershoot' => { 229 => 0x801c },
	'sharpnessuserdef1' => { 13 => 0xf7 },
	'sharpnessuserdef2' => { 13 => 0xf8 },
	'sharpnessuserdef3' => { 13 => 0xf9 },
	'shootinginfodisplay' => { 172 => '13.2', 176 => '5.3' },
	'shootinginfomonitorofftime' => { 176 => '22.2' },
	'shootingmode' => { 96 => 'ShootingMode', 137 => 0x89, 195 => 0x1f },
	'shootingmodesetting' => { 173 => '5.1' },
	'shortdescription' => { 241 => 'shortdescription' },
	'shortdocumentid' => { 76 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 8 => 0xd8, 10 => 0xf8, 11 => 0xec, 12 => 0x101, 13 => 0x93, 14 => 0xe8, 16 => 0xf0, 20 => 0x18 },
	'shortownername' => { 13 => 0xac },
	'shortreleasetimelag' => { 47 => 0x80d },
	'shotdate' => { 258 => 'shotDate' },
	'shotlocation' => { 258 => 'shotLocation' },
	'shotname' => { 258 => 'shotName' },
	'shutter-aelock' => { 45 => 0x4, 47 => 0x701, 48 => 0x3, 49 => 0x4, 50 => 0x3, 51 => 0x3, 52 => 0x4, 53 => 0x2 },
	'shutteraelbutton' => { 46 => 0x4 },
	'shutterbuttonafonbutton' => { 47 => 0x701 },
	'shuttercount' => { 5 => 0x176, 30 => 0x1, 137 => 0xa7, 143 => [0x6a,0x157,0x24d], 144 => 0x286, 145 => 0x279, 146 => 0x284, 147 => 0x242, 148 => 0x280, 149 => 0x276, 150 => [0x27d,0x27f], 151 => 0x246, 152 => 0x2d6, 153 => 0x24a, 154 => 0x2d5, 209 => 0x5d },
	'shuttercurtainsync' => { 45 => 0xf, 46 => 0xf, 47 => 0x305, 48 => 0xe, 49 => 0xf, 50 => 0x8, 51 => 0x8, 52 => 0xf, 53 => 0x8 },
	'shuttermode' => { 83 => 0x1b },
	'shutterreleasebuttonae-l' => { 172 => '17.7', 174 => '16.1', 176 => '18.2' },
	'shutterreleasemethod' => { 60 => 0x1010 },
	'shutterreleasenocfcard' => { 45 => 0x2, 46 => 0x2, 53 => 0xf },
	'shutterreleasetiming' => { 60 => 0x1011 },
	'shutterspeedrange' => { 47 => 0x10c },
	'shutterspeedvalue' => { 56 => 0x1, 70 => 0x9201, 182 => 0x1000, 243 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 247 => 'SidecarForExtension' },
	'similarityindex' => { 76 => 0xe4 },
	'singleframebracketing' => { 113 => 0x21 },
	'slaveflashmeteringsegments' => { 209 => 0x20b },
	'slowshutter' => { 42 => 0x8 },
	'slowsync' => { 74 => 0x1030 },
	'smoothness' => { 70 => 0xfe57, 239 => 'Smoothness' },
	'software' => { 70 => 0x131, 97 => 'Software', 188 => 'Software', 224 => 0x18, 254 => 'Software' },
	'softwareversion' => { 223 => 0x207 },
	'sonydatetime' => { 228 => 0x6 },
	'sonyimagesize' => { 113 => 0x3b, 225 => 0x54, 226 => 0x54 },
	'sonymodelid' => { 227 => 0xb001 },
	'sonyquality' => { 113 => 0x3c },
	'source' => { 76 => 0x73, 188 => 'Source', 240 => 'source', 241 => 'source', 247 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 243 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 243 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 243 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 243 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 258 => 'speakerPlacement' },
	'specialeffectlevel' => { 67 => 0x3030 },
	'specialeffectmode' => { 67 => 0x2076 },
	'specialeffectsetting' => { 67 => 0x3031 },
	'specialinstructions' => { 76 => 0x28 },
	'specialmode' => { 182 => 0x200, 223 => 0x200 },
	'spectralsensitivity' => { 70 => 0x8824, 243 => 'SpectralSensitivity' },
	'splittoningbalance' => { 239 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 239 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 239 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 239 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 239 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 110 => 0x2d },
	'spotfocuspointy' => { 110 => 0x2e },
	'spotmeteringmode' => { 20 => 0x27 },
	'spotmeterlinktoafpoint' => { 47 => 0x107 },
	'sractive' => { 202 => '17.1' },
	'srawquality' => { 20 => 0x2e },
	'srfocallength' => { 210 => 0x3 },
	'srhalfpresstime' => { 210 => 0x2 },
	'srresult' => { 210 => 0x0 },
	'startingpage' => { 249 => 'startingPage' },
	'startmovieshooting' => { 47 => 0x70d },
	'starttimecodetimeformat' => { 258 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 258 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 258 => 'startTimecodeValue' },
	'state' => { 101 => 'State', 195 => 0x6b, 247 => 'State' },
	'status' => { 234 => 'Status' },
	'storagemethod' => { 115 => 0x12 },
	'straightenangle' => { 165 => 0x2fc08431 },
	'stretchmode' => { 258 => 'stretchMode' },
	'studydatetime' => { 231 => 'StudyDateTime' },
	'studydescription' => { 231 => 'StudyDescription' },
	'studyid' => { 231 => 'StudyID' },
	'studyphysician' => { 231 => 'StudyPhysician' },
	'sub-location' => { 76 => 0x5c },
	'subfiledata' => { 104 => 'data' },
	'subfiledirectory' => { 104 => '1Directory' },
	'subfilemimetype' => { 104 => '2MIME' },
	'subfilename' => { 104 => '1Name' },
	'subfileresource' => { 104 => 'rsrc' },
	'subfiletype' => { 70 => 0xfe, 104 => '0Type' },
	'subject' => { 186 => 'Subject', 217 => 'Subject', 240 => 'subject', 246 => 'Subject' },
	'subjectarea' => { 70 => 0x9214, 243 => 'SubjectArea' },
	'subjectcode' => { 244 => 'SubjectCode' },
	'subjectdistance' => { 70 => 0x9206, 83 => 0x3e, 243 => 'SubjectDistance' },
	'subjectdistancerange' => { 70 => 0xa40c, 243 => 'SubjectDistanceRange' },
	'subjectlocation' => { 70 => 0xa214, 243 => 'SubjectLocation' },
	'subjectprogram' => { 110 => 0x22 },
	'subjectreference' => { 76 => 0xc },
	'subsectime' => { 70 => 0x9290 },
	'subsectimedigitized' => { 70 => 0x9292 },
	'subsectimeoriginal' => { 70 => 0x9291 },
	'subsection1' => { 249 => 'subsection1' },
	'subsection2' => { 249 => 'subsection2' },
	'subsection3' => { 249 => 'subsection3' },
	'subsection4' => { 249 => 'subsection4' },
	'superimposeddisplay' => { 45 => 0xa, 47 => 0x510, 48 => 0x9, 49 => 0xa, 52 => 0xa, 53 => 0xe },
	'supermacro' => { 34 => 0x1a },
	'supplementalcategories' => { 76 => 0x14, 247 => 'SupplementalCategories' },
	'supplementaltype' => { 78 => 0x37 },
	'svisosetting' => { 202 => 0x14 },
	'switchtoregisteredafpoint' => { 46 => 0x12, 47 => 0x50a },
	'tagged' => { 212 => 0xdd, 236 => 'tagged' },
	'tagslist' => { 242 => 'TagsList' },
	'tapename' => { 258 => 'tapeName' },
	'targetaperture' => { 42 => 0x4 },
	'targetcompressionratio' => { 58 => 0x1 },
	'targetdistancesetting' => { 60 => 0x1807 },
	'targetexposuretime' => { 42 => 0x5 },
	'targetimagetype' => { 60 => 0x100a },
	'teaser' => { 249 => 'teaser' },
	'teleconverter' => { 114 => 0x105, 227 => 0x105 },
	'temperature' => { 239 => 'Temperature' },
	'tempo' => { 258 => 'tempo' },
	'termsandconditionstext' => { 248 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 248 => 'TermsAndConditionsURL' },
	'textstamp' => { 195 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 70 => 0x107 },
	'thumbnailfilename' => { 60 => 0x817 },
	'thumbnailformat' => { 256 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 84 => 0xfa55, 256 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 60 => 0x2008, 68 => 'ThumbnailImage', 72 => 0x3, 107 => 'data', 182 => 0x100, 256 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 107 => '1Name' },
	'thumbnailimagesize' => { 107 => 'ImageSize' },
	'thumbnailimagetype' => { 107 => '0Type' },
	'thumbnailimagevalidarea' => { 34 => 0x13 },
	'thumbnaillength' => { 70 => 0x202 },
	'thumbnailoffset' => { 70 => 0x201 },
	'thumbnailwidth' => { 84 => 0xfa54, 256 => 'ThumbnailsWidth' },
	'ticker' => { 249 => 'ticker' },
	'tilelength' => { 70 => 0x143 },
	'tilewidth' => { 70 => 0x142 },
	'time' => { 81 => 0x401, 209 => 0x7 },
	'timecreated' => { 76 => 0x3c, 83 => 0x14, 91 => 0x10, 213 => 'TimeCreated' },
	'timeperiod' => { 249 => 'timePeriod' },
	'timerfunctionbutton' => { 173 => '5.2', 174 => '12.1' },
	'timerlength' => { 47 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 258 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 258 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 258 => 'timeScaleParamsQuality' },
	'timesent' => { 77 => 0x50 },
	'timesignature' => { 258 => 'timeSignature' },
	'timesincepoweron' => { 195 => 0x29 },
	'timestamp' => { 5 => 0x45e, 13 => 0x11c, 188 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 157 => 0x0 },
	'timezonecode' => { 63 => 0x1 },
	'timezoneinfo' => { 63 => 0x2 },
	'timezoneoffset' => { 70 => 0x882a },
	'tint' => { 239 => 'Tint' },
	'title' => { 97 => 'Title', 186 => 'Title', 188 => 'Title', 217 => 'Title', 240 => 'title', 246 => 'Title' },
	'tonecomp' => { 137 => 0x81 },
	'tonecurve' => { 40 => 0x1, 209 => 0x402, 239 => 'ToneCurve' },
	'tonecurveactive' => { 64 => 0x110 },
	'tonecurvebluex' => { 229 => 0x9003 },
	'tonecurvebluey' => { 229 => 0x9007 },
	'tonecurvebrightnessx' => { 229 => 0x9000 },
	'tonecurvebrightnessy' => { 229 => 0x9004 },
	'tonecurvefilename' => { 81 => 0x1391 },
	'tonecurvegreenx' => { 229 => 0x9002 },
	'tonecurvegreeny' => { 229 => 0x9006 },
	'tonecurvename' => { 239 => 'ToneCurveName' },
	'tonecurveproperty' => { 64 => 0x3c },
	'tonecurveredx' => { 229 => 0x9001 },
	'tonecurveredy' => { 229 => 0x9005 },
	'tonecurves' => { 209 => 0x403 },
	'toningeffect' => { 30 => 0xf, 137 => 0xb3, 139 => 0x38 },
	'toningeffectmonochrome' => { 13 => 0x108 },
	'toningsaturation' => { 139 => 0x39 },
	'totalzoom' => { 83 => 0x62 },
	'tracknumber' => { 258 => 'trackNumber' },
	'tracksframerate' => { 258 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 258 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 258 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 258 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 258 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 258 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 258 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 258 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 258 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 258 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 258 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 258 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 258 => 'TracksMarkersType' },
	'trackstrackname' => { 258 => 'TracksTrackName' },
	'trackstracktype' => { 258 => 'TracksTrackType' },
	'trailersignature' => { 104 => 'zmie' },
	'transferfunction' => { 70 => 0x12d, 254 => 'TransferFunction' },
	'transform' => { 195 => [0x8012,0x59] },
	'transmissionreference' => { 247 => 'TransmissionReference' },
	'trapped' => { 186 => 'Trapped', 246 => 'Trapped' },
	'travelday' => { 195 => 0x36 },
	'ttl_da_adown' => { 205 => 0x5 },
	'ttl_da_aup' => { 205 => 0x4 },
	'ttl_da_bdown' => { 205 => 0x7 },
	'ttl_da_bup' => { 205 => 0x6 },
	'tvexposuretimesetting' => { 202 => 0x12 },
	'type' => { 240 => 'type', 253 => 'type' },
	'uniquecameramodel' => { 70 => 0xc614 },
	'uniquedocumentid' => { 76 => 0xbb },
	'uniqueobjectname' => { 77 => 0x64 },
	'unknownblock' => { 181 => 0x1103 },
	'unknowncompensation' => { 224 => 0xc },
	'unknownev' => { 81 => 0x1 },
	'unknownmode' => { 67 => 0x301b },
	'unknownnumber' => { 60 => 0x180b },
	'unsharp1color' => { 170 => 0x13 },
	'unsharp1halowidth' => { 170 => 0x19 },
	'unsharp1intensity' => { 170 => 0x17 },
	'unsharp1threshold' => { 170 => 0x1b },
	'unsharp2color' => { 170 => 0x2e },
	'unsharp2halowidth' => { 170 => 0x34 },
	'unsharp2intensity' => { 170 => 0x32 },
	'unsharp2threshold' => { 170 => 0x36 },
	'unsharp3color' => { 170 => 0x49 },
	'unsharp3halowidth' => { 170 => 0x4f },
	'unsharp3intensity' => { 170 => 0x4d },
	'unsharp3threshold' => { 170 => 0x51 },
	'unsharp4color' => { 170 => 0x64 },
	'unsharp4halowidth' => { 170 => 0x6a },
	'unsharp4intensity' => { 170 => 0x68 },
	'unsharp4threshold' => { 170 => 0x6c },
	'unsharpcount' => { 170 => 0x0 },
	'unsharpmask' => { 165 => 0x76a43200 },
	'urgency' => { 76 => 0xa, 247 => 'Urgency' },
	'url' => { 97 => 'URL', 188 => 'URL', 215 => 0x40b, 249 => 'url' },
	'usablemeteringmodes' => { 47 => 0x10a },
	'usableshootingmodes' => { 47 => 0x109 },
	'usage' => { 250 => 'usage' },
	'usagefee' => { 251 => 'usageFee' },
	'usageterms' => { 262 => 'UsageTerms' },
	'usercomment' => { 60 => 0x805, 70 => 0x9286, 243 => 'UserComment' },
	'userdef1picturestyle' => { 13 => 0x10c },
	'userdef2picturestyle' => { 13 => 0x10e },
	'userdef3picturestyle' => { 13 => 0x110 },
	'userfields' => { 234 => 'UserFields' },
	'userprofile' => { 191 => 0x302, 196 => 0x3038 },
	'usmlenselectronicmf' => { 46 => 0x7, 47 => 0x501 },
	'utmeasting' => { 108 => 'Easting' },
	'utmmapdatum' => { 108 => 'Datum' },
	'utmnorthing' => { 108 => 'Northing' },
	'utmzone' => { 108 => 'Zone' },
	'uv-irfiltercorrection' => { 191 => 0x325 },
	'validbits' => { 181 => 0x611, 182 => 0x102c },
	'validpixeldepth' => { 185 => 0x611 },
	'variousmodes' => { 83 => 0x26 },
	'variousmodes2' => { 83 => 0x3a },
	'variprogram' => { 137 => 0xab },
	'version' => { 74 => 0x0, 217 => 'Version', 239 => 'Version' },
	'versioncreatedate' => { 229 => 0xd100 },
	'versionid' => { 259 => 'VersionID' },
	'versionidentifier' => { 249 => 'versionIdentifier' },
	'versionmodifydate' => { 229 => 0xd101 },
	'versionscomments' => { 259 => 'VersionsComments' },
	'versionseventaction' => { 259 => 'VersionsEventAction' },
	'versionseventchanged' => { 259 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 259 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 259 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 259 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 259 => 'VersionsEventWhen' },
	'versionsmodifier' => { 259 => 'VersionsModifier' },
	'versionsmodifydate' => { 259 => 'VersionsModifyDate' },
	'versionsversion' => { 259 => 'VersionsVersion' },
	'verticalafonbutton' => { 172 => '3.2' },
	'vfdisplayillumination' => { 47 => 0x510 },
	'vibrance' => { 239 => 'Vibrance' },
	'vibrationreduction' => { 143 => [0x75,0x82,0x1ae], 151 => '586.1', 153 => '590.2', 156 => 0x4 },
	'videoalphamode' => { 258 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 258 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 258 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 258 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 258 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 258 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 258 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 258 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 258 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 258 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 258 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 258 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 258 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 258 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 258 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 258 => 'videoColorSpace' },
	'videocompressor' => { 258 => 'videoCompressor' },
	'videofieldorder' => { 258 => 'videoFieldOrder' },
	'videoframerate' => { 258 => 'videoFrameRate' },
	'videoframesizeh' => { 258 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 258 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 258 => 'videoFrameSizeW' },
	'videomoddate' => { 258 => 'videoModDate' },
	'videopixelaspectratio' => { 258 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 258 => 'videoPixelDepth' },
	'videoquality' => { 67 => 0x4003 },
	'viewfinderdisplay' => { 172 => '12.4' },
	'viewfinderwarning' => { 172 => '13.4', 175 => '6.2', 176 => '4.4' },
	'viewinfoduringexposure' => { 47 => 0x407 },
	'vignetteamount' => { 239 => 'VignetteAmount' },
	'vignettecontrol' => { 137 => 0x2a, 165 => 0x76a43205 },
	'vignettecontrolintensity' => { 165 => 0xac6bd5c0 },
	'vignettemidpoint' => { 239 => 'VignetteMidpoint' },
	'voicememo' => { 223 => 0x216 },
	'volume' => { 249 => 'volume' },
	'vr_0x66' => { 143 => 0x66 },
	'vrdoffset' => { 34 => 0xd0 },
	'wb_gbrglevels' => { 117 => 0x4 },
	'wb_glevel' => { 181 => 0x11f },
	'wb_glevel3000k' => { 181 => 0x113 },
	'wb_glevel3300k' => { 181 => 0x114 },
	'wb_glevel3600k' => { 181 => 0x115 },
	'wb_glevel3900k' => { 181 => 0x116 },
	'wb_glevel4000k' => { 181 => 0x117 },
	'wb_glevel4300k' => { 181 => 0x118 },
	'wb_glevel4500k' => { 181 => 0x119 },
	'wb_glevel4800k' => { 181 => 0x11a },
	'wb_glevel5300k' => { 181 => 0x11b },
	'wb_glevel6000k' => { 181 => 0x11c },
	'wb_glevel6600k' => { 181 => 0x11d },
	'wb_glevel7500k' => { 181 => 0x11e },
	'wb_grbglevels' => { 125 => 0x0 },
	'wb_rbgglevels' => { 122 => 0x0 },
	'wb_rblevels' => { 137 => 0xc, 181 => 0x100 },
	'wb_rblevels3000k' => { 181 => 0x102 },
	'wb_rblevels3300k' => { 181 => 0x103 },
	'wb_rblevels3600k' => { 181 => 0x104 },
	'wb_rblevels3900k' => { 181 => 0x105 },
	'wb_rblevels4000k' => { 181 => 0x106 },
	'wb_rblevels4300k' => { 181 => 0x107 },
	'wb_rblevels4500k' => { 181 => 0x108 },
	'wb_rblevels4800k' => { 181 => 0x109 },
	'wb_rblevels5300k' => { 181 => 0x10a },
	'wb_rblevels6000k' => { 181 => 0x10b },
	'wb_rblevels6600k' => { 181 => 0x10c },
	'wb_rblevels7500k' => { 181 => 0x10d },
	'wb_rblevelsauto' => { 185 => 0x110 },
	'wb_rblevelscloudy' => { 185 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 185 => 0x132 },
	'wb_rblevelscwb1' => { 181 => 0x10e },
	'wb_rblevelscwb2' => { 181 => 0x10f },
	'wb_rblevelscwb3' => { 181 => 0x110 },
	'wb_rblevelscwb4' => { 181 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 185 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 185 => 0x131 },
	'wb_rblevelseveningsunlight' => { 185 => 0x124 },
	'wb_rblevelsfineweather' => { 185 => 0x122 },
	'wb_rblevelsshade' => { 185 => 0x120 },
	'wb_rblevelstungsten' => { 185 => 0x123 },
	'wb_rblevelsused' => { 185 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 185 => 0x133 },
	'wb_rgbglevels' => { 124 => 0x0 },
	'wb_rgblevels' => { 192 => 0xd, 193 => 0x413, 196 => 0x3036 },
	'wb_rggblevels' => { 117 => 0x4, 123 => 0x0, 222 => 0xa021 },
	'wb_rggblevelsasshot' => { 22 => 0x19, 23 => 0x22, 24 => 0x3f, 25 => 0x3f, 26 => 0x47 },
	'wb_rggblevelsauto' => { 21 => 0x0, 22 => 0x1e, 23 => 0x18, 24 => 0x44, 25 => 0x44, 26 => 0x4c },
	'wb_rggblevelscloudy' => { 21 => 0xc, 22 => 0x2d, 23 => 0x31, 24 => 0x58, 25 => 0x5d, 26 => 0x65, 209 => 0x20f },
	'wb_rggblevelscustom' => { 21 => 0x1c, 24 => 0x80 },
	'wb_rggblevelscustom1' => { 22 => 0x41 },
	'wb_rggblevelscustom2' => { 22 => 0x46 },
	'wb_rggblevelsdaylight' => { 21 => 0x4, 22 => 0x23, 23 => 0x27, 24 => 0x4e, 25 => 0x53, 26 => 0x5b, 209 => 0x20d },
	'wb_rggblevelsflash' => { 21 => 0x18, 22 => 0x3c, 23 => 0x45, 24 => 0x6c, 25 => 0x71, 26 => 0x79, 209 => 0x214 },
	'wb_rggblevelsfluorescent' => { 21 => 0x14, 22 => 0x37, 23 => 0x3b, 24 => 0x62, 25 => 0x67, 26 => 0x6f },
	'wb_rggblevelsfluorescentd' => { 209 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 209 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 209 => 0x213 },
	'wb_rggblevelskelvin' => { 21 => 0x20, 23 => 0x40, 24 => 0x67, 25 => 0x6c, 26 => 0x74 },
	'wb_rggblevelsmeasured' => { 24 => 0x49, 25 => 0x49, 26 => 0x51 },
	'wb_rggblevelspc1' => { 23 => 0x90, 24 => 0x71 },
	'wb_rggblevelspc2' => { 23 => 0x95, 24 => 0x76 },
	'wb_rggblevelspc3' => { 23 => 0x9a, 24 => 0x7b },
	'wb_rggblevelsshade' => { 21 => 0x8, 22 => 0x28, 23 => 0x2c, 24 => 0x53, 25 => 0x58, 26 => 0x60, 209 => 0x20e },
	'wb_rggblevelstungsten' => { 21 => 0x10, 22 => 0x32, 23 => 0x36, 24 => 0x5d, 25 => 0x62, 26 => 0x6a, 209 => 0x210 },
	'wb_rggblevelsunknown' => { 23 => 0x1d, 25 => 0x4e, 26 => 0x56 },
	'wb_rggblevelsunknown10' => { 23 => 0x72, 25 => 0x9e, 26 => 0xa6 },
	'wb_rggblevelsunknown11' => { 23 => 0x77, 25 => 0xa3, 26 => 0xab },
	'wb_rggblevelsunknown12' => { 23 => 0x7c, 26 => 0xb0 },
	'wb_rggblevelsunknown13' => { 23 => 0x81, 26 => 0xb5 },
	'wb_rggblevelsunknown14' => { 23 => 0x86 },
	'wb_rggblevelsunknown15' => { 23 => 0x8b },
	'wb_rggblevelsunknown16' => { 23 => 0x9f },
	'wb_rggblevelsunknown2' => { 23 => 0x4a, 25 => 0x76, 26 => 0x7e },
	'wb_rggblevelsunknown3' => { 23 => 0x4f, 25 => 0x7b, 26 => 0x83 },
	'wb_rggblevelsunknown4' => { 23 => 0x54, 25 => 0x80, 26 => 0x88 },
	'wb_rggblevelsunknown5' => { 23 => 0x59, 25 => 0x85, 26 => 0x8d },
	'wb_rggblevelsunknown6' => { 23 => 0x5e, 25 => 0x8a, 26 => 0x92 },
	'wb_rggblevelsunknown7' => { 23 => 0x63, 25 => 0x8f, 26 => 0x97 },
	'wb_rggblevelsunknown8' => { 23 => 0x68, 25 => 0x94, 26 => 0x9c },
	'wb_rggblevelsunknown9' => { 23 => 0x6d, 25 => 0x99, 26 => 0xa1 },
	'wbadjbluebalance' => { 171 => 0x8 },
	'wbadjcolortemp' => { 64 => 0x1a },
	'wbadjlighting' => { 171 => 0x15 },
	'wbadjlightingsubtype' => { 171 => 0x14 },
	'wbadjmode' => { 171 => 0x10 },
	'wbadjredbalance' => { 171 => 0x0 },
	'wbadjrgblevels' => { 64 => 0x8 },
	'wbadjtemperature' => { 171 => 0x18 },
	'wbadjtint' => { 171 => 0x25 },
	'wbadjustab' => { 195 => 0x46 },
	'wbadjustgm' => { 195 => 0x47 },
	'wbbluelevel' => { 191 => 0x324, 195 => 0x8006, 197 => 0x26 },
	'wbbracketmode' => { 30 => 0x9 },
	'wbbracketvalueab' => { 30 => 0xc },
	'wbbracketvaluegm' => { 30 => 0xd },
	'wbfinetuneactive' => { 64 => 0x24 },
	'wbfinetunesaturation' => { 64 => 0x28 },
	'wbfinetunetone' => { 64 => 0x2c },
	'wbgreenlevel' => { 191 => 0x323, 195 => 0x8005, 197 => 0x25 },
	'wbmediaimagesizesetting' => { 47 => 0x708 },
	'wbmode' => { 116 => 0x4, 182 => 0x1015 },
	'wbredlevel' => { 191 => 0x322, 195 => 0x8004, 197 => 0x24 },
	'wbscale' => { 117 => 0x0 },
	'wbshiftab' => { 40 => 0xc, 203 => 0x10 },
	'wbshiftgm' => { 40 => 0xd },
	'wbshiftmg' => { 203 => 0x11 },
	'webstatement' => { 262 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 8 => 0x6f, 9 => 0x6f, 10 => 0x73, 11 => 0x6f, 12 => 0x78, 13 => 0x54, 14 => 0x6f, 16 => 0x53, 40 => 0x8, 42 => 0x7, 66 => 0x7, 67 => [0x19,0x2012], 70 => [0xa403,0xfe4e], 74 => 0x1002, 81 => 0x3fc, 82 => 0xfa0d, 83 => 0x40, 110 => 0x3, 111 => 0xe, 112 => 0x4, 113 => 0xb, 114 => 0x115, 137 => 0x5, 155 => 0x7, 191 => 0x304, 195 => 0x3, 209 => 0x19, 211 => 0x7, 218 => 0x26, 224 => [0x3c,0x7], 227 => [0x115,0xb054], 239 => 'WhiteBalance', 243 => 'WhiteBalance' },
	'whitebalance2' => { 177 => 0x500 },
	'whitebalanceadj' => { 64 => 0x18, 165 => 0x76a43204 },
	'whitebalancebias' => { 67 => 0x2011, 182 => 0x304, 195 => 0x23 },
	'whitebalanceblue' => { 40 => 0x7 },
	'whitebalancebracket' => { 177 => 0x502, 182 => 0x303 },
	'whitebalancebracketing' => { 113 => 0x22 },
	'whitebalancecomp' => { 185 => 0x1001 },
	'whitebalancefinetune' => { 74 => 0x100a, 113 => 0x38, 114 => 0x112, 137 => 0xb, 225 => 0x6, 227 => 0x112 },
	'whitebalancemode' => { 209 => 0x1a },
	'whitebalancered' => { 40 => 0x6 },
	'whitebalanceset' => { 202 => 0xa },
	'whitebalancesetting' => { 113 => 0x23 },
	'whitebalancetemperature' => { 177 => 0x501 },
	'whiteboard' => { 182 => 0x301 },
	'whitelevel' => { 70 => 0xc61d },
	'whitepoint' => { 70 => 0x13e, 209 => 0x201, 254 => 'WhitePoint' },
	'widefocuszone' => { 110 => 0x2f },
	'widerange' => { 223 => 0x20f },
	'wordcount' => { 249 => 'wordCount' },
	'workcolorspace' => { 64 => 0x270 },
	'worldtimelocation' => { 195 => 0x3a, 209 => 0x22 },
	'writer-editor' => { 76 => 0x7a },
	'x3filllight' => { 224 => 0x12 },
	'xmp' => { 71 => 'XMP' },
	'xmptoolkit' => { 255 => 'xmptk' },
	'xpauthor' => { 70 => 0x9c9d },
	'xpcomment' => { 70 => 0x9c9c },
	'xpkeywords' => { 70 => 0x9c9e },
	'xposition' => { 70 => 0x11e },
	'xpsubject' => { 70 => 0x9c9f },
	'xptitle' => { 70 => 0x9c9b },
	'xresolution' => { 70 => 0x11a, 79 => 0x3, 216 => 0x0, 254 => 'XResolution' },
	'xyresolution' => { 73 => 0x3 },
	'ycbcrcoefficients' => { 70 => 0x211, 254 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 70 => 0x213, 254 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 70 => 0x212, 254 => 'YCbCrSubSampling' },
	'yearcreated' => { 83 => 0x10, 91 => 0xc },
	'yposition' => { 70 => 0x11f },
	'yresolution' => { 70 => 0x11b, 79 => 0x5, 216 => 0x4, 254 => 'YResolution' },
	'zonematching' => { 113 => 0x14, 114 => 0x10a, 116 => 0x3a, 227 => 0xb024 },
	'zonematchingon' => { 112 => 0x75 },
	'zonematchingvalue' => { 225 => 0x1f },
	'zoomsourcewidth' => { 20 => 0x24 },
	'zoomstepcount' => { 180 => 0x300, 182 => 0x100d },
	'zoomtargetwidth' => { 20 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'animationextension' => 1,
	'animationiterations' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplebits' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'chapterlist' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'client' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datecompleted' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'facerecinfo' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstchar' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'frameheight' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framewidth' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isbasefont' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturer' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureinfo' => 1,
	'picturemimetype' => 1,
	'picturetype' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchangle' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryitemreference' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resourceversion' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollangle' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'starttimecode' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'synchronizedlyrictext' => 1,
	'syncsampletable' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totaltime' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodec' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpextension' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) source hash of tag definitions, 1) destination table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagsHash, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagsHash)) {
            my $newInfo = $$tagsHash{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagsHash{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagsHash = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2010, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
