use strict;

use Test::More tests => 20;

use DateTime;


my @tests = ( [ [ 1971,  9,  7 ], [ 1971, 36 ] ],
              [ [ 1971, 10, 25 ], [ 1971, 43 ] ],
              [ [ 2001,  4, 28 ], [ 2001, 17 ] ],
              [ [ 2001,  8,  2 ], [ 2001, 31 ] ],
              [ [ 2001,  9, 11 ], [ 2001, 37 ] ],
              [ [ 2002, 12, 25 ], [ 2002, 52 ] ],
              [ [ 2002, 12, 31 ], [ 2003,  1 ] ],
              [ [ 2003,  1,  1 ], [ 2003,  1 ] ],
              [ [ 2003, 12, 31 ], [ 2003, 53 ] ],
              [ [ 2004,  1,  1 ], [ 2003, 53 ] ],
              [ [ 2004, 12, 31 ], [ 2004, 52 ] ],
              [ [ 2005,  1,  1 ], [ 2004, 52 ] ],
              [ [ 2005, 12, 31 ], [ 2005, 52 ] ],
              [ [ 2006,  1,  1 ], [ 2006,  1 ] ],
              [ [ 2006, 12, 31 ], [ 2007,  1 ] ],
              [ [ 2007,  1,  1 ], [ 2007,  1 ] ],
              [ [ 2007, 12, 31 ], [ 2008,  1 ] ],
              [ [ 2008,  1,  1 ], [ 2008,  1 ] ],
              [ [ 2008, 12, 31 ], [ 2008, 53 ] ],
              [ [ 2009,  1,  1 ], [ 2008, 53 ] ],
            );

foreach my $test ( @tests )
{
    my @args = @{ $test->[0] };
    my @results = @{ $test->[1] };

    my $dt = DateTime->new( year  => $args[0],
                            month => $args[1],
                            day   => $args[2],
                          );

    my ($year, $week) = $dt->week();

    is( "$year-W$week", "$results[0]-W$results[1]" );
}
