package Locales::DB::Language::nds;

# Auto generated from CLDR

$Locales::DB::Language::nds::VERSION = '0.02';

$Locales::DB::Language::nds::cldr_version = '1.7.1';

%Locales::DB::Language::nds::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'unconfirmed'
        },
        'language' => "Spraak\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'unconfirmed'
        },
        'percent' => {
            'content' => "\#\,\#\#0 \%",
            'draft'   => 'unconfirmed'
        },
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "nee\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "jo\:j",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::nds::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchaasch',
    'ace'   => 'Aceh',
    'ach'   => 'Acholi',
    'ada'   => 'Adangme',
    'ady'   => 'Adygeisch',
    'ae'    => 'Avestsch',
    'af'    => 'Afrikaansch',
    'afa'   => "Afro\-Asiaatsche\ Spraken",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadsch',
    'ale'   => 'Aleutsch',
    'alg'   => "Algonkin\-Spraken",
    'alt'   => "Süüd\-Altaisch",
    'am'    => 'Amhaarsch',
    'an'    => 'Aragoneesch',
    'ang'   => 'Ooldengelsch',
    'anp'   => 'Angika',
    'apa'   => 'Apache',
    'ar'    => 'Araabsch',
    'arc'   => 'Aramääsch',
    'arn'   => 'Araukaansch',
    'arp'   => 'Arapaho',
    'art'   => 'Kunstspraken',
    'arw'   => "Arawak\-Spraken",
    'as'    => 'Assameesch',
    'ast'   => 'Asturiaansch',
    'ath'   => "Athabasksche\ Spraken",
    'aus'   => "Austraalsche\ Spraken",
    'av'    => 'Awaarsch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Aserbaidschaansch',
    'ba'    => 'Baschkiersch',
    'bad'   => 'Banda',
    'bai'   => 'Bamileke',
    'bal'   => 'Belutschisch',
    'ban'   => 'Balineesch',
    'bas'   => 'Basaa',
    'bat'   => "Baltsche\ Spraken",
    'be'    => 'Wittruss’sch',
    'bej'   => 'Bedscha',
    'bem'   => 'Bemba',
    'ber'   => 'Berberspraken',
    'bg'    => 'Bulgaarsch',
    'bh'    => 'Bihaarsch',
    'bho'   => 'Bhodschpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengaalsch',
    'bnt'   => 'Bantuspraken',
    'bo'    => 'Tibeetsch',
    'br'    => 'Bretoonsch',
    'bra'   => "Braj\-Bhakha",
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Burjaatsch',
    'bug'   => 'Bugineesch',
    'byn'   => 'Blin',
    'ca'    => 'Katalaansch',
    'cad'   => 'Caddo',
    'cai'   => "Indianerspraken\ in\ Zentralamerika",
    'car'   => "Kariebsche\ Spraken",
    'cau'   => "Kaukaasche\ Spraken",
    'cch'   => 'Atsam',
    'ce'    => 'Tschetscheensch',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltsche\ Spraken",
    'ch'    => 'Chamorro',
    'chb'   => "Chibcha\-Spraken",
    'chg'   => 'Tschagataisch',
    'chk'   => 'Trukeesch',
    'chm'   => 'Mari',
    'chn'   => 'Chinook',
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Cham\-Spraken",
    'co'    => 'Koorsch',
    'cop'   => 'Koptsch',
    'cpe'   => "Kreoolsch\-Engelsche\ Spraken",
    'cpf'   => "Kreoolsch\-Franzöösche\ Spraken",
    'cpp'   => "Kreoolsch\-Portugeesche\ Spraken",
    'cr'    => 'Cree',
    'crh'   => 'Krimtataarsch',
    'crp'   => "Kreoolsche\ Spraken",
    'cs'    => 'Tschech’sch',
    'csb'   => 'Kaschuubsch',
    'cu'    => 'Karkenslaavsch',
    'cus'   => "Kuschietsche\ Spraken",
    'cv'    => 'Tschuwasch’sch',
    'cy'    => 'Waliesch',
    'da'    => 'Däänsch',
    'dak'   => 'Dakota',
    'dar'   => 'Dargiensch',
    'day'   => 'Dajak',
    'de'    => 'Düütsch',
    'de_at' => "Öösterrieksch\ Hoochdüütsch",
    'de_ch' => "Swiezer\ Hoochdüütsch",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Drawiedsche\ Spraken",
    'dsb'   => 'Neddersorbsch',
    'dua'   => 'Duala',
    'dum'   => 'Middelnedderlandsch',
    'dv'    => 'Maledievsch',
    'dyu'   => 'Dyula',
    'dz'    => 'Bhutaansch',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => 'Ägyptsch',
    'eka'   => 'Ekajuk',
    'el'    => 'Greeksch',
    'elx'   => 'Elaamsch',
    'en'    => 'Engelsch',
    'en_au' => "Austraalsch\ Engelsch",
    'en_ca' => "Kanaadsch\ Engelsch",
    'en_gb' => "Brietsch\ Engelsch",
    'en_us' => "Amerikaansch\ Engelsch",
    'enm'   => 'Middelengelsch',
    'eo'    => 'Esperanto',
    'es'    => 'Spaansch',
    'es_es' => "Ibeersch\ Spaansch",
    'et'    => 'Eestnisch',
    'eu'    => 'Basksch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Pers’sch',
    'fan'   => 'Pangwe',
    'fat'   => 'Fanti',
    'ff'    => 'Ful',
    'fi'    => 'Finnsch',
    'fil'   => 'Philippiensch',
    'fiu'   => "Finnougrische\ Spraken",
    'fj'    => 'Fidschiaansch',
    'fo'    => 'Färöösch',
    'fon'   => 'Fon',
    'fr'    => 'Franzöösch',
    'fr_ca' => "Kanaadsch\ Franzöösch",
    'fr_ch' => "Swiezer\ Franzöösch",
    'frm'   => 'Middelfranzöösch',
    'fro'   => 'Ooldfranzöösch',
    'frr'   => 'Noordfreesch',
    'frs'   => 'Saterfreesch',
    'fur'   => 'Friuulsch',
    'fy'    => 'Westfreesch',
    'ga'    => 'Iersch',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Schottsch\ Gäälsch",
    'gem'   => "Germaansche\ Spraken",
    'gez'   => 'Geez',
    'gil'   => 'Gilberteesch',
    'gl'    => 'Galizisch',
    'gmh'   => 'Middelhoochdüütsch',
    'gn'    => 'Guarani',
    'goh'   => 'Ooldhoochdüütsch',
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gootsch',
    'grb'   => 'Grebo',
    'grc'   => 'Ooldgreeksch',
    'gsw'   => 'Swiezerdüütsch',
    'gu'    => 'Gujarati',
    'gv'    => 'Manx',
    'gwi'   => 'Kutchin',
    'ha'    => 'Haussa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiiaansch',
    'he'    => 'Hebrääsch',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hethitsch',
    'hmn'   => "Miao\-Spraken",
    'ho'    => "Hiri\-Motu",
    'hr'    => 'Kroaatsch',
    'hsb'   => 'Böversorbsch',
    'ht'    => "Haitiaansch\-Kreoolsch",
    'hu'    => 'Ungaarsch',
    'hup'   => 'Hupa',
    'hy'    => 'Armeensch',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indoneesch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Ilokano',
    'inc'   => "Indoarische\ Spraken",
    'ine'   => "Indogermaansche\ Spraken",
    'inh'   => 'Ingusch’sch',
    'io'    => 'Ido',
    'ira'   => "Iraansche\ Spraken",
    'iro'   => "Irokeesche\ Spraken",
    'is'    => 'Ieslandsch',
    'it'    => 'Italieensch',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japaansch',
    'jbo'   => 'Lojban',
    'jpr'   => "Jöödsch\-Pers’sch",
    'jrb'   => "Jöödsch\-Araabsch",
    'jv'    => 'Javaansch',
    'ka'    => 'Georgsch',
    'kaa'   => 'Karakalpaksch',
    'kab'   => 'Kabyylsch',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Kareensch',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardiensch',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\-Spraken",
    'kho'   => 'Saaksch',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kwanyama',
    'kk'    => 'Kasach’sch',
    'kl'    => 'Gröönlandsch',
    'km'    => 'Kambodschaansch',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Koreaansch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeaansch',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuursch',
    'krc'   => "Karatschaisch\-Balkaarsch",
    'krl'   => 'Kareelsch',
    'kro'   => "Kru\-Spraken",
    'kru'   => 'Oraon',
    'ks'    => 'Kaschmiersch',
    'ku'    => 'Kurdsch',
    'kum'   => 'Kumücksch',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Koornsch',
    'ky'    => 'Kirgiesch',
    'la'    => 'Latiensch',
    'lad'   => 'Ladiensch',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxemborgsch',
    'lez'   => 'Lesgisch',
    'lg'    => 'Ganda',
    'li'    => 'Limborgsch',
    'ln'    => 'Lingala',
    'lo'    => 'Laootsch',
    'lol'   => 'Mongo',
    'loz'   => 'Rotse',
    'lt'    => 'Litausch',
    'lu'    => 'Luba',
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Lettsch',
    'mad'   => 'Madureesch',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makassarsch',
    'man'   => 'Manding',
    'map'   => "Austroneesche\ Spraken",
    'mas'   => 'Massai',
    'mdf'   => 'Mokscha',
    'mdr'   => 'Mandareesch',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Madagassisch',
    'mga'   => 'Middeliersch',
    'mh'    => 'Marschalleesch',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Verschedene\ Spraken",
    'mk'    => 'Mazedoonsch',
    'mkh'   => "Mon\-Khmer\-Spraken",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongoolsch',
    'mnc'   => 'Mandschuursch',
    'mni'   => 'Manipuri',
    'mno'   => 'Manobo',
    'mo'    => 'Moldaawsch',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malaisch',
    'mt'    => 'Malteesch',
    'mul'   => 'Mehrsprakig',
    'mun'   => "Munda\-Spraken",
    'mus'   => "Muskogee\-Spraken",
    'mwl'   => 'Mirandeesch',
    'mwr'   => 'Marwari',
    'my'    => 'Birmaansch',
    'myn'   => "Maya\-Spraken",
    'myv'   => 'Erzya',
    'na'    => 'Nauruusch',
    'nah'   => 'Nahuatl',
    'nai'   => "Indianerspraken\ in\ Noordamerika",
    'nap'   => 'Neapolitaansch',
    'nb'    => "Norweegsch\ Bokmål",
    'nd'    => "Noord\-Ndebele",
    'nds'   => 'Plattdüütsch',
    'ne'    => 'Nepaleesch',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Nigerkordofaansche\ Spraken",
    'niu'   => 'Niue',
    'nl'    => 'Nedderlandsch',
    'nl_be' => 'Fläämsch',
    'nn'    => "Norweegsch\ Nynorsk",
    'no'    => 'Norweegsch',
    'nog'   => 'Nogai',
    'non'   => 'Ooldnoorsch',
    'nqo'   => 'N’Ko',
    'nr'    => "Süüd\-Ndebele",
    'nso'   => "Noord\-Sotho",
    'nub'   => "Nuubsche\ Spraken",
    'nv'    => 'Navajo',
    'nwc'   => "Oold\-Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okzitaansch',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Orija',
    'os'    => 'Ossetsch',
    'osa'   => 'Osage',
    'ota'   => 'Osmaansch',
    'oto'   => "Otomangue\-Spraken",
    'pa'    => 'Pandschabsch',
    'paa'   => 'Papuaspraken',
    'pag'   => 'Pangasinan',
    'pal'   => 'Middelpers’sch',
    'pam'   => 'Pampanggan',
    'pap'   => 'Papiamento',
    'pau'   => 'Palausch',
    'peo'   => 'Ooldpers’sch',
    'phi'   => "Philippinen\-Austroneesche\ Spraken",
    'phn'   => 'Phönieksch',
    'pi'    => 'Pali',
    'pl'    => 'Poolsch',
    'pon'   => 'Ponapeaansch',
    'pra'   => 'Prakrit',
    'pro'   => 'Ooldprovenzaalsch',
    'ps'    => 'Paschtu',
    'pt'    => 'Portugeesch',
    'pt_br' => "Brasiliaansch\ Portugeesch",
    'pt_pt' => "Ibeersch\ Portugeesch",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => "Oosterinsel\-Spraak",
    'rar'   => 'Rarotongaansch',
    'rm'    => 'Rätoromaansch',
    'rn'    => 'Rundi',
    'ro'    => 'Rumäänsch',
    'roa'   => "Romaansche\ Spraken",
    'rom'   => 'Romani',
    'ru'    => 'Russ’sch',
    'rup'   => 'Aromuunsch',
    'rw'    => 'Ruandsch',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Jakuutsch',
    'sai'   => "Indianerspraken\ in\ Süüdamerika",
    'sal'   => 'Salish',
    'sam'   => 'Samaritaansch',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardsch',
    'scn'   => 'Siziliaansch',
    'sco'   => 'Schottsch',
    'sd'    => 'Sindhi',
    'se'    => "Noord\-Saamsch",
    'sel'   => 'Selkupsch',
    'sem'   => "Semietsche\ Spraken",
    'sg'    => 'Sango',
    'sga'   => "Oold\-Iersch",
    'sgn'   => 'Tekenspraken',
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Schan',
    'si'    => 'Singhaleesch',
    'sid'   => 'Sidamo',
    'sio'   => "Sioux\-Spraken",
    'sit'   => "Sinotibeetsche\ Spraken",
    'sk'    => 'Slowaaksch',
    'sl'    => 'Sloweensch',
    'sla'   => "Slaavsche\ Spraken",
    'sm'    => 'Samoaansch',
    'sma'   => "Süüd\-Lappsch",
    'smi'   => 'Lappsch',
    'smj'   => "Lule\-Lappsch",
    'smn'   => "Inari\-Lappsch",
    'sms'   => "Skolt\-Lappsch",
    'sn'    => 'Schona',
    'snk'   => 'Soninke',
    'so'    => 'Somaalsch',
    'sog'   => 'Sogdisch',
    'son'   => 'Songhai',
    'sq'    => 'Albaansch',
    'sr'    => 'Serbsch',
    'srn'   => 'Surinaamsch',
    'srr'   => 'Serer',
    'ss'    => 'Swazi',
    'ssa'   => "Nilosaharaansche\ Spraken",
    'st'    => "Süüd\-Sotho",
    'su'    => 'Sundaneesch',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumersch',
    'sv'    => 'Sweedsch',
    'sw'    => 'Suaheli',
    'syc'   => "Oold\-Syyrsch",
    'syr'   => 'Syyrsch',
    'ta'    => 'Tamilsch',
    'tai'   => 'Thaispraken',
    'te'    => 'Telugu',
    'tem'   => 'Temne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tadschiksch',
    'th'    => 'Thai',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeensch',
    'tkl'   => 'Tokelausch',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingoonsch',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaschek',
    'tn'    => 'Tswana',
    'to'    => 'Tongaasch',
    'tog'   => "Tonga\ \(Nyasa\)",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Törksch',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tataarsch',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\-Spraken",
    'tut'   => "Altaische\ Spraken",
    'tvl'   => 'Elliceaansch',
    'tw'    => 'Twi',
    'ty'    => 'Tahitsch',
    'tyv'   => 'Tuwinsch',
    'udm'   => 'Udmurtsch',
    'ug'    => 'Uiguursch',
    'uga'   => 'Ugaritsch',
    'uk'    => 'Ukrainsch',
    'umb'   => 'Mbundu',
    'und'   => "Unbestimmte\ Spraak",
    'ur'    => 'Urdu',
    'uz'    => 'Usbeeksch',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnameesch',
    'vo'    => 'Volapük',
    'vot'   => 'Wootsch',
    'wa'    => 'Walloonsch',
    'wak'   => 'Wakashaansch',
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => 'Sorbsch',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmücksch',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapeesch',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => 'Yupik',
    'za'    => 'Zhuang',
    'zap'   => 'Zapoteeksch',
    'zbl'   => "Bliss\-Symbolen",
    'zen'   => 'Zenaga',
    'zh'    => 'Chineesch',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Keen\ Spraakinhold",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::nds::name_to_code = (
    'abchaasch'                       => 'ab',
    'aceh'                            => 'ace',
    'acholi'                          => 'ach',
    'adangme'                         => 'ada',
    'adygeisch'                       => 'ady',
    'afar'                            => 'aa',
    'afrihili'                        => 'afh',
    'afrikaansch'                     => 'af',
    'afroasiaatschespraken'           => 'afa',
    'ainu'                            => 'ain',
    'akan'                            => 'ak',
    'akkadsch'                        => 'akk',
    'albaansch'                       => 'sq',
    'aleutsch'                        => 'ale',
    'algonkinspraken'                 => 'alg',
    'altaischespraken'                => 'tut',
    'amerikaanschengelsch'            => 'en_us',
    'amhaarsch'                       => 'am',
    'angika'                          => 'anp',
    'apache'                          => 'apa',
    'araabsch'                        => 'ar',
    'aragoneesch'                     => 'an',
    'aramääsch'                     => 'arc',
    'arapaho'                         => 'arp',
    'araukaansch'                     => 'arn',
    'arawakspraken'                   => 'arw',
    'armeensch'                       => 'hy',
    'aromuunsch'                      => 'rup',
    'aserbaidschaansch'               => 'az',
    'assameesch'                      => 'as',
    'asturiaansch'                    => 'ast',
    'athabaskschespraken'             => 'ath',
    'atsam'                           => 'cch',
    'austraalschengelsch'             => 'en_au',
    'austraalschespraken'             => 'aus',
    'austroneeschespraken'            => 'map',
    'avestsch'                        => 'ae',
    'awaarsch'                        => 'av',
    'awadhi'                          => 'awa',
    'aymara'                          => 'ay',
    'balineesch'                      => 'ban',
    'baltschespraken'                 => 'bat',
    'bambara'                         => 'bm',
    'bamileke'                        => 'bai',
    'banda'                           => 'bad',
    'bantuspraken'                    => 'bnt',
    'basaa'                           => 'bas',
    'baschkiersch'                    => 'ba',
    'basksch'                         => 'eu',
    'batak'                           => 'btk',
    'bedscha'                         => 'bej',
    'belutschisch'                    => 'bal',
    'bemba'                           => 'bem',
    'bengaalsch'                      => 'bn',
    'berberspraken'                   => 'ber',
    'bhodschpuri'                     => 'bho',
    'bhutaansch'                      => 'dz',
    'bihaarsch'                       => 'bh',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'birmaansch'                      => 'my',
    'bislama'                         => 'bi',
    'blin'                            => 'byn',
    'blisssymbolen'                   => 'zbl',
    'bosnisch'                        => 'bs',
    'brajbhakha'                      => 'bra',
    'brasiliaanschportugeesch'        => 'pt_br',
    'bretoonsch'                      => 'br',
    'brietschengelsch'                => 'en_gb',
    'bugineesch'                      => 'bug',
    'bulgaarsch'                      => 'bg',
    'burjaatsch'                      => 'bua',
    'böversorbsch'                   => 'hsb',
    'caddo'                           => 'cad',
    'cebuano'                         => 'ceb',
    'chamorro'                        => 'ch',
    'chamspraken'                     => 'cmc',
    'cherokee'                        => 'chr',
    'cheyenne'                        => 'chy',
    'chibchaspraken'                  => 'chb',
    'chineesch'                       => 'zh',
    'chinook'                         => 'chn',
    'chipewyan'                       => 'chp',
    'choctaw'                         => 'cho',
    'cree'                            => 'cr',
    'dajak'                           => 'day',
    'dakota'                          => 'dak',
    'dargiensch'                      => 'dar',
    'delaware'                        => 'del',
    'dinka'                           => 'din',
    'dogri'                           => 'doi',
    'dogrib'                          => 'dgr',
    'drawiedschespraken'              => 'dra',
    'duala'                           => 'dua',
    'dyula'                           => 'dyu',
    'däänsch'                       => 'da',
    'düütsch'                       => 'de',
    'eestnisch'                       => 'et',
    'efik'                            => 'efi',
    'ekajuk'                          => 'eka',
    'elaamsch'                        => 'elx',
    'elliceaansch'                    => 'tvl',
    'engelsch'                        => 'en',
    'erzya'                           => 'myv',
    'esperanto'                       => 'eo',
    'ewe'                             => 'ee',
    'ewondo'                          => 'ewo',
    'fanti'                           => 'fat',
    'fidschiaansch'                   => 'fj',
    'finnougrischespraken'            => 'fiu',
    'finnsch'                         => 'fi',
    'fläämsch'                      => 'nl_be',
    'fon'                             => 'fon',
    'franzöösch'                    => 'fr',
    'friuulsch'                       => 'fur',
    'ful'                             => 'ff',
    'färöösch'                     => 'fo',
    'ga'                              => 'gaa',
    'galizisch'                       => 'gl',
    'ganda'                           => 'lg',
    'gayo'                            => 'gay',
    'gbaya'                           => 'gba',
    'geez'                            => 'gez',
    'georgsch'                        => 'ka',
    'germaanschespraken'              => 'gem',
    'gilberteesch'                    => 'gil',
    'gondi'                           => 'gon',
    'gootsch'                         => 'got',
    'gorontalo'                       => 'gor',
    'grebo'                           => 'grb',
    'greeksch'                        => 'el',
    'gröönlandsch'                  => 'kl',
    'guarani'                         => 'gn',
    'gujarati'                        => 'gu',
    'haida'                           => 'hai',
    'haitiaanschkreoolsch'            => 'ht',
    'haussa'                          => 'ha',
    'hawaiiaansch'                    => 'haw',
    'hebrääsch'                     => 'he',
    'herero'                          => 'hz',
    'hethitsch'                       => 'hit',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindi'                           => 'hi',
    'hirimotu'                        => 'ho',
    'hupa'                            => 'hup',
    'iban'                            => 'iba',
    'ibeerschportugeesch'             => 'pt_pt',
    'ibeerschspaansch'                => 'es_es',
    'ido'                             => 'io',
    'iersch'                          => 'ga',
    'ieslandsch'                      => 'is',
    'igbo'                            => 'ig',
    'ijo'                             => 'ijo',
    'ilokano'                         => 'ilo',
    'inarilappsch'                    => 'smn',
    'indianersprakeninnoordamerika'   => 'nai',
    'indianersprakeninsüüdamerika'  => 'sai',
    'indianersprakeninzentralamerika' => 'cai',
    'indoarischespraken'              => 'inc',
    'indogermaanschespraken'          => 'ine',
    'indoneesch'                      => 'id',
    'ingusch’sch'                   => 'inh',
    'interlingua'                     => 'ia',
    'interlingue'                     => 'ie',
    'inuktitut'                       => 'iu',
    'inupiak'                         => 'ik',
    'iraanschespraken'                => 'ira',
    'irokeeschespraken'               => 'iro',
    'italieensch'                     => 'it',
    'jakuutsch'                       => 'sah',
    'japaansch'                       => 'ja',
    'javaansch'                       => 'jv',
    'jiddisch'                        => 'yi',
    'jju'                             => 'kaj',
    'jöödscharaabsch'               => 'jrb',
    'jöödschpers’sch'             => 'jpr',
    'kabardiensch'                    => 'kbd',
    'kabyylsch'                       => 'kab',
    'kachin'                          => 'kac',
    'kalmücksch'                     => 'xal',
    'kamba'                           => 'kam',
    'kambodschaansch'                 => 'km',
    'kanaadschengelsch'               => 'en_ca',
    'kanaadschfranzöösch'           => 'fr_ca',
    'kannada'                         => 'kn',
    'kanuursch'                       => 'kr',
    'karakalpaksch'                   => 'kaa',
    'karatschaischbalkaarsch'         => 'krc',
    'kareelsch'                       => 'krl',
    'kareensch'                       => 'kar',
    'kariebschespraken'               => 'car',
    'karkenslaavsch'                  => 'cu',
    'kasach’sch'                    => 'kk',
    'kaschmiersch'                    => 'ks',
    'kaschuubsch'                     => 'csb',
    'katalaansch'                     => 'ca',
    'kaukaaschespraken'               => 'cau',
    'kawi'                            => 'kaw',
    'keenspraakinhold'                => 'zxx',
    'keltschespraken'                 => 'cel',
    'khasi'                           => 'kha',
    'khoisanspraken'                  => 'khi',
    'kikuyu'                          => 'ki',
    'kimbundu'                        => 'kmb',
    'kirgiesch'                       => 'ky',
    'klingoonsch'                     => 'tlh',
    'komi'                            => 'kv',
    'kongo'                           => 'kg',
    'konkani'                         => 'kok',
    'koornsch'                        => 'kw',
    'koorsch'                         => 'co',
    'koptsch'                         => 'cop',
    'koreaansch'                      => 'ko',
    'koro'                            => 'kfo',
    'kosraeaansch'                    => 'kos',
    'kpelle'                          => 'kpe',
    'kreoolschengelschespraken'       => 'cpe',
    'kreoolschespraken'               => 'crp',
    'kreoolschfranzööschespraken'   => 'cpf',
    'kreoolschportugeeschespraken'    => 'cpp',
    'krimtataarsch'                   => 'crh',
    'kroaatsch'                       => 'hr',
    'kruspraken'                      => 'kro',
    'kumücksch'                      => 'kum',
    'kunstspraken'                    => 'art',
    'kurdsch'                         => 'ku',
    'kuschietschespraken'             => 'cus',
    'kutchin'                         => 'gwi',
    'kutenai'                         => 'kut',
    'kwanyama'                        => 'kj',
    'ladiensch'                       => 'lad',
    'lahnda'                          => 'lah',
    'lamba'                           => 'lam',
    'laootsch'                        => 'lo',
    'lappsch'                         => 'smi',
    'latiensch'                       => 'la',
    'lesgisch'                        => 'lez',
    'lettsch'                         => 'lv',
    'limborgsch'                      => 'li',
    'lingala'                         => 'ln',
    'litausch'                        => 'lt',
    'lojban'                          => 'jbo',
    'luba'                            => 'lu',
    'lubalulua'                       => 'lua',
    'luiseno'                         => 'lui',
    'lulelappsch'                     => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luxemborgsch'                    => 'lb',
    'madagassisch'                    => 'mg',
    'madureesch'                      => 'mad',
    'magahi'                          => 'mag',
    'maithili'                        => 'mai',
    'makassarsch'                     => 'mak',
    'malaisch'                        => 'ms',
    'malayalam'                       => 'ml',
    'maledievsch'                     => 'dv',
    'malteesch'                       => 'mt',
    'mandareesch'                     => 'mdr',
    'manding'                         => 'man',
    'mandschuursch'                   => 'mnc',
    'manipuri'                        => 'mni',
    'manobo'                          => 'mno',
    'manx'                            => 'gv',
    'maori'                           => 'mi',
    'marathi'                         => 'mr',
    'mari'                            => 'chm',
    'marschalleesch'                  => 'mh',
    'marwari'                         => 'mwr',
    'massai'                          => 'mas',
    'mayaspraken'                     => 'myn',
    'mazedoonsch'                     => 'mk',
    'mbundu'                          => 'umb',
    'mehrsprakig'                     => 'mul',
    'mende'                           => 'men',
    'miaospraken'                     => 'hmn',
    'micmac'                          => 'mic',
    'middelengelsch'                  => 'enm',
    'middelfranzöösch'              => 'frm',
    'middelhoochdüütsch'            => 'gmh',
    'middeliersch'                    => 'mga',
    'middelnedderlandsch'             => 'dum',
    'middelpers’sch'                => 'pal',
    'minangkabau'                     => 'min',
    'mirandeesch'                     => 'mwl',
    'mohawk'                          => 'moh',
    'mokscha'                         => 'mdf',
    'moldaawsch'                      => 'mo',
    'mongo'                           => 'lol',
    'mongoolsch'                      => 'mn',
    'monkhmerspraken'                 => 'mkh',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'mundaspraken'                    => 'mun',
    'muskogeespraken'                 => 'mus',
    'nahuatl'                         => 'nah',
    'nauruusch'                       => 'na',
    'navajo'                          => 'nv',
    'ndonga'                          => 'ng',
    'neapolitaansch'                  => 'nap',
    'nedderlandsch'                   => 'nl',
    'neddersorbsch'                   => 'dsb',
    'nepaleesch'                      => 'ne',
    'newari'                          => 'new',
    'nias'                            => 'nia',
    'nigerkordofaanschespraken'       => 'nic',
    'nilosaharaanschespraken'         => 'ssa',
    'niue'                            => 'niu',
    'nogai'                           => 'nog',
    'noordfreesch'                    => 'frr',
    'noordndebele'                    => 'nd',
    'noordsaamsch'                    => 'se',
    'noordsotho'                      => 'nso',
    'norweegsch'                      => 'no',
    'norweegschbokmål'               => 'nb',
    'norweegschnynorsk'               => 'nn',
    'nuubschespraken'                 => 'nub',
    'nyamwezi'                        => 'nym',
    'nyanja'                          => 'ny',
    'nyankole'                        => 'nyn',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    'n’ko'                          => 'nqo',
    'ojibwa'                          => 'oj',
    'okzitaansch'                     => 'oc',
    'ooldengelsch'                    => 'ang',
    'ooldfranzöösch'                => 'fro',
    'ooldgreeksch'                    => 'grc',
    'ooldhoochdüütsch'              => 'goh',
    'ooldiersch'                      => 'sga',
    'ooldnewari'                      => 'nwc',
    'ooldnoorsch'                     => 'non',
    'ooldpers’sch'                  => 'peo',
    'ooldprovenzaalsch'               => 'pro',
    'ooldsyyrsch'                     => 'syc',
    'oosterinselspraak'               => 'rap',
    'oraon'                           => 'kru',
    'orija'                           => 'or',
    'oromo'                           => 'om',
    'osage'                           => 'osa',
    'osmaansch'                       => 'ota',
    'ossetsch'                        => 'os',
    'otomanguespraken'                => 'oto',
    'palausch'                        => 'pau',
    'pali'                            => 'pi',
    'pampanggan'                      => 'pam',
    'pandschabsch'                    => 'pa',
    'pangasinan'                      => 'pag',
    'pangwe'                          => 'fan',
    'papiamento'                      => 'pap',
    'papuaspraken'                    => 'paa',
    'paschtu'                         => 'ps',
    'pers’sch'                      => 'fa',
    'philippiensch'                   => 'fil',
    'philippinenaustroneeschespraken' => 'phi',
    'phönieksch'                     => 'phn',
    'plattdüütsch'                  => 'nds',
    'ponapeaansch'                    => 'pon',
    'poolsch'                         => 'pl',
    'portugeesch'                     => 'pt',
    'prakrit'                         => 'pra',
    'quechua'                         => 'qu',
    'rajasthani'                      => 'raj',
    'rarotongaansch'                  => 'rar',
    'romaanschespraken'               => 'roa',
    'romani'                          => 'rom',
    'rotse'                           => 'loz',
    'ruandsch'                        => 'rw',
    'rumäänsch'                     => 'ro',
    'rundi'                           => 'rn',
    'russ’sch'                      => 'ru',
    'rätoromaansch'                  => 'rm',
    'saaksch'                         => 'kho',
    'salish'                          => 'sal',
    'samaritaansch'                   => 'sam',
    'samoaansch'                      => 'sm',
    'sandawe'                         => 'sad',
    'sango'                           => 'sg',
    'sanskrit'                        => 'sa',
    'santali'                         => 'sat',
    'sardsch'                         => 'sc',
    'sasak'                           => 'sas',
    'saterfreesch'                    => 'frs',
    'schan'                           => 'shn',
    'schona'                          => 'sn',
    'schottsch'                       => 'sco',
    'schottschgäälsch'              => 'gd',
    'selkupsch'                       => 'sel',
    'semietschespraken'               => 'sem',
    'serbocroatian'                   => 'sh',
    'serbsch'                         => 'sr',
    'serer'                           => 'srr',
    'sichuanyi'                       => 'ii',
    'sidamo'                          => 'sid',
    'siksika'                         => 'bla',
    'sindhi'                          => 'sd',
    'singhaleesch'                    => 'si',
    'sinotibeetschespraken'           => 'sit',
    'siouxspraken'                    => 'sio',
    'siziliaansch'                    => 'scn',
    'skoltlappsch'                    => 'sms',
    'slaavschespraken'                => 'sla',
    'slave'                           => 'den',
    'slowaaksch'                      => 'sk',
    'sloweensch'                      => 'sl',
    'sogdisch'                        => 'sog',
    'somaalsch'                       => 'so',
    'songhai'                         => 'son',
    'soninke'                         => 'snk',
    'sorbsch'                         => 'wen',
    'spaansch'                        => 'es',
    'suaheli'                         => 'sw',
    'sukuma'                          => 'suk',
    'sumersch'                        => 'sux',
    'sundaneesch'                     => 'su',
    'surinaamsch'                     => 'srn',
    'susu'                            => 'sus',
    'swazi'                           => 'ss',
    'sweedsch'                        => 'sv',
    'swiezerdüütsch'                => 'gsw',
    'swiezerfranzöösch'             => 'fr_ch',
    'swiezerhoochdüütsch'           => 'de_ch',
    'syyrsch'                         => 'syr',
    'süüdaltaisch'                  => 'alt',
    'süüdlappsch'                   => 'sma',
    'süüdndebele'                   => 'nr',
    'süüdsotho'                     => 'st',
    'tadschiksch'                     => 'tg',
    'tagalog'                         => 'tl',
    'tahitsch'                        => 'ty',
    'tamaschek'                       => 'tmh',
    'tamilsch'                        => 'ta',
    'taroko'                          => 'trv',
    'tataarsch'                       => 'tt',
    'tekenspraken'                    => 'sgn',
    'telugu'                          => 'te',
    'temne'                           => 'tem',
    'tereno'                          => 'ter',
    'tetum'                           => 'tet',
    'thai'                            => 'th',
    'thaispraken'                     => 'tai',
    'tibeetsch'                       => 'bo',
    'tigre'                           => 'tig',
    'tigrinja'                        => 'ti',
    'tiv'                             => 'tiv',
    'tlingit'                         => 'tli',
    'tokelausch'                      => 'tkl',
    'tokpisin'                        => 'tpi',
    'tongaasch'                       => 'to',
    'tonganyasa'                      => 'tog',
    'trukeesch'                       => 'chk',
    'tschagataisch'                   => 'chg',
    'tschech’sch'                   => 'cs',
    'tschetscheensch'                 => 'ce',
    'tschuwasch’sch'                => 'cv',
    'tsimshian'                       => 'tsi',
    'tsonga'                          => 'ts',
    'tswana'                          => 'tn',
    'tumbuka'                         => 'tum',
    'tupispraken'                     => 'tup',
    'turkmeensch'                     => 'tk',
    'tuwinsch'                        => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    'törksch'                        => 'tr',
    'udmurtsch'                       => 'udm',
    'ugaritsch'                       => 'uga',
    'uiguursch'                       => 'ug',
    'ukrainsch'                       => 'uk',
    'unbestimmtespraak'               => 'und',
    'ungaarsch'                       => 'hu',
    'urdu'                            => 'ur',
    'usbeeksch'                       => 'uz',
    'vai'                             => 'vai',
    'venda'                           => 've',
    'verschedenespraken'              => 'mis',
    'vietnameesch'                    => 'vi',
    'volapük'                        => 'vo',
    'wakashaansch'                    => 'wak',
    'walamo'                          => 'wal',
    'waliesch'                        => 'cy',
    'walloonsch'                      => 'wa',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'westfreesch'                     => 'fy',
    'wittruss’sch'                  => 'be',
    'wolof'                           => 'wo',
    'wootsch'                         => 'vot',
    'xhosa'                           => 'xh',
    'yao'                             => 'yao',
    'yapeesch'                        => 'yap',
    'yoruba'                          => 'yo',
    'yupik'                           => 'ypk',
    'zande'                           => 'znd',
    'zapoteeksch'                     => 'zap',
    'zaza'                            => 'zza',
    'zenaga'                          => 'zen',
    'zhuang'                          => 'za',
    'zulu'                            => 'zu',
    'zuni'                            => 'zun',
    'Ägyptsch'                       => 'egy',
    'Öösterriekschhoochdüütsch'   => 'de_at',
);

1;
