# perl

use Benchmark;
use Getopt::Std 'getopts';
getopts('vI:p:');

chdir( 't' ) if -d 't';
@tests = @ARGV ? @ARGV : <*.[tv]>;

$perl5db = 'use Devel::DProf;';
$perl5lib = $opt_I || join( ':', @INC );
$perl = $opt_p || $^X;

if( $opt_v ){
	print "tests: @tests\n";
	print "perl: $perl\n";
	print "perl5lib: $perl5lib\n";
}
if( $perl =~ m|^\./| ){
	$perl = ".$perl";
}
if( ! -f $perl ){ die "Where's Perl?" }

sub profile {
	my $test = shift;
	my @results;
	my $t_start = new Benchmark;
	local $ENV{PERL5DB} = $perl5db;
	local $ENV{PERL5LIB} = $perl5lib;

	open( R, "$perl -d $test |" ) || warn "$0: Can't run. $!\n";
	@results = <R>;
	close R;
	if( $opt_v ){
		print "\n";
		print @results
	}

	my $t_total = timediff( new Benchmark, $t_start );
	print timestr( $t_total, 'nop' ), "\n";
}


sub verify {
	my $test = shift;

	system $perl, '-I.', $test, $opt_v?'-v':'', '-p', $perl;
}


$| = 1;
while( @tests ){
	$test = shift @tests;
	print $test . '.' x (20 - length $test);
	if( $test =~ /t$/ ){
		profile $test;
	}
	else{
		verify $test;
	}
}
