# Pod::WikiDoc - check module loading and create testing directory

use Test::More;
use IO::String;
use t::Casefiles;

use Pod::WikiDoc;

#--------------------------------------------------------------------------#
# parser setup
#--------------------------------------------------------------------------#

my $parser = Pod::WikiDoc->new ();

#--------------------------------------------------------------------------#
# case file runner
#--------------------------------------------------------------------------#

my $cases = t::Casefiles->new( "t/filter_pod" );

plan tests => 1 + $cases->files();

#--------------------------------------------------------------------------#
# test "Generated by" line
#--------------------------------------------------------------------------#

my $in_fh = IO::String->new("foo");
my $out_fh = IO::String->new();
$parser->_filter_podfile( $in_fh, $out_fh );
seek $out_fh, 0, 0;
my $version = $parser->VERSION();
like( ${$out_fh->string_ref()},
    qr{\A# Generated by Pod::WikiDoc version $version},
    "'Generated by' string"
);

#--------------------------------------------------------------------------#
# run test cases
#--------------------------------------------------------------------------#

$cases->run_tests( 
    sub { 
        my $input_string = shift;
        my $input_fh = IO::String->new( $input_string );
        my $output_fh = IO::String->new();
        $parser->_filter_podfile( $input_fh, $output_fh );
        my $got = ${ $output_fh->string_ref() };
        $got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line
        return $got;
    }
);

