# -*-perl-*-

# $Id: 06_ruleset.t,v 1.3 2002/08/21 14:36:01 lachoy Exp $

use strict;
use lib qw( t/ );
use Test::More tests => 7;

{
    my %config = (
      test => {
         class      => 'LoopbackTest',
         isa        => [ qw( SPOPS::Key::Random SPOPS::Loopback ) ],
         rules_from => [ 'SampleRuleset' ],
         field      => [ qw( id_field field_name ) ],
         id_field   => 'id_field',
      },
    );

    # Create our test class using the loopback

    require_ok( 'SPOPS::Initialize' );

    my $class_init_list = eval { SPOPS::Initialize->process({ config => \%config }) };
    ok( ! $@, "Initialize process run $@" );
    is( $class_init_list->[0], 'LoopbackTest', 'Loopback initialized' );

    # Create an object and save it, checking to see if the {id_field}
    # generated by SPOPS::Key::Random was overwritten by the one in
    # SampleRuleset

    my $item = eval { LoopbackTest->new };
    eval { $item->save };
    ok( ! $@, "Initial save" );
    is( $item->{id_field}, 'blimey!', "Rule overwrote ID field after insert save()" );

    $item->{id_field} = "Foo!";
    eval { $item->save };
    ok( ! $@, "Update save" );
    is( $item->{id_field}, "Foo!", "Rule did not overwrite ID field after update save()" );
}
