# TODO: This is not an Action; should it be? Should it be here?
package OpenInteract2::Action::SystemBoxes;

# $Id: SystemBoxes.pm,v 1.3 2003/06/04 15:47:00 lachoy Exp $

use strict;
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );

$OpenInteract2::Action::SystemBoxes::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

sub handler {
    my ( $class ) = @_;
    my @boxes = ();
    my $request = CTX->request;
    # First deal with the user info box, and any other boxes that
    # depend on the user being logged in

    if ( $request->auth_is_logged_in ) {
        DEBUG && LOG( LDEBUG, "Adding box [user_info]" );
        eval { push @boxes, CTX->lookup_action( 'user_info_box' ) };
        if ( $@ ) {
            DEBUG && LOG( LWARN, "Error looking up 'user_info_box': $@" );
        }
        if ( $request->auth_is_admin ) {
            DEBUG && LOG( LDEBUG, "Adding box [admin_tools]" );
            eval { push @boxes, CTX->lookup_action( 'admin_tools_box' ) };
            if ( $@ ) {
                DEBUG && LOG( LWARN, "Error looking up 'admin_tools_box': $@" );
            }
        }
    }
    else {
        DEBUG && LOG( LDEBUG, "Adding box [login]" );
        eval { push @boxes, CTX->lookup_action( 'login_box' ) };
        if ( $@ ) {
            DEBUG && LOG( LWARN, "Error looking up 'login_box': $@" );
        }
    }
    return @boxes;
}

1;

__END__

=head1 NAME

OpenInteract2::Action::SystemBoxes -- Generate default boxes that appear on all pages

=head1 SYNOPSIS

 # Defined from your server configuration:
 
 [box]
 ...
 system_box_handler = OpenInteract2::Handler::SystemBoxes
 system_box_method  =

=head1 DESCRIPTION

This handler defines the boxes that can appear on every
page. Currently, these include:

B<user_info> (if logged in)

Displays username, full name and any other information or links you
want your users to see about themselves on every page.

B<login_form> (if not logged in)

Displays a username/password form and a link to create a new account.

B<admin_tools> (if user is admin)

Displays links for site administrators.

=head1 CONFIGURING BOXES

Since each box is a component and components are defined through the
Action Table, you can define information for each of these boxes in
the file C<conf/action.ini> for this package or in your website's
global override. (The information for each should already be defined,
so if you want to modify any of the values there feel free.)

=head1 BUGS

None known -- hey, it's too simple to have bugs!

=head1 TO DO

B<More?>

Any other system-wide boxes needed?

=head1 SEE ALSO

L<OpenInteract2::Action::Box>

=head1 COPYRIGHT

Copyright (c) 2001-2002 Chris Winters. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters E<lt>chris@cwinters.comE<gt>
