package OpenInteract2::Action::SiteTemplate;

# $Id: SiteTemplate.pm,v 1.7 2003/06/10 04:07:41 lachoy Exp $

use strict;
use base qw( OpenInteract2::Action );
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );
use SPOPS::Secure            qw( SEC_LEVEL_WRITE );

$OpenInteract2::Action::SiteTemplate::VERSION = sprintf("%d.%02d", q$Revision: 1.7 $ =~ /(\d+)\.(\d+)/);

sub list {
    my ( $self ) = @_;
    my $website_dir = CTX->server_config->{dir}{website};
    my $packages = CTX->repository->fetch_all_packages();
    my $tmpl_class = CTX->template_class;
    my %templates = ();
    foreach my $pkg ( @{ $packages } ) {
        eval {
            $templates{ $pkg->name } =
                         $tmpl_class->fetch_by_package( $pkg->name );
        };
        if ( $@ ) {
            my $msg = "Failed to fetch templates in " . $pkg->name . ": $@";
            LOG( LERROR, $msg );
            $self->param_add( error_msg => $msg );
        }
    }
    eval {
        $templates{ '' } = $tmpl_class->fetch_by_package( '' )
    };
    if ( $@ ) {
        my $msg = "Failed to get global templates: $@";
        LOG( LERROR, $msg );
        $self->param_add( error_msg => $msg );
    }
    return $self->generate_content(
                    { package_templates => \%templates },
                    { name => 'base_template::template_list' } );
}

sub _set_package_info {
    my ( $self, $template_params ) = @_;
    my $packages = CTX->packages;
    for ( @{ $packages } ) {
        push @{ $template_params->{package_list} }, $_->{name};
        push @{ $template_params->{package_labels} }, $_->{name};
    }
}

sub display_form {
    my ( $self ) = @_;
    my %params = ( package_list   => [ '' ],
                   package_labels => [ 'Global Templates' ] );
    $self->_set_package_info( \%params );

    my $tmpl_class = CTX->template_class;
    my $request = CTX->request;
    my $template = $self->param( 'template' );
    unless ( $template ) {
        my $package = $request->param( 'package' );
        my $name    = $request->param( 'name' );
        if ( $name ) {
            my $fq_name = $tmpl_class->create_name( $package, $name );
            $template = eval { $tmpl_class->fetch( $fq_name ) };
            if ( $@ || ! $template ) {
                my $error = $@ || 'not found';
                $self->param_add(
                    error_msg => "Failed to fetch template [$fq_name]: $error" );
                return $self->execute({ task => 'list' });
            }
        }
    }
    $params{tmpl} = $template;
    return $self->generate_content(
                    \%params,
                    { name => 'base_template::template_form' } );
}

sub display_add {
    my ( $self ) = @_;
    my $tmpl_class = CTX->template_class;

    # We might have one leftover from a failed 'add'...
    my $template = $self->param( 'template' ) || $tmpl_class->new;

    my %params = ( tmpl           => $template,
                   package_list   => [ '' ],
                   package_labels => [ 'Global Templates' ] );
    $self->_set_package_info( \%params );
    return $self->generate_content(
                    \%params,
                    { name => 'base_template::template_form' } );
}

sub update {
    my ( $self ) = @_;
    $self->response->return_url(
        OpenInteract2::URL->create_from_action( 'template' ) );

    my $request = CTX->request;
    my $package = $request->param( 'package_original' );
    my $name    = $request->param( 'name_original' );

    my $tmpl_class = CTX->template_class;
    my $fq_name = $tmpl_class->create_name( $package, $name );
    my $template = eval { $tmpl_class->fetch( $fq_name ) };
    if ( $@ or ! $template ) {
        my $error = $@ || 'not found';
        $self->param_add(
            error_msg => "Failed to fetch template [$fq_name]: $error" );
        return $self->execute({ task => 'list' });
    }
    $template->package( $request->param( 'package' ) );
    $template->name( $request->param( 'name' ) );
    $template->set_contents( $request->param( 'contents' ) );
    eval { $template->save };
    if ( $@ ) {
        $self->param_add( error_msg => "Failed to save template: $@" );
        $self->param( template => $template );
        return $self->execute({ task => 'display_form' });
    }
    else {
        my $new_name = $template->create_name;
        $self->param_add( status_msg => "Template $new_name saved ok" );
        return $self->execute({ task => 'list' });
    }
}


sub add {
    my ( $self ) = @_;
    $self->response->return_url(
        OpenInteract2::URL->create_from_action( 'template' ) );

    my $request = CTX->request;

    my $tmpl_class = CTX->template_class;
    my $template = $tmpl_class->new;

    my $package = $request->param( 'package' );
    my $name    = $request->param( 'name' );

    $template->package( $package );
    $template->name( $name );
    $template->set_contents( $request->param( 'contents' ) );
    $self->param( template => $template );

    my $fq_name = $tmpl_class->create_name( $package, $name );
    my $existing_template = eval { $tmpl_class->fetch( $fq_name ) };
    if ( $existing_template ) {
        $self->param_add(
            error_msg => "Template [$fq_name] already exists, cannot create" );
        return $self->execute({ task => 'display_add' });
    }

    eval { $template->save };
    if ( $@ ) {
        $self->param_add( error_msg => "Failed to create template: $@" );
        return $self->execute({ task => 'display_add' });
    }
    else {
        $self->param_add( status_msg => "Template $fq_name saved ok" );
        return $self->execute({ task => 'list' });
    }
}


sub remove {
    my ( $self ) = @_;
    my $request = CTX->request;
    my $template = $self->param( 'template' );
    my ( $fq_name );
    if ( $template ) {
        $fq_name = $template->create_name;
    }
    else {
        my $package = $request->param( 'package' );
        my $name    = $request->param( 'name' );
        my $tmpl_class = CTX->template_class;
        $fq_name = $tmpl_class->create_name( $package, $name );
        $template = eval { $tmpl_class->fetch( $fq_name ) };
        if ( $@ ) {
            $self->param_add(
                error_msg => "Cannot fetch template [$fq_name]: $@" );
            return $self->execute({ task => 'list' });
        }
    }
    if ( $template ) {
        eval { $template->remove };
        if ( $@ ) {
            $self->param_add(
                error_msg => "Error removing template $fq_name: $@" );
        }
        else {
            $self->param_add(
                status_msg => "Template $fq_name removed ok" );
        }
    }
    else {
        $self->param_add(
            error_msg => "Template [$fq_name] does not seem to exist" );
    }
    return $self->execute({ task => 'list' });
}

1;
