package OpenInteract2::Action::Error;

# $Id: Error.pm,v 1.7 2003/06/09 11:46:57 lachoy Exp $

use strict;
use base qw( OpenInteract2::Action::CommonSearch
             OpenInteract2::Action::CommonDisplay );
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );
use Text::Wrap    qw();

$OpenInteract2::Action::Error::VERSION = sprintf("%d.%02d", q$Revision: 1.7 $ =~ /(\d+)\.(\d+)/);

sub _search_query_customize {
    my ( $self ) = @_;
    my $request = CTX->request;

    # First, set the order

    my $order = $request->param( 'sort' ) || 'error_time';
    $order = ( $order eq 'error_time' ) ? 'error_time DESC' : $order;
    $self->param( c_search_results_order => $order );

    # Next, set the date_from and/or date_to

    my $where = $self->param( 'c_search_query_where' )  || [];
    my $value = $self->param( 'c_search_query_values' ) || [];
    if ( my $from_date = $request->param_date( 'filter_date_from' ) ) {
        push @{ $where }, 'error_time >= ?';
        push @{ $value }, $from_date->strftime( '%Y-%m-%d' );
    }
    if ( my $to_date = $request->param_date( 'filter_date_to' ) ) {
        push @{ $where }, 'error_time <= ?';
        push @{ $value }, $to_date->strftime( '%Y-%m-%d' );
    }
    $self->param( c_search_query_where  => $where );
    $self->param( c_search_query_values => $value );
    return undef;
}


sub _search_customize {
    my ( $self, $template_params ) = @_;
    my $request = CTX->request;
    $template_params->{filterby} = {
         sort      => $request->param( 'filter_sort' ),
         code      => $request->param( 'filter_code' ),
         type      => $request->param( 'filter_type' ),
         date_from => $request->param_date( 'filter_date_from' ),
         date_to   => $request->param_date( 'filter_date_to' ),
    };
    return undef;
}



# Grab the user here since sometimes the user might be 'superuser'
# who cannot be seen by mere mortals. This throws an error if you
# do in the template [% error_user = err.user %] and rather than a
# TRY/CATCH block we'll just do it here.

sub _show_customize {
    my ( $self, $params ) = @_;
    $params->{error_user} = eval { $params->{error}->user };
}


# Implement 'remove()' ourselves so we can delete multiple objects at
# once

sub remove {
    my ( $self ) = @_;
    my $request = CTX->request;
    my @error_id = $request->param( 'error_id' );
    my ( @error_results );
    my $success = 0;
    foreach my $eid ( @error_id ) {
        DEBUG && LOG( LDEBUG, "Removing error: $eid" );
        my $error = eval {
            CTX->lookup_object( 'error_object' )->fetch( $eid )
        };
        if ( $@ or ! $error ) {
            my $msg = ( $@ )
                        ? "Could not retrieve error [$eid] to remove: $@"
                        : "Error [$eid] does not exist, not removed.";
            LOG( LWARN, "Failed to fetch error for removal: $msg" );
            $self->param_add( error_msg => $msg );
            push @error_results, $msg;
            next;
        }
        eval { $error->remove };
        if ( $@ ) {
            LOG( LERROR, "Failed to delete error [$eid]: $@" );
            $self->param_add( error_msg => "Failed to remove [$eid]: $@" );
        }
        else {
            $success++;
        }
    }
    $self->param_add(
               status_msg => "$success objects removed successfully" );
    return $self->execute( task=> 'search_form' );
}

1;
