package OpenInteract::SQLInstall::News;

# $Id: News.pm,v 1.6 2002/05/02 12:42:26 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
   tables        => [ 'news.sql' ],
   tables_oracle => [ 'news_oracle.sql', 'news_sequence.sql' ],
   tables_pg     => [ 'news.sql', 'news_sequence.sql' ],
   tables_ib     => [ 'news_interbase.sql', 'news_generator.sql' ],
   security      => [ 'install_security.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure',
                                          { table_file_list => $files{tables} } ],
                         'Oracle'    => [ 'create_structure',
                                          { table_file_list => $files{tables_oracle} } ],
                         'Pg'        => [ 'create_structure',
                                          { table_file_list => $files{tables_pg} } ],
                         'InterBase' => [ 'create_structure',
                                          { table_file_list => $files{tables_ib} } ],
    },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;
