package OpenInteract::Handler::Logout;

# $Id: Logout.pm,v 1.3 2001/05/30 03:13:03 lachoy Exp $

use strict;

@OpenInteract::Handler::Logout::ISA     = ();
$OpenInteract::Handler::Logout::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

use constant DEBUG  => 0;

sub handler {
  my ( $class ) = @_;
  my $R = OpenInteract::Request->instance;
  $R->cookies->create_cookie({ name    => $OpenInteract::Session::COOKIE_NAME,
                               value   => '', 
                               path    => '/', 
                               expires => '-3d' });
  my $return = $R->apache->param( 'return' );
  $R->DEBUG && $R->scrib( 1, "Logged out and trying to return to: <<$return>>" );
  my ( $action_class, $action_method ) = $R->lookup_action( 'redirect' );
  return $action_class->$action_method({ url => $return });
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Handler::Logout - Process logouts

=head1 SYNOPSIS

Most of the time you will call this like:

 /NoTmpl/Logout/

Which logs out the current user.

=head1 DESCRIPTION

None needed.

=head1 METHODS

B<handler()>

Logs the current user out.

=head1 TO DO

Nothing.

=head1 BUGS

B<Set time somewhere?>

We currently do not set any information in the user record or anywhere
else about logouts.

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
<
