package OpenInteract::Handler::Package;

# $Id: Package.pm,v 1.11 2001/02/01 05:24:32 cwinters Exp $

use strict;
use SPOPS::Secure qw( :level );
use Data::Dumper  qw( Dumper );

@OpenInteract::Handler::Package::ISA               = qw( OpenInteract::Handler::GenericDispatcher SPOPS::Secure );
$OpenInteract::Handler::Package::VERSION           = sprintf("%d.%02d", q$Revision: 1.11 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::Package::author            = 'chris@cwinters.com';
$OpenInteract::Handler::Package::default_method    = 'listing';
@OpenInteract::Handler::Package::forbidden_methods = ();
$OpenInteract::Handler::Package::select_tab        = { main => 'interact', group => 'members' };
%OpenInteract::Handler::Package::security          = ( 
 listing => SEC_LEVEL_READ,  show => SEC_LEVEL_WRITE,    
 edit => SEC_LEVEL_WRITE,    remove => SEC_LEVEL_WRITE,
);

use constant DEBUG => 1;

my $MAIN_SCRIPT = '/Package';

# List packages in the main interact directory as well as
# the packages in the website directory

sub listing {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my $params = { main_script => $MAIN_SCRIPT, error_msg => $p->{error_msg} };

  # First retrieve the packages from this app

  my %local_pkg = map { $_->id => $_ } 
                     @{ $R->package->fetch_group({ directory => $R->CONFIG->{dir}->{base} }) };
  foreach my $pkg_id ( sort keys %local_pkg ) {
    push @{ $params->{website_pkg} }, $local_pkg{ $pkg_id };
  }

  # Next, retrieve the packages from interact

  my %interact_pkg = map { $_->id => $_ } 
                     @{ $R->package->fetch_group({ directory => $R->CONFIG->{dir}->{interact} }) };
  foreach my $pkg_id ( sort keys %interact_pkg ) {
    push @{ $params->{interact_pkg} }, $interact_pkg{ $pkg_id };
  }
  return $R->template->handler( {}, $params, 
                                { db => 'package_listing', package => 'base' } );
}


# The only thing you can edit is the notes, so we don't need to go
# through contortions here

sub show {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my $params = { main_script => $MAIN_SCRIPT, error_msg => $p->{error_msg} };
  my $do_edit = ( $R->apache->param( 'edit' ) and $p->{level} >= SEC_LEVEL_WRITE );

  $params->{scope} = $R->apache->param( 'scope' ) || 'local';
  my $base_dir = ( $params->{scope} eq 'interact' ) 
                   ? $R->CONFIG->{dir}->{interact} 
                   : $R->CONFIG->{dir}->{base};
  my $name    = $R->apache->param( 'name' );
  my $version = $R->apache->param( 'version' );
  my $pkg = $p->{pkg} || 
            $R->package->fetch_by_name({ directory => $base_dir, 
                                         name => $name, 
                                         version => $version });
  unless ( $pkg ) {
    my $error_msg = "Sorry, couldn't find a package matching the criteria you specified.";
    return $class->listing( { error_msg => $error_msg } );
  }
  if ( $version and $version != $pkg->{version} ) {
    $params->{error_msg} .= "Found a working package, but it wasn't the version you requested.";
  }
  $params->{pkg} = $pkg;
  return $R->template->handler( {}, $params, { db => 'package_detail', package => 'base' } );
}

sub edit {
  my ( $class, $p ) = @_;
  my $params = {};
  my $R = OpenInteract::Request->instance;
  my $name    = $R->apache->param( 'name' );
  my $version = $R->apache->param( 'version' );
  my $scope   = $R->apache->param( 'scope' );
  my $base_dir = ( $scope eq 'interact' ) ? $R->CONFIG->{dir}->{interact} : $R->CONFIG->{dir}->{base};
  my $db_file = join( '/', $base_dir, $OpenInteract::Package::PKG_DB_FILE );
  my $pkg = $R->package->fetch_by_name({ name => $name, 
                                         version => $version,
                                         directory => $base_dir });
  if ( $@ or $pkg ) {
    my $error = $@ || "no package found using $name - $version";
    my $error_msg = "No changes made; cannot retrieve package for editing. Error: $error";
    return $class->listing( { error_msg => $error_msg } );
  }
  my @editable_fields = qw( notes );
  foreach my $field ( @editable_fields ) {
    $pkg->{ $field } = $R->apache->param( $field );
  }
  $pkg->{last_updated_on} = $pkg->now;
  $pkg->{last_updated_by} = $R->{auth}->{user}->{user_id};
  eval { $pkg->save };
  if ( $@ ) {
    $params->{error_msg} = "Cannot save package changes! Error returned: $@";
  }
  $params->{pkg} = $pkg;
  return $class->show( $params );
}

sub remove {
 my ( $class, $p ) = @_;
 return $class->listing({ error_msg => 'Sorry, removal of packages is not supported yet.' });
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Handler::Package - Allow viewing/editing of package information in base and website

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head1 TO DO

=head1 BUGS

A few things do not work in here yet. Need to take a good look at this.

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
