$spops = {
            'classified' => {
              class        => 'OpenInteract::Classified',
              isa          => [ qw/ OpenInteract::SPOPS SPOPS::Utility  SPOPS::Secure  SPOPS::DBI::MySQL  SPOPS::DBI / ],
              field        => [ qw/ classified_id posted_on posted_by title deadline 
                                    description location required_skills recommended_skills 
                                    application_info contact organization phone fax email url active expires_on / ],
              id_field     => 'classified_id',
              no_insert    => [ qw/ classified_id / ],
              skip_undef   => [ qw/ active expires_on / ],
              no_update    => [ qw/ classified_id posted_on / ],
              key_table    => 'classified',
              base_table   => 'classified',
              sql_defaults => [ qw/ active / ],
              field_alter  => {},
              alias        => [],
              has_a        => { 'OpenInteract::User' => [ 'posted_by' ] },
              links_to     => {},
              creation_security => {
                 u   => undef,
                 g   => { 3 => 'WRITE' },
                 w   => 'READ',
              },
              as_string_order => [ qw/ classified_id title classified_item posted_on posted_by expires_on / ],
              as_string_label => { classified_id => 'ID', title => 'Title', classified_item => 'Classifieds Item',
                                   posted_on => 'Posted On',  posted_by => 'Posted By',
                                   expires_on => 'Expires On' },
              track => {
                 create => 1, update => 1, remove => 1
              },
              display => { url => '/Classified/show/', class => 'OpenInteract::Handler::Classified', method => 'show' },
              linkterm => 1,
              name => sub { return $_[0]->{title} },
              object_name => 'Classified',
            },

};