# Copyright (C) 2001-2003, The Perl Foundation.
# $Id: /mirror/trunk/t/configure/testlib/init/beta.pm 22195 2007-10-18T01:51:52.269094Z jkeenan  $

=head1 NAME

t/configure/testlib/init/beta.pm - Module used in configuration tests

=cut

package init::beta;
use strict;
use warnings;

use base qw(Parrot::Configure::Step::Base);

use Parrot::Configure::Step;

sub _init {
    my $self = shift;
    my %data;
    $data{description} = q{Determining if your computer does beta};
    $data{args}        = [ qw( verbose ) ];
    $data{result}      = q{};
    return \%data;
}

sub runstep {
    my ( $self, $conf ) = @_;
    my $verbose = $conf->options->get('verbose');
    print "\nbeta is verbose\n" if $verbose;
    print "\nYou've got beta\n";
    return 1;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
