# Copyright (C) 2001-2006, The Perl Foundation.
# $Id: /mirror/trunk/config/init/headers.pm 22195 2007-10-18T01:51:52.269094Z jkeenan  $

=head1 NAME

config/init/headers.pm - Nongenerated Headers

=head1 DESCRIPTION

Uses C<ExtUtils::Manifest> to find the C header files that are
distributed with Parrot.

=cut

package init::headers;

use strict;
use warnings;


use base qw(Parrot::Configure::Step::Base);

use Parrot::Configure::Step;
use ExtUtils::Manifest qw(maniread);

sub _init {
    my $self = shift;
    my %data;
    $data{description} = q{Finding header files distributed with Parrot};
    $data{args}        = [ qw(  ) ];
    $data{result}      = q{};
    return \%data;
}

sub runstep {
    my ( $self, $conf ) = @_;

    my $inc = 'include/parrot';

    my @headers = (
        sort
            map { m{^$inc/(.*\.h)\z} }
            keys %{ maniread() }
    );

    $_ = "\$(INC_DIR)/$_" for @headers;
    my $TEMP_nongen_headers = join( "\\\n        ", @headers );

    $conf->data->set(
        inc                 => $inc,
        TEMP_nongen_headers => $TEMP_nongen_headers,
    );

    return 1;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
