# $Id: Makefile.PL 83 2008-09-20 14:51:23Z cfaerber $

BEGIN { require 5.006; }

use utf8;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
	'NAME'		=> 'Unicode::Stringprep',
	'VERSION_FROM'	=> 'lib/Unicode/Stringprep.pm', # finds $VERSION
	'PREREQ_PM'	=> {
		'Unicode::Normalize' => 0.30,
	    },
	'ABSTRACT'	=> 'Preparation of Internationalized Strings (RFC 3454)',
	'AUTHOR'	=> 'Claus Faerber <CFAERBER@cpan.org>',
	'LICENSE'	=> 'perl',

	$ExtUtils::MakeMaker::VERSION < 6.18 ? () : (
		'SIGN'		=> 1,
	    ),

	$ExtUtils::MakeMaker::VERSION < 6.45 ? () : (
  		'META_MERGE'	=> { 
			'requires'	=> { 'perl'	=> 5.006, },
			'recommends'	=> { 'perl'	=> 5.008003, },
		    },
	    ),
);

sub MY::postamble {
return <<EOF
release: release-sf release-cpan

release-cpan:
	cpan-upload \$(DISTVNAME).tar\$(SUFFIX)

release-sf:
	sf-upload -groupid 112466 -packageid 246624 -r \$(VERSION) -cf Changes -nf README -f \$(DISTVNAME).tar\$(SUFFIX)
EOF
}
