#!/usr/bin/perl
#
# AUTOGENERATED TEST SCRIPT FOR Parallel::ForkControl
# 
# Built: Fri Dec 19 17:56:13 2003
#  by /home/brad/bin/generate_tests.pl  written by Brad Lhotsky <brad@divisionbyzero.net>
#
$|++;

use strict;

use Test::More qw(no_plan);

################################################################################
#	This section is basic module testing and should be completed	       #
################################################################################

#
# make sure we can safely use the module
BEGIN: { use_ok( 'Parallel::ForkControl' ); }

#
# test object creation via new
my $obj;
if(UNIVERSAL::can('Parallel::ForkControl','new')) {
	alarm 5;
	eval {
		local $SIG{ALRM} = sub { die 'timedout' };
		$obj = new Parallel::ForkControl;
		isa_ok( $obj, 'Parallel::ForkControl' );
	};
	alarm 0;
	if($@) {
		fail ( 'new() - create an object' );
		diag( $@ );
	}
	else {
		pass ( 'new() - create an object' );
	}
}
else {
	diag("Parallel::ForkControl::new() not defined");
}
if( !defined $obj ) {
	$obj = bless {}, 'Parallel::ForkControl';
}

#
# list of all public and private methods
#
can_ok($obj, qw/_attributes _default _can _kidstarted _kidstopped kids kid_time _pid new _overLoad _tooManyKids _check run cleanup _REAPER _parentAlive _print_me _dbmsg/);

# ====> !!!! DO NOT ERASE THIS LINE !!!! <==== #

################################################################################
#	This section is for more extensive testing of the return values        #
#	and functionality of the module and should be comprehensive            #
# see: perldoc Test::More to get more information on the testing capabilities  #
################################################################################

# ================>      PLEASE CUSTOMIZE THIS SECTION       <================ #

$obj = undef();

$obj = new Parallel::ForkControl(
		Name		=> 'install testing for Parallel::ForkControl',
		WatchLoad	=> 1,
		MaxLoad		=> 3.50,
		MaxKids		=> 10,
		ProcessTimeout => 5,
		Accounting	=> 1,
		Code		=> sub { my $n = shift; print "$$ - $n\n"; sleep $n; },
		Debug		=> 0
);

isa_ok( $obj, 'Parallel::ForkControl' );

my $FORKS = 15;

while($FORKS--) {
	my $t = $FORKS % 2 ? 2 : 3;
	ok($obj->run($t), "run");
}
ok($obj->cleanup(), "cleanup");



#-----------------------------------------------------------------------------#
