# This is a test for module Image::Quantize.

use warnings;
use strict;
use Test::More;
use FindBin;
use Image::Quantize::PNG;
use Image::PNG::Libpng ':all';
use Data::Dumper;
my $iq = Image::Quantize::PNG->new ();
ok ($iq);
$iq->speed (10);
my $pngfile = "$FindBin::Bin/test.png";
my $pngin = read_png_file ($pngfile);
my $pngout = $iq->quantize ($pngin);
my $outfile = "$FindBin::Bin/test-output.png";

$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}

$pngfile = "$FindBin::Bin/mach.png";
$pngin = read_png_file ($pngfile);
$pngout = $iq->quantize ($pngin);
$outfile = "$FindBin::Bin/mach-output.png";
$pngout->write_png_file ($outfile);
ok (-f $outfile);
if (-f $outfile) {
    unlink ($outfile);
}
done_testing ();
