use strict;
use warnings;

# Load the Module::Install bundled in ./inc/
use inc::Module::Install;

my %features = (
    templating => {
        namespace       => 'Template',

        Tiny            => { name => 'Template::Tiny', min => '0.02' },
        HtmlTemplate    => { name => 'HTML::Template', min => '0.02' },

        Alloy           => { name => 'Alloy'               },
        Tenjin          => { name => 'Tenjin'              },
        Haml            => { name => 'Text::HAML'          },
        Mason           => { name => 'HTML::Mason'         },
        Mason2          => { name => 'HTML::Mason2', min => '0.02' },
        MicroTemplate   => { name => 'Text::MicroTemplate' },
        MojoTemplate    => { name => 'Mojo::Template wrapper for Dancer' },
        Semantic        => { name => 'Semantic Template wrapper for Dancer' },
        TemplateSandbox => { name => 'Template::Sandbox'   },
        Xslate          => { name => 'Text::Xslate wrapper for Dancer' },
    },

    logging => {
        namespace  => 'Logger',

        LogHandler => { name => 'Log::Handler'                               },
        Log4perl   => { name => 'Log4Perl'                                   },
        Pipe       => { name => 'Pipe-based logging engine for Dancer'       },
        PSGI       => { name => 'PSGI'                                       },
        Spinner    => { name => 'Show a spinner in the console log messages' },
        Syslog     => { name => 'Sys::Syslog'                                },
    },

    serialization => {
        namespace => 'Serializer',

        UUEncode => { name => 'UU Encoding serializer' },
    },

    session => {
        namespace => 'Session',

        Cookie    => { name => 'Encrypted cookie-based'     },
        KiokuDB   => { name => 'KiokuDB Dancer session backend',
                       min => '0.04' },
        Memcached => { name => 'Cache::Memcached'           },
        PSGI      => { name => 'Plack::Middleware::Session' },
        Storable  => { name => 'Storable file-based'        },
    },

    plugin => {
        namespace    => 'Plugin',

        'Auth::RBAC'  => { name => 'Authentication, Security and Role-Based Access Control' },
        'Auth::Twitter' => { name => 'Authenticate with Twitter' },
        Browser       => { name => 'Browser detection'           },
        Cache         => { name => 'Plugin to cache response content' },
        Database      => { name => 'Database'                    },
        DataFu        => { name => 'Generate HTML tables/forms'  },
        DBIC          => { name => 'DBIx::Class interface'       },
        DebugDump     => { name => 'dump objects to debug log'   },
        Email         => { name => 'Email::Stuff integration'    },
        Facebook      => { name => 'Plugin linking Dancer with Facebook::Graph' },
        Feed          => { name => 'Generate feed rss or atom'   },
        FlashMessage  => { name => 'Display temporary messages'  },
        FlashNote     => { name => 'Notification messages'       },
        FormattedOutput => { name => 'Provide output in a variety of formats' },
        FormValidator => { name => 'Easy input validator'        },
        # GearmanXS     => { name => 'a Dancer Gearman::XS client' }, => failing 0.110570
        Memcached     => { name => 'Cache response content'      },
        MemcachedFast => { name => 'Cache things using Cache::Memcached::Fast' },
        # MobileDevice => { name => 'Dancer app mobile-aware'     }, => failing 0.02
        Mongo         => { name => 'MongoDB'                     },
        MPD           => { name => 'Easy connection to MPD'      },
        # ORMesque    => { name => 'Light ORM'                   }, => failing 1.103180
        'Params::Normalization' => { name => 'query param normalization' },
        # ProxyPath     => { name => 'Provides user-perspective paths' },
        Redis         => { name => 'Redis database connections'  },
        REST          => { name => 'RESTful apps', min => '0.05' },
        # Scoped      => { name => 'parameter variables scoping' }, => failing 0.01
        SimpleCRUD    => { name => 'very simple CRUD', min => '0.02' },
        SiteMap       => { name => 'Site map creation'           },
        SMS           => { name => 'Easy SMS sending'            },
        SporeDefinitionControl => { name => 'Validite route from a Spore' },
        # Validation  => { name => 'Oogly Data validation'       }, => not available on CPAN?
        ValidationClass => { name => 'Centralized Input Validation' },
        WebSocket     => { name => 'Easily create WebSocket apps' },
    },

    # for now it's middlewares
    middleware => {
        namespace => 'Middleware',
        Rebase => { name => 'Plack middleware for Dancer' },
    },

    other => {
        Debug => { name => 'Plack::Middleware::Debug' },
    },
);

name     'Task-Dancer';
all_from 'lib/Task/Dancer.pm';
license  'perl';
include  'Module::AutoInstall';
requires 'Dancer' => 0;

foreach my $type ( keys %features ) {
    my $namespace = delete $features{$type}{'namespace'};

    foreach my $semi_namespace ( keys %{ $features{$type} } ) {
        my $full_namespace = $namespace                               ?
                            "Dancer::${namespace}::${semi_namespace}" :
                            "Dancer::${semi_namespace}";

        my ( $name, $default, $min ) =
            @{ $features{$type}{$semi_namespace} }{qw/ name default min /};

        $default ||= 1; # install by default unless otherwise specified
        $min     ||= 0; # no minimum version by default

        feature "$name $type support",
            -default => $default, $full_namespace => $min;
    }
}

auto_install;
WriteAll;

