package Lingua::PT::ProperNames;

#require Exporter;
use locale;
use warnings;
use strict;

=head1 NAME

Lingua::PT::ProperNames - Simple module to extract proper names from Portuguese Text

=head1 Version

Version 0.02

=cut
our $VERSION = '0.02';
our @ISA = qw(Exporter);
our @EXPORT = qw/get print printString process forString/;

our ($em, $np1, $np, $prof, $sep1, $sep2, %vazia, @stopw);

BEGIN {

  $np1 = qr{(?:(?:[A-Z][.])+|[sS]r[.]|[dD]r[.]|St[oa]?[.]|[A-Z]\w+(?:[\'\-]\w+)*)};

  #if ($e) {
  #$np= qr{$np1(?:\s+(?:d[eao]s?\s+|e\s+)?$np1)*};
  #} else {
  $np= qr{$np1(?:\s+(?:d[eao]s?\s+)?$np1)*};
  #}

  @stopw = qw{
              no com se em segundo a o os as na nos nas do das dos da tanto
              para de desde mas quando esta sem nem s apenas mesmo at uma uns um
              pela por pelo pelas pelos depois ao sobre como umas j enquanto aos
              tambm amanh ontem embora essa nesse olhe hoje no eu ele eles
              primeiro simplesmente era foi  ser so seja nosso nossa nossos nossas
              chama-se chamam-se subtitui resta diz salvo disse diz vamos entra entram
              aqui comeou l seu vinham passou quanto sou vi onde este ento temos
              num aquele tivemos
             };

  $prof = join("|", qw{
                       astrlogo astrnomo advogado actor
                       baterista
                       cantor compositor
                       dramaturgo
                       engenheiro escritor
                       filsofo flautista fsico
                       investigador
                       jogador
                       matemtico mdico ministro msico
                       pianista poeta professor
                       qumico
                       telogo
                      });
  $sep1 = join("|", qw{chamado "conhecido como"});

  $sep2 = join("|", qw{brilhante conhecido reputado popular});
  @vazia{@stopw} = (@stopw); # para ser mais facil ver se uma pal  stopword
  $em = '\b(?:[Ee]m|[nN][oa]s?)';
}

=head1 Synopsis

This module contains simple Perl-based functions to detect and extract
proper names from Portuguese text.

    use Lingua::PT::ProperNames;

    my $pndict = Lingua::PT::ProperNames->new;

=head1 ProperNames dictionary

=head2 new

Creates a new ProperNames dictionary

=cut

sub new {
  my $class = shift;
  # my $filename = shift;

  my $self = bless {}, $class;
  $self->_load_dictionary;
  return $self;
}

sub _load_dictionary {
  my $self = shift;
  my $file = shift || undef;

  if ($file) {
    open C, $file or die;
    while(<C>) {
      chomp;
      next if m!^\s*$!;
      $self->{cdic}{$_} = $_;
    }
    close C;
  } else {
    seek DATA, 0, 0;
    while(<DATA>) {
      chomp;
      next if m!^\s*$!;
      $self->{dic}{$_} = $_;
    }
  }
}



sub _exists {
  my $self = shift;
  my $word = shift;
  return exists($self->{dic}{$word}) or
    exists($self->{cdic}{$word}) or
      exists($self->{sdic}{$word})
}

=head2 is_name

This method checks if a name exists in the Names dictionary.

=cut

sub is_name {
  return _exists(@_)
}



=head1 Export the following functions

=head2 process

=cut


sub process{
  ## opt:  in=> inputfile(sdtin), out => file(stdout)
  my %opt = (sep => "", t => "normal" );

  %opt = (%opt , %{shift(@_)}) if ref($_[0]) eq "HASH";

  my $f=shift;
  my $m="\x01";
  my $f1;
  my $old;
  my $F1 ;

  local $/ = $opt{sep};  # input record separator=1 or more empty lines

  if (defined $opt{in}) {
    open $F1, "$opt{in}" or die "cant open $opt{in}\n";
  } else {
    $F1=*STDIN;
  }

  if (defined $opt{out}) {
    open F, ">$opt{out}" or die "cant create $opt{out}\n";
    $old = select(F);
  }

  die "invalid parameter to 'forPN'" unless ref($f) eq "CODE";

  if ($opt{t} eq "double") {
    $f1 = shift;
    die "invalid parameter ". ref($f1) unless ref($f1) eq "CODE";
  }

  while (<$F1>) {
    my $ctx = $_;
    if ($opt{t} eq "double") {

      s{($np)}{$m($1$m)}g;
      s{(^\s*|[-]\s+|[.!?]\s*)$m\(($np)$m\)}{
	my ($aux1,$aux2,$aux3)= ($1,$2, &{$f1}($2,$ctx));
	if   (defined($aux3)){$aux1 . $aux3}
	else                 {$aux1 . _tryright($aux2)} }ge;
      s{$m\(($np)$m\)}{   &{$f }($1,$ctx) }ge;

    } else {
      s{(\w+\s+|[\\,:()'`"]\s*)($np)}{$1 . &{$f }($2,$ctx) }ge;
    }
    print;
  }
  close $F1 if $opt{in};
  if (defined $opt{out}) {
    select $old;
    close F;
  }
}

=head2 forPNstring

=cut

sub forPNstring {
  my $f = shift;
  die "invalid parameter to 'forPNstring': function expected" unless ref($f) eq "CODE";
  my $text = shift;
  my $sep = shift || "\n";
  my $r = '';
  for (split(/$sep/,$text)) {
    my $ctx = $_;
    s/(\w+\s+|[\\,()'`i"]\s*)($np)/$1 . &{$f}($2,$ctx)/ge       ;
    $r .= "$_$sep";
  }
  return $r;
}

=head2 printPNstring

=cut

sub printPNstring{
  my $text = shift;
  my %opt = ();

  if   (ref($text) eq "HASH") { %opt = %$text        ; $text = shift; }
  elsif(ref($text) eq "ARRAY"){ @opt{@$text} = @$text; $text = shift; }

  my (%profissao, %names, %namesduv, %gnames);

  for ($text) {
    chop;
    s/\n/ /g;
    for (m/[.?!:;"]\s+($np1\s+$np)/gxs)  { $namesduv{$_}++ }
    for (m![)>(]\s*($np1\s+$np)!gxs)     { $namesduv{$_}++ }
    for (m/(?:[\w\\,]\s+)($np)/gxs)    { $names{$_}++ }
    if ($opt{em}) {
      for (/$em\s+($np)/g) { $gnames{$_}++ }
    }
    if ($opt{prof}) {
      while(/\b($prof)\s+(?:(?:$sep1)\s+)?($np)/g)
	{ $profissao{$2} = $1 }
      while(/(?:[\w\\,]\s+|[(])($np),\s*(?:(?:$sep2)\s+)?($prof)/g)
	{ $profissao{$1} = $2 }
    }
  }

  # tratamento dos nomes "duvidosos" = Nome prop no inicio duma frase
  #

  for (keys %namesduv) {
    if (/^(\w+)/ && $vazia{lc($1)}) { #exemplo "Como Jose Manuel"
      s/^\w+\s*//;                    # retira-se a 1.a palavra
      $names{$_}++
    } else { 
      $names{$_}++
    }
  }

  for (keys %names) {
    if (/^(\w+)/ && $vazia{lc($1)}) {  #exemplo "Como Jose Manuel"
      my $ant = $_;
      s/^\w+\s*//;                     # retira-se a 1.a palavra
      $names{$_} += $names{$ant};
      delete $names{$ant}
    }
  }

  if ($opt{oco}) {
    for (sort {$names{$b} <=> $names{$a}} keys %names ) {
      printf("%60s - %d\n", $_ ,$names{$_});
    }
  } else {
    if ($opt{comp}) {
      my @l = sort _compara keys %names;
      _compacta(\%names, @l)
    } else {
      for (sort _compara keys %names ) {
	printf("%60s - %d\n", $_ ,$names{$_});
      }
    }
    if ($opt{prof}) {
      print "\nProfisses\n";
      for (keys %profissao) {
	print "$_ -- $profissao{$_}"
      }
    }
    if ($opt{em}) {
      print "\nGeograficos\n";
      for (sort _compara keys %gnames ) {
	printf("%60s - %d\n", $_ ,$gnames{$_})
      }
    }
  }
}


=head2 getPN

=cut

sub getPN {
  local $/ = "";           # input record separator=1 or more empty lines

  my %opt;
  @opt{@_} = @_;
  my (%profissao, %names, %namesduv, %gnames);

  while (<>) {
    chop;
    s/\n/ /g;
    for (/[.?!:;"]\s+($np1\s+$np)/g)     { $namesduv{$_}++;}
    for (/[)>(]\s*($np1\s+$np)/g)        { $namesduv{$_}++;}
    for (/(?:[\w\\,]\s+)($np)/g)       { $names{$_}++;}
    if ($opt{em}) {
      for (/$em\s+($np)/g) { $gnames{$_}++;}}
    if ($opt{prof}) {
       while(/\b($prof)\s+(?:(?:$sep1)\s+)?($np)/g)
	 { $profissao{$2} = $1 }
       while(/(?:[\w\\,]\s+|[(])($np),\s*(?:(?:$sep2)\s+)?($prof)/g)
	 { $profissao{$1} = $2 }
     }
  }

  # tratamento dos nomes "duvidosos" = Nome prop no inicio duma frase
  #

  for (keys %namesduv) {
    if(/^(\w+)/ && $vazia{lc($1)}) {  # exemplo "Como Jose Manuel"
      s/^\w+\s*//;                    # retira-se a 1.a palavra
      $names{$_}++
    } else {
      $names{$_}++
    }
  }
  return (%names)
}


=head2 printPN

=cut

sub printPN{
  local $/ = "";           # input record separator=1 or more empty lines

  my %opt;
  @opt{@_} = @_;
  my (%profissao, %names, %namesduv, %gnames);

  while (<>) {
    chop;
    s/\n/ /g;
    for (/[.?!:;"]\s+($np1\s+$np)/g)     { $namesduv{$_}++ }
    for (/[)>(]\s*($np1\s+$np)/g)        { $namesduv{$_}++ }
    for (/(?:[\w\\,]\s+)($np)/g)       { $names{$_}++ }
    if ($opt{em}) {
      for (/$em\s+($np)/g) { $gnames{$_}++ }
    }
    if ($opt{prof}) {
       while(/\b($prof)\s+(?:(?:$sep1)\s+)?($np)/g)
	 { $profissao{$2} = $1 }
       while(/(?:[\w\\,]\s+|[(])($np),\s*(?:(?:$sep2)\s+)?($prof)/g)
	 { $profissao{$1} = $2 }
     }
  }

  # tratamento dos nomes "duvidosos" = Nome prop no inicio duma frase
  #

  for (keys %namesduv){
    if(/^(\w+)/ && $vazia{lc($1)} )   #exemplo "Como Jose Manuel"
      {s/^\w+\s*//;                  # retira-se a 1.a palavra
       $names{$_}++;}
    else
      { $names{$_}++;}
  }

  ##### No sei bem se isto serve...

  for (keys %names){
    if(/^(\w+)/ && $vazia{lc($1)} )   #exemplo "Como Jose Manuel"
      { my $ant = $_;
        s/^\w+\s*//;                  # retira-se a 1.a palavra
        $names{$_}+=$names{$ant};
        delete $names{$ant};}
  }

  if($opt{oco}){
    for (sort {$names{$b} <=> $names{$a}} keys %names )
      {printf("%6d - %s\n",$names{$_}, $_ );}
  }
  else
    {
      if($opt{comp}){my @l = sort _compara keys %names;
		     _compacta(\%names, @l); }
      else{for (sort _compara keys %names )
	     {printf("%60s - %d\n", $_ ,$names{$_});} }

      if($opt{prof}){print "\nProfisses\n";
		     for (keys %profissao){print "$_ -- $profissao{$_}";} }

      if($opt{em}){print "\nGeograficos\n";
		   for (sort _compara keys %gnames )
		     {printf("%60s - %d\n", $_ ,$gnames{$_});} }
  }
}



##
# Auxiliary stuff

sub _tryright{
  my $a = shift;
  return $a unless $a =~ /(\w+)/;
  my $m = "\x01";
  my ($w,$r) = ($1,$');
  $r =~ s{($np)}{$m($1$m)}g;
  return "$w$r";
}


sub _compacta{
  my $s;
  my $names = shift;

  my $p = shift;
  my $r = $p;
  my $q = $names->{$p};
  while ($s = shift)
    { if ($s =~ (/^(.+) $p/)) { $r = "($1) $r" ;
				$q += $names->{$s};
			      }
      else {print "$r - $q"; $r=$s; $q = $names->{$s}; }
      $p=$s;
    }
  print "$r - $q";
}

sub _compara {
  # ordena pela lista de palavras invertida
  join(" ", reverse(split(" ",$a))) cmp join(" ", reverse(split(" ",$b)));
}


=head1 Author

Jos Joo Almeida, C<< <jj@di.uminho.pt> >>

Alberto Simes, C<< <ambs@di.uminho.pt> >>

=head1 Bugs

NOTE: We know documentation for exported methods is inexistent. We are
      working on that for very soon.

Please report any bugs or feature requests to
C<bug-lingua-pt-propernames@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.  I will be notified, and then you'll automatically
be notified of progress on your bug as I make changes.

=head1 Copyright & License

Copyright 2004 Alberto Simes, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Lingua::PT::ProperNames

__DATA__
Abecassis
Abel
Abrcio
Ablio
Abissnia
Aboim
Abrao
Abraham
Abrams
Abrantes
Abreu
Abril
Abu
Accio
Aores
Acre
Adalberto
Adamastor
Adams
Ado
Adelaide
Adelina
Adelino
Adelson
Adolfo
Adnis
Adriano
Adritico
Afeganisto
Afonso
frica
Afrodite
gata
Agostinho
Agostinhos
Agosto
Agra
Agrao
guas
gueda
Aguiar
Aires
Aix-en-Provence
Aix-la-Chapelle
jax
Alandroal
Al
Alarico
Alasca
Albnia
Albano
Alba
Albergaria-a-Nova
Albergaria-a-Velha
Albertina
Albertino
Albert
Alberto
Albino
Albufeira
Albuquerque
Alccer
Alcanena
Alcntara
Alcino
Alcinos
Alcobaa
Alcochete
Alcoforado
Alcoro
Alcoutim
Aldora
lea
Aleixo
Alemanha
Alencar
Alenquer
Alentejo
Alexandra
Alexandre
Alexandria
Alfredo
Algarves
Algarve
Algs
Algodres
Alhambra
Alhandra
Alicante
Alice
Alij
Alpio
Aljezur
Aljubarrota
Aljustrel
Allen
Almada
Almanor
Almeida
Almeirim
Almodvar
Almorto
Alpes
Alpiara
Alportel
Alscia
Alvaizere
Alvalade
lvares
lvaro
Alverca
Alves
Alvim
Alvito
Alzira
Amadeu
Amadeus
Amadora
Amado
Amlia
Amncio
Amndio
Amap
Amaral
Amarante
Amares
Amaro
Am
Amato
Amazonas
Amaznia
Ambrsio
Amlia
Amricas
Amrica
Amrico
Amesterdo
Amlcar
Amorim
Anabela
Anadia
Ana
Anastcio
Anatlia
Anaximandro
Anaxmenes
Ancara
Andaluzia
Andersen
Andrade
Andr
Andrews
Andrmeda
Andy
Angeiras
ngela
Angeles
Anglica
ngelo
ngelo
Angkor
Angola
Angra
Anbal
Aniceto
Anita
Anselmo
Ansies
Ansio
Anto
Antrctida
Antas
Antero
Antilhas
Antioquia
Antoine
Antnia
Antnio
Anturpia
Antunes
Apalaches
Aparcio
Apocalipse
Apolinrio
Apolnia
Apolnio
Apolo
Aplia
Aquiles
Aquilino
Aquino
Aquisgrana
Aquitnia
Arao
Arbia
Arafat
Arago
Aranjuez
Arajo
Arcdia
Ardenas
Ardila
Arganil
Arglia
Argel
Argentina
rgon
Argvia
Aristides
Aristfanes
Aristteles
Arizona
Arkansas
Arles
Arlindo
Armamar
Armando
Armnia
Armnio
Armindo
Arnaldo
Arnold
Arnoldo
Arno
Arouca
Arquimedes
Arrabal
Arrbida
Arraiolos
Arronches
Arruda
Artur
Asceno
sia
Aspsia
Assria
Assis
Assis
Assuno
Astrix
Astrias
talo
Atenas
tila
Atlanta
Atlntico
Auckland
Augusta
Augustini
Augusto
Aurlia
Aurlio
Auschwitz
Austrlia
ustria
Aveiro
Avelar
Aveleda
Avelino
Avicena
vila
Avilez
Avinho
Avintes
Avis
Azambuja
Azeito
Azemis
Azerbaijo
Azevedo
Babilnia
Bacelar
Bach
Bacon
Baco
Badajoz
Bagdade
Bagdad
Baa
Baio
Baa
Baiona
Bairrada
Baker
Balcs
Balsemo
Baltasar
Baltazar
Bltico
Baltimore
Balzac
Baptista
Baptiste
Barahona
Brbara
Barbosa
Barcelona
Barcelos
Barnab
Barquinha
Barrabs
Barrancos
Barreiros
Barreiro
Barreto
Barroso
Bartok
Bartolomeu
Basileia
Basilicata
Basilienses
Baslio
Bassor
Basto
Bastos
Baudelaire
Baviera
Beatles
Beatriz
Beaumont
Becket
Beethoven
Beirute
Beja
Belarmino
Belchior
Belm
Belfast
Blgica
Belgrado
Belize
Belmiro
Belmonte
Beltrano
Beltro
Belzebu
Benavente
Benedito
Benelux
Benfica
Bengala
Benguela
Benilde
Benjamin
Bento
Berengrio
Bergen
Berger
Bergman
Bergson
Berkeley
Berlenga
Berlim
Berlioz
Bernardes
Bernardino
Bernard
Bernardo
Berna
Bernoulli
Bernstein
Berta
Berto
Bertrand
Bessa
Betnia
Bettencourt
Btica
Bblia
Bielorssia
Bi
Bilbau
Bill
Birmnia
Biscaia
Bismarck
Bismark
Bissau
Bizet
Boaventura
Boavista
Bocage
Bogot
Bohr
Bolena
Bolvia
Bolonha
Boltzmann
Bombaim
Bombarda
Bombarral
Bonaparte
Bona
Bonfim
Bonifcio
Bonjardim
Boole
Borba
Bordalo
Borges
Borgonha
Borguinhes
Boris
Bornu
Bsnia
Boston
Botelho
Botswana
Boulevard
Bouro
Boximanes
Boyle
Brabante
Bracara
Bradenburgo
Bragana
Braga
Brahms
Brama
Branca
Brando
Brandeburgo
Brandt
Braslia
Brasil
Brs
Bratislava
Braun
Bremen
Bretanha
Breyner
Brighton
Briolanja
Bristol
Britnia
Briteiros
British
Brito
Brno
Broadway
Brooklyn
Brown
Bruce
Bruges
Bruno
Brutus
Bruxelas
Buaco
Bucareste
Buda
Budapeste
Buenos
Bulgria
Burgenland
Burgos
Bush
Byron
Cabanelas
Cabral
Cabul
Cacm
Cacilhas
Cadaval
Cdis
Caeiro
Caetano
Caim
Caio
Cairo
Calbria
Calcednia
Calcut
Caldelas
Calheta
Calheiro
Calheiros
Califrnia
Calgula
Calisto
Calvino
Cambodja
Cambra
Cambridge
Camelo
Camilo
Cames
Campanh
Campnia
Cana
Canad
Canrias
Canaveses
Cndida
Cndido
Cannes
Cansas
Cantbria
Cantanhede
Canto
Canturia
Capadcia
Caparica
Capricrnio
Carachi
Carabas
Carcavelos
Cardan
Cardoso
Carlia
Carntia
Carla
Carl
Carlos
Carlota
Carmelo
Crmen
Carminda
Carmona
Carmo
Carnaval
Carnegie
Carolina
Carol
Crpatos
Carrazeda
Carregal
Carrol
Cartago
Cartaxo
Cartuxa
Carvalhos
Carvalhas
Casablanca
Casanova
Cascais
Casimiro
Cspio
Cassiano
Cassinga
Cassiopeia
Castela
Castilho
Castro
Catalunha
Catnia
Catarina
Catherine
Catulo
Cucaso
Cavacoti
Cvado
Caxias
Cazaquisto
Cear
Ceclia
Cedofeita
Ceilo
Celeste
Clia
Celorico
Celso
Cenculo
Cerqueira
Cervantes
Cerveira
Cesareia
Cesrio
Csar
Cu
Ceuta
Czanne
Chang
Chaplin
Charles
Charlot
Charlotte
Chaves
Checoslovquia
Chen
Cher
Chevalier
Chicago
Chile
China
Chipre
Chomsky
Chopin
Christian
Christopher
Ccero
Cidlia
Cid
Cinderela
Cinfes
Cipio
Cipriano
Cirilo
Cisjordnia
Citnia
City
Claire
Clark
Claudel
Claude
Cludia
Cludio
Clemente
Clementina
Clepatra
Clinton
Clotilde
Cluj
Cohen
Coimbra
Colegiada
College
Collins
Colmbia
Colombo
Colonato
Colorado
Columbano
Colmbia
Comba
Compostela
Conceio
Condeixa-a-Nova
Condeixa
Condestvel
Confcio
Congo
Connor
Conrado
Constana
Constncio
Constantino
Constantinopla
Copenhaga
Coprnico
Copperfield
Coro
Cordeiro
Crdoba
Crdova
Coreia
Cornlia
Correia
Crsega
Corteso
Coruche
Corunha
Corvina
Corvino
Cosme
Costa
Couceiro
Coutinho
Covilh
Cracvia
Crato
Crespo
Creta
Crimeia
Criologia
Criptfita
Cristinia
Cristiano
Cristo
Cristvo
Crocia
Cromwell
Cruzeirinho
Cruz
Cuba
Cunene
Cunhal
Cunha
Curdisto
Curicios
Cria
Custdio
Custias
Czardas
Dcia
Dcios
Dacota
Dahl
Daire
Dalila
Dalmcia
Dalton
Damasco
Damsio
Damas
Dmaso
Dame
Damio
Daniel
Dan
Dante
Danbio
Dario
Darwinti
David
Davidson
Davis
Dbora
Debrecen
Debussy
Declogo
Ddalo
Delfim
Delfos
Demtrio
Demcrito
Demnio
Descartes
Desidrio
Detroit
Deus
Dezembro
Diabo
Diamantina
Diamantino
Diana
Dispora
Didier
Diego
Dili
Dinamarca
Dinis
Diocleciano
Diodoro
Diogo
Dionsio
Dirac
Dirceu
Direco-Geral
Diu
Dolores
Domingos
Domingues
Donato
Donetsk
Don
Doris
Doroteia
Dortmund
Dostoievski
Douglas
Douro
Drake
Dresden
Duarte
Dublin
Duke
Dulce
Dumont
Dunquerque
Duro
Dsseldorf
Dylan
Eanes
Eastwood
Ebro
Ea
Edgar
Edimburgo
dipo
Edite
Edmond
Edmund
Edmundo
Eduarda
Eduardo
Edward
Efsio
feso
Egas
Egeu
Egdio
Egipto
Einstein
Eisenberg
Eisenhower
Ekaterinburgo
Eldio
Elba
Electra
Elia
Elias
Elisa
Elsio
Elsios
Eli
Elsa
Elvas
Elvira
Emanuel
Emdio
Emile
Emiliano
Emlia
Emlio
Eneias
Engels
Eng
Engrcia
Entre-os-Rios
Epicuro
Erasmo
Eratstenes
Ericeira
Erich
Ermelinda
Ermesinde
Ermnio
Ernesto
Ernst
Escandinvia
Escobar
Esccia
Escorial
Escritura
Esfinge
Esgalhado
Eslovquia
Eslovnia
Esmeralda
Esmirna
Espanha
Esparta
Espinozati
Esprito
Esposende
squilo
Essnios
Estalinegrado
Estaline
Estarreja
Estefnia
Estela
Estvo
Esteves
Estio
Estria
Estocolmo
Estnia
Estoril
Estrasburgo
Estrela
Estremadura
Estremoz
Estugarda
Etelvina
Etipia
Eucaristia
Euclides
Eufmia
Eufrates
Eugnia
Eugnio
Eullia
Euler
Eunice
Eurico
Eurpides
Eurosia
Europa
Eusbio
Evangelho
Eva
Evans
Evaristo
Evereste
vora
Ezequiel
Fbio
Fafe
Fahrenheit
Fagundes
Faial
Falco
Falkland
Famagusta
Famalico
Fanny
Faria
Faro
Ftima
Faustino
Fausto
Feij
Feio
Feldspato
Felgueiras
Feliciano
Feldeos
Felisberto
Felismina
Flix
Fellini
Ferguson
Fermat
Fernanda
Fernandes
Fernandez
Fernando
Ferno
Ferrari
Ferraz
Ferreira
Fevereiro
Feynman
Fialho
Fibonacci
Figueiredo
Figueir
Filadlfia
Filgueiras
Filinto
Filipa
Filipe
Filipes
Filipinas
Filipos
Filomena
Finlndia
Fiorentina
Firmino
Fischer
Fitzgerald
Flandres
Flaviano
Flvio
Fletcher
Florena
Florncio
Flrido
Florinda
Fonseca
Fontainhas
Ford
Fortunato
Foz
Fraga
Frana
Francelina
Francs
Francforte
Francisca
Francisco
Francis
Franoise
Franois
Francos
Frankenstein
Frankfurt
Franklin
Frank
Franz
Frederico
Fred
Freire
Freitas
Freixo
Freud
Friburgo
Frsia
Fritz
Friuli
Fulton
Funchal
Furna
Gabo
Gabriela
Gabriel
Gaia
Gaio
Galcia
Glias
Glia
Galileia
Galileu
Galiza
Gal
Gl
Galvo
Gmbia
Ganges
Garcia
Garrett
Gaspar
Gasset
Gasto
Gates
Gauguin
Gaulle
Gaza
Gedeo
Geiger
Genebra
Gnesis
Gnova
George
Gergia
Georgina
Geraldes
Geraldo
Gerardo
Gers
Germnia
Gertrudes
Gervsio
Gestapo
Getlio
Gibraltar
Gilberto
Gilda
Gil
Giovanni
Giro
Gisela
Glasgow
Glen
Glria
Goa
Godard
Godinho
Goethe
Gogh
Gois
Gis
Goleg
Gomes
Gomez
Gonalo
Gonalves
Gondomar
Gngora
Gonzaga
Gonzlez
Gordon
Grgias
Gorki
Gotland
Gouveia
Gouveias
Gouveia
Goya
Gr-Bretanha
Graa
Graciano
Gracinda
Graciosa
Grndola
Gro-Par
Graz
Grcia
Greenwich
Gregoriano
Gregrio
Grenoble
Grieg
Gronelndia
Grozny
Guadalajara
Guadalquivir
Guadalupe
Guadiana
Gualtar
Guanabara
Guarda
Guatemala
Guedes
Guelfos
Guevara
Guianas
Guiana
Guida
Guilherme
Guilhermina
Guimares
Guin-Bissau
Guin
Guiomar
Gulbenkian
Guliver
Gusmo
Gusmo
Gustavo
Gutemberg
Gutenberg
Guterres
Habsburgos
Haia
Haiti
Hall
Halle
Hamburgo
Hamilton
Hamlet
Hammerfest
Hampshire
Handel
Hanver
Hansa
Hansetica
Harold
Harvard
Havana
Hebron
Hcuba
Hegel
Heidegger
Heisenberg
Heitor
Hlder
Helena
Helen
Helga
Heliodoro
Helmut
Helsnquia
Henri
Henrique
Henriques
Henriqueta
Herclito
Herbert
Herculano
Hrcules
Herman
Hermano
Hermenegildo
Hermes
Hermnio
Hernni
Herodes
Herdoto
Herzegovina
Hessen
Hess
Hilrio
Hilbert
Hildebrando
Hill
Himalaias
Himalaia
Hipcrates
Hiplito
Hiroshima
Hispnia
Hispano
Hitchcock
Hitleri
Hoare
Hobbes
Holanda
Hollywood
Holy
Homrico
Homero
Honduras
Hong-Kong
Hong
Honorato
Honrio
Hopkins
Horcia
Horcio
Horcios
Horn
Hortnsia
Hortnsio
Houdini
Howard
Huambo
Hubble
Hudson
Hugo
Humberto
Humphrey
Hungria
Hussein
caro
Idanha-a-Nova
Idanha-a-Velha
Imene
Igreja
Ilda
Ildefonso
lhavo
Ilada
Ildio
Illinois
Incio
ndias
ndico
Indochina
Indonsia
Ins
Inglaterra
Ingmar
Innsbruck
Inocncio
Inverno
Iorque
Iowa
Ipanema
Iro
Iraque
Irene
Irlanda
Irving
Isaac
Isabel
Isaas
Isaura
Isidoro
Isidro
Islndia
Islo
Ismaelitas
Ismael
Isolda
Israel
Istambul
stmicos
Itlia
Itamar
Ivan
Ivone
Ivo
Jacar
Jacarta
Jacinta
Jacinto
Jack
Jackson
Jacobi
Jacobitas
Jacob
Jacques
Jaime
Jamaica
James
Janeiro
Jane
Janet
Jansenistas
Janus
Jamurio
Japo
Jaques
Jargal
Jarreteira
Jasmim
Jaspers
Java
Jean
Jefferson
Jenny
Jeov
Jeremias
Jeric
Jernimo
Jernimos
Jersey
Jerusalm
Jesus
Joana
Joanesburgo
Joanina
Joan
Joo
Joaquim
Joaquina
John
Jonas
Jordnia
Jordan
Jordo
Jorge
Josefa
Josefina
Josef
Jos
Joseph
Josu
Joyce
Juan
Judas
Jud
Judeia
Judite
Judith
Jugoslviax
Jules
Julho
Juliana
Julian
Juliano
Jlia
Julio
Julie
Julieta
Jlio
Julius
Jung
Junho
Juno
Junqueira
Junqueiro
Jpiter
Jurssico
Justiniano
Justino
Kafka
Kahn
Kali
Kant
Karl
Kazan
Kazan
Keaton
Keil
Keller
Kelvin
Kennedy
Kensington
Kentucky
Kepler
Keynes
Khan
Kiev
King
Kinshasa
Kleene
Klein
Kong
Korsakov
Kosovo
Kremlin
Kuwait
Lacerda
Lacroix
Ladislau
Lagrange
Lajes
Lamarcki
Lambert
Lamego
Lanhoso
Laos
Laplace
Lapnia
Las
Latro
Laura
Laurentino
Laurinda
Lausana
Lautrec
Lavoisier
Lawrence
Lzaro
Lzio
Leal
Leandro
Lea
Leibnitz
Leibniz
Leida
Leipzig
Leiria
Leixes
Lencastre
Leninegrado
Lenineit
Leonard
Leonardo
Leonel
Lenidas
Leonor
Leopoldina
Leopoldo
Lrida
Letnia
Levtico
Lewis
Lbano
Libria
Lbia
Licnio
Ldia
Lige
Lili
Lima
Limpopo
Lincoln
Lino
Lisboa
Litunia
Liverpool
Ljubljana
Lobato
Lobo
Loiola
Lombardia
Lombardi
Londres
Lopes
Lopez
Lopo
Lordelo
Lord
Lorena
Los
Louis
Loul
Loureno
Lourinh
Lourosa
Lousada
Lous
Louvre
Luanda
Lubango
Lucas
Lucena
Luciano
Lcia
Lcifer
Luclia
Luclio
Lucinda
Lcio
Luc
Lucrcia
Lucrcio
Ludovico
Ludwig
Lugo
Luigi
Lusa
Luisiana
Lus
Lumen
Lumiar
Lumire
Lurdes
Lusadas
Lusitnia
Lutero
Luther
Luxemburgo
Luzia
Luz
Lvov
Maastricht
Macrio
Macau
Macednia
Macedo
Machado
Machico
Macintosh
Macintosh
Madagscar
Madalena
Madeleine
Madonna
Madre
Madrid
Madureira
Mafalda
Mafra
Magalhes
Magda
Magdeburgo
Magrebe
Maias
Maia
Maio
Maiorca
Malaca
Mlaga
Malaia
Malanje
Malsia
Malawi
Malheiro
Mali
Malta
Malva
Mamede
Manchester
Manchria
Mandela
Mangualde
Manica
Manila
Manteigas
Mntua
Manuela
Manuel
Maom
Mao
Maputo
Maquiavel
Maranho
Maro
Marcelino
Marcel
Marceloti
Mrcio
Maro
Marconi
Marcos
Marcus
Margo
Margarida
Mariana
Maria
Marias
Marie
Marlia
Marilyn
Marim
Mrio
Mariz
Mark
Marques
Marrocos
Marselha
Marselhesa
Marshall
Marte
Martim
Martinez
Martnez
Martinho
Martinica
Martin
Martins
Marvo
Marxi
Mary
Mascarenhas
Massachusetts
Massarelos
Mateus
Matias
Matilde
Matosinhos
Matos
Matusalm
Maurcio
Mauro
Mavilde
Maximiano
Maximiliano
Max
Mazago
Mealhada
Meca
Mda
Medeiros
Medina
Mediterrneo
Meije
Meireles
Melansios
Melchior
Melgao
Melinde
Melo
Memphis
Mendes
Mendez
Mendona
Mendo
Menelau
Meneses
Menezes
Mercedes
Mrida
Meriterrneo
Mrtola
Mesopotmia
Mesquita
Messalina
Messias
Messina
Metelo
Metz
Mxico
Mxico
Miami
Michaelis
Michael
Michigan
Midas
Miguel
Milo
Mileto
Mileto
Mille
Miller
Milner
Milton
Mimi
Mindelo
Minerva
Ming
Minho
Minneli
Minnesota
Minotauro
Minsk
Miragaia
Miranda
Mirandela
Mira
Miskolc
Mistral
Mitilene
Mitra
Moambique
Momedes
Mogadouro
Mohmede
Moimenta
Moiss
Moldvia
Molire
Mnaco
Monchique
Moncorvo
Mondego
Mondim
Monforte
Monfortinho
Mongis
Monglia
Mnica
Moniz
Monroe
Monsanto
Monsaraz
Montalegre
Montalvo
Montebelo
Montecorvo
Monteiro
Montejunto
Montemor
Montemor-o-Novo
Montemor-o-Velho
Montenegro
Montenegro
Monterverdi
Montesquieu
Monteverdi
Montevideu
Montgomery
Montpellier
Montreal
Monza
Moore
Morais
Morvia
Moreira
Morgado
Morgan
Morin
Morse
Mortgua
Moscovo
Ms
Mota
Moura
Mouro
Moutinho
Mozart
Muller
Munique
Mura
Mrcia
Murdock
Murphy
Murtosa
Mussolini
Nadine
Nagasaki
Nagasqui
Nanci
Nancy
Nanquim
Nantes
Napoleo
Npoles
Narva
Nashville
Natlia
Navarra
Nazar
Nazar
Necas
Neil
Neiva
Nellie
Nelson
Nemsio
Nemo
Nepal
Neptuno
Nri
Nero
Nestor
Neva
Nevogilde
Newcastle
Newman
Nicargua
Nice
Nick
Nicolas
Nicolau
Nicsia
Nietzsche
Nigria
Nilo
Nilsson
Nisa
Nobel
No
Nogueira
Normandia
Normandos
Noronha
Norton
Noruega
Notre
Ntre
Nottingham
Novais
Novembro
Novgorod
Novossibirsk
Nunes
Nuno
Nuremberga
Oakland
Oblix
bidos
Oceania
Ocenia
Octaviano
Octvio
Odemira
Odense
der
Oder
Odete
Odisseia
Odivelas
Odorico
Oeiras
Oflia
Ohio
Oklahoma
Olga
Olho
Oligocnico
Olmpia
Olimpo
Olinda
Oliva
Olivares
Oliveira
Olivena
Olivrio
Oliver
Omar
Om
Onofre
Ontrio
Orestes
Orfeu
Orlando
Orlees
Ormuz
Orofernes
Orontes
Ortega
Ortigo
Osaca
Osaka
Osborn
scar
Oslo
Osrio
Ostende
Ostrogodos
Osvaldo
Otvio
Otelo
Othello
Otlia
Ourm
Ourense
Ourique
Outono
Outubro
Ovar
Ovdio
Ovdio
Oviedo
Owen
Oxford
Pacheco
Pacfico
Paos
Padre-Nosso
Pdua
Pai-Nosso
Paio
Paiva
Paleoltico
Palermo
Palestina
Palmeira
Palmela
Palmer
Palmira
Palo
Pampilhosa
Panam
Pandora
Pantagruel
Papas
Paquisto
Paraguai
Paraba
Paraso
Paramcidas
Paramecdeos
Paran
Paran
Paranhos
Par
Parente
Prias
Paris
Parkinson
Park
Parma
Parnasianismo
Prtenon
Pascal
Pscoa
Pascoal
Pascoal
Pascoela
Pas-de-Calais
Pasolini
Passau
Passos
Pasteur
Patagnia
Pato
Patrcio
Patrick
Paula
Pauli
Paulino
Paulina
Paulista
Paul
Pauloh
Pavlov
Peano
Pedrogo
Pedro
Pedrosa
Pedroso
Pgaso
Peixoto
Peles-Vermelhas
Pelourinho
Penacova
Penafiel
Penaguio
Penalva
Penamacr
Penedono
Penela
Peng
Peniche
Pensilvnia
Pentecostes
Pepino
Pequim
Pera
Pereira
Peres
Perez
Prez
Pernambuco
Pro
Perptua
Perseu
Prsia
Pestana
Petersburgo
Petrarcai
Petrozavodsk
Philippe
Phil
Phoenix
Piau
Piarra
Picasso
Piemonte
Piemonte
Pierre
Pilar
Pilatos
Pimenta
Pimentel
Pinacoteca
Pina
Pndaro
Ping
Pinheiro
Pinhel
Pinto
Pio
Pirenus
Pires
Pireu
Pirro
Pitgoras
Plcido
Planck
Plato
Plauto
Plnio
Plistocnico
Pneumtica
Poiares
Poincar
Policarpo
Polinsia
Polnia
Polo
Pombeiro
Pomernia
Pompeu
Pontevedra
Pontfice
Popper
Portalegre
Portela
Portel
Portimo
Porto
Portugal
Potter
Pvoa
Prado
Praga
Preciosa
Primavera
Prince
Proena-a-Nova
Proena
Prokofiev
Prometeu
Protgoras
Proust
Provena
Prudncio
Prssia
Psico
Pskov
Ptolomeu
Pblia
Pblio
Puglia
Pulitzer
Quanza
Quaternrio
Quebeque
Queirs
Queiroz
Quelnios
Queluz
Qunia
Quental
Quentin
Quibir
Quitria
Quixoteit
Rabago
Rachel
Racine
Radagsio
Rafael
Raimundo
Ramado
Ramalde
Ramalho
Ramires
Ramirez
Ramiro
Ramon
Ramn
Ramss
Rangel
Raposo
Raquel
Ratisbona
Raul
Ravel
Real
Rebeca
Rebelo
Rebordelo
Regina
Rgio
Rego
Reguengos
Reinaldo
Rembrandt
Remo
Rennia
Renato
Renoir
Reno
Resende
Ressurreio
Reynolds
Ribatejo
Ribeiro
Ricardo
Richard
Richardson
Riemann
Riga
Rimini
Rimski
Rioja
Rita
Rivera
Riviera
Robert
Roberto
Robespierre
Robin
Robinson
Rockefeller
Rockford
Rdano
Rdo
Rodsia
Rodolfo
Rodrigo
Rodrigues
Rodriguez
Rodrguez
Rogrio
Roldo
Romo
Roma
Romnia
Romero
Romeu
Rommel
Rmulo
Rondnia
Roosevelt
Roraima
Roslia
Rosalina
Rosa
Rosrio
Rosenberg
Rose
Rosita
Rossilho
Rossini
Rostock
Roterdo
Rousseau
Royal
Roy
Ruanda
Rubens
Rudolfo
Rufino
Rui
Russell
Russel
Rssia
Rute
Rutherford
Ruth
Saar
Sab
Sabrosa
Sado
Sadova
Saint
Salamanca
Salazarit
Saldanha
Salemas
Sally
Salmo
Salomo
Salom
Salsete
Salvador
Salvaterra
Salvatore
Salzburgo
Samaria
Sameiro
Sam
Samora
Sampaiot
Samuel
Samuelson
San
Sanches
Sanchez
Sancho
Sandinoti
Sandra
S
Sanso
Santana
Santander
Santarm
Santiago
So
Saragoa
Sarah
Saraiva
Sarajevo
Saramago
Sara
Sardenha
Sardoal
Sargo
Sarre
Sartre
Sat
Satans
Satan
Sto
Satis
Satureja
Saturno
Saudita
Savia
Saxnia-Anhalt
Saxnia
Scala
Scarlatti
Schelling
Schengen
Schiller
Schlwesig-Holstein
Schopenhauer
Schubert
Schumann
Schwarz
Scott
Seabra
Seattle
Sebastio
Segismundo
Segvia
Seguin
Seia
Selznick
Semedo
Sena
Sneca
Senegal
Sequeira
Serafim
Serafins
Srbia
Srgio
Sergipe
Sernancelhe
Serpa
Serpula
Sesimbra
S
Setembro
Setbal
Seul
Severino
Sever
Sevilha
Shakespeare
Shangai
Shapiro
Shaw
Sio
Sibria
Sicliap
Sicrano
SIDA
Sidney
Sidnio
Sdon
Siegfried
Silsia
Silva
Silveira
Silvrio
Silves
Silvestre
Slvia
Slvio
Simo
Simeo
Simes
Simone
Simon
Simpson
Sinai
Sindrio
Sines
Singapura
Sinopsis
Sinquio
Sintra
Siracusa
Siracusanas
Sir
Sria
Smith
Soares
Sobral
Society
Scrates
Soeiro
Sofia
Sfocles
Soleimo
Solimo
Solimes
Solino
Somlia
Snia
Sorbona
Sortelha
Sr
Sotomaior
Soure
Sousa
Sousel
Soutelo
Souto
Spencer
Spenser
Sporting
Stanley
Stefano
Stephens
Stern
Stevens
Stewart
Stratford
Strauss
Stravinsky
Stuart
Surez
Sudo
Sudetas
Sucia
Sueste
Suez
Sua
Sullivan
Suriname
Susana
Susan
Suto
Sutra
Szabo
Taboritas
Tabuao
Tabula
Tadeu
Tailndia
Taira
Taishi
Taiwan
Tales
Tallinn
Tamo
Tmega
Tamisa
Tancos
Tancredo
Tnger
Tanner
Tao
Tarouca
Tarqunio
Trrega
Tarso
Tasmnia
Tauride
Tauris
Tauro
Tauros
Taurus
Tavares
Taveira
Tavira
Tvora
Taylorit
Tchaikovsky
Tuzzu
Tebaldo
Tebas
Teero
Teixeira
Tejo
Telavive
Telesio
Teles
Telmo
Tenessi
Tenreiro
Teodora
Teodoreto
Teodorico
Teodoro
Teodsio
Tefilo
Teofrasto
Teotnio
Terncio
Teresa
Tertuliano
Tesauro
Teseu
Tete
Texas
Thomas
Thompson
Thomson
Thor
Thorp
Tiago
Tibes
Tibrio
Tibete
Tibre
Ticiano
Tim
Timor-Leste
Timor
Timteo
Timothy
Tirol
Tirso
Titnia
Titanic
Tito
Toarciano
Tobias
Tocantins
Toledo
Tolstoi
Toms
Tom
Tondela
Tnia
Toni
Tony
Tquio
Torcato
Tordesilhas
Torga
Toronto
Torres
Toscana
Toulouse
Tracy
Trancoso
Transcaucsia
Transilvnia
Transjordnia
Transval
Trs-os-Montes
Trento
Trevis
Trigueiros
Trindade
Trinit
Tripoli
Tristo
Trofa
Tria
Trondheim
Trotski
Ts
Tucdides
Tucultininurta
Tudor
Tui
Tunes
Tunsia
Turcomenisto
Turim
Turngia
Trios
Turner
Turquesto
Turquia
Tutancamon
Ucrnia
Uganda
Uge
Ulisses
Ulster
Umbria
UNESCO
Universo
Urais
rano
Urbin
Uruguai
Uzbequisto
Valdemar
Valdevez
Valena
Valena
Valncia
Vale
Valentim
Valentino
Valhadolid
Valongo
Valnia
Valpaos
Van
Varsvia
Varzim
Vasconcelos
Vasco
Vasques
Vsquez
Vassoural
Vaticano
Vaz
Vedras
Veiga
Velado
Velsquez
Veloso
Venncio
Venceslau
Veneto
Veneza
Venezianos
Venezuela
Vnus
Venusino
Vera
Vero
Verdelete
Verdi
Vergara
Verssimo
Verona
Verons
Versalhes
Vesta
Vesvio
Via-Lctea
Viana
Vicente
Vichy
Viosa
Victoria
Victor
Vidigueira
Viegas
Vieira
Viena
Vietname
Vigo
Vilafranca
Vilaria
Vilarinho
Vilar
Vilela
Vilhena
Vilnius
Vimioso
Vinci
Vingt
Vinhais
Virglio
Virgnia
Virgo
Viriato
Visconti
Viseu
Vstula
Vito
Vitria
Vitorina
Vitorino
Vtor
Vivaldi
Vizela
Vladimir
Vladivostok
Volga
Voltaire
Volta
Von
Vorarlberg
Vouga
Vouzela
Vulcano
Vulgata
Wagneri
Walter
Washington
Waterloo
Watson
WC
Weber
Weimar
Welles
Westminster
White
Wilde
William
Williams
Wilson
Windsor
Winston
Wolf
Xanana
Xangai
Xavier
Xenofonte
Xerxes
Xiitas
Ximenes
Xira
Xiva
Yale
Yang
Yao
Yoga
Yorkshire
York
Zacarias
Zagreb
Zaire
Zambeze
Zambzia
Zmbia
Zamora
Zanzibar
Zapatait
Zeca
Zeferino
Zelndia
Zlia
Z
Zeus
Zzere
Zimbabwe
Zodaco
Zola
Zulmira
Zurique
