package Algorithm::Easing::Quartinion;

use Moo;

use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return $c * ($t /= $d) * $t * $t * $t + $b;
}

sub ease_out  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return -$c * (($t = $t / $d - 1) * $t * $t * $t - 1) + $b;
}

sub ease_both  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if (($t /= $d / 2) < 1) {
        return $c / 2 * $t * $t * $t * $t + $b;
    }

    return -$c / 2 * (($t -= 2) * $t * $t * $t - 2) + $b;
}

1;

__END__
