package Algorithm::Easing::Exponential;

use Moo;

use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return ($t==0) ? $b : $c * $self->pow(2, 10 * ($t / $d - 1)) + $b;
}

sub ease_out {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return ($t == $d) ? $b + $c : $c * (-$self->pow(2, -10 * $t / $d) + 1) + $b;
}

sub ease_both {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if ($t == 0) {
        return $b;
    }

    if ($t == $d) {
        return $b + $c;
    }

    if (($t /= $d / 2) < 1) {
        return $c / 2 * $self->pow(2, 10 * ($t - 1)) + $b;
    }

    return $c / 2 * (-$self->pow(2, -10 * --$t) + 2) + $b;
}

1;

__END__
