package Nephia::Setup::View::TT;
use strict;
use warnings;
use parent qw( Nephia::Setup::Base );
use File::Spec;

sub index_template_file {
    my $self = shift;
    my $body = $self->templates->{index_template_file};
    my $file = File::Spec->catfile($self->approot, qw/view index.tt/);
    $self->spew($file, $body);
}

1;

__DATA__

app_class_file
---
package $appname;
use strict;
use warnings;
use Nephia;

our $VERSION = 0.02;

path '/' => sub {
    my $req = shift;
    return {
        template => 'index.tt',
        title => '$appname',
        envname  => config->{envname},
        apppath  => 'lib/' . __PACKAGE__ .'.pm',
    };
};

1;

:::head1 NAME

$appname - Web Application

:::head1 SYNOPSIS

  $ plackup

:::head1 DESCRIPTION

$appname is web application based Nephia.

:::head1 AUTHOR

clever guy

:::head1 SEE ALSO

Nephia

Nephia::View::TT

:::head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

:::cut
===

index_template_file
---
<html>
<head>
  <link rel="stylesheet" href="/static/style.css" />
  <link rel="shortcut icon" href="/static/favicon.ico" />
  <title>[% title %] - powerd by Nephia</title>
</head>
<body>
  <div class="title">
    <span class="title-label">[% title %]</span>
    <span class="envname">[% envname %] with View::TT</span>
  </div>

  <div class="content">
    <h2>Hello, Nephia world!</h2>
    <p>Nephia is a mini web-application framework.</p>
    <pre>
    ### [% apppath %]
    use Nephia;

    # <a href="/data">JSON responce sample</a>
    path '/data' => sub {
        my $req = shift;

        return { # responce-value as JSON unless exists {template}
            #template => 'index.tt',
            title    => config->{appname},
            envname  => config->{envname},
        };
    };
    </pre>
    <h2>See also</h2>
    <ul>
      <li><a href="https://metacpan.org/module/Nephia">Read the documentation</a></li>
    </ul>
  </div>

  <address class="generated-by">Generated by Nephia</address>
</body>
</html>

===

common_conf
---
+{
    appname => $appname,
    view => {
        class => 'TT',
    },
};
===
