package WWW::Streamripper::WebUI;

use strict;


require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(install);


use IO::All;
use Archive::Tar;

sub tarball { '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' }

sub install {
    (my $cont = tarball) =~ s/(..)/chr hex($1)/eg;
    io("./webui.tar.gz")->print($cont);
    Archive::Tar->extract_archive("./webui.tar.gz");
    unlink "./webui.tar.gz";
    chmod 0777, qw(config mp3 mp3/incomplete run);
    chmod 0755, qw(bin/get_streams.pl);
    print "WWW::Streamripper::WebUI is Installed.\n";
}




1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

WWW::Streamripper::WebUI - WWW interface for streamripper

=head1 INSTALLATION

 mkdir ~/htdocs/streamripper
 cd ~/htdocs/streamripper
 perl -MWWW::Streamripper::WebUI -e 'install'


=head1 SEE ALSO

L<http://streamripper.sourceforge.net/>. Please have it installed first.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by Yung-chung Lin (a.k.a. xern) <xern@cpan.org> This package is free software; you can redistribute it and/or modify it under the same terms as Perl itself

=cut
