# DESCRIPTION

# SYNOPSIS

    use WebSerivce

# ATTRIBUTES

## api\_key

The KvK API key. You can request one at [https://developers.kvk.nl/](https://developers.kvk.nl/).

## client

An [OpenAPI::Client](https://metacpan.org/pod/OpenAPI::Client) object. Build for you.

# METHODS

## api\_call

Directly do an API call towards the KvK API. Returns the JSON datastructure as an `HashRef`.

## profile

Retreive detailed information of one company. Dies when the company
cannot be found. Make sure to call `search` first in case you don't
want to die.

## search

Search the KVK, only retrieves the first 10 entries.

    my $results = $self->search(kvkNumber => 12345678, ...);
    foreach (@$results) {
        ...;
    }

## search\_all

Seach the KVK, retreives ALL entries. Potentially a very expensive call
(money wise). Don't lookup the Albert Heijn KvK number, do more specific
searches

    my $results = $self->search_all(kvkNumber => 12345678, ...);
    foreach (@$results) {
        ...;
    }

## search\_max

Seach the KVK, retreives a maximum of X results up the the nearest 10, eg 15 as a max returns 20 items.

    my $results = $self->search_max(15, kvkNumber => 12345678, ...);
    foreach (@$results) {
        ...;
    }
