use v6;
# generated by: ../../etc/make-modules.p6 --role-name=ISO_32000::Text_annotation_additional ../../resources/ISO_32000/Text_annotation_additional_entries.json

#| PDF 32000-1:2008 Table 172 – Additional entries specific to a text annotation
role ISO_32000::Text_annotation_additional {
    method Subtype {...};
    method Open {...};
    method Name {...};
    method State {...};
    method StateModel {...};
}

=begin pod

=head1 Methods (Entries)

=head2 Subtype [name]
- (Required) The type of annotation that this dictionary describes; is Text for a text annotation.

=head2 Open [boolean]
- (Optional) A flag specifying whether the annotation shall initially be displayed open. Default value: false (closed).

=head2 Name [name]
- (Optional) The name of an icon that is used in displaying the annotation. Conforming readers shall provide predefined icon appearances for at least the following standard names:
Comment, Key, Note, Help, NewParagraph, Paragraph, Insert
Additional names may be supported as well. Default value: Note.
The annotation dictionary’s AP entry, if present, shall take precedence over the Name entry; see
Table 168
and
12.5.5, “Appearance Streams.”


=head2 State [text string]
- (Optional; PDF 1.5) The state to which the original annotation is set; see
12.5.6.3, “Annotation States.”
Default: “Unmarked” if StateModel is “Marked”; “None” if StateModel is “Review”.

=head2 StateModel [text string]
- (Required if State is present, otherwise optional; PDF 1.5) The state model corresponding to State; see
12.5.6.3, “Annotation States.”


=end pod
