#!/usr/bin/perl

=head1 NAME

  create_controller.pl 

=head2 SYNOPSYS

This is a template use to generate a project specific helper script. Once generated the usage is as follows:

    cd $PROJECT_ROOT_DIRECTORY
    
    ~/tmp/MyApp1$ perl script/create_controller.pl  --name="Conrtoller2"    
    will try to create lib/MyApp1/C
    Created lib/MyApp1/C/Conrtoller2.pm
    will try to create template directory templates/MyApp1/C/Conrtoller2
    Created templates/MyApp1/C/Conrtoller2
    Created templates/MyApp1/C/Conrtoller2/index.tmpl


=cut


=head2 DESCRIPTION


This will produce a subclass of your main application module, create a default runmode for it, and generate a default TT template for the default runmode.  Restart server.pl and you can run that controller at:

   http://localhost:8060/cgi-bin/index.cgi/controller2

The result will be a page with the title "controller2" and an HTML H2 element with the text "Hello world!".

Also generate an index.tmpl for the new controller and puts it in the directory tree
rooted in the 'templates' directory of the projects root directory. The directory structure of the 'templates' directory should mirror that of the path under 'lib' for the associated controller.

=cut 

=head3 


This script was generated by <L>attainium_starter.pl from <L>Module::Starter::Plugin::Attanium.

=cut
use strict; 
use warnings;

use FindBin qw/$Bin/;
use ExtUtils::Command qw( mkpath );
use Module::Starter::Plugin::Attanium;
use File::Basename;
use Getopt::Long;

#
# Constants populated by template processor.
# '-'is  namespace separator for main_module
#
use constant  DISTRO => "<tmpl_var main_module>";       

#
# user supplies these:
#
my $new_module;
my $result = GetOptions(
    "name=s" => \$new_module,
			);
sub usage(){
    print "usage:\n";
    print "  cd MyApp\n";
    print "  perl script/create_controller.pl --name=MyMod\n";
}

if (!$result){usage(); die ;}
if (!$new_module){usage(); die ;}

create_submodule($new_module);
create_tt ($new_module);

exit(0);


# -------------------------------------------------------- #


=head3 create_file($path, $contents)

Utility to create a file given it's path and desired contents.

=cut 

sub create_file{
    my $fname = shift;
    my $content = shift;
 
    die "File $fname alread exists\n" 
	if (-f $fname);
    open (my $fh, ">", $fname) 
	or die "Cannot create $fname: $!\n";
    print $fh $content 
	or die "Cannot write file: $!\n";
    close $fh 
	or die "Cannot close file $fname: $!\n";
    print "Created $fname\n";
}


=head3 get_template_path

Given a template name, finds it's full path in the 
Module::Starter::Plugin::Attanium template distribution.

=cut 

sub get_template_path{
    my $tname = shift;
	
    my $tdir  = 
	File::Spec->catdir(  
	    dirname($INC{'Module/Starter/Plugin/Attanium.pm'}), 
	    'Attanium','templates' );
    return File::Spec->catfile($tdir, $tname);
}


=head3 create_submodule($module_name)

Given a partial module name, generates a module by prepending
the applications main module name + "::C::" to $module_name to create
the fully qualified package for the new controller module.

=cut
 
sub create_submodule {
	my $submodule = shift;
	
	my @distroparts = split /-/mx, DISTRO;

	my @submodparts = split/::/, $submodule;

        my @submoddirs = @submodparts > 1? $submodparts[0..-2]: ();
        my $submodname = $submodparts[0];

       
	my @dirparts =
	  ( 'lib', @distroparts, "C" , @submoddirs);
	my $tdir = File::Spec->catdir(@dirparts);
	
	print "will try to create $tdir\n";
	if ( not -d $tdir ) {
		local @ARGV = $tdir;
		mkpath();
		print "Created $tdir\n";
	}

	
	my $out_fname =
	  File::Spec->catfile(@dirparts, "${submodname}.pm" );
	my $tmpl_path = get_template_path("submodule.pm");

	my $htmlt = HTML::Template->new(filename=> $tmpl_path);
	$htmlt->param(main_module => DISTRO);
	$htmlt->param(sub_module =>  "C::$new_module");

	create_file( $out_fname, $htmlt->output );
}


=head3 create_tt($module_name)

Given a module name it generates a Template Toolkit template for the
'index' runmode.  The template is generated into the applications
'templates' directory.  The nested directory structure reflects
the director structure for your modules under the 'lib' directory.

Examples"

     gordon@govitoshi:~/tmp$ find MyApp1/lib/
     MyApp1/lib/
     MyApp1/lib/MyApp1.pm
     MyApp1/lib/MyApp1
     MyApp1/lib/MyApp1/C
     MyApp1/lib/MyApp1/C/Home.pm
     MyApp1/lib/MyApp1/C/Control2.pm
     MyApp1/lib/MyApp1/Dispatch.pm

     gordon@govitoshi:~/tmp$ find MyApp1/templates
     MyApp1/templates
     MyApp1/templates/MyApp1
     MyApp1/templates/MyApp1/C
     MyApp1/templates/MyApp1/C/Control2
     MyApp1/templates/MyApp1/C/Control2/index.tmpl
     MyApp1/templates/MyApp1/C/Home
     MyApp1/templates/MyApp1/C/Home/index.tmpl


=cut

sub create_tt {
	my $submodule = shift;
	
	my @distroparts = split /-/mx, DISTRO;

	my @submodparts = split/::/, $submodule;

        my @submoddirs = @submodparts > 1? $submodparts[0..-2]: ($submodparts[0]);
        my $submodname = $submodparts[0];

       
	my @dirparts =
	  ( 'templates', @distroparts, "C" , @submodparts);
	my $tdir = File::Spec->catdir(@dirparts);
	
	
	if ( not -d $tdir ) {
	    print "will try to create template directory $tdir\n";
	    local @ARGV = $tdir;
	    mkpath();
	    print "Created $tdir\n";
	}


	my $tmpl_path = get_template_path("index.tmpl");
	my $htmlt = HTML::Template->new(filename=> $tmpl_path);
	my $out_fname = File::Spec->catfile(@dirparts, "index.tmpl" );

	create_file( $out_fname, $htmlt->output );

}




=head1 AUTHOR

    Gordon Van Amburg
    CPAN ID: VANAMBURG
    vanamburg at cpan.org

=head1 COPYRIGHT

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.







