<?php
/**
 * 
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Myron Turner <turnermm02@shaw.ca>
 */

// must be run within Dokuwiki
if(!defined('DOKU_INC')) die();
 
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'syntax.php');
 
/**
 * All DokuWiki plugins to extend the parser/rendering mechanism
 * need to inherit from this class
 */
class syntax_plugin_styles_indent extends DokuWiki_Syntax_Plugin {
 
   
    /**
     * return some info
     */
    function getInfo(){
        return array(
            'author' => 'Myron Turner',
            'email'  => 'turnermm02@shaw.ca',
            'date'   => '2007-07-26',
            'name'   => 'indent Plugin',
            'desc'   => 'handles space-bar indenting for gckg',
            'url'    => 'http://www.mturner.org/development/',
        );
    }
 
    function getType(){ return 'formatting'; }
    function getAllowedTypes() { return array('disabled'); }   
    function getSort(){ return 190; }
    function connectTo($mode) {
         $this->Lexer->addSpecialPattern('<indent.*?</indent>',$mode,'plugin_styles_indent'); 
	$this->Lexer->addSpecialPattern('<br />',$mode,'plugin_styles_indent'); 
       }

    function handle($match, $state, $pos, &$handler){    

/*
        if(preg_match('/<indent>(.*?)<\/indent>/', $match,$matches)) {  
            list($type,$color) explode('=',$matches[1]);         
            
            return array( $state, '<span>' . $match . '</span>');
        }

*/
        return array( $state, $match);
             
    }
      

    /**
     * Create output
     */
    function render($mode, &$renderer, $data) {

        if($mode == 'xhtml'){
            list($state, $match) = $data;
            $renderer->doc .= $match;          
            return true;         
         }
        
              
        return false;
    } 


}
 

